/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-02-01 18:26:23
 * @LastEditTime: 2021-03-17 10:35:09
 * @LastModifyUser: 
 * @Remark: 
 */
import GUID from "../components/guid.js";
let mLayuiObject = null, mRelationDiagramFolder = null, mOperationType = null;
export default function initDiagramFolderForm(index, layuiObject, operationType, relationDiagramFolder, addDiagramFolderSubmit, editDiagramFolderSubmit, relationDiagramFolders){
    mLayuiObject = layuiObject;
    mRelationDiagramFolder = relationDiagramFolder;
    mOperationType = operationType;
    mLayuiObject.form.val("formWindow",{
        "folderName": relationDiagramFolder.folderName || "",
        "folderParentID": relationDiagramFolder.folderParentID
    });
    
    $("#folderParentName").text(relationDiagramFolders.item(relationDiagramFolder.folderParentID) ? relationDiagramFolders.item(relationDiagramFolder.folderParentID).folderName : (relationDiagramFolder.relationDiagramType == 0 ? "维度表关系图" : "事实表关系图"));
    $(".folder-window input[name=folderName]").focus();

    createFolderTree(relationDiagramFolders);

    mLayuiObject.form.on("submit(formSubmit)", function (formObject){
        if (mOperationType == 0){
            if (validate(formObject, relationDiagramFolders)) {
                let guID = new GUID();
                mRelationDiagramFolder.folderID = guID.newGUID();
                mRelationDiagramFolder.folderName = formObject.field.folderName;
                mRelationDiagramFolder.folderParentID = formObject.field.folderParentID;
                addDiagramFolderSubmit(mRelationDiagramFolder);
                mLayuiObject.layer.close(index);
            }
        } else {
            if (change(formObject)) {
                if (validate(formObject, relationDiagramFolders)) {
                    mRelationDiagramFolder.folderName = formObject.field.folderName;
                    mRelationDiagramFolder.folderParentID = formObject.field.folderParentID;
                    editDiagramFolderSubmit(mRelationDiagramFolder);
                    mLayuiObject.layer.close(index);
                }
            } else {
                mLayuiObject.layer.close(index);
            }
        }
        return false;
    });

    $(".layui-btn-cancel").click(function () {
        mLayuiObject.layer.close(index);
    });
}

function createFolderTree(relationDiagramFolders){
    var treeData = setTreeData(relationDiagramFolders);
    mLayuiObject.tree.render({
        elem: '#classtree',
        data: treeData,
        onlyIconControl: true,
        click: function (node) { //点击节点回调
            var $select = $($(this)[0].elem).parents(".layui-form-select");
            $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderParentID']").val(node.data.folderID);
        },
    });
    $(".folder-window .downpanel").off("click").on("click", ".layui-select-title", function (e) {
        $(".folder-window .layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
        $(this).parents(".downpanel").toggleClass("layui-form-selected");
        layui.stope(e);
    }).on("click", "dl i", function (e) {
        layui.stope(e);
    });
    $(document).on("click", function (e) {
        $(".folder-window .layui-form-select").removeClass("layui-form-selected");
    });
}

function setTreeData(relationDiagramFolders){
    let treeData = [];
    let hashTable = new HashTable();
    if (mRelationDiagramFolder.relationDiagramType == "0"){
        hashTable.add("-2", { title: "维度表关系图", id: "-2", folderID: "-2", folderParentID: "-1", relationDiagramType: 0, spread: true });
    } else {
        hashTable.add("-3", { title: "事实表关系图", id: "-3", folderID: "-3", folderParentID: "-1", relationDiagramType: 1, spread: true });
    }
    for (let i = 0; i < relationDiagramFolders.count(); i++) {
        let folder = relationDiagramFolders.item(i);
        if (mRelationDiagramFolder.relationDiagramType == folder.relationDiagramType){
            hashTable.add(folder.folderID, { title: folder.folderName, id: folder.folderID, folderID: folder.folderID, folderParentID: folder.folderParentID, relationDiagramType: folder.relationDiagramType, spread: false });
        }
    }
    for (let i = 0; i < relationDiagramFolders.count(); i++) {
        let folder = relationDiagramFolders.item(i);
        if (mRelationDiagramFolder.relationDiagramType == folder.relationDiagramType) {
            let parentFolder = hashTable.getValue(folder.folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(folder.folderID));
            if (mOperationType == 1 && parentFolder.folderID == mRelationDiagramFolder.folderID) {
                parentFolder.children = [];
            }
        }
    }
    if (mRelationDiagramFolder.relationDiagramType == "0") {
        treeData.push(hashTable.getValue("-2"));
    } else {
        treeData.push(hashTable.getValue("-3"));
    }

    for (var i = 0; i < treeData.length; i++) {
        if (treeData[i].folderID == mRelationDiagramFolder.folderID) {
            treeData.splice(i, 1);
        } else if (treeData[i].children && treeData[i].children.length) {
            removeCurrentFolder(treeData[i].children);
        }
    }

    return treeData;
}

function removeCurrentFolder(childrenArr) {
    for (var i = 0; i < childrenArr.length; i++) {
        if (childrenArr[i].folderID == mRelationDiagramFolder.folderID) {
            childrenArr.splice(i, 1);
        } else if (childrenArr[i].children && childrenArr[i].children.length) {
            removeCurrentFolder(childrenArr[i].children);
        }
    }
}

function validate(formObject, relationDiagramFolders) {
    let result = isNameCorrect(formObject.field.folderName);
    if (!result.result) {
        mLayuiObject.layer.msg(result.message, { icon: 2 });
        return false;
    }
    for (let i = 0; i < relationDiagramFolders.count(); i++){
        if (mOperationType == 0) {
            if (relationDiagramFolders.item(i).folderParentID == formObject.field.folderParentID && relationDiagramFolders.item(i).folderName == formObject.field.folderName) {
                mLayuiObject.layer.msg("名称已存在。", { icon: 2 });
                return false;
            }
        } else if (mOperationType == 1) {
            if (mRelationDiagramFolder.folderID != relationDiagramFolders.item(i).folderID && relationDiagramFolders.item(i).folderParentID == formObject.field.folderParentID && relationDiagramFolders.item(i).folderName == formObject.field.folderName) {
                mLayuiObject.layer.msg("名称已存在。", { icon: 2 });
                return false;
            }
        }
    }
    return true;
}

function change(formObject){
    if(formObject.field.folderName != mRelationDiagramFolder.folderName){
        return true;
    }
    if(formObject.field.folderParentID != mRelationDiagramFolder.folderParentID){
        return true;
    }
    return false;
}