/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-02-03 19:21:05
 * @LastEditTime: 2021-04-09 16:54:08
 * @LastModifyUser: 
 * @Remark: 
 */
import GUID from "../components/guid.js";
import dataTypeArr from "../components/dataType.js";
import aggregateFunctionObject from "../components/aggregateFunction.js";
import initFieldListForm from "./fieldList_controller.js";

let mBusinessObject = null, mLayuiObject = null, mOperationType = null, sqlEditor = null, mRelationModel = null, mDatabaseTypeName = null;
export default function initBusinessObjectForm(index, layuiObject, operationType, businessObject, relationModel, addBusinessObjectSubmit, editBusinessObjectSubmit, databaseTypeName){
    mLayuiObject = layuiObject;
    mOperationType = operationType;
    mBusinessObject = businessObject;
    mRelationModel = relationModel;
    mDatabaseTypeName = databaseTypeName;

    initDataTypeNode();
    mLayuiObject.form.val("formWindow", {
        "businessObjectName": mBusinessObject.businessObjectName || "",
        "dataType": mBusinessObject.dataType || 0,
        "businessObjectType": mBusinessObject.businessObjectType || 0,
        "valueOrder": mBusinessObject.valueOrder || 0,
        "formatString": mBusinessObject.formatString || ""
    });

    $(".business-object-window input[name=businessObjectName]").focus();

    $(".tips-text span").text(mDatabaseTypeName);

    initExpression();

    $(".form-submit .layui-btn-cancel").click(function () {
        mLayuiObject.layer.close(index);
    });

    mLayuiObject.form.on("submit(formSubmit)", function (formObject) {
        let layerIndex = index;
        if(mOperationType == 0){
            if (validate(formObject)) {
                let result = analysisExpression();
                if (result.result) {
                    let guID = new GUID();
                    mBusinessObject.businessObjectID = guID.newGUID();
                    setBusinessObject(formObject);
                    addBusinessObjectSubmit(mBusinessObject);
                    mLayuiObject.layer.close(index);
                }else{
                    layer.open({
                        type: 0,
                        title: "新增过滤对象",
                        resize: false,
                        area: ["480px", "270px"],
                        skin: "delete-window",
                        content: `<div class='fail-box clearfix'>
                            <div class='fl fail-icon enquire-icon'><i class="iconfont bda-xunwen"></i></div>
                            <div class='fr fail-content'>
                                ` + result.message+` 是否继续保存您的更改？<br>
                                单击“是”将提交您的更改。<br>
                                单击“否”继续编辑。
                            </div>
                        </div>`,
                        btn: ["是","否"],
                        yes: function (index, layero) {
                            let guID = new GUID();
                            mBusinessObject.businessObjectID = guID.newGUID();
                            setBusinessObject(formObject);
                            addBusinessObjectSubmit(mBusinessObject);
                            mLayuiObject.layer.close(index);
                            mLayuiObject.layer.close(layerIndex);
                        }
                    });
                }
            }
        }else{
            if (change(formObject)){
                if (validate(formObject)){
                    let result = analysisExpression();
                    if (result.result) {
                        setBusinessObject(formObject);
                        editBusinessObjectSubmit(mBusinessObject);
                        mLayuiObject.layer.close(index);
                    } else {
                        layer.open({
                            type: 0,
                            title: mBusinessObject.businessObjectName + " 属性",
                            resize: false,
                            area: ["480px", "270px"],
                            skin: "delete-window",
                            content: `<div class='fail-box clearfix'>
                            <div class='fl fail-icon enquire-icon'><i class="iconfont bda-xunwen"></i></div>
                            <div class='fr fail-content'>
                                ` + result.message + ` 是否继续保存您的更改？<br>
                                单击“是”将提交您的更改。<br>
                                单击“否”继续编辑。
                            </div>
                        </div>`,
                            btn: ["是", "否"],
                            yes: function (index, layero) {
                                setBusinessObject(formObject);
                                editBusinessObjectSubmit(mBusinessObject);
                                mLayuiObject.layer.close(index);
                                mLayuiObject.layer.close(layerIndex);
                            }
                        });
                    }
                }
            }else{
                mLayuiObject.layer.close(index);
            }
        }
        return false;
    });

    bindEvent();
}

function initDataTypeNode(){
    let dataTypeNode = document.getElementById("dataType");
    for(let i = 0; i < dataTypeArr.length; i++){
        let option = document.createElement("option");
        option.setAttribute("value", dataTypeArr[i].value);
        option.innerText = dataTypeArr[i].key;
        dataTypeNode.appendChild(option);
    }
    mLayuiObject.form.render();
}

function initExpression(){
    sqlEditor = CodeMirror.fromTextArea(document.getElementById("sqlEditor"), {
        mode: "text/x-sparksql", // spark sql模式
        tabSize: 4,
        styleActiveLine: true, // 行高亮
        lineNumbers: false,  // 显示行号
        theme: "eclipse", // 设置主题
        lineWrapping: true, // 自动换行
        matchBrackets: false, // 匹配括号
        autoCloseBrackets: true
    });

    sqlEditor.on('keyup', (cm, event) => {
        if (event.keyCode >= 65 && event.keyCode <= 90) {
            cm.showHint();
        }
    });

    sqlEditor.setValue(mBusinessObject.expressionText || "");
}

function bindEvent(){
    $("#formatStringButton").click(function(){
        getAndLoadDataFormatForm();
        return false;
    });

    $("#aggregateAware").click(function(){
        editorInsertText("@Aggregate_Aware(,)",2);
    });

    $("#selectField").click(function(){
        getAndLoadFieldListForm();
    });

    $("#analysis").click(function(){
        let result = analysisExpression();
        if (result.result) {
            mLayuiObject.layer.msg("表达式正确。", { icon: 1 });
        } else {
            $Utils.openWindow.failWindow("分析表达式", result.message);
        }
    });
}

function getAndLoadDataFormatForm(){
    $.ajax({
        url: "/html/dataFormat/dataFormat_Model.html",
        type: 'GET',
        success: function (data) {
            loadDataFormatHtml(data);
        }
    });
}

function loadDataFormatHtml(strHtml){
    mLayuiObject.layer.open({
        type: 1,
        title: ["数值格式", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["700px", "525px"],
        content: strHtml,
        success: function (layero, index) {
            let formatStringObj = {
                data: {
                    formatString: mBusinessObject.formatString || ""
                }
            };
            initDataFormat(formatStringObj, index, setDataFormatToInput);
        }
    });
}

function getAndLoadFieldListForm() {
    $.ajax({
        url: "dialogs/fieldList.html",
        type: 'GET',
        success: function (data) {
            loadFieldListHtml(data);
        }
    });
}

function loadFieldListHtml(strHtml) {
    mLayuiObject.layer.open({
        type: 1,
        title: ["选择表字段", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["375px", "500px"],
        content: strHtml,
        success: function (layero, index) {
            initFieldListForm(index, mLayuiObject, mRelationModel, addField);
        }
    });
}

function analysisExpression(){
    return mRelationModel.analyzeExpression(sqlEditor.getValue(), mDatabaseTypeName);
}

function editorInsertText(text, offset) {
    sqlEditor.replaceSelection(text);
    let currentCursorPosition = sqlEditor.getCursor();
    let line = {
        ch: currentCursorPosition.ch - offset,
        line: 0,
        sticky: "after",
        xRel: currentCursorPosition.ch - offset,
    };
    sqlEditor.setCursor(line)
    sqlEditor.focus();
}

function validate(formObject){
    let result = isNameCorrect(formObject.field.businessObjectName);
    if (!result.result){
        mLayuiObject.layer.msg(result.message, { icon: 2 });
        return false;
    }
    for (let i = 0; i < mRelationModel.businessObjects.count(); i++){
        if (mOperationType == 0) {
            if (formObject.field.businessObjectName == mRelationModel.businessObjects.item(i).businessObjectName) {
                mLayuiObject.layer.msg("业务对象名称已存在。", { icon: 2 });
                return false;
            }
        } else if (mOperationType == 1){
            if (mBusinessObject.businessObjectID != mRelationModel.businessObjects.item(i).businessObjectID && formObject.field.businessObjectName == mRelationModel.businessObjects.item(i).businessObjectName) {
                mLayuiObject.layer.msg("业务对象名称已存在。", { icon: 2 });
                return false;
            }
        }
    }
    if (sqlEditor.getValue() == ""){
        mLayuiObject.layer.msg("表达式不能为空。",{icon: 2});
        return false;
    }
    return true;
}

function change(formObject){
    if(mBusinessObject.businessObjectName != formObject.field.businessObjectName){
        return true;
    }
    if(mBusinessObject.businessObjectType != formObject.field.businessObjectType){
        return true;
    }
    if(mBusinessObject.dataType != formObject.field.dataType){
        return true;
    }
    if(mBusinessObject.valueOrder != formObject.field.valueOrder){
        return true;
    }
    if(mBusinessObject.formatString != formObject.field.formatString){
        return true;
    }
    if(mBusinessObject.expressionText != sqlEditor.getValue()){
        return true;
    }
    return false;
}

function setBusinessObject(formObject){
    mBusinessObject.businessObjectName = formObject.field.businessObjectName;
    mBusinessObject.businessObjectType = Number(formObject.field.businessObjectType);
    mBusinessObject.dataType = Number(formObject.field.dataType);
    mBusinessObject.valueOrder = Number(formObject.field.valueOrder);
    mBusinessObject.formatString = formObject.field.formatString;
    mBusinessObject.aggregateAware = isAggregateAware($.trim(sqlEditor.getValue()));
    mBusinessObject.aggregateFunction = isAggregateFunction($.trim(sqlEditor.getValue()));
    mBusinessObject.expressionText = $.trim(sqlEditor.getValue());
    mBusinessObject.expressionList = setExpressionList($.trim(sqlEditor.getValue()));
    mBusinessObject.tableNamesList = setTableNamesList(mBusinessObject.expressionList);
}

function isAggregateAware(expressionText){
    let originalText = "@Aggregate_Aware(".toUpperCase();
    let compareText = expressionText.toString().toUpperCase();
    if(compareText.indexOf(originalText) != -1){
        return true;
    }
    return false;
}

function isAggregateFunction(expressionText){
    for(let i = 0; i < aggregateFunctionObject[mDatabaseTypeName].length; i++){
        let aggregate = aggregateFunctionObject[mDatabaseTypeName][i];
        if(expressionText.toString().toUpperCase().indexOf((aggregate+"(").toUpperCase()) != -1){
            return true;
        }
    }
    return false;
}

function setExpressionList(expressionText){
    return mRelationModel.getExpressionList(expressionText);
}

function setTableNamesList(expressionList){
    let nameListArr = [];
    for(let i = 0; i < expressionList.length; i++){
        nameListArr.push(mRelationModel.getTableAliass(expressionList[i]));
    }
    return nameListArr;
}

const setDataFormatToInput = (obj, dataFormatStr, index) => {
    mLayuiObject.form.val("formWindow", {
        "formatString": dataFormatStr || ""
    });
    mLayuiObject.layer.close(index);
};

const addField = (tableFieldStr) => {
    editorInsertText(tableFieldStr,0);
}