let mRelationModel = null;
export default function initValueListForm(index, layuiObject,relationModel,selectValue){
    mRelationModel = relationModel;
    loadListTreeList();
    bindTreeEvent();

    $(".object-list .layui-btn-cancel").click(function () {
        layuiObject.layer.close(index);
    });

    $(".object-list .submit-object").click(function () {
        if($("#objectTree li.selected-li").length && $("#objectTree li.selected-li").hasClass("object")){
            let objectName = $.trim($("#objectTree li.selected-li").text());
            selectValue(objectName);
            layuiObject.layer.close(index);
        }else{
            layuiObject.layer.msg("请选择业务对象。",{icon: 2});
        }
    });
}

function loadListTreeList(){
    let treeData = setTreeData();
    $("#objectTree").html("");
    createBusinessObjectTree(treeData);
}

function setTreeData() {
    let hashTable = new HashTable();
    hashTable.add("-1", { name: "业务对象", folderID: "-1", folderParentID: "-1"});
    for (let i = 0; i < mRelationModel.businessObjectFolders.count(); i++){
        let folder = mRelationModel.businessObjectFolders.item(i);
        hashTable.add(folder.folderID, {
            name: folder.folderName,
            folderID: folder.folderID,
            folderParentID: folder.folderParentID,
            sortIndex: folder.sortIndex
        });
    }
    for (let i = 0; i < mRelationModel.businessObjects.count(); i++){
        let businessObject = mRelationModel.businessObjects.item(i);
        if (!hashTable.getValue(businessObject.businessObjectFolderID).children){
            hashTable.getValue(businessObject.businessObjectFolderID).children = [];
        }
        hashTable.getValue(businessObject.businessObjectFolderID).children.push({
            name: businessObject.businessObjectName,
            businessObjectID: businessObject.businessObjectID,
            folderID: businessObject.businessObjectFolderID,
            businessObjectType: businessObject.businessObjectType,
            sortIndex: businessObject.sortIndex
        });
    }
    for (let i = 0; i < mRelationModel.businessObjectFolders.count(); i++) {
        let folder = mRelationModel.businessObjectFolders.item(i);
        let parentFolder = hashTable.getValue(folder.folderParentID);
        if(!parentFolder.children){
            parentFolder.children = [];
        }
        parentFolder.children.push(hashTable.getValue(folder.folderID));
    }

    let businessObjectsArr = hashTable.getValue("-1").children || [];
    bubbleSort(businessObjectsArr);

    return businessObjectsArr;
}

function createBusinessObjectTree(treeData){
    for(let i = 0; i < treeData.length; i++){
        if (!treeData[i].businessObjectID){
            let strHtml = `<li class="folder" data-folderID="${treeData[i].folderID}" draggable="true">
                <div title="${treeData[i].name}">
                    <i class="iconfont bda-wenjianjia"></i>
                    <span class="folder-name">${treeData[i].name}</span>
                    <span class="triangle"></span>
                </div>
                <ul></ul>
            </li>`;
            $("#objectTree").append(strHtml);
            if (treeData[i].children) {
                $("#objectTree li:last-child").addClass("hasChildren");
                createChildrenFolder(treeData[i].children, $("#objectTree li:last-child").children("ul"));
            }
        }else{
            let strHtml = `<li class="object ${(treeData[i].businessObjectType ? (treeData[i].businessObjectType == 1 ? "measure" : "filter-object") : "dimension")}" data-objectID="${treeData[i].businessObjectID}" draggable="true">
                <div title="${treeData[i].name}">
                    <i class="iconfont bda-${(treeData[i].businessObjectType ? (treeData[i].businessObjectType == 1 ? "measure" : "guolv") : "dimension")}"></i>
                    <span>${treeData[i].name}</span>
                </div>
            </li>`;
            $("#objectTree").append(strHtml);
        }
    }
}

function createChildrenFolder(childrenArr, element) {
    for (let i = 0; i < childrenArr.length; i++) {
        if (!childrenArr[i].businessObjectID) {
            let strHtml = `<li class="folder" data-folderID="${childrenArr[i].folderID}" draggable="true">
                <div title="${childrenArr[i].name}">
                    <i class="iconfont bda-wenjianjia"></i>
                    <span class="folder-name">${childrenArr[i].name}</span>
                    <span class="triangle"></span>
                </div>
                <ul></ul>
            </li>`;
            element.append(strHtml);
            if (childrenArr[i].children) {
                element.find("li:last-child").addClass("hasChildren");
                createChildrenFolder(childrenArr[i].children, element.find("li:last-child").children("ul"));
            }
        } else {
            let strHtml = `<li class="object ${(childrenArr[i].businessObjectType ? (childrenArr[i].businessObjectType == 1 ? "measure" : "filter-object") : "dimension")}" data-objectID="${childrenArr[i].businessObjectID}" draggable="true">
                <div title="${childrenArr[i].name}">
                    <i class="iconfont bda-${(childrenArr[i].businessObjectType ? (childrenArr[i].businessObjectType == 1 ? "measure" : "guolv") : "dimension")}"></i>
                    <span>${childrenArr[i].name}</span>
                </div>
            </li>`;
            element.append(strHtml);
        }
    }
}

function bindTreeEvent(){
    $("#objectTree").on("click", "li", function (e) {
        if (!$(this).hasClass("selected-li")) {
            $("#objectTree").find("li").removeClass("selected-li");
            $(this).addClass("selected-li");
        }
        e.stopPropagation();
    });

    $(".left-content").on("click",function(e){
        if ($(e.target).attr("id") != "businessObjectTree" && $(e.target).parents("ul#objectTree").length == 0){
            $("#objectTree").find("li").removeClass("selected-li");
        }
    })

    $("#objectTree").on("click", "span.triangle", function (e) {
        $("#objectTree").find("li").removeClass("selected-li");
        if ($(this).parent("div").siblings("ul").is(":hidden")) {
            $(this).parent("div").parent("li").addClass("selected-li open-folder");
        } else {
            $(this).parent("div").parent("li").addClass("selected-li").removeClass("open-folder");
        }
        e.stopPropagation();
    });

    $("#objectTree").on("dblclick", "li.folder > div", function (e) {
        if ($(this).siblings("ul").is(":hidden")) {
            $(this).parent("li").addClass("open-folder");
            $("#objectTree").find("li").removeClass("selected-li");
            $(this).parent("li").addClass("selected-li");
        } else {
            $(this).parent("li").removeClass("open-folder");
            $("#objectTree").find("li").removeClass("selected-li");
            $(this).parent("li").addClass("selected-li");
        }
        e.stopPropagation();
    });
}

function bubbleSort(arr) {
    for (var i = 0; i < arr.length; i++) {
        if (arr[i].children) {
            bubbleSort(arr[i].children);
        }
    }
    arr.sort(function (a, b) {
        return a.sortIndex - b.sortIndex;
    });
}