/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-02-02 20:02:37
 * @LastEditTime: 2021-03-17 10:30:06
 * @LastModifyUser: 
 * @Remark: 
 */
import GUID from "../components/guid.js";

let mBusinessObjectFolder = null, mLayuiObject = null, mOperationType = null, mBusinessObjectFolders = null;

export default function initBusinessObjectFolderForm(index, layuiObject, operationType, businessObjectFolder, businessObjectFolders, addFolderSubmit, editFolderSubmit){
    mLayuiObject = layuiObject;
    mOperationType = operationType;
    mBusinessObjectFolder = businessObjectFolder;
    mBusinessObjectFolders = businessObjectFolders;

    mLayuiObject.form.val("formWindow",{
        "folderName": mBusinessObjectFolder.folderName,
        "description": mBusinessObjectFolder.description
    });

    $(".folder-window input[name=folderName]").focus();

    $(".layui-btn-cancel").click(function () {
        mLayuiObject.layer.close(index);
    });

    mLayuiObject.form.on("submit(formSubmit)", function (formObject) {
        if (mOperationType == 0) {
            if (validate(formObject)) {
                let guID = new GUID();
                mBusinessObjectFolder.folderID = guID.newGUID();
                mBusinessObjectFolder.folderName = formObject.field.folderName;
                mBusinessObjectFolder.description = formObject.field.description;
                addFolderSubmit(mBusinessObjectFolder);
                mLayuiObject.layer.close(index);
            }
        } else {
            if (change(formObject)) {
                if (validate(formObject)) {
                    mBusinessObjectFolder.folderName = formObject.field.folderName;
                    mBusinessObjectFolder.description = formObject.field.description;
                    editFolderSubmit(mBusinessObjectFolder);
                    mLayuiObject.layer.close(index);
                }
            } else {
                mLayuiObject.layer.close(index);
            }
        }
        return false;
    });
}

function validate(formObject){
    let result = isNameCorrect(formObject.field.folderName);
    if (!result.result) {
        mLayuiObject.layer.msg(result.message, { icon: 2 });
        return false;
    }
    for (let i = 0; i < mBusinessObjectFolders.count(); i++){
        if(mOperationType == 0){
            if (mBusinessObjectFolders.item(i).folderParentID == mBusinessObjectFolder.folderParentID && mBusinessObjectFolders.item(i).folderName == formObject.field.folderName) {
                mLayuiObject.layer.msg("名称已存在。", { icon: 2 });
                return false;
            }
        } else if (mOperationType == 1) {
            if (mBusinessObjectFolders.item(i).folderID != mBusinessObjectFolder.folderID && mBusinessObjectFolders.item(i).folderParentID == mBusinessObjectFolder.folderParentID && mBusinessObjectFolders.item(i).folderName == formObject.field.folderName) {
                mLayuiObject.layer.msg("名称已存在。", { icon: 2 });
                return false;
            }
        }
    }
    return true;
}

function change(formObject) {
    if (formObject.field.folderName != mBusinessObjectFolder.folderName) {
        return true;
    }
    if (formObject.field.description != mBusinessObjectFolder.description) {
        return true;
    }
    return false;
}