

let mLayuiObject = null, mTables = null;

let mTableBody = [];//全部的obj
let backupArr = [];
let lazyArr = [];

let searchBody = [];//筛选后的的obj

let selectTables = [];

let onSucc;
let mIndex;

export default function initAddTablesDialog(index, layuiObject, tables, succCallback){
    selectTables = [];
    searchBody = [];
    mIndex = index;
    mLayuiObject = layuiObject;
    mTables = tables;
    onSucc = succCallback;
    initTableListHead();
    let tableBody = [];
    for(let i = 0; i < mTables.count(); i++){
        let tableObj = {};
        tableObj.tableName = mTables.item(i).tableName;
        tableObj.tableFields = mTables.item(i).tableFields;
        tableBody.push(tableObj);
    }
    $.extend(true,mTableBody,tableBody);
    $.extend(true,searchBody,tableBody);
    
    loadTableListBody(tableBody);
    bindEvent();
}

function initTableListHead(){
    let tableHead = [
        [
            {type: "checkbox"},
            {field: "tableName", title: "表名"}
        ]
    ];

    mLayuiObject.table.render({
        elem: "#tableList",
        height: 480,
        cellMinWidth: 80,
        data: [],
        cols: tableHead,
        toolbar: false,
        limit: mTables.count()
    });
}

function loadTableListBody(tableBody){
    if(tableBody.length > 100){
        lazyArr = tableBody.splice(100,tableBody.length);
    }
    backupArr = tableBody;
    if(selectTables.length){
        setSelect(tableBody);
    }
    mLayuiObject.table.reload("tableList",{
        data:tableBody,limit:tableBody.length,skin: "nob",done:function(){
            $(".table-list .layui-table-main").scroll(function(){
                var scrollTop = $(this)[0].scrollTop;
                var clientHeight = $(this)[0].clientHeight;
                var scrollHeight = $(this)[0].scrollHeight;
                
                if(lazyArr.length > 0 && scrollHeight > clientHeight && scrollTop + clientHeight === scrollHeight) {
                    loadmore(scrollTop);
                }
            });
        }
    });
    $("#tbkTip").html("共 " + tableBody.length + " 个对象");
}

function setSelect(currentData){
    let selectTableNames = [];
    for(let i = 0; i < selectTables.length; i++){
        selectTableNames.push(selectTables[i].tableName);
    }
    for(let i = 0; i < currentData.length; i++){
        if(selectTableNames.indexOf(currentData[i].tableName) != -1){
            currentData[i].LAY_CHECKED = true;
        }else if(currentData[i].LAY_CHECKED){
            currentData[i].LAY_CHECKED = false;
        }
    }
}

function loadmore(scrollTop){
    if(lazyArr.length > 100){
        var tempArr = lazyArr.splice(0,100);
        backupArr = backupArr.concat(tempArr);
    }else{
        backupArr = backupArr.concat(lazyArr);
        lazyArr = [];
    }
    if(selectUsers.length){
        setSelect(backupArr)
    }
    table.reload("tableList",{data:backupArr,limit:backupArr.length,skin: "nob"});
    $(".table-list .layui-table-main").scrollTop(scrollTop);
}

function setSearchData(searchValue){
    searchBody = [];
    // let searchData = [];
    let lowerSearchValue = searchValue.toLowerCase();
    for(let i = 0; i < mTableBody.length; i++){
        if(mTableBody[i].tableName.toLowerCase().indexOf(lowerSearchValue) != -1){
            searchBody.push(mTableBody[i]);
        }
    }
    // return searchData;
}


function bindEvent(){
    mLayuiObject.table.on("checkbox(tableList)",function(obj){
        if(obj.type == "one"){
            if(obj.checked){
                selectTables.push(obj.data);
            }else{
                for(let i = selectTables.length - 1; i >= 0; i--){
                    if(selectTables[i].tableName == obj.data.tableName){
                        selectTables.splice(i,1);
                        break;
                    }
                }
            }
        }else if(obj.type == "all"){
            
            if(obj.checked){
                for(let i = 0; i < searchBody.length; i++){
                    if(selectTables.indexOf(searchBody[i]) == -1){
                        selectTables.push(searchBody[i]);
                    }
                }
            }else{
                for(let i = 0; i < searchBody.length; i++){
                    for(let j = selectTables.length - 1; j >= 0; j--){
                        if(selectTables[j].tableName == searchBody[i].tableName){
                            selectTables.splice(j,1);
                            break;
                        }
                    }
                }
            }
        }
        
    });

    $("#btnFilter").click(function(){
        let searchValue = $(".list-filter input").val();
        if(searchValue == ""){
            searchBody = [];
            $.extend(true,searchBody,mTableBody);
        }else{
            setSearchData(searchValue);
        }
        loadTableListBody(searchBody);
    })
    $(".list-filter input").keypress(function (e) {
        if (e.which == 13) {
            $("#btnFilter").click();
        }
    });


    $("#btnSure").click(function(){
        let tempTables = new Tables();
        for(let i = 0; i < selectTables.length; i++){
            tempTables.add(mTables.item(selectTables[i].tableName));
        }
        if(onSucc(tempTables) == true){
            layer.close(mIndex);
        }
    });

    $(".layui-btn-cancel").click(function(){
        layer.close(mIndex);
    });
}
