/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-01-30 16:52:20
 * @LastEditTime: 2021-03-01 20:05:46
 * @LastModifyUser: 
 * @Remark: 
 */
import GUID from "./components/guid.js";
import { totalBusinessObject } from "./components/bottomStatusBar_controller.js";
import initBusinessObjectFolderForm from "./dialogs/businessObjectFolder_controller.js";
import initBusinessObjectForm from "./dialogs/businessObject_controller.js";
import initFilterBusinessObjectForm from "./dialogs/filterBusinessObject_controller.js";

let mRelationModel = null;
let mLayuiObject = null;
let mDatabaseLink = null;
let cloneNodeHtml = null;
let copyNewBusinessObjectFolders = new BusinessObjectFolders();
let copyNewBusinessObjects = new BusinessObjects();
let guID = new GUID();

function initBusinessObjects(relationModel, layuiObject, databaseLink){
    mRelationModel = relationModel;
    mLayuiObject = layuiObject;
    mDatabaseLink = databaseLink;
    totalBusinessObject(mRelationModel.businessObjects.count());
    loadTreeList();
    bindEvent();
}

function loadTreeList(){
    let treeData = setTreeData();
    $("#businessObjectTree").html("");
    createBusinessObjectTree(treeData);
}

function setTreeData() {
    let hashTable = new HashTable();
    hashTable.add("-1", { name: "业务对象", folderID: "-1", folderParentID: "-1"});
    for (let i = 0; i < mRelationModel.businessObjectFolders.count(); i++){
        let folder = mRelationModel.businessObjectFolders.item(i);
        hashTable.add(folder.folderID, {
            name: folder.folderName,
            folderID: folder.folderID,
            folderParentID: folder.folderParentID,
            sortIndex: folder.sortIndex
        });
    }
    for (let i = 0; i < mRelationModel.businessObjects.count(); i++){
        let businessObject = mRelationModel.businessObjects.item(i);
        if (!hashTable.getValue(businessObject.businessObjectFolderID).children){
            hashTable.getValue(businessObject.businessObjectFolderID).children = [];
        }
        hashTable.getValue(businessObject.businessObjectFolderID).children.push({
            name: businessObject.businessObjectName,
            businessObjectID: businessObject.businessObjectID,
            folderID: businessObject.businessObjectFolderID,
            businessObjectType: businessObject.businessObjectType,
            sortIndex: businessObject.sortIndex
        });
    }
    for (let i = 0; i < mRelationModel.businessObjectFolders.count(); i++) {
        let folder = mRelationModel.businessObjectFolders.item(i);
        let parentFolder = hashTable.getValue(folder.folderParentID);
        if(!parentFolder.children){
            parentFolder.children = [];
        }
        parentFolder.children.push(hashTable.getValue(folder.folderID));
    }

    let businessObjectsArr = hashTable.getValue("-1").children || [];
    bubbleSort(businessObjectsArr);

    return businessObjectsArr;
}

function createBusinessObjectTree(treeData){
    for(let i = 0; i < treeData.length; i++){
        if (!treeData[i].businessObjectID){
            let strHtml = `<li class="folder" data-folderID="${treeData[i].folderID}" draggable="true">
                <div title="${treeData[i].name}">
                    <i class="iconfont bda-wenjianjia"></i>
                    <span class="folder-name">${treeData[i].name}</span>
                    <span class="triangle"></span>
                </div>
                <ul></ul>
            </li>`;
            $("#businessObjectTree").append(strHtml);
            if (treeData[i].children) {
                $("#businessObjectTree > li:last-child").addClass("hasChildren");
                createChildrenFolder(treeData[i].children, $("#businessObjectTree > li:last-child").children("ul"));
            }
        }else{
            let strHtml = `<li class="object ${(treeData[i].businessObjectType ? (treeData[i].businessObjectType == 1 ? "measure" : "filter-object") : "dimension")}" data-objectID="${treeData[i].businessObjectID}" draggable="true">
                <div title="${treeData[i].name}">
                    <i class="iconfont bda-${(treeData[i].businessObjectType ? (treeData[i].businessObjectType == 1 ? "measure" : "guolv") : "dimension")}"></i>
                    <span>${treeData[i].name}</span>
                </div>
            </li>`;
            $("#businessObjectTree").append(strHtml);
        }
    }
}

function createChildrenFolder(childrenArr, element) {
    for (let i = 0; i < childrenArr.length; i++) {
        if (!childrenArr[i].businessObjectID) {
            let strHtml = `<li class="folder" data-folderID="${childrenArr[i].folderID}" draggable="true">
                <div title="${childrenArr[i].name}">
                    <i class="iconfont bda-wenjianjia"></i>
                    <span class="folder-name">${childrenArr[i].name}</span>
                    <span class="triangle"></span>
                </div>
                <ul></ul>
            </li>`;
            element.append(strHtml);
            if (childrenArr[i].children) {
                element.children("li:last-child").addClass("hasChildren");
                createChildrenFolder(childrenArr[i].children, element.children("li:last-child").children("ul"));
            }
        } else {
            let strHtml = `<li class="object ${(childrenArr[i].businessObjectType ? (childrenArr[i].businessObjectType == 1 ? "measure" : "filter-object") : "dimension")}" data-objectID="${childrenArr[i].businessObjectID}" draggable="true">
                <div title="${childrenArr[i].name}">
                    <i class="iconfont bda-${(childrenArr[i].businessObjectType ? (childrenArr[i].businessObjectType == 1 ? "measure" : "guolv") : "dimension")}"></i>
                    <span>${childrenArr[i].name}</span>
                </div>
            </li>`;
            element.append(strHtml);
        }
    }
}

function bindEvent() {
    treeClickEvent();
    buttonEvent();
    dragEvent();
    mouseRightEvent();
}

function treeClickEvent() {
    $("#businessObjectTree").on("click", "li > div", function (e) {
        if (!$(this).parent().hasClass("selected-li")) {
            $("#businessObjectTree").find("li").removeClass("selected-li");
            $(this).parent().addClass("selected-li");
            if (!$(".default-status").hasClass("button-color")) {
                $(".default-status").addClass("button-color");
            }
        }
        e.stopPropagation();
    });

    $(".left-content").on("click",function(e){
        if ($(e.target).attr("id") != "businessObjectTree" && $(e.target).parents("ul#businessObjectTree").length == 0){
            $("#businessObjectTree").find("li").removeClass("selected-li");
            if ($(".default-status").hasClass("button-color")) {
                $(".default-status").removeClass("button-color");
            }
        }
    })

    $("#businessObjectTree").on("click", "span.triangle", function (e) {
        $("#businessObjectTree").find("li").removeClass("selected-li");
        if ($(this).parent("div").siblings("ul").is(":hidden")) {
            $(this).parent("div").parent("li").addClass("selected-li open-folder");
        } else {
            $(this).parent("div").parent("li").addClass("selected-li").removeClass("open-folder");
        }
        if (!$(".default-status").hasClass("button-color")) {
            $(".default-status").addClass("button-color");
        }
        e.stopPropagation();
    });

    $("#businessObjectTree").on("dblclick", "li.folder > div", function (e) {
        if ($(this).siblings("ul").is(":hidden")) {
            $(this).parent("li").addClass("open-folder");
            $("#businessObjectTree").find("li").removeClass("selected-li");
            $(this).parent("li").addClass("selected-li");
        } else {
            $(this).parent("li").removeClass("open-folder");
            $("#businessObjectTree").find("li").removeClass("selected-li");
            $(this).parent("li").addClass("selected-li");
        }
        if (!$(".default-status").hasClass("button-color")) {
            $(".default-status").addClass("button-color");
        }
        e.stopPropagation();
    });

    $("#businessObjectTree").on("dblclick", "li.object", function (e) {
        if (!$(this).hasClass("selected-li")) {
            $("#businessObjectTree").find("li").removeClass("selected-li");
            $(this).addClass("selected-li");
            if (!$(".default-status").hasClass("button-color")) {
                $(".default-status").addClass("button-color");
            }
        }
        //打开属性窗口
        e.stopPropagation();
        let businessObjectID = $(this).attr("data-objectid");
        if ($(this).hasClass("filter-object")) {
            getAndLoadFilterBusinessObjectForm(1, mRelationModel.businessObjects.item(businessObjectID));
        } else {
            getAndLoadBusinessObjectForm(1, mRelationModel.businessObjects.item(businessObjectID));
        }
    });
}

function buttonEvent(){
    $("#newBusinessObjectCategory").click(function(){
        addCateGory();
    });

    $("#newBusinessObject").click(function () {
        addBusinessObject();
    });

    $("#newFilterObject").click(function () {
        addFilterObject();
    });

    $("#businessObjectOrCategoryAttribute").click(function(){
        if ($(this).hasClass("button-color")){
            openAttribute();
        }
    });

    $("#deleteBusinessObjectOrCategory").click(function(){
        if ($("#businessObjectTree li").hasClass("selected-li")) {
            openDelete();
        }
    });

    $("#moveBusinessObjectOrCategroyUp").click(function () {
        if ($("#businessObjectTree li").hasClass("selected-li")) {
            let currentNode = $("#businessObjectTree li.selected-li");
            if (currentNode.index() != 0) {
                currentNode.prev().before(currentNode);
            }
        }
    });

    $("#moveBusinessObjectOrCategroyDown").click(function () {
        if ($("#businessObjectTree li").hasClass("selected-li")) {
            let currentNode = $("#businessObjectTree li.selected-li");
            let length = currentNode.parent("ul").children("li").length;
            if (currentNode.index() != length - 1) {
                currentNode.next().after(currentNode);
            }
        }
    });
}

function addCateGory(){
    let folderParentID = "-1";
    if ($("#businessObjectTree li").hasClass("selected-li")) {
        folderParentID = $("#businessObjectTree li.selected-li").hasClass("folder") ? $("#businessObjectTree li.selected-li").attr("data-folderid") : $("#businessObjectTree li.selected-li").parents("li.folder").eq(0).attr("data-folderid");
    }
    let sortIndex = $("#businessObjectTree > li").length;
    $("#businessObjectTree li.folder").each(function () {
        if ($(this).attr("data-data-folderid") == folderParentID) {
            sortIndex = $(this).children("ul").children("li").length;
        }
    });
    var businessObjectFolder = new BusinessObjectFolder();
    businessObjectFolder.folderParentID = folderParentID;
    businessObjectFolder.sortIndex = sortIndex;

    getAndLoadBusinessObjectFolderForm(0, businessObjectFolder);
}

function addBusinessObject(){
    let businessObject = new BusinessObject();
    if ($("#businessObjectTree li").hasClass("selected-li")) {
        if ($("#businessObjectTree li.selected-li").hasClass("folder")) {
            businessObject.businessObjectFolderID = $("#businessObjectTree li.selected-li").attr("data-folderid");
        } else {
            businessObject.businessObjectFolderID = $("#businessObjectTree li.selected-li").parents("li.folder").eq(0).attr("data-folderid");
        }
    } else {
        businessObject.businessObjectFolderID = "-1";
    }
    getAndLoadBusinessObjectForm(0, businessObject);
}

function addFilterObject(){
    let businessObject = new BusinessObject();
    if ($("#businessObjectTree li").hasClass("selected-li")) {
        if ($("#businessObjectTree li.selected-li").hasClass("folder")) {
            businessObject.businessObjectFolderID = $("#businessObjectTree li.selected-li").attr("data-folderid");
        } else {
            businessObject.businessObjectFolderID = $("#businessObjectTree li.selected-li").parents("li.folder").eq(0).attr("data-folderid");
        }
    } else {
        businessObject.businessObjectFolderID = "-1";
    }
    businessObject.businessObjectType = 2;
    getAndLoadFilterBusinessObjectForm(0, businessObject);
}

function openAttribute(){
    if ($("#businessObjectTree li.selected-li").hasClass("folder")) {
        let folderID = $("#businessObjectTree li.selected-li").attr("data-folderid");
        getAndLoadBusinessObjectFolderForm(1, mRelationModel.businessObjectFolders.item(folderID));
    } else {
        let businessObjectID = $("#businessObjectTree li.selected-li").attr("data-objectid");
        if ($("#businessObjectTree li.selected-li").hasClass("filter-object")) {
            getAndLoadFilterBusinessObjectForm(1, mRelationModel.businessObjects.item(businessObjectID));
        } else {
            getAndLoadBusinessObjectForm(1, mRelationModel.businessObjects.item(businessObjectID));
        }
    }
}

function openDelete(){
    if ($("#businessObjectTree li.selected-li").hasClass("folder")) {
        let folderID = $("#businessObjectTree li.selected-li").attr("data-folderid");
        deleteBusinessObjectFolder(mRelationModel.businessObjectFolders.item(folderID));
    } else {
        let objectID = $("#businessObjectTree li.selected-li").attr("data-objectid");
        deleteBusinessObject(mRelationModel.businessObjects.item(objectID));
    }
    $("#businessObjectTree li.selected-li").remove();
    if ($(".default-status").hasClass("button-color")) {
        $(".default-status").removeClass("button-color");
    }
    totalBusinessObject(mRelationModel.businessObjects.count());
}

function getAndLoadBusinessObjectFolderForm(operationType, businessObjectFolder){
    $.ajax({
        url: "dialogs/businessObjectFolder.html",
        type: 'GET',
        success: function (data) {
            loadBusinessObjectFolderForm(data, operationType, businessObjectFolder);
        }
    });
}

function loadBusinessObjectFolderForm(strHtml, operationType, businessObjectFolder){
    layer.open({
        type: 1,
        title: [operationType ? (businessObjectFolder.folderName + " 属性") : "新增分类", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["450px", "350px"],
        content: strHtml,
        success: function (layero, index) {
            initBusinessObjectFolderForm(index, mLayuiObject, operationType, businessObjectFolder, mRelationModel.businessObjectFolders, addFolderSubmit, editFolderSubmit);
        }
    });
}

function getAndLoadFilterBusinessObjectForm(operationType, businessObject) {
    $.ajax({
        url: "dialogs/filterBusinessObject.html",
        type: 'GET',
        success: function (data) {
            loadFilterBusinessObjectForm(data, operationType, businessObject);
        }
    });
}

function loadFilterBusinessObjectForm(strHtml, operationType, businessObject){
    layer.open({
        type: 1,
        title: [operationType ? (businessObject.businessObjectName + " 属性") : "新增过滤对象", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["600px", "540px"],
        content: strHtml,
        success: function (layero, index) {
            initFilterBusinessObjectForm(index, mLayuiObject, operationType, businessObject, mRelationModel, addBusinessObjectSubmit, editBusinessObjectSubmit, mDatabaseLink.databaseTypeName);
        }
    });
}

function getAndLoadBusinessObjectForm(operationType, businessObject) {
    $.ajax({
        url: "dialogs/businessObject.html",
        type: 'GET',
        success: function (data) {
            loadBusinessObjectForm(data, operationType, businessObject);
        }
    });
}

function loadBusinessObjectForm(strHtml, operationType, businessObject){
    layer.open({
        type: 1,
        title: [operationType ? (businessObject.businessObjectName + " 属性") : "新增业务对象", "font-size: 14px"],
        btn: false,
        resize: false,
        area: ["600px", "540px"],
        content: strHtml,
        success: function (layero, index) {
            initBusinessObjectForm(index, mLayuiObject, operationType, businessObject, mRelationModel, addBusinessObjectSubmit, editBusinessObjectSubmit, mDatabaseLink.databaseTypeName);
        }
    });
}

function deleteBusinessObjectFolder(businessObjectFolder){
    let folderIDArr = [];
    folderIDArr.push(businessObjectFolder.folderID);
    for (let i = 0; i < mRelationModel.businessObjectFolders.count(); i++){
        if (folderIDArr.indexOf(mRelationModel.businessObjectFolders.item(i).folderParentID) != -1){
            folderIDArr.push(mRelationModel.businessObjectFolders.item(i).folderID);
        }
    }
    for(let i = 0; i < folderIDArr.length; i++){
        mRelationModel.businessObjectFolders.remove(mRelationModel.businessObjectFolders.item(folderIDArr[i]));
        for (let j = mRelationModel.businessObjects.count() - 1; j >= 0; j--) {
            if (mRelationModel.businessObjects.item(j).businessObjectFolderID == folderIDArr[i]){
                deleteBusinessObject(mRelationModel.businessObjects.item(j));
            }
        }
    }
}

function deleteBusinessObject(businessObject){
    mRelationModel.businessObjects.remove(businessObject);
}

function dragEvent() {
    $("#businessObjectTree").on("dragstart", "li", function (e) {
        e.originalEvent.dataTransfer.clearData();
        if ($(e.target).hasClass("folder")) {
            e.originalEvent.dataTransfer.setData("folderID", $(e.target).attr("data-folderid"));
        } else {
            e.originalEvent.dataTransfer.setData("businessObjectID", $(e.target).attr("data-objectid"));
        }
    });
    
    $("#businessObjectTree").on("dragover", "div", function (e) {
        e.preventDefault();
    });

    $("#businessObjectTree").on("drop", "div", function (e) {
        //  先判断落点是文件夹还是数据对象
        if($(this).parent("li").hasClass("folder")){
            let folderID = $(this).parent("li").attr("data-folderid");
            // 落点是文件夹，则继续判断拖拽对象是文件夹还是数据对象
            if (e.originalEvent.dataTransfer.getData("folderID")) {
                let dragFolderID = e.originalEvent.dataTransfer.getData("folderID");
                // 落点是文件夹，则继续判断是否移出拖拽对象的父级容器，如移出才做处理，否则不处理
                let isTargetParentFolder = false;
                $(this).parents("li.folder").each(function(){
                    if($(this).attr("data-folderid") == dragFolderID){
                        isTargetParentFolder = true;
                    }
                });
                if (dragFolderID != folderID && !isTargetParentFolder){
                    moveFolderNode(dragFolderID, folderID);
                }
            }else if(e.originalEvent.dataTransfer.getData("businessObjectID")){
                let dragObjectID = e.originalEvent.dataTransfer.getData("businessObjectID");
                // 落点是数据对象，则继续判断是否移出拖拽对象的父级容器，如移出才做处理，否则不处理
                if (mRelationModel.businessObjects.item(dragObjectID).businessObjectFolderID != folderID){
                    moveObjectNode(dragObjectID, folderID);
                }
            } else if (e.originalEvent.dataTransfer.getData("object")) {
                let businessObjectJSONStr = JSON.parse(e.originalEvent.dataTransfer.getData("object"));
                autoGenerateObjects(folderID, [businessObjectJSONStr],true);
            } else if (e.originalEvent.dataTransfer.getData("folder")) {
                let folderAndObject = JSON.parse(e.originalEvent.dataTransfer.getData("folder"));
                autoGenerateFolder(folderID, folderAndObject.folder);
                autoGenerateObjects(folderID, folderAndObject.objects,false);
            }
        } else if ($(this).parent("li").hasClass("object")){
            let businessObjectID = $(this).parent("li").attr("data-objectid");
            let folderID = $(this).parents("li.folder").eq(0).attr("data-folderid");
            // 落点是数据对象，则继续判断拖拽对象是文件夹还是数据对象
            if (e.originalEvent.dataTransfer.getData("folderID")) {
                let dragFolderID = e.originalEvent.dataTransfer.getData("folderID");
                // 落点是文件夹，则继续判断是否移出拖拽对象的父级容器，如移出才做处理，否则不处理
                let isTargetParentFolder = false;
                $(this).parents("li.folder").each(function () {
                    if ($(this).attr("data-folderid") == dragFolderID) {
                        isTargetParentFolder = true;
                    }
                });
                if(folderID != dragFolderID && !isTargetParentFolder){
                    moveFolderNode(dragFolderID, folderID);
                }
            } else if (e.originalEvent.dataTransfer.getData("businessObjectID")){
                let dragObjectID = e.originalEvent.dataTransfer.getData("businessObjectID");
                // 落点是数据对象，则继续判断是否移出拖拽对象的父级容器，如移出才做处理，否则不处理
                if (mRelationModel.businessObjects.item(dragObjectID).businessObjectFolderID != mRelationModel.businessObjects.item(businessObjectID).businessObjectFolderID) {
                    moveObjectNode(dragObjectID, folderID);
                }
            } else if (e.originalEvent.dataTransfer.getData("object")) {
                let businessObjectJSONStr = JSON.parse(e.originalEvent.dataTransfer.getData("object"));
                autoGenerateObjects(folderID, [businessObjectJSONStr], true);
            } else if (e.originalEvent.dataTransfer.getData("folder")) {
                let folderAndObject = JSON.parse(e.originalEvent.dataTransfer.getData("folder"));
                autoGenerateFolder(folderID, folderAndObject.folder);
                autoGenerateObjects(folderID, folderAndObject.objects, false);
            }
        }
    });

    $(".drop-box")[0].ondragover = function (e) {
        e.preventDefault();
    }

    $(".drop-box")[0].ondrop = function(e){
        if (e.dataTransfer.getData("businessObjectID")){
            let businessObjectID = e.dataTransfer.getData("businessObjectID");
            $("#businessObjectTree li.object").each(function(){
                if ($(this).attr("data-objectid") == businessObjectID){
                    moveHtml($(this),"-1");
                }
            });
        }else if (e.dataTransfer.getData("folderID")){
            let folderID = e.dataTransfer.getData("folderID");
            $("#businessObjectTree li.folder").each(function () {
                if ($(this).attr("data-folderid") == folderID) {
                    moveHtml($(this), "-1");
                }
            });
        } else if (e.dataTransfer.getData("object")) {
            let businessObjectJSONStr = JSON.parse(e.dataTransfer.getData("object"));
            autoGenerateObjects("-1", [businessObjectJSONStr], true);
        } else if (e.dataTransfer.getData("folder")) {
            let folderAndObject = JSON.parse(e.dataTransfer.getData("folder"));
            autoGenerateFolder("-1", folderAndObject.folder);
            autoGenerateObjects("-1", folderAndObject.objects, false);
        }
    }
    
}

function autoGenerateFolder(folderID,folderStr){
    let folder = new BusinessObjectFolder();
    folder.init(folderStr);
    folder.folderParentID = folderID;
    let name = folder.folderName;
    let j = 1;
    while (existFolderName(name,folderID)) {
        name = name + j;
        j++;
    }
    folder.folderName = name;
    addFolderSubmit(folder);
}

function autoGenerateObjects(folderID,objects,isSetFolderID){
    for (let i = 0; i < objects.length; i++) {
        let businessObject = new BusinessObject();
        businessObject.init(objects[i]);
        if (isSetFolderID){
            businessObject.businessObjectFolderID = folderID;
        }
        let name = businessObject.businessObjectName;
        let j = 1;
        while (existbusinessObjectName(name)) {
            name = name + j;
            j++;
        }
        businessObject.businessObjectName = name;
        addBusinessObjectSubmit(businessObject);
    }
}

function moveFolderNode(sourceFolderID, targetFolderID){
    $("#businessObjectTree li.folder").each(function(){
        if($(this).attr("data-folderid") == sourceFolderID){
            moveHtml($(this),targetFolderID);
            return false;
        }
    });
    mRelationModel.businessObjectFolders.item(sourceFolderID).folderParentID = targetFolderID;
}

function moveObjectNode(sourceBusinessObjectID, targetFolderID){
    $("#businessObjectTree li.object").each(function () {
        if ($(this).attr("data-objectid") == sourceBusinessObjectID) {
            moveHtml($(this), targetFolderID);
            return false;
        }
    });
    mRelationModel.businessObjects.item(sourceBusinessObjectID).businessObjectFolderID = targetFolderID;
}

function moveHtml(strHtml, targetFolderID) {
    $("#businessObjectTree li.selected-li").removeClass("selected-li");
    if(targetFolderID == "-1"){
        $("#businessObjectTree").append(strHtml);
        $("#businessObjectTree > li:last-child").addClass("selected-li");
    } else {
        $("#businessObjectTree li.folder").each(function () {
            if ($(this).attr("data-folderid") == targetFolderID) {
                $(this).addClass("open-folder hasChildren").children("ul").append(strHtml);
                $(this).children("ul").children("li:last-child").addClass("selected-li");
                $(this).parents("li.folder").addClass("open-folder hasChildren");
                return false;
            }
        });
    }
}

function mouseRightEvent(){
    $("#businessObjectTree").on("mousedown", "li > div", function (e) {//紧接上面的实例demo1 在script中插入这段代码即可获取到鼠标点击事件
        let code = e.which;//判断是单机了鼠标哪个键(1,2,3)
        if (code == 3) {
            $(".diagram-contextmenu").hide();
            $(".left-contextmenu ul").removeClass("hide-li");
            setBoxStyle(e,0);
            $("#businessObjectTree").find("li").removeClass("selected-li");
            $(this).parent().addClass("selected-li");

            let self = $(this).parent("li")[0];
            $(".left-contextmenu li").off("click").on("click", function () {
                if ($(this).attr("data-code") == 0) {
                    addCateGory();
                }
                if ($(this).attr("data-code") == 1) {
                    addBusinessObject();
                }
                if ($(this).attr("data-code") == 2) {
                    addFilterObject();
                }
                if ($(this).attr("data-code") == 3) {
                    openAttribute();
                }
                if ($(this).attr("data-code") == 4) {
                    cloneNodeHtml = null;
                    cloneNodeHtml = $(self).clone(true);
                    copyObjectOrFolder();
                }
                if ($(this).attr("data-code") == 5) {
                    pasteObjectOrFolder(self);
                }
                if ($(this).attr("data-code") == 6) {
                    openDelete();
                }
                $(".diagram-contextmenu").hide();
            });
            e.stopPropagation();
        }
    });

    $(".drop-box").on("mousedown", function(e){
        let code = e.which;
        if(code == 3){
            $(".diagram-contextmenu").hide();
            $(".left-contextmenu ul").addClass("hide-li");
            setBoxStyle(e,1);

            $(".left-contextmenu li").off("click").on("click", function () {
                if ($(this).attr("data-code") == 0) {
                    addCateGory();
                }
                if ($(this).attr("data-code") == 1) {
                    addBusinessObject();
                }
                if ($(this).attr("data-code") == 2) {
                    addFilterObject();
                }
                if ($(this).attr("data-code") == 3) {
                    openAttribute();
                }
                if ($(this).attr("data-code") == 5) {
                    pasteObjectOrFolder($("#businessObjectTree")[0],true);
                }
                $(".diagram-contextmenu").hide();
            });
            // hideContextmenuBox();
            e.stopPropagation();
        }
    });
}

function setBoxStyle(e, index) {
    let positionWidth = 78;
    let positionHeight = index ? 112 : 187;
    let pageX = e.pageX;
    let pageY = e.pageY;
    let documentWidth = $(document).width();
    let documentHeight = $(document).height();
    let styleObj = {};
    styleObj.left = pageX + "px";
    styleObj.top = pageY + "px";
    if (pageX + positionWidth >= documentWidth) {
        styleObj.left = (pageX - positionWidth) + "px";
    }
    if (pageY + positionHeight >= documentHeight) {
        styleObj.top = (pageY - positionHeight) + "px";
    }
    $(".left-contextmenu").show().css(styleObj);
}

function copyObjectOrFolder(){
    copyNewBusinessObjectFolders.clear();
    copyNewBusinessObjects.clear();
    let cloneNodeArr = [];
    cloneNodeArr.push(cloneNodeHtml);
    while (cloneNodeArr.length > 0) {
        let currentNode = cloneNodeArr[0];
        cloneNodeArr.splice(0, 1);
        if (currentNode.hasClass("folder")) {
            let businessObjectFolder = new BusinessObjectFolder();
            businessObjectFolder.init(JSON.parse(JSON.stringify(mRelationModel.businessObjectFolders.item(currentNode.attr("data-folderid")))));
            copyNewBusinessObjectFolders.add(businessObjectFolder);
            if (currentNode.hasClass("hasChildren")) {
                currentNode.children("ul").children("li").each(function () {
                    cloneNodeArr.push($(this));
                });
            }
        } else if (currentNode.hasClass("object")) {
            let businessObject = new BusinessObject();
            businessObject.init(JSON.parse(JSON.stringify(mRelationModel.businessObjects.item(currentNode.attr("data-objectid")))));
            copyNewBusinessObjects.add(businessObject);
        }
    }
    if (copyNewBusinessObjectFolders.count() > 0) {
        copyNewBusinessObjectFolders.item(0).folderParentID = "-1";
    }
}

function pasteObjectOrFolder(elem,isAddRoot){
    let pasteFolderID = ($(elem).hasClass("folder") ? $(elem).attr("data-folderid") : $(elem).parents("li.folder").eq(0).attr("data-folderid")) || "-1";
    let idMaps = {};
    let copyBusinessObjectFolders = new BusinessObjectFolders();
    copyBusinessObjectFolders.init(copyNewBusinessObjectFolders.toJSON());
    let copyBusinessObjects = new BusinessObjects();
    copyBusinessObjects.init(copyNewBusinessObjects.toJSON());
    if (copyBusinessObjectFolders.count() > 0) {
        copyBusinessObjectFolders.item(0).folderParentID = pasteFolderID;
        idMaps[pasteFolderID] = pasteFolderID;
    } else if (copyBusinessObjectFolders.count() == 0 && copyBusinessObjects.count() > 0) {
        copyBusinessObjects.item(0).businessObjectFolderID = pasteFolderID;
        idMaps[pasteFolderID] = pasteFolderID;
    }
    for (let i = 0; i < copyBusinessObjectFolders.count(); i++) {
        let folder = copyBusinessObjectFolders.item(i);
        if (i == 0) {
            let name = folder.folderName;
            let j = 1;
            while (existFolderName(name, pasteFolderID)) {
                name = name + j;
                j++;
            }
            folder.folderName = name;
        }
        let oldFolderID = folder.folderID;
        folder.folderID = guID.newGUID();
        idMaps[oldFolderID] = folder.folderID;
        folder.folderParentID = idMaps[folder.folderParentID];
        mRelationModel.businessObjectFolders.add(folder);
    }
    for (let i = 0; i < copyBusinessObjects.count(); i++) {
        let businessObject = copyBusinessObjects.item(i);
        let name = businessObject.businessObjectName;
        let j = 1;
        while (existbusinessObjectName(name)) {
            name = name + j;
            j++;
        }
        businessObject.businessObjectName = name;
        businessObject.businessObjectID = guID.newGUID();
        businessObject.businessObjectFolderID = idMaps[businessObject.businessObjectFolderID];
        mRelationModel.businessObjects.add(businessObject);
    }
    createPasteDom(elem, copyBusinessObjectFolders, copyBusinessObjects, isAddRoot);
}

function createPasteDom(elem, copyBusinessObjectFolders, copyBusinessObjects, isAddRoot) {
    $("#businessObjectTree li.selected-li").removeClass("selected-li");
    if (copyBusinessObjectFolders.count() > 0) {
        let treeData = setPasteData(copyBusinessObjectFolders, copyBusinessObjects);
        createPasteBusinessObjectTree(treeData, elem, copyBusinessObjects, isAddRoot)
    }
    if (copyBusinessObjectFolders.count() == 0 && copyBusinessObjects.count() > 0) {
        for (let i = 0; i < copyBusinessObjects.count(); i++) {
            let businessObject = copyBusinessObjects.item(i);
            let isLast = (i == copyBusinessObjects.count() - 1) ? true : false;
            let strHtml = `<li class="object ${(isLast ? "selected-li" : "")} ${(businessObject.businessObjectType ? (businessObject.businessObjectType == 1 ? "measure" : "filter-object") : "dimension")}" data-objectID="${businessObject.businessObjectID}" draggable="true">
                <div title="${businessObject.businessObjectName}">
                    <i class="iconfont bda-${(businessObject.businessObjectType ? (businessObject.businessObjectType == 1 ? "measure" : "guolv") : "dimension")}"></i>
                    <span>${businessObject.businessObjectName}</span>
                </div>
            </li>`;
            $("#businessObjectTree li.folder").each(function () {
                if (businessObject.businessObjectFolderID == "-1") {
                    $("#businessObjectTree").append(strHtml);
                    if (!$(".default-status").hasClass("button-color")) {
                        $(".default-status").addClass("button-color");
                    }
                    return false;
                } else {
                    if ($(this).attr("data-folderid") == businessObject.businessObjectFolderID) {
                        $(this).addClass("open-folder hasChildren").children("ul").append(strHtml);
                        $(this).parents("li.folder").addClass("open-folder hasChildren");
                        if (!$(".default-status").hasClass("button-color")) {
                            $(".default-status").addClass("button-color");
                        }
                        return false;
                    }
                }
            });
        }
    }
}

function setPasteData(copyBusinessObjectFolders, copyBusinessObjects) {
    let hashTable = new HashTable();
    hashTable.add(copyBusinessObjectFolders.item(0).folderParentID, { name: "粘贴对象", folderID: copyBusinessObjectFolders.item(0).folderParentID, folderParentID: copyBusinessObjectFolders.item(0).folderParentID });
    for (let i = 0; i < copyBusinessObjectFolders.count(); i++) {
        let folder = copyBusinessObjectFolders.item(i);
        hashTable.add(folder.folderID, {
            name: folder.folderName,
            folderID: folder.folderID,
            folderParentID: folder.folderParentID,
            sortIndex: folder.sortIndex
        });
    }
    for (let i = 0; i < copyBusinessObjects.count(); i++) {
        let businessObject = copyBusinessObjects.item(i);
        if (!hashTable.getValue(businessObject.businessObjectFolderID).children) {
            hashTable.getValue(businessObject.businessObjectFolderID).children = [];
        }
        hashTable.getValue(businessObject.businessObjectFolderID).children.push({
            name: businessObject.businessObjectName,
            businessObjectID: businessObject.businessObjectID,
            folderID: businessObject.businessObjectFolderID,
            businessObjectType: businessObject.businessObjectType,
            sortIndex: businessObject.sortIndex
        });
    }
    for (let i = 0; i < copyBusinessObjectFolders.count(); i++) {
        let folder = copyBusinessObjectFolders.item(i);
        let parentFolder = hashTable.getValue(folder.folderParentID);
        if (!parentFolder.children) {
            parentFolder.children = [];
        }
        parentFolder.children.push(hashTable.getValue(folder.folderID));
    }

    let businessObjectsArr = hashTable.getValue(copyBusinessObjectFolders.item(0).folderParentID).children || [];
    if (businessObjectsArr.children){
        bubbleSort(businessObjectsArr.children);
    }

    return businessObjectsArr;
}

function createPasteBusinessObjectTree(treeData, elem, copyBusinessObjects, isAddRoot) {
    for (let i = 0; i < treeData.length; i++) {
        if (!treeData[i].businessObjectID) {
            let isLast = (i == treeData.length - 1) ? true : false;
            if (isLast) {
                if (copyBusinessObjects.count() == 0 && !treeData[i].children) {
                    isLast = true;
                } else {
                    isLast = false;
                }
            }
            let strHtml = `<li class="folder ${(isLast ? "selected-li" : "")} open-folder" data-folderID="${treeData[i].folderID}" draggable="true">
                <div title="${treeData[i].name}">
                    <i class="iconfont bda-wenjianjia"></i>
                    <span class="folder-name">${treeData[i].name}</span>
                    <span class="triangle"></span>
                </div>
                <ul></ul>
            </li>`;
            if ($(elem).hasClass("folder") || isAddRoot) {
                if (isAddRoot){
                    $(elem).append(strHtml);
                }else{
                    $(elem).children("ul").append(strHtml);
                }
            } else {
                $(elem).parent("ul").append(strHtml);
            }
            if (treeData[i].children) {
                if ($(elem).hasClass("folder") || isAddRoot) {
                    if (isAddRoot) {
                        $(elem).children("li:last-child").addClass("hasChildren open-folder");
                        createPasteChildrenFolder(treeData[i].children, $(elem).children("li:last-child").children("ul"), copyBusinessObjects);
                    } else {
                        $(elem).addClass("hasChildren open-folder").children("ul").children("li:last-child").addClass("hasChildren");
                        createPasteChildrenFolder(treeData[i].children, $(elem).children("ul").children("li:last-child").children("ul"), copyBusinessObjects);
                    }
                } else {
                    $(elem).parent("ul").children("li:last-child").addClass("hasChildren");
                    createPasteChildrenFolder(treeData[i].children, $(elem).parent("ul").children("li:last-child").children("ul"), copyBusinessObjects);
                }
            }
        } else {
            let isLast = (i == treeData.length - 1) ? true : false;
            let strHtml = `<li class="object ${(isLast ? "selected-li" : "")} ${(treeData[i].businessObjectType ? (treeData[i].businessObjectType == 1 ? "measure" : "filter-object") : "dimension")}" data-objectID="${treeData[i].businessObjectID}" draggable="true">
                <div title="${treeData[i].name}">
                    <i class="iconfont bda-${(treeData[i].businessObjectType ? (treeData[i].businessObjectType == 1 ? "measure" : "guolv") : "dimension")}"></i>
                    <span>${treeData[i].name}</span>
                </div>
            </li>`;
            $(elem).children("ul").append(strHtml);
        }
    }
}

function createPasteChildrenFolder(childrenArr, element, copyBusinessObjects) {
    for (let i = 0; i < childrenArr.length; i++) {
        if (!childrenArr[i].businessObjectID) {
            let isLast = (i == childrenArr.length - 1) ? true : false;
            if (isLast) {
                if (copyBusinessObjects.count() == 0 && !childrenArr[i].children) {
                    isLast = true;
                } else {
                    isLast = false;
                }
            }
            let strHtml = `<li class="folder ${(isLast ? "selected-li" : "")} open-folder" data-folderID="${childrenArr[i].folderID}" draggable="true">
                <div title="${childrenArr[i].name}">
                    <i class="iconfont bda-wenjianjia"></i>
                    <span class="folder-name">${childrenArr[i].name}</span>
                    <span class="triangle"></span>
                </div>
                <ul></ul>
            </li>`;
            element.append(strHtml);
            if (childrenArr[i].children) {
                element.children("li:last-child").addClass("hasChildren");
                createChildrenFolder(childrenArr[i].children, element.children("li:last-child").children("ul"), copyBusinessObjects);
            }
        } else {
            let isLast = (i == childrenArr.length - 1) ? true : false;
            let strHtml = `<li class="object ${(isLast ? "selected-li" : "")} ${(childrenArr[i].businessObjectType ? (childrenArr[i].businessObjectType == 1 ? "measure" : "filter-object") : "dimension")}" data-objectID="${childrenArr[i].businessObjectID}" draggable="true">
                <div title="${childrenArr[i].name}">
                    <i class="iconfont bda-${(childrenArr[i].businessObjectType ? (childrenArr[i].businessObjectType == 1 ? "measure" : "guolv") : "dimension")}"></i>
                    <span>${childrenArr[i].name}</span>
                </div>
            </li>`;
            element.append(strHtml);
        }
    }
}

function existFolderName(name, folderParentID) {
    for (let i = 0; i < mRelationModel.businessObjectFolders.count(); i++) {
        if (mRelationModel.businessObjectFolders.item(i).folderParentID == folderParentID && name == mRelationModel.businessObjectFolders.item(i).folderName) {
            return true;
        }
    }
    return false;
}

function existbusinessObjectName(name) {
    for (let i = 0; i < mRelationModel.businessObjects.count(); i++) {
        if (mRelationModel.businessObjects.item(i).businessObjectName == name) {
            return true;
        }
    }
    return false;
}

const addFolderSubmit = (businessObjectFolder) => {
    mRelationModel.businessObjectFolders.add(businessObjectFolder);
    addFolderNode(businessObjectFolder);
};

function addFolderNode(businessObjectFolder){
    $("#businessObjectTree li.selected-li").removeClass("selected-li");
    $("#businessObjectTree li.folder").each(function () {
        let strHtml = `<li class="folder selected-li" data-folderID="${businessObjectFolder.folderID}" draggable="true">
                <div title="${businessObjectFolder.folderName}">
                    <i class="iconfont bda-wenjianjia"></i>
                    <span class="folder-name">${businessObjectFolder.folderName}</span>
                    <span class="triangle"></span>
                </div>
                <ul></ul>
            </li>`;
        if(businessObjectFolder.folderParentID == "-1"){
            $("#businessObjectTree").append(strHtml);
            if (!$(".default-status").hasClass("button-color")) {
                $(".default-status").addClass("button-color");
            }
            return false;
        }else{
            if ($(this).attr("data-folderid") == businessObjectFolder.folderParentID) {
                $(this).addClass("open-folder hasChildren").children("ul").append(strHtml);
                $(this).parents("li.folder").addClass("open-folder hasChildren");
                if (!$(".default-status").hasClass("button-color")) {
                    $(".default-status").addClass("button-color");
                }
                return false;
            }
        }
    });
}

const editFolderSubmit = (businessObjectFolder) => {
    $("#businessObjectTree li.folder").each(function () {
        if ($(this).attr("data-folderid") == businessObjectFolder.folderID) {
            $(this).children("div").attr("title", businessObjectFolder.folderName);
            $(this).children("div").find("span.folder-name").text(businessObjectFolder.folderName);
            return false;
        }
    });
};

const addBusinessObjectSubmit = (businessObject) => {
    mRelationModel.businessObjects.add(businessObject);
    addBusinessObjectNode(businessObject);
    totalBusinessObject(mRelationModel.businessObjects.count());
};

function addBusinessObjectNode(businessObject){
    $("#businessObjectTree li.selected-li").removeClass("selected-li");
    let strHtml = `<li class="object selected-li ${(businessObject.businessObjectType ? (businessObject.businessObjectType == 1 ? "measure" : "filter-object") : "dimension")}" data-objectID="${businessObject.businessObjectID}" draggable="true">
        <div title="${businessObject.businessObjectName}">
            <i class="iconfont bda-${(businessObject.businessObjectType ? (businessObject.businessObjectType == 1 ? "measure" : "guolv") : "dimension")}"></i>
            <span>${businessObject.businessObjectName}</span>
        </div>
    </li>`;
    $("#businessObjectTree li.folder").each(function () {
        if(businessObject.businessObjectFolderID == "-1"){
            $("#businessObjectTree").append(strHtml);
            if (!$(".default-status").hasClass("button-color")) {
                $(".default-status").addClass("button-color");
            }
            return false;
        }else{
            if ($(this).attr("data-folderid") == businessObject.businessObjectFolderID) {
                $(this).addClass("open-folder hasChildren").children("ul").append(strHtml);
                $(this).parents("li.folder").addClass("open-folder hasChildren");
                if (!$(".default-status").hasClass("button-color")) {
                    $(".default-status").addClass("button-color");
                }
                return false;
            }
        }
    });
}

const editBusinessObjectSubmit = (businessObject) => {
    $("#businessObjectTree li.object").each(function () {
        if ($(this).attr("data-objectID") == businessObject.businessObjectID) {
            $(this).children("div").attr("title", businessObject.businessObjectName);
            $(this).children("div").find("span").text(businessObject.businessObjectName);
            return false;
        }
    });
};

function bubbleSort(arr) {
    for (var i = 0; i < arr.length; i++) {
        if (arr[i].children) {
            bubbleSort(arr[i].children);
        }
    }
    arr.sort(function (a, b) {
        return a.sortIndex - b.sortIndex;
    });
}

export { initBusinessObjects };