/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-04-26 15:10:28
 * @LastEditTime: 2021-05-10 20:14:06
 * @LastModifyUser: 
 * @Remark: 
 */
!function () {
    var $ = layui.jquery, layer = layui.layer, form = layui.form;
    var organizations = new Organizations();
    var bmPublishes = new BmPublishes();
    var bmPublish = new BmPublish();
    var reportPublish = new ReportPublish();
    var reportPublishes = new ReportPublishes();
    var mType = null, mPublishContent = null, layerIndex = null, formSubmit = null;

    window.initPublisherForm = function(type, publishContent, index, updatePublisher){
        mType = type;
        mPublishContent = publishContent;
        layerIndex = index;
        formSubmit = updatePublisher;

        getOrganizationsAndPublish();
    };

    function getOrganizationsAndPublish(){
        var succ = function () {
            if (mPublishContent.publishStatus == 0) {
                initForm();
            } else {
                if (mType == 0) {
                    getBusinessModelPublish();
                } else if (mType == 1) {
                    getReportPublish();
                }
            }
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取组织列表", errorStatus, msg);
        };
        organizations.getItems(true, succ, fail);
    }

    function getBusinessModelPublish(){
        var succ = function () {
            initForm();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取模型发布列表", errorStatus, msg);
        };
        bmPublish.businessModelID = mPublishContent.businessModelID;
        bmPublish.getItemByID(true, succ, fail);
    }

    function getReportPublish(){
        var succ = function () {
            initForm();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取报表发布列表", errorStatus, msg);
        };
        reportPublish.reportID = mPublishContent.reportID;
        reportPublish.getItemByID(true, succ, fail);
    }

    function initForm(){
        form.val("formWindow", {
            publishType: mPublishContent.publishStatus == 0 ? 0 : (mType == 0 ? bmPublish.publishType : reportPublish.publishType),
            publishStatus: mPublishContent.publishStatus == 2 ? true : false
        });

        var createUserName = mPublishContent.publishStatus == 0 ? $AppVars.gUser.userName : (mType == 0 ? (bmPublish.createUserName || "") : (reportPublish.createUserName || ""));
        var createDate = mPublishContent.publishStatus == 0 ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date()) : (mType == 0 ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(bmPublish.createDate)) : $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(reportPublish.createDate)));
        var lastModifyUserName = mPublishContent.publishStatus == 0 ? "" : (mType == 0 ? (bmPublish.lastModifyUserName || "") : (reportPublish.lastModifyUserName || ""));
        var lastModifyDate = mPublishContent.publishStatus == 0 ? "" : (mType == 0 ? (bmPublish.lastModifyDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(bmPublish.lastModifyDate)) : "") : (reportPublish.lastModifyDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(reportPublish.lastModifyDate)) : ""));
        $(".bottom-item .createUserName").text(createUserName);
        $(".bottom-item .createDate").text(createDate);
        $(".bottom-item .lastModifyUserName").text(lastModifyUserName);
        $(".bottom-item .lastModifyDate").text(lastModifyDate);

        createOrganizationTree();

        if (mPublishContent.publishStatus != 0 && (bmPublish.publishType == 1 || "")){
            $(".publisher-organization-list").removeClass("publisher-disabled");
        }

        $Utils.loading.close();

        bindEvent();
    }

    function createOrganizationTree(){
        var treeData = setTreeData();
        $(".publisher-organization-list > ul").html("");
        var str = "";
        for(var i = 0; i < treeData.length; i++){
            if (treeData[i].children){
                str = "<li class='folder' data-organizationid=" + treeData[i].organizationID + "><label><span></span></label><div title='" + treeData[i].title + "'>" + treeData[i].title + "</div><ul style='display:none;'></ul></li>";
            }else{
                str = "<li class='folder' data-organizationid=" + treeData[i].organizationID + "><div title='" + treeData[i].title + "'>" + treeData[i].title + "</div><ul style='display:none;'></ul></li>";
            }
            $(".publisher-organization-list > ul").append(str);
            if (treeData[i].children) {
                createChildrenDom(treeData[i].children, $(".publisher-organization-list"));
            }
        }

        var publishedOrganizationArr = [];
        if(mType == 0){
            for (var i = 0; i < bmPublish.bmpDestinationOrganizations.count; i++) {
                if (publishedOrganizationArr.indexOf(bmPublish.bmpDestinationOrganizations.item(i).destinationOrganizationID) == -1) {
                    publishedOrganizationArr.push(bmPublish.bmpDestinationOrganizations.item(i).destinationOrganizationID);
                }
            }

            if (publishedOrganizationArr.length > 0) {
                $(".publisher-organization-list li").each(function () {
                    if (publishedOrganizationArr.indexOf($(this).attr("data-organizationid")) != -1) {
                        $(this).addClass("select-value");
                    }
                });
            }
        }else{
            for (var i = 0; i < reportPublish.rpDestinationOrganizations.count; i++) {
                if (publishedOrganizationArr.indexOf(reportPublish.rpDestinationOrganizations.item(i).destinationOrganizationID) == -1) {
                    publishedOrganizationArr.push(reportPublish.rpDestinationOrganizations.item(i).destinationOrganizationID);
                }
            }

            if (publishedOrganizationArr.length > 0) {
                $(".publisher-organization-list li").each(function () {
                    if (publishedOrganizationArr.indexOf($(this).attr("data-organizationid")) != -1) {
                        $(this).addClass("select-value");
                    }
                });
            }
        }
    }

    function createChildrenDom(childrenArr, elem){
        var str = "";
        for (var i = 0; i < childrenArr.length; i++) {
            if (childrenArr[i].children){
                str = "<li class='folder' data-organizationid=" + childrenArr[i].organizationID + "><label><span></span></label><div title='" + childrenArr[i].title + "'>" + childrenArr[i].title + "</div><ul style='display:none;'></ul></li>";
            }else{
                str = "<li class='folder' data-organizationid=" + childrenArr[i].organizationID + "><div title='" + childrenArr[i].title + "'>" + childrenArr[i].title + "</div><ul style='display:none;'></ul></li>";
            }
            $(elem).find("li").each(function(){
                if ($(this).attr("data-organizationid") == childrenArr[i].organizationParentID){
                    $(this).children("ul").append(str);
                }
            });
            if (childrenArr[i].children) {
                createChildrenDom(childrenArr[i].children, $(elem));
            }
        }
    }

    function setTreeData(){
        var hashTable = new $Utils.HashTable();
        hashTable.add("-1", { title: "组织列表", organizationID: "-1", organizationParentID: "-1"});
        for (var i = 0; i < organizations.count; i++) {
            hashTable.add(organizations.item(i).organizationID, { title: organizations.item(i).organizationShortName, organizationID: organizations.item(i).organizationID, organizationParentID: organizations.item(i).organizationParentID || "-1" });
        }
        for (var i = 0; i < organizations.count; i++) {
            var parentFolder = hashTable.getValue(organizations.item(i).organizationParentID || "-1");
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(organizations.item(i).organizationID));
        }

        return hashTable.getValue("-1").children;
    }

    function bindEvent(){
        form.on("radio(publishType)", function (data) {
            if (this.value == '0') {
                $(".publisher-organization-list").addClass("publisher-disabled");
            } else if (this.value == '1') {
                $(".publisher-organization-list").removeClass("publisher-disabled");
            }
        });

        $(".publisher-organization-list li").on("click", "label", function (e) {
            if ($(this).siblings("ul").is(":hidden")) {
                $(this).siblings("ul").show(200);
                $(this).parent("li").addClass("select-folder");
            } else {
                $(this).siblings("ul").hide(200);
                $(this).parent("li").removeClass("select-folder");
            }
            e.stopPropagation();
        });

        $(".publisher-organization-list li").on("click", "div", function (e) {
            if (!$(".publisher-organization-list").hasClass("publisher-disabled")) {
                var me = $(this).parent("li");
                if (!$(me).hasClass("select-value")) {
                    $(me).addClass("select-value");
                } else {
                    $(me).removeClass("select-value");
                }
                e.stopPropagation();
            }
        });

        $(".layui-btn-cancel").click(function () {
            layer.close(layerIndex);
        });

        form.on('submit(formSubmit)', function (data) {
            debugger
            if(validate(data)){
                if (mPublishContent.publishStatus == 0) {
                    $Utils.loading.open();
                    submitPublisher(data);
                }else{
                    if (change(data)) {
                        $Utils.loading.open();
                        submitPublisher(data);
                    }else{
                        layer.close(layerIndex);
                    }
                }
            }
            return false;
        });
    }

    function validate(data){
        if (data.field.publishType == 1 && !data.field.publishStatus && $(".publisher-organization-list li.select-value").length < 1){
            layer.msg("必须勾选一个组织才能发布。", { icon: 2});
            return false;
        }
        return true;
    }

    function change(data){
        if (data.field.publishType != mPublishContent.publishType){
            return true;
        }
        if (data.field.publishStatus && (mPublishContent.publishStatus != 2)){
            return true;
        }
        if (!data.field.publishStatus && (mPublishContent.publishStatus == 2)) {
            return true;
        }
        var selectOrganizationIDs = [];
        $(".publisher-organization-list li.select-value").each(function(){
            if(selectOrganizationIDs.indexOf($(this).attr("data-organizationid")) == -1){
                selectOrganizationIDs.push($(this).attr("data-organizationid"));
            }
        });
        var oldOrganizationIDs = [];
        if (mType == 0) {
            for (var i = 0; i < bmPublish.bmpDestinationOrganizations.count; i++) {
                if (oldOrganizationIDs.indexOf(bmPublish.bmpDestinationOrganizations.item(i).destinationOrganizationID) == -1) {
                    oldOrganizationIDs.push(bmPublish.bmpDestinationOrganizations.item(i).destinationOrganizationID);
                }
            }
        }else if(mType == 1){
            for (var i = 0; i < reportPublish.rpDestinationOrganizations.count; i++) {
                if (oldOrganizationIDs.indexOf(reportPublish.rpDestinationOrganizations.item(i).destinationOrganizationID) == -1) {
                    oldOrganizationIDs.push(reportPublish.rpDestinationOrganizations.item(i).destinationOrganizationID);
                }
            }
        }

        for(var i = 0; i < selectOrganizationIDs.length; i++){
            if(oldOrganizationIDs.indexOf(selectOrganizationIDs[i]) != -1){
                return true;
            }
        }

        return false;
    }

    function submitPublisher(data){
        if(mType == 0){
            var submitPublish = setModelPulish(data);
            var succ = function () {
                $Utils.loading.close();
                mPublishContent.publishStatus = submitPublish.publishStatus;
                mPublishContent.publishType = submitPublish.publishType;
                formSubmit(mPublishContent);
                layer.close(layerIndex);
            };
            var fail = function (errorStatus, msg) {
                $Utils.loading.close();
                $Utils.openWindow.failWindow("发布", errorStatus, msg);
            };
            if(mPublishContent.publishStatus == 0){
                bmPublishes.addItem(submitPublish,true,succ,fail);
            } else {
                bmPublishes.editItem(submitPublish, true, succ, fail);
            }
        }else if(mType == 1){
            var submitPublish = setReportPulish(data);
            var succ = function () {
                $Utils.loading.close();
                mPublishContent.publishStatus = submitPublish.publishStatus;
                mPublishContent.publishType = submitPublish.publishType;
                formSubmit(mPublishContent);
                layer.close(layerIndex);
            };
            var fail = function (errorStatus, msg) {
                $Utils.loading.close();
                $Utils.openWindow.failWindow("发布", errorStatus, msg);
            };
            if (mPublishContent.publishStatus == 0) {
                reportPublishes.addItem(submitPublish, true, succ, fail);
            } else {
                reportPublishes.editItem(submitPublish, true, succ, fail);
            }
        }
    }

    function setModelPulish(data){
        var tempBmPublish = new BmPublish();
        tempBmPublish.businessModelID = mPublishContent.businessModelID;
        tempBmPublish.publishType = data.field.publishType;
        tempBmPublish.publishStatus = data.field.publishStatus ? 2 : 1;
        tempBmPublish.bmpDestinationOrganizations = [];
        if (tempBmPublish.publishType == 1) {
            var selectOrganizationIDs = [];
            $(".publisher-organization-list li.select-value").each(function () {
                if (selectOrganizationIDs.indexOf($(this).attr("data-organizationid")) == -1) {
                    selectOrganizationIDs.push($(this).attr("data-organizationid"));
                }
            });
            var bmpDestinationOrganizations = [];
            for (var i = 0; i < selectOrganizationIDs.length; i++) {
                var tempObj = {};
                tempObj.businessModelID = mPublishContent.businessModelID;
                tempObj.destinationOrganizationID = selectOrganizationIDs[i];
                bmpDestinationOrganizations.push(tempObj);
            }
            tempBmPublish.bmpDestinationOrganizations = bmpDestinationOrganizations;
        }
        return tempBmPublish;
    }

    function setReportPulish(data){
        var tempReportPublish = new ReportPublish();
        tempReportPublish.reportID = mPublishContent.reportID;
        tempReportPublish.publishType = data.field.publishType;
        tempReportPublish.publishStatus = data.field.publishStatus ? 2 : 1;
        tempReportPublish.rpDestinationOrganizations = [];
        if (tempReportPublish.publishType == 1) {
            var selectOrganizationIDs = [];
            $(".publisher-organization-list li.select-value").each(function () {
                if (selectOrganizationIDs.indexOf($(this).attr("data-organizationid")) == -1) {
                    selectOrganizationIDs.push($(this).attr("data-organizationid"));
                }
            });
            var rpDestinationOrganizations = [];
            for (var i = 0; i < selectOrganizationIDs.length; i++) {
                var tempObj = {};
                tempObj.reportID = mPublishContent.reportID;
                tempObj.destinationOrganizationID = selectOrganizationIDs[i];
                rpDestinationOrganizations.push(tempObj);
            }
            tempReportPublish.rpDestinationOrganizations = rpDestinationOrganizations;
        }

        return tempReportPublish;
    }

}();