function initWithObject(instance, aryObjectProperties, jObject){
    for(var key in jObject){
        if(instance[key] === undefined) continue;
        if(jObject[key] == null){
            instance[key] = null
        }else{
            if(aryObjectProperties.indexOf(key) == -1){
                instance[key] = jObject[key];
            }
            else if(instance[key] && instance[key].init){
                instance[key].init(jObject[key]);
            }
        }
    }
};


//调用的集合类必须有clear方法和add方法
function initWithArray(collection, constructor, jArray){
    collection.clear();
    for(var i = 0; i < jArray.length; i++){
        var modelObject = new constructor();
        modelObject.init(jArray[i]);
        collection.add(modelObject);
    }
}

function decrypt(word, password){
    var key = CryptoJS.enc.Utf8.parse(password);
    var decrypt = CryptoJS.AES.decrypt(word, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
    return CryptoJS.enc.Utf8.stringify(decrypt).toString();
}

function encrypt(word, password){
    var key = CryptoJS.enc.Utf8.parse(password);
    var srcs = CryptoJS.enc.Utf8.parse(word);
    var encrypted = CryptoJS.AES.encrypt(srcs, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
    return encrypted.toString();
}

function Utf8ArrayToStr(array) {
    var out, i, len, c;
    var char2, char3;
 
    out = "";
    len = array.length;
    i = 0;
    while(i < len) {
    c = array[i++];
    switch(c >> 4)
    { 
      case 0: case 1: case 2: case 3: case 4: case 5: case 6: case 7:
        // 0xxxxxxx
        out += String.fromCharCode(c);
        break;
      case 12: case 13:
        // 110x xxxx   10xx xxxx
        char2 = array[i++];
        out += String.fromCharCode(((c & 0x1F) << 6) | (char2 & 0x3F));
        break;
      case 14:
        // 1110 xxxx  10xx xxxx  10xx xxxx
        char2 = array[i++];
        char3 = array[i++];
        out += String.fromCharCode(((c & 0x0F) << 12) |
                       ((char2 & 0x3F) << 6) |
                       ((char3 & 0x3F) << 0));
        break;
    }
    }
 
    return out;
}
function Utf16ArrayToStr(array) {
    var out, i, len, c;
    var char2, char3;
 
    out = "";
    len = array.length;
    i = 0;
    while(i < len) {
    c = array[i];
    i += 2;
    switch(c >> 4)
    { 
      case 0: case 1: case 2: case 3: case 4: case 5: case 6: case 7:
        // 0xxxxxxx
        out += String.fromCharCode(c);
        break;
      case 12: case 13:
        // 110x xxxx   10xx xxxx
        char2 = array[i];
        i += 2;
        out += String.fromCharCode(((c & 0x1F) << 6) | (char2 & 0x3F));
        break;
      case 14:
        // 1110 xxxx  10xx xxxx  10xx xxxx
        char2 = array[i];
        i += 2;
        char3 = array[i];
        i += 2;
        out += String.fromCharCode(((c & 0x0F) << 12) |
                       ((char2 & 0x3F) << 6) |
                       ((char3 & 0x3F) << 0));
        break;
    }
    }
 
    return out;
}
// function uniencode(text) { 
//     var aaa = escape(text.toString());
//     text = escape(text.toString()).replace("+", "%2B"); 
//     var matches = text.match(/(%([0-9A-F]{2}))/gi);
//      if (matches) { 
//         for (var matchid = 0; matchid < matches.length; matchid++) { 
//             var code = matches[matchid].substring(1,3); 
//             if (parseInt(code, 16) >= 128) { 
//                 text = text.replace(matches[matchid], '%u00' + code); 
//             } 
//         } 
//     } 
//     text = text.replace('%25', '%u0025');
//     return text;
// }
function trim(text,ch){
    var startIndex = 0;
    var endIndex = text.length - 1;
    for(;startIndex < text.length; startIndex++){
        if(text.charAt(startIndex) != ch) break;
    }
    for(;endIndex >= 0; endIndex--){
        if(text.charAt(endIndex) != ch) break;
    }
    if(startIndex >= endIndex){
        return "";
    }else{
        return text.substring(startIndex, endIndex);
    }
}
function UTF8ToUTF16(str) {
    var uint16 = new Uint16Array(str.length); // 并非所有的字符都是2个字节可以搞定，有的字符需要4个字节，此处32位字符的长度是2，正确
    // Array.prototype.forEach.call(null, function (el, idx, arr) { arr[idx] = str.charCodeAt(idx); }); // MDN的高级写法
    var length = uint16.length; // 'A\u4F60\u{2F804}'.length // 1+1+2=4
    for (var i = 0; i < length; i++) {
        uint16[i] = str.charCodeAt(i); // 4字节字符需要前后取两次
    }
    return uint16;
}
function ArrayBuffer2Base64(buffer) {
    var binary = '';
    var bytes = new Uint8Array(buffer);
    var len = bytes.byteLength;
    // 将原始二进制数据按字节转换, 拼接为二进制字符串
    for (var i = 0; i < len; i++) {
        if (len - i > 70) { // 减少binary拼接次数
          binary += String.fromCharCode(bytes[i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i],
            bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i],
            bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i],
            bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i],
            bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i],
            bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i],
            bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i], bytes[++i],
          );
        } else if (len - i > 5) { // 减少binary拼接次数
            binary += String.fromCharCode(bytes[i], bytes[++i], bytes[++i], bytes[++i], bytes[++i]);
        } else {
            binary += String.fromCharCode(bytes[i]);
        }
    }
    return window.btoa(binary);
}
function btoaUTF16(sString) {
    // var aUTF16CodeUnits = new Uint16Array(sString.length);
    // Array.prototype.forEach.call(aUTF16CodeUnits, function (el, idx, arr) { arr[idx] = sString.charCodeAt(idx); });
    // return btoa(String.fromCharCode.apply(null, new Uint8Array(aUTF16CodeUnits.buffer)));

    var uint16 = UTF8ToUTF16(sString);
    var buffer = uint16.buffer;
    return ArrayBuffer2Base64(buffer);
}
function HashTable() {
    var size = 0;
    var entry = new Object();
    this.add = function (key, value) {
        if (!this.containsKey(key)) {
            size++;
        }
        entry[key] = value;
    }
    this.getValue = function (key) {
        return this.containsKey(key) ? entry[key] : null;
    }
    this.remove = function (key) {
        if (this.containsKey(key) && (delete entry[key])) {
            size--;
        }
    }
    this.containsKey = function (key) {
        return (key in entry);
    }
    this.containsValue = function (value) {
        for (var prop in entry) {
            if (entry[prop] == value) {
                return true;
            }
        }
        return false;
    }
    this.getValues = function () {
        var values = new Array();
        for (var prop in entry) {
            values.push(entry[prop]);
        }
        return values;
    }
    this.getKeys = function () {
        var keys = new Array();
        for (var prop in entry) {
            keys.push(prop);
        }
        return keys;
    }
    this.getSize = function () {
        return size;
    }
    this.clear = function () {
        size = 0;
        entry = new Object();
    }
}
class BDAResult {
    constructor(result, msg) {
        this.result = result;
        this.message = msg;
    }
}
/**
 * 获取符合规范的名字
 */
function getAppropriateName(originalString) {
    var result = originalString;
    var re1 = /^[0-9]/m
    if (re1.test(result)) {
        result = "_" + result;
    }
    result = result.replace(/[ ()（）`~@#$￥%^&*{}:;\[\]|\\/'\""<>.,+=!-]/, "_");
    return mergeDuplicateUnderLine(result);
}
/**
 * 去除重复的下划线
 */
function mergeDuplicateUnderLine(originalString) {
    var sbResult = "";
    var lastCharIsUnderLine = false;
    for (var i = 0; i < originalString.length; i++) {
        let ch = originalString.charAt(i);
        if (ch == "_") {
            if (!lastCharIsUnderLine) {
                sbResult += ch;
            }
            lastCharIsUnderLine = true;
        } else {
            sbResult += ch;
            lastCharIsUnderLine = false;
        }
    }
    return sbResult;
}

if (typeof String.prototype.startsWith != 'function') {
    String.prototype.startsWith = function (prefix) {
        return this.slice(0, prefix.length) === prefix;
    };
}

if (typeof String.prototype.endsWith != 'function') {
    String.prototype.endsWith = function (suffix) {
        return this.indexOf(suffix, this.length - suffix.length) !== -1;
    };
}

function isNameCorrect(name){
    let specialChar = "`[]/\"#%￥\\*+^$";
    let numRep = /^[0-9]/;
    let result = new BDAResult(true);
    for(let i = 0; i < name.length; i++){
        if(specialChar.indexOf(name[i]) != -1){
            result.result = false;
            result.message = "名称中不能包含：`、#、$、￥、%、^、*、+、[、]、\"、/、\\这些符号，这些符号已经被系统内部使用。";
            break;
        }
        if (name.indexOf("___") != -1) {
            result.result = false;
            result.message = "名称中不能包含三个以上的连续的下划线。";
            break;
        }
        if (name.endsWith("_")) {
            result.result = false;
            result.message = "名称不能以下划线结尾。";
            break;
        }
        if (numRep.test(name)) {
            result.result = false;
            result.message = "名称不能以数字开头。";
            break;
        }
    }
    return result;

}

function isStrictNameCorrect(name) {
    let specialChar = "()（）`~@#$￥%^&*{}:;[]|\\/'\"'<>.,+=-!";
    let numRep = /^[0-9]/;
    let result = new BDAResult(true);
    for (let i = 0; i < name.length; i++) {
        if (specialChar.indexOf(name[i]) != -1) {
            result.result = false;
            result.message = "名称中不能包含：(、)、（、）、`、~、@、#、$、￥、%、^、&、*、{、}、:、;、[、]、|、\\、/、'、\"、'、<、>、.、,、+、=、-、!这些符号，这些符号已经被系统内部使用。";
            break;
        }
        if (name.indexOf("___") != -1) {
            result.result = false;
            result.message = "名称中不能包含三个以上的连续的下划线。";
            break;
        }
        if (name.endsWith("_")) {
            result.result = false;
            result.message = "名称不能以下划线结尾。";
            break;
        }
        if (numRep.test(name)) {
            result.result = false;
            result.message = "名称不能以数字开头。";
            break;
        }
    }
    return result;
}