function ReportFolders(){
	var me = this;
    var aryReportFolders = [];

    this.count = function(){
        return aryReportFolders.length;
    };
    this.clear = function(){
        aryReportFolders = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryReportFolders[indexOrKey];
        }else{
            for(var i = 0; i < aryReportFolders.length; i++){
                if(aryReportFolders[i].folderID == indexOrKey){
                    return aryReportFolders[i];
                }
            }
        }
    };
    this.add = function (reprortFolder) {
        aryReportFolders.push(reprortFolder);
    };
    this.remove = function (reprortFolder) {
        for(var i = 0; i < aryReportFolders.length; i++){
            if(aryReportFolders[i].folderID==reprortFolder.folderID){
                k = i;
                break;
            }
        }
        aryReportFolders.splice(k,1);
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(folder,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath;
        var obj = JSON.stringify(folder);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var folderID = request.getResponseHeader('location').split('/reportFolders/')[1];
                folder.folderID = folderID;
                me.add(folder);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(folder,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath + "/" + folder.folderID;
        var obj = JSON.stringify(folder);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(folderID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath + "/" + folderID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(folderID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jArray){
        initWithArray(this, ReportFolder.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryReportFolders;
    }
}


function ReportFolder(){
    var me = this;
    this.folderID = null;
    this.folderName = null;
    this.folderParentID = null;
    this.organizationID = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = (new Date()).getTime();
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;

    this.folderChildren = [];
    Object.defineProperties(this, {
        folderChildren: {
            enumerable: false
        }
    });

    
    this.getItemByID = function(folderID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath + "/" + folderID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function Reports(){
    var me = this;
    var aryReports = [];

    this.count = function(){
        return aryReports.length;
    };
    this.clear = function(){
        aryReports = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryReports[indexOrKey];
        }else{
            for(var i = 0; i < aryReports.length; i++){
                if(aryReports[i].reportID == indexOrKey){
                    return aryReports[i];
                }
            }
        }
    };
    this.add = function (report) {
        aryReports.push(report);
    };
    this.remove = function (report) {
        for(var i = 0; i < aryReports.length; i++){
            if(aryReports[i].reportID==report.reportID){
                k = i;
                break;
            }
        }
        aryReports.splice(k,1);
    };
    this.getItemsByFolderID = function(folderID,moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "?folderID=" + folderID + "&moduleID=" + moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(report,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath;
        var obj = JSON.stringify(report);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var reportID = request.getResponseHeader('location').split('/reports/')[1];
                report.reportID = reportID;
                me.add(report);
                succ(reportID);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(report,asyncOrSync,succ,fail, param){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + report.reportID;
        if(param){
            url = url + param;
        }
        var obj = JSON.stringify(report);
        obj = obj.replace(/\?\?\?/g,"/?/?/?");

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editSimpleProperty = function(report,parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + report.reportID + "/simpleProperties?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    }
    this.deleteItem = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(reportID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getUsedCount = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.modelReportsPath + "/count?modelID="+businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.property);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(textStatus == "timeout"){
                fail("请求超时。");
            }
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getReportByName = function(reportName, folderID){
        for(var i = 0; i < aryReports.length; i++){
            if(aryReports[i].reportName == reportName && aryReports[i].folderID == folderID){
                return aryReports[i];
            }
        }
        return null;
    };
    this.init = function(jArray){
        initWithArray(this, Report.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryReports;
    };
}

function Report(){
    var me = this;
    this.reportID = null;
    this.reportName = null;
    this.folderID = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = (new Date()).getTime();
    this.createSource = 0;
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;
    this.reportSettings = new ReportSettings();
    this.reportDesign = new ReportDesign();

    this.getItemByID = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getSimpleItemByID = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID + "/simpleProperties";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemAllPropertiesByID = function (reportID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getReportDesign = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID + "/reportDesign";
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getReleaseDevices = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + this.reportID + "/reportVisibilities";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateRelease = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + this.reportID + "/reportVisibilities?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.uploadResource = function(resource,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + this.reportID + "/reportImages";
        var obj = resource;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };


    this.init = function(jObject){
        initWithObject(this, ["reportSettings", "reportDesign"],jObject);
    };

}

function ReportSettings(){
    var me = this;
    var aryReportSettings = [];

    this.count = function(){
        return aryReportSettings.length;
    };
    this.clear = function(){
        aryReportSettings = [];
    };
    this.add = function (reportSetting) {
        aryReportSettings.push(reportSetting);
    };
    this.item = function (indexOrKey) {
        return aryReportSettings[indexOrKey];
    };
    this.remove = function (reportSetting) {
        for(var i = 0; i < aryReportSettings.length; i++){
            if(aryReportSettings[i].reportSettingKey==reportSetting.reportSettingKey){
                k = i;
                break;
            }
        }
        aryReportSettings.splice(k,1);
    };

    this.init = function(jArray){
        initWithArray(this, ReportSetting.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryReportSettings;
    };
}


function ReportSetting(){
    var me = this;

    this.reportSettingKey = null;
    this.reportSettingValue = null;
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function ReportDesign(){
    this.pcPages = new Pages();
    this.padPages = new Pages();
    this.mobilePages = new Pages();

    this.padLayoutChanged = false;
    this.mobileLayoutChanged = false;

    this.chartBlocks = new ChartBlocks();
    this.verticalTableBlocks = new VerticalTableBlocks();
    this.horizontalTableBlocks = new HorizontalTableBlocks();
    this.foldingTableBlocks = new FoldingTableBlocks();
    this.pivotTableBlocks = new PivotTableBlocks();
    this.tileBlocks = new TileBlocks();
    this.gaugeBlocks = new GaugeBlocks();
    this.mapBlocks = new MapBlocks();
    this.labelBlocks = new LabelBlocks();
    this.reportContainerBlocks = new ReportContainerBlocks();
    this.buttonBlocks = new ButtonBlocks();
    this.equipmentBlocks = new EquipmentBlocks();
    this.ganttBlocks = new GanttBlocks();
    this.freeTableBlocks = new FreeTableBlocks();
    this.tabControlBlocks = new TabControlBlocks();

    this.blocks = [];
    

    this.queries = new Queries();
    this.selects = new Selects();

    this.dataObjects = new BDADataObjects();

    this.dynamicOfficeCreator = new DynamicOfficeCreator();

    this.fillBlocks = function(){
        this.blocks = [];
        for(var i =0; i < this.chartBlocks.count(); i++){
            this.blocks.push(this.chartBlocks.item(i));
        }
        for(var i =0; i < this.verticalTableBlocks.count(); i++){
            this.blocks.push(this.verticalTableBlocks.item(i));
        }
        for(var i =0; i < this.horizontalTableBlocks.count(); i++){
            this.blocks.push(this.horizontalTableBlocks.item(i));
        }
        for(var i =0; i < this.foldingTableBlocks.count(); i++){
            this.blocks.push(this.foldingTableBlocks.item(i));
        }
        for(var i =0; i < this.pivotTableBlocks.count(); i++){
            this.blocks.push(this.pivotTableBlocks.item(i));
        }
        for(var i =0; i < this.tileBlocks.count(); i++){
            this.blocks.push(this.tileBlocks.item(i));
        }
        for(var i =0; i < this.gaugeBlocks.count(); i++){
            this.blocks.push(this.gaugeBlocks.item(i));
        }
        for(var i =0; i < this.mapBlocks.count(); i++){
            this.blocks.push(this.mapBlocks.item(i));
        }
        for(var i =0; i < this.labelBlocks.count(); i++){
            this.blocks.push(this.labelBlocks.item(i));
        }
        for(var i =0; i < this.reportContainerBlocks.count(); i++){
            this.blocks.push(this.reportContainerBlocks.item(i));
        }
        for(var i =0; i < this.buttonBlocks.count(); i++){
            this.blocks.push(this.buttonBlocks.item(i));
        }
        for(var i =0; i < this.equipmentBlocks.count(); i++){
            this.blocks.push(this.equipmentBlocks.item(i));
        }
        for(var i =0; i < this.ganttBlocks.count(); i++){
            this.blocks.push(this.ganttBlocks.item(i));
        }
        for(var i =0; i < this.freeTableBlocks.count(); i++){
            this.blocks.push(this.freeTableBlocks.item(i));
        }
        for(var i =0; i < this.tabControlBlocks.count(); i++){
            this.blocks.push(this.tabControlBlocks.item(i));
        }
    }
    
    this.init = function(jObject){
        initWithObject(this, ["pcPages","padPages","mobilePages","chartBlocks","verticalTableBlocks","horizontalTableBlocks","foldingTableBlocks","pivotTableBlocks"
        ,"tileBlocks","gaugeBlocks","mapBlocks","labelBlocks","reportContainerBlocks","buttonBlocks","equipmentBlocks","ganttBlocks","freeTableBlocks","tabControlBlocks","queries","selects","dataObjects","dynamicOfficeCreator"],jObject);
    };

    Object.defineProperties(this, {
        blocks: {
            enumerable: false
        }
    });
}


function Pages(){
    var me = this;
    var aryPages = [];

    this.count = function(){
        return aryPages.length;
    };
    this.clear = function(){
        aryPages = [];
    };
    this.add = function (page) {
        aryPages.push(page);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryPages[indexOrKey];
        }else{
            for(var i = 0; i < aryPages.length; i++){
                if(aryPages[i].pageID == indexOrKey){
                    return aryPages[i];
                }
            }
        }
    };
    this.remove = function (page) {
        for(var i = 0; i < aryPages.length; i++){
            if(aryPages[i].pageID==page.pageID){
                k = i;
                break;
            }
        }
        aryPages.splice(k,1);
    };

    
    this.init = function(jArray){
        initWithArray(this, Page.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryPages;
    };
}

function Page(){
    var me = this;

    this.pageID = null;
    this.name = null;
    this.rows = 0;
    this.columns = 0;
    this.pageImage = new ReportImage();
    this.backgroundColor = -328966;

    
    this.init = function(jObject){
        initWithObject(this, ["pageImage"],jObject);
    };
}

function ReportImages(){
    var me = this;
    var aryReportImages = [];

    this.count = function(){
        return aryReportImages.length;
    };
    this.clear = function(){
        aryReportImages = [];
    };
    this.add = function (reportimage) {
        aryReportImages.push(reportimage);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryReportImages[indexOrKey];
        }else{
            for(var i = 0; i < aryReportImages.length; i++){
                if(aryReportImages[i].imageID == indexOrKey){
                    return aryReportImages[i];
                }
            }
        }
    };
    this.remove = function (reportimage) {
        for(var i = 0; i < aryReportImages.length; i++){
            if(aryReportImages[i].imageID==reportimage.imageID){
                k = i;
                break;
            }
        }
        aryReportImages.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, ReportImage.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryReportImages;
    };
}

function ReportImage(){
    var me = this;

    this.imageID = null;
    this.imageURL = null;
    this.imageName = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = -328966;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function Blocks(){
    var me = this;
    var aryBlocks = [];

    this.count = function(){
        return aryBlocks.length;
    };
    this.clear = function(){
        aryBlocks = [];
    };
    this.add = function (block) {
        aryBlocks.push(block);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryBlocks.length; i++){
                if(aryBlocks[i].blockID == indexOrKey){
                    return aryBlocks[i];
                }
            }
        }
    };
    this.remove = function (block) {
        for(var i = 0; i < aryBlocks.length; i++){
            if(aryBlocks[i].blockID==block.blockID){
                k = i;
                break;
            }
        }
        aryBlocks.splice(k,1);
    };

    
    this.init = function(jArray){
        initWithArray(this, Block.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryBlocks;
    };
}

function Block(){
    var me = this;

    this.blockID = null;
    this.blockName = null;

    this.title = "";
    this.titleExpression = "";
    this.titleIcon = new ReportImage();
    this.titleTextBox = new BDATextBox();
    this.titleBottomBorderWidth = 0;
    this.titleBottomBorderColor = 0;
    
    this.subtitle = "";
    this.subtitleExpression = "";
    this.subtitleTextBox = new BDATextBox();

    this.showToolButtons = true;
    this.singleLineTitleBar = true;

    this.remark = null
    this.remarkTextBox = new BDATextBox();

    this.queryIDs = [];
    this.chartID = 0;
    this.blockLayouts = new BlockLayouts();
    this.blockFilters = new BlockFilters();
    this.blockSort = new BlockSort();
    this.blockRank = new BlockRank();

    this.directlyGetDataFromQuery = false;
    this.backgroundColorTransparent = false;
    this.backgroundImage = new ReportImage();
    this.backgroundColor = 0;

    this.margin = "4, 4, 4, 4";


    this.borderWidth = "0, 0, 0, 0";
    this.borderColor = "-14408668, -14408668, -14408668, -14408668";
    this.borderRadius = "0, 0, 0, 0";
    this.autoRefreshFollowReport = true;
    this.scaleUpByMagnifyButton = false;

    this.superObjProperties = ["titleIcon", "titleTextBox", "subtitleTextBox", "remarkTextBox", "blockLayouts", "blockFilters", "blockSort", "blockRank", "backgroundImage"];
    Object.defineProperties(this, {
        superObjProperties: {
            enumerable: false
        }
    });
}

function BDATextBox(){
    var me = this;

    this.borderRadius = null;
    this.height = 0;
    this.textAlign = 0;//Left = 0,Center = 1,Right = 2,
    this.font = new BDAFont();
    this.verticalAlign = 0;//Top = 0,Middle = 1,Bottom = 2,
    this.backgroundColor = 0;
    this.color = 0;
    this.adjustWidthAccordingToText = false;
    
    
    this.init = function(jObject){
        initWithObject(this, ["font"],jObject);
    };
}


function BDAFont(){
    var me = this;

    this.italic = false;
    this.bold = false;
    this.fontFamily = null;
    this.size = 22;
    this.strikeout = false;
    this.underline = false;

    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function BlockLayouts(){
    var me = this;
    var aryBlockLayouts = [];
    
    this.count = function(){
        return aryBlockLayouts.length;
    };
    this.clear = function(){
        aryBlockLayouts = [];
    };
    this.add = function (Layout) {
        aryBlockLayouts.push(Layout);
    };
    this.item = function (index) {
        return aryBlockLayouts[index];
    };
    this.remove = function (index) {
        aryBlockLayouts.splice(index,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, BlockLayout.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryBlockLayouts;
    };
}

function BlockLayout(){
    var me = this;

    this.pageID = null;
    this.containerID = null;
    this.containerIndex = 0;
    
    this.left = 0;
    this.top = 0;
    this.width = 0;
    this.height = 0;
    this.zIndex = 0;

    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function BlockFilters(){
    var me = this;
    var aryBlockFilters = [];

    this.count = function(){
        return aryBlockFilters.length;
    };
    this.clear = function(){
        aryBlockFilters = [];
    };
    this.add = function (blockFilter) {
        aryBlockFilters.push(blockFilter);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryBlockFilters[indexOrKey];
        }else{
            for(var i = 0; i < aryBlockFilters.length; i++){
                if(aryBlockFilters[i].filterID == indexOrKey){
                    return aryBlockFilters[i];
                }
            }
        }
    };
    this.remove = function (blockFilter) {
        for(var i = 0; i < aryBlockFilters.length; i++){
            if(aryBlockFilters[i].filterID==blockFilter.filterID){
                k = i;
                break;
            }
        }
        aryBlockFilters.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, BlockFilter.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryBlockFilters;
    };
}
function BlockFilter(){
    var me = this;

    this.filterID = null;
    this.dataObject = new BDADataObject();
    this.operation = 0;//Equals = 0,NotEquals = 1,Greater = 2,GreaterAndEquals = 3,Less = 4,LessAndEquals = 5,Contains = 6,NotContains = 7,Matching = 8,NotMatching = 9
    
    this.filterInputMethod = 0;//Constant = 0,List = 1,Prompt = 2
    this.filterValues = new FilterValues();

    
    this.init = function(jObject){
        initWithObject(this, ["dataObject", "filterValues"],jObject);
    };
}

function FilterValues(){
    var me = this;
    var aryFilterValues = [];

    this.count = function(){
        return aryFilterValues.length;
    };
    this.clear = function(){
        aryFilterValues = [];
    };
    this.add = function (filterValue) {
        aryFilterValues.push(filterValue);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryFilterValues[indexOrKey];
        }else{
            for(var i = 0; i < aryFilterValues.length; i++){
                if(aryFilterValues[i].businessModelID == indexOrKey){
                    return aryFilterValues[i];
                }
            }
        }
    };
    this.remove = function (filterValue) {
        for(var i = 0; i < aryFilterValues.length; i++){
            if(aryFilterValues[i].value==filterValue.value){
                k = i;
                break;
            }
        }
        aryFilterValues.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, FilterValue.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryFilterValues;
    };
}

function FilterValue(){
    var me = this;

    this.value = null;
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function BDADataObjects(){
    var me = this;
    var aryDataObjects = [];

    this.count = function(){
        return aryDataObjects.length;
    };
    this.clear = function(){
        aryDataObjects = [];
    };
    this.add = function (dataObject) {
        aryDataObjects.push(dataObject);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryDataObjects[indexOrKey];
        }else{
            for(var i = 0; i < aryDataObjects.length; i++){
                if(aryDataObjects[i].objectID == indexOrKey){
                    return aryDataObjects[i];
                }
            }
        }
    };
    this.remove = function (dataObject) {
        for(var i = 0; i < aryDataObjects.length; i++){
            if(aryDataObjects[i].objectID==dataObject.objectID){
                k = i;
                break;
            }
        }
        aryDataObjects.splice(k,1);
    };

    this.init = function(jArray){
        initWithArray(this, BDADataObject.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryDataObjects;
    };
}


function BDADataObject(){
    var me = this;

    this.objectID = null;
    this.objectName = null;
    this.queryID = null;
    this.selectIDs = [];
    this.objectType = null;//Dimension = 0, Measure = 1, Filter = 2
    this.dataType = null;//Character = 0, DateTime = 1, Decimal = 2, ImageUrl = 3, ImageBinary = 4
    this.expression = null;
    this.sourceType = null;// 0:查询;1:合并维度;2:自定义变量;3:表格的透明对象
    this.sourceName = null;
    this.formatString = "";
    this.finalExpression = new FinalExpression();
    this.sourceDimensions = new BDADataObjects();
    this.dataKey = null;
    this.calculatedWhenSum = false;

    
    this.init = function(jObject){
        initWithObject(this, ["finalExpression","finalExpression"],jObject);
    };
}


function FinalExpression(){
    var me = this;

    this.feString = null;
    this.ceString = null;
    this.sqlSupported = true;
    this.basicDataObjects = new BDADataObjects();
    //组成当前DataObject的所有的DataObject的ObjectID
    //如D=C+100,C=B*10,B=A^,其中A由查询生成，则D的compositeDataObjects有ABC,C的compositeDataObjects有AB,B的compositeDataObjects有A，A的compositeDataObjects为空
    this.compositeDataObjectIDs = [];
    
    this.init = function(jObject){
        initWithObject(this, ["basicDataObjects"],jObject);
    };
}

function BlockSort(){
    var me = this;

    this.sortEnabled = false;
    this.sortDataObject = new BDADataObject();
    this.sortType = 0;//Ascending = 0,Descending = 1,Custom = 2
    this.customList = [];
    
    this.init = function(jObject){
        initWithObject(this, ["sortDataObject"],jObject);
    };
}


function BlockRank(){
    var me = this;

    this.rankEnabled = false;
    this.rankDataObject = new BDADataObject();
    this.rankNumber = 3;
    this.rankDirection = 0;//1:前几名,-1:后几名

    this.init = function(jObject){
        initWithObject(this, ["rankDataObject"],jObject);
    };
}


function Queries(){
    var me = this;
    var aryQueries = [];

    this.count = function(){
        return aryQueries.length;
    };
    this.clear = function(){
        aryQueries = [];
    };
    this.add = function (query) {
        aryQueries.push(query);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryQueries[indexOrKey];
        }else{
            for(var i = 0; i < aryQueries.length; i++){
                if(aryQueries[i].queryID == indexOrKey){
                    return aryQueries[i];
                }
            }
        }
    };
    this.remove = function (query) {
        for(var i = 0; i < aryQueries.length; i++){
            if(aryQueries[i].queryID==query.queryID){
                k = i;
                break;
            }
        }
        aryQueries.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, Query.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryQueries;
    };
}

function Query(){
    var me = this;

    this.queryID = null;
    this.queryName = null;
    this.modelType = 0;//关系模型 = 0,数据表模型 = 1,SQL模型 = 2,Excel模型 = 3
    this.modelID = null;
    this.modelName = null;
    this.selectObjects = new BusinessObjects();
    this.businessObjectHierarchies = new BusinessObjectHierarchies();
    this.filters = new Filters();
    this.directlyReturnDataToChart = false;
    this.queryRank = new QueryRank();
    
    this.init = function(jObject){
        initWithObject(this, ["selectObjects", "businessObjectHierarchies", "queryRank"],jObject);
    };
}

function BusinessObjectHierarchies(){
    var me = this;
    var aryBusinessObjectHierarchies = [];

    this.count = function(){
        return aryBusinessObjectHierarchies.length;
    };
    this.clear = function(){
        aryBusinessObjectHierarchies = [];
    };
    this.add = function (businessObjectHierarchy) {
        aryBusinessObjectHierarchies.push(businessObjectHierarchy);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryBusinessObjectHierarchies[indexOrKey];
        }else{
            for(var i = 0; i < aryBusinessObjectHierarchies.length; i++){
                if(aryBusinessObjectHierarchies[i].hierarchyID == indexOrKey){
                    return aryBusinessObjectHierarchies[i];
                }
            }
        }
    };
    this.remove = function (businessObjectHierarchy) {
        for(var i = 0; i < aryBusinessObjectHierarchies.length; i++){
            if(aryBusinessObjectHierarchies[i].hierarchyID==businessObjectHierarchy.hierarchyID){
                k = i;
                break;
            }
        }
        aryBusinessObjectHierarchies.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, BusinessObjectHierarchy.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryBusinessObjectHierarchies;
    };
}
function BusinessObjectHierarchy(){
    var me = this;

    this.hierarchyName = null;
    this.hierarchyID = null;
    this.hierarchyDimensions = new BusinessObjects();

    
    this.init = function(jObject){
        initWithObject(this, ["hierarchyDimensions"],jObject);
    };
}

function QueryRank(){
    var me = this;

    this.rankEnabled = false;
    this.rankBusinessObject = new BusinessObject();
    this.rankNumber = 3;
    this.rankDirection = 0;

    
    this.init = function(jObject){
        initWithObject(this, ["rankBusinessObject"],jObject);
    };
}

function Selects(){
    var me = this;
    var arySelects = [];

    this.count = function(){
        return arySelects.length;
    };
    this.clear = function(){
        arySelects = [];
    };
    this.add = function (select) {
        arySelects.push(select);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return arySelects[indexOrKey];
        }else{
            for(var i = 0; i < arySelects.length; i++){
                if(arySelects[i].selectID == indexOrKey){
                    return arySelects[i];
                }
            }
        }
    };
    this.remove = function (select) {
        for(var i = 0; i < arySelects.length; i++){
            if(arySelects[i].selectID==select.selectID){
                k = i;
                break;
            }
        }
        arySelects.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, Select.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return arySelects;
    };
}

function Select(){
    var me = this;

    this.selectID = null;
    this.queryID = null;
    this.modelID = null;
    this.selectObjects = new BusinessObjects();
    this.relationDiagramName = null;
    this.sqlStatement = null;
    
    this.init = function(jObject){
        initWithObject(this, ["selectObjects"],jObject);
    };
}

function Filters(){
    var me = this;
    var aryFilters = [];

    this.count = function(){
        return aryFilters.length;
    };
    this.clear = function(){
        aryFilters = [];
    };
    this.add = function (filter) {
        aryFilters.push(filter);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryFilters[indexOrKey];
        }else{
            for(var i = 0; i < aryFilters.length; i++){
                if(aryFilters[i].filterID == indexOrKey){
                    return aryFilters[i];
                }
            }
        }
    };
    this.remove = function (filter) {
        for(var i = 0; i < aryFilters.length; i++){
            if(aryFilters[i].filterID==filter.filterID){
                k = i;
                break;
            }
        }
        aryFilters.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, Filter.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryFilters;
    };
}

function Filter(){
    var me = this;

    this.filterID = null;
    this.businessObject = new BusinessObject();
    this.operation = 0;
    this.multipleValue = false;
    this.filterInputMethod = 0;
    this.prompt = null;
    this.filterValues = new FilterValues();
    this.valueObject = new BusinessObject();
    this.defaultValueName = null;
    this.defaultValueDataFormat = null;
    
    this.cascadeFilterID = null;

    
    this.marginRight = 10;
    this.inputWidth = 90;
    
    this.init = function(jObject){
        initWithObject(this, ["businessObject", "filterValues", "valueObject"],jObject);
    };
}


function DynamicOfficeCreator(){
    var me = this;

    this.officeTemplate = new OfficeTemplate();
    this.bookmarkMappings = new BookmarkMappings();
    
    this.init = function(jObject){
        initWithObject(this, ["officeTemplate", "bookmarkMappings"],jObject);
    };
}

function OfficeTemplate(){
    var me = this;

    this.templateID = null;
    this.templateType = 0;//Word = 0,PowerPoint = 1,Excel = 2
    this.templateURL = null;
    this.templateName = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = null;
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function BookmarkMappings(){
    var me = this;
    var aryBookmarkMappings = [];

    this.count = function(){
        return aryBookmarkMappings.length;
    };
    this.clear = function(){
        aryBookmarkMappings = [];
    };
    this.add = function (bookmarkmapping) {
        aryBookmarkMappings.push(bookmarkmapping);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryBookmarkMappings[indexOrKey];
        }else{
            for(var i = 0; i < aryBookmarkMappings.length; i++){
                if(aryBookmarkMappings[i].bookMarkName == indexOrKey){
                    return aryBookmarkMappings[i];
                }
            }
        }
    };
    this.remove = function (bookmarkmapping) {
        for(var i = 0; i < aryBookmarkMappings.length; i++){
            if(aryBookmarkMappings[i].bookMarkName==bookmarkmapping.bookMarkName){
                k = i;
                break;
            }
        }
        aryBookmarkMappings.splice(k,1);
    };

    
    this.init = function(jArray){
        initWithArray(this, BookmarkMapping.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryBookmarkMappings;
    };
}
function BookmarkMapping(){
    var me = this;

    this.bookMarkName = null;
    this.sourceType = 0;//None = 0,DataObject = 1,Block = 2
    this.blockID = null;
    this.blockName = null;

    this.chartType = 0;
    this.dataObjectID = null;
    this.dataObjectName = null;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function ChartBlocks(){
    var me = this;
    var aryChartBlocks = [];

    this.count = function(){
        return aryChartBlocks.length;
    };
    this.clear = function(){
        aryChartBlocks = [];
    };
    this.add = function (chartblock) {
        aryChartBlocks.push(chartblock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryChartBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryChartBlocks.length; i++){
                if(aryChartBlocks[i].blackID == indexOrKey){
                    return aryChartBlocks[i];
                }
            }
        }
    };
    this.remove = function (chartblock) {
        for(var i = 0; i < aryChartBlocks.length; i++){
            if(aryChartBlocks[i].blackID==chartblock.blackID){
                k = i;
                break;
            }
        }
        aryChartBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, ChartBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryChartBlocks;
    };
}
function ChartBlock(){
    var me = this;
    Block.call(this);

    
    this.primaryDimension = new BDADataObject();
    this.groupDimension = new BDADataObject();
    this.y1Measures = new BDADataObjects();
    this.y1FormatString = null;
    this.y2Measures = new BDADataObjects();
    this.y2FormatString = null;
    this.y3Measures = new BDADataObjects();
    this.y3FormatString = null;

    this.reportLink = new ReportLink();
    this.linkage = new Linkage();

    this.legendShow = true;
    this.legendPosition = 1;//Top = 0,Right = 1,Bottom = 2,Left = 3
    this.legendFont = new BDAFont();
    this.legendColor = 0;
    this.showDataInLegend = false;

    this.dataShow = true;
    this.dataFont = new BDAFont();
    this.dataHoverShow = true;
    this.dataHoverFont = new BDAFont();
    this.dataHoverColor = 0;
    this.dataColor = 0;
    
    this.showScale = true;
    this.scaleFont = new BDAFont();
    this.scaleColor = 0;
    this.scalePosition = 0;//Left = 0,Top = 1

    this.xScaleLineColor = 0;
    this.xScaleLineWidth = 1;
    this.y1ScaleLineColor = 0;
    this.y1ScaleLineWidth = 0;
    this.y2ScaleLineColor = 0;
    this.y2ScaleLineWidth = 0;

    this.axisLabelShow = true;
    this.axisLabelFont = new BDAFont();
    this.axisLabelColor = 0;

    this.showGridLine = true;
    
    this.showTick = false;
    this.showTickValue = true;
    
    this.dataLabel = new DataLabel();
    this.connectorWidth = 1;
    
    this.smooth = false;
    this.lineWidth = 2;
    
    this.bulletWarnings = new BulletWarnings();
    
    this.colorSequence = [];
    this.scaleMaxValues = new ScaleMaxValues();
    
    this.colorByPoint = false;
    this.subtitleInCircle = false;
    this.barWidth = null;
    
    this.colorGradual = false;
    
    this.negativeColor = null;

    this.tooltipBackgroundColor = null;
    this.tooltipBorderColor = null;
    this.tooltipBorderWidth = 1;
    this.tooltipPadding = 8;
    this.carouselTooltip = false;
    this.carouselInterval = 3;

    this.innerSize = 0.5;

    this.picture = new ReportImage();

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["primaryDimension", "groupDimension", "y1Measures", "y2Measures", "y3Measures", "reportLink", "linkage",
        "legendFont", "dataFont", "dataHoverFont", "scaleFont", "axisLabelFont", "dataLabel", "bulletWarnings", "scaleMaxValues", "picture"]),jObject);
    };
}


function ReportLink(){
    var me = this;

    this.reportID = null;
    this.reportLinkFilters = new ReportLinkFilters();
    this.containerBlockID = null;

    
    this.init = function(jObject){
        initWithObject(this, ["reportLinkFilters"],jObject);
    };
}

function ReportLinkFilters(){
    var me = this;
    var aryReportLinkFilters = [];

    this.count = function(){
        return aryReportLinkFilters.length;
    };
    this.clear = function(){
        aryReportLinkFilters = [];
    };
    this.add = function (reportLinkFilter) {
        aryReportLinkFilters.push(reportLinkFilter);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryReportLinkFilters[indexOrKey];
        }else{
            for(var i = 0; i < aryReportLinkFilters.length; i++){
                if(aryReportLinkFilters[i].reportLinkFilterID == indexOrKey){
                    return aryReportLinkFilters[i];
                }
            }
        }
    };
    this.remove = function (reportLinkFilter) {
        for(var i = 0; i < aryReportLinkFilters.length; i++){
            if(aryReportLinkFilters[i].reportLinkFilterID==reportLinkFilter.reportLinkFilterID){
                k = i;
                break;
            }
        }
        aryReportLinkFilters.splice(k,1);
    };

    this.init = function(jArray){
        initWithArray(this, ReportLinkFilter.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryReportLinkFilters;
    };
}

function ReportLinkFilter(){
    var me = this;

    this.prompt = null;
    this.vlaueType = 0;//0:从当前报表的过滤条件获取用户输入值 1:从当前图表的数据对象获取上下文值 2:常量 3:空值
    this.valueExpression = null;
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function Linkage(){
    var me = this;

    this.blockIDs = [];
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function DataLabel(){
    this.showValue = true;
    this.showPercentage = false;
    this.showDimension = false;
    this.position = 30;
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function BulletWarnings(){
    var me = this;
    var aryBulletWarnings = [];

    this.count = function(){
        return aryBulletWarnings.length;
    };
    this.clear = function(){
        aryBulletWarnings = [];
    };
    this.add = function (bulletWarning) {
        aryBulletWarnings.push(bulletWarning);
    };
    this.item = function (indexOrKey) {
        return aryBulletWarnings[indexOrKey];
    };
    this.remove = function (bulletWarning) {
        for(var i = 0; i < aryBulletWarnings.length; i++){
            if(aryBulletWarnings[i] == bulletWarning ){
                k = i;
                break;
            }
        }
        aryBulletWarnings.splice(k,1);
    };

    this.init = function(jArray){
        initWithArray(this, BulletWarning.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryBulletWarnings;
    };
}


function BulletWarning(){
    var me = this;

    this.thresholdType = 0;//Absolute = 0,Relative = 1
    this.targetMeasure = new BDADataObject();
    this.targetValue = 85;
    this.color = 0;
    this.intervals = new Intervals();
    this.unit = "";
    
    this.init = function(jObject){
        initWithObject(this, ["targetMeasure", "intervals"],jObject);
    };
}

function Intervals(){
    var me = this;
    var aryIntervals = [];

    this.count = function(){
        return aryIntervals.length;
    };
    this.clear = function(){
        aryIntervals = [];
    };
    this.add = function (interval) {
        aryIntervals.push(interval);
    };
    this.item = function (index) {
        return aryIntervals[index];
    };
    this.remove = function (interval) {
        for(var i = 0; i < aryIntervals.length; i++){
            if(aryIntervals[i] == interval ){
                k = i;
                break;
            }
        }
        aryIntervals.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, Interval.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryIntervals;
    };
}

function Interval(){
    this.order = 0;
    this.fromThreshold = 0;
    this.endThreshold = 0;
    this.color = 0;
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function ScaleMaxValues(){
    var me = this;
    var aryScaleMaxValues = [];

    this.count = function(){
        return aryScaleMaxValues.length;
    };
    this.clear = function(){
        aryScaleMaxValues = [];
    };
    this.add = function (scaleMaxValue) {
        aryScaleMaxValues.push(scaleMaxValue);
    };
    this.item = function (index) {
        return aryScaleMaxValues[index];
    };
    this.remove = function (scaleMaxValue) {
        for(var i = 0; i < aryScaleMaxValues.length; i++){
            if(aryScaleMaxValues[i] == scaleMaxValue ){
                k = i;
                break;
            }
        }
        aryScaleMaxValues.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, ScaleMaxValue.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryScaleMaxValues;
    };
}

function ScaleMaxValue(){
    var me = this;

    this.thresholdType = 0;//Absolute = 0,Relative = 1
    this.maxValue = 0;
    this.targetMeasure = new BDADataObject();
    this.times = 1.2;
    
    this.init = function(jObject){
        initWithObject(this, ["targetMeasure"],jObject);
    };
}

function VerticalTableBlocks(){
    var me = this;
    var aryVerticalTableBlocks = [];

    this.count = function(){
        return aryVerticalTableBlocks.length;
    };
    this.clear = function(){
        aryVerticalTableBlocks = [];
    };
    this.add = function (verticalTableBlock) {
        aryVerticalTableBlocks.push(verticalTableBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryVerticalTableBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryVerticalTableBlocks.length; i++){
                if(aryVerticalTableBlocks[i].blackID == indexOrKey){
                    return aryVerticalTableBlocks[i];
                }
            }
        }
    };
    this.remove = function (verticalTableBlock) {
        for(var i = 0; i < aryVerticalTableBlocks.length; i++){
            if(aryVerticalTableBlocks[i].blackID==verticalTableBlock.blackID){
                k = i;
                break;
            }
        }
        aryVerticalTableBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, VerticalTableBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryVerticalTableBlocks;
    };
}

function VerticalTableBlock(){
    var me = this;
    Block.call(this);

    this.tableHead = new TableHead();
    this.tableBody = new TableBody();
    this.tableFoot = new TableFoot();

    this.linkage = new Linkage();

    this.tableWarnings = new TableWarnings();
    this.autoMergeDimensionCells = false;
    this.notShowBorderOfDetailTableCell = false;
    this.tBodyScrolling = false;
    this.scrollTimePerLine = 2000;
    this.striped = true;

    this.headHeight = 30;
    this.bodyHeight = 30;
    this.footHeight = 30;

    this.tableStyle = 0;//风格1(全格子) = 0,风格2(去掉列分割线) = 1,风格3(三条横线) = 2,风格4(一条横线) = 3,
    this.tableStyleColor = 0;

    this.wordWrap = false;

    this.rowMarginBottom = 0;
    
    this.pagingDisplay = false;
    this.pageRecordCount = -1;

    this.frozenColumnCount = 0;
    
    this.padding = "10, 10, 10, 10";

    
    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["tableHead", "tableBody", "tableFoot", "linkage", "tableWarnings"]),jObject);
    };
}

function TableHead(){
    var me = this;

    this.tableRows = new TableRows();
    
    this.init = function(jObject){
        initWithObject(this, ["tableRows"],jObject);
    };
}
function TableBody(){
    var me = this;

    this.tableRows = new TableRows();
    
    this.init = function(jObject){
        initWithObject(this, ["tableRows"],jObject);
    };
}
function TableFoot(){
    var me = this;

    this.tableRows = new TableRows();
    
    this.init = function(jObject){
        initWithObject(this, ["tableRows"],jObject);
    };
}

function TableRows(){
    var me = this;
    var aryTableRows = [];

    this.count = function(){
        return aryTableRows.length;
    };
    this.clear = function(){
        aryTableRows = [];
    };
    this.add = function (tableRow) {
        aryTableRows.push(tableRow);
    };
    this.item = function (indexOrKey) {
        return aryTableRows[indexOrKey];
    };
    this.remove = function (tableRow) {
        for(var i = 0; i < aryTableRows.length; i++){
            if(aryTableRows[i]==tableRow){
                k = i;
                break;
            }
        }
        aryTableRows.splice(k,1);
    };

    this.init = function(jArray){
        initWithArray(this, TableRow.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTableRows;
    };
}

function TableRow(){
    this.rowID = 0;
    this.tableCells = new TableCells();

    this.init = function(jObject){
        initWithObject(this, ["tableCells"],jObject);
    };
}

function TableCells(){
    var me = this;
    var aryTableCells = [];

    this.count = function(){
        return aryTableCells.length;
    };
    this.clear = function(){
        aryTableCells = [];
    };
    this.add = function (tableCell) {
        aryTableCells.push(tableCell);
    };
    this.item = function (indexOrKey) {
        return aryTableCells[indexOrKey];
    };
    this.remove = function (tableCell) {
        for(var i = 0; i < aryTableCells.length; i++){
            if(aryTableCells[i]==tableCell){
                k = i;
                break;
            }
        }
        aryTableCells.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, TableCell.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTableCells;
    };
}

function TableCell(){
    var me = this;

    this.rowID = 0;
    this.columnIndex = 0;
    this.text = null;
    this.dataObject = new BDADataObject();
    this.formatString = null;
    this.borderWidth = "0, 0, 0, 0";
    this.borderColor = null;
    this.borderRadius = "0, 0, 0, 0";
    this.cellTextBox = new BDATextBox();
    this.reportLink = new ReportLink();
    this.colspan = 1;
    this.rowspan = 1;
    this.showColumnBarForMeasure = false;
    this.columnBarMaxLength = 0.8;
    this.positiveColumnBarColor = 0;
    this.negativeColumnBarColor = 0;
    this.columnWidth = 108;
    this.autoColumnWidth = true;
    this.sparkline = new Sparkline();

    this.init = function(jObject){
        initWithObject(this, ["dataObject", "cellTextBox", "reportLink", "sparkline"],jObject);
    };
}

function Sparkline(){
    this.sparklineID = null;
    this.chartID = 0;
    this.dimension = new BDADataObject();
    this.measure = new BDADataObject();
    this.showAxis = true;

    this.init = function(jObject){
        initWithObject(this, ["dimension", "measure"],jObject);
    };
}

function TableWarnings(){
    var me = this;
    var aryTableWarnings = [];

    this.count = function(){
        return aryTableWarnings.length;
    };
    this.clear = function(){
        aryTableWarnings = [];
    };
    this.add = function (tableWarning) {
        aryTableWarnings.push(tableWarning);
    };
    this.item = function (indexOrKey) {
        return aryTableWarnings[indexOrKey];
    };
    this.remove = function (tableWarning) {
        for(var i = 0; i < aryTableWarnings.length; i++){
            if(aryTableWarnings[i]==tableWarning){
                k = i;
                break;
            }
        }
        aryTableWarnings.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, TableWarning.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTableWarnings;
    };
}

function TableWarning(){
    var me = this;

    this.dataObject = new BDADataObject();
    this.operation = 0;
    
    this.compareValueType = 0;//0:常量  1:对象
    this.compareObject = new BDADataObject();
    this.compareConstants = [];
    this.color = 0;
    this.backgroundColor = 0;
    this.effectType = 0;//WarningObject = 0,Row = 1
    
    this.init = function(jObject){
        initWithObject(this, ["dataObject", "compareObject"],jObject);
    };
}

function HorizontalTableBlocks(){
    var me = this;
    var aryHorizontalTableBlocks = [];

    this.count = function(){
        return aryHorizontalTableBlocks.length;
    };
    this.clear = function(){
        aryHorizontalTableBlocks = [];
    };
    this.add = function (horizontalTableBlock) {
        aryHorizontalTableBlocks.push(horizontalTableBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryHorizontalTableBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryHorizontalTableBlocks.length; i++){
                if(aryHorizontalTableBlocks[i].blackID == indexOrKey){
                    return aryHorizontalTableBlocks[i];
                }
            }
        }
    };
    this.remove = function (horizontalTableBlock) {
        for(var i = 0; i < aryHorizontalTableBlocks.length; i++){
            if(aryHorizontalTableBlocks[i].blackID==horizontalTableBlock.blackID){
                k = i;
                break;
            }
        }
        aryHorizontalTableBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, HorizontalTableBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryHorizontalTableBlocks;
    };
}

function HorizontalTableBlock(){
    var me = this;
    Block.call(this);

    
    this.tableHead = new HorizontalTableHead();
    this.tableBody = new HorizontalTableBody();
    this.tableFoot = new HorizontalTableFoot();

    this.linkage = new Linkage();

    this.tableWarnings = new TableWarnings();
    this.autoMergeDimensionCells = false;
    this.notShowBorderOfDetailTableCell = false;

    this.cellHeight = 30;
    this.wordWrap = false;
    
    this.padding = "10, 10, 10, 10";

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["tableHead", "tableBody", "tableFoot", "linkage", "tableWarnings"]),jObject);
    };
}
function HorizontalTableHead(){
    this.tableColumns = new TableColumns();
    
    this.init = function(jObject){
        initWithObject(this, ["tableColumns"],jObject);
    };
}
function HorizontalTableBody(){
    this.tableColumns = new TableColumns();
    
    this.init = function(jObject){
        initWithObject(this, ["tableColumns"],jObject);
    };
}
function HorizontalTableFoot(){
    this.tableColumns = new TableColumns();
    
    this.init = function(jObject){
        initWithObject(this, ["tableColumns"],jObject);
    };
}

function TableColumns(){
    var aryTableColumns = [];

    this.count = function(){
        return aryTableColumns.length;
    };
    this.clear = function(){
        aryTableColumns = [];
    };
    this.add = function (tableColumn) {
        aryTableColumns.push(tableColumn);
    };
    this.item = function (indexOrKey) {
        return aryTableColumns[indexOrKey];
    };
    this.remove = function (tableColumn) {
        for(var i = 0; i < aryTableColumns.length; i++){
            if(aryTableColumns[i]==tableColumn){
                k = i;
                break;
            }
        }
        aryTableColumns.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, TableColumn.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTableColumns;
    };
}
function TableColumn(){
    this.columnIndex = 0;
    this.tableCells = new TableCells();

    this.init = function(jObject){
        initWithObject(this, ["tableCells"],jObject);
    };
}

function FoldingTableBlocks(){
    var me = this;
    var aryFoldingTableBlocks = [];

    this.count = function(){
        return aryFoldingTableBlocks.length;
    };
    this.clear = function(){
        aryFoldingTableBlocks = [];
    };
    this.add = function (foldingTableBlock) {
        aryFoldingTableBlocks.push(foldingTableBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryFoldingTableBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryFoldingTableBlocks.length; i++){
                if(aryFoldingTableBlocks[i].blackID == indexOrKey){
                    return aryFoldingTableBlocks[i];
                }
            }
        }
    };
    this.remove = function (foldingTableBlock) {
        for(var i = 0; i < aryFoldingTableBlocks.length; i++){
            if(aryFoldingTableBlocks[i].blackID==foldingTableBlock.blackID){
                k = i;
                break;
            }
        }
        aryFoldingTableBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, FoldingTableBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryFoldingTableBlocks;
    };
}

function FoldingTableBlock(){
    var me = this;
    Block.call(this);

    this.foldingDimensions = new BDADataObjects();
    this.measures = new BDADataObjects();

    this.tableHead = new TableHead();
    this.tableBody = new TableBody();

    this.tableStyle = 0;
    this.tableStyleColor = 0;

    this.rowTotal = false;// 行总计 true：显示  false：不显示
    
    this.padding = "10, 10, 10, 10";
    
    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["tableHead", "tableBody", "foldingDimensions", "measures"]),jObject);
    };
}

function PivotTableBlocks(){
    var me = this;
    var aryPivotTableBlocks = [];

    this.count = function(){
        return aryPivotTableBlocks.length;
    };
    this.clear = function(){
        aryPivotTableBlocks = [];
    };
    this.add = function (pivotTableBlock) {
        aryPivotTableBlocks.push(pivotTableBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryPivotTableBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryPivotTableBlocks.length; i++){
                if(aryPivotTableBlocks[i].blackID == indexOrKey){
                    return aryPivotTableBlocks[i];
                }
            }
        }
    };
    this.remove = function (pivotTableBlock) {
        for(var i = 0; i < aryPivotTableBlocks.length; i++){
            if(aryPivotTableBlocks[i].blackID==pivotTableBlock.blackID){
                k = i;
                break;
            }
        }
        aryPivotTableBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, PivotTableBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryPivotTableBlocks;
    };
}

function PivotTableBlock(){
    var me = this;
    Block.call(this);

    this.rowDimensions = new BDADataObjects();
    this.columnDimensions = new BDADataObjects();
    this.pivotMeasures = new PivotMeasures();


    this.rowSubtotal = false;// 行小计 true：显示  false：不显示
    this.rowTotal = false;// 行总计 true：显示  false：不显示
    this.columnSubtotal = false;// 列小计 true：显示  false：不显示
    this.columnTotal = false;// 列总计 true：显示  false：不显示
    
    this.showCrossTableHead = false;
    this.totalBackgroundColor = 0;
    this.totalColor = 0;
    this.totalFont = new BDAFont();

    this.tableHeadBackgroundColor = 0;
    this.tableHeadColor = 0;
    this.tableHeadFont = new BDAFont();

    this.padding = "10, 10, 10, 10";

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["rowDimensions", "columnDimensions", "pivotMeasures", "totalFont", "tableHeadFont"]),jObject);
    };

}

function PivotMeasures(){
    var me = this;
    var aryPivotMeasures = [];

    this.count = function(){
        return aryPivotMeasures.length;
    };
    this.clear = function(){
        aryPivotMeasures = [];
    };
    this.add = function (pivotMeasure) {
        aryPivotMeasures.push(pivotMeasure);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryPivotMeasures[indexOrKey];
        }else{
            for(var i = 0; i < aryPivotMeasures.length; i++){
                if(aryPivotMeasures[i].measureID == indexOrKey){
                    return aryPivotMeasures[i];
                }
            }
        }
    };
    this.remove = function (pivotMeasure) {
        for(var i = 0; i < aryPivotMeasures.length; i++){
            if(aryPivotMeasures[i].measureID==pivotMeasure.measureID){
                k = i;
                break;
            }
        }
        aryPivotMeasures.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, PivotMeasure.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryPivotMeasures;
    };
}
function PivotMeasure(){
    var me = this;

    this.measureID = null;
    this.measureName = null;
    this.measureObject = new BDADataObject();
    this.aggregateFunctionName = "sum";
    this.formatString = "";
    this.hidden = false;

    this.init = function(jObject){
        initWithObject(this, ["measureObject"],jObject);
    };
}

function TileBlocks(){
    var me = this;
    var aryTileBlocks = [];

    this.count = function(){
        return aryTileBlocks.length;
    };
    this.clear = function(){
        aryTileBlocks = [];
    };
    this.add = function (tileBlock) {
        aryTileBlocks.push(tileBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryTileBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryTileBlocks.length; i++){
                if(aryTileBlocks[i].blackID == indexOrKey){
                    return aryTileBlocks[i];
                }
            }
        }
    };
    this.remove = function (tileBlock) {
        for(var i = 0; i < aryTileBlocks.length; i++){
            if(aryTileBlocks[i].blackID==tileBlock.blackID){
                k = i;
                break;
            }
        }
        aryTileBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, TileBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTileBlocks;
    };
}

function TileBlock(){
    var me = this;
    Block.call(this);

    this.autoFontSize = true;

    this.mainDataObject = new BDADataObject();
    this.mainTextBox = new BDATextBox();
    this.mainLabel = "";
    this.mainLabelTextBox = new BDATextBox();
    this.mainUnit = "";
    this.mainUnitTextBox = new BDATextBox();
    this.mainFormatString = null;
    this.mainTileWarning = new TileWarning();

    this.dataObject1 = new BDADataObject();
    this.textBox1 = new BDATextBox();
    this.label1 = "";
    this.alertImage1 = 0;//无 = 0,箭头 = 1,红绿灯 = 2
    this.imageColor1 = 0;//比主数据对象高为红色 = 0,比主数据对象高为绿色 = 1,正数为红色 = 2,正数为绿色 = 3
    this.arrowDirection1 = 0;//比主数据低向上 = 0,正数向上 = 1
    this.formatString1 = null;
    
    this.dataObject2 = new BDADataObject();
    this.textBox2 = new BDATextBox();
    this.label2 = "";
    this.alertImage2 = 0;//无 = 0,箭头 = 1,红绿灯 = 2
    this.imageColor2 = 0;//比主数据对象高为红色 = 0,比主数据对象高为绿色 = 1,正数为红色 = 2,正数为绿色 = 3
    this.arrowDirection2 = 0;//比主数据低向上 = 0,正数向上 = 1
    this.formatString2 = null;
    
    this.dataObject3 = new BDADataObject();
    this.textBox3 = new BDATextBox();
    this.label3 = "";
    this.alertImage3 = 0;//无 = 0,箭头 = 1,红绿灯 = 2
    this.imageColor3 = 0;//比主数据对象高为红色 = 0,比主数据对象高为绿色 = 1,正数为红色 = 2,正数为绿色 = 3
    this.arrowDirection3 = 0;//比主数据低向上 = 0,正数向上 = 1
    this.formatString3 = null;
    
    this.dataObject4 = new BDADataObject();
    this.textBox4 = new BDATextBox();
    this.label4 = "";
    this.alertImage4 = 0;//无 = 0,箭头 = 1,红绿灯 = 2
    this.imageColor4 = 0;//比主数据对象高为红色 = 0,比主数据对象高为绿色 = 1,正数为红色 = 2,正数为绿色 = 3
    this.arrowDirection4 = 0;//比主数据低向上 = 0,正数向上 = 1
    this.formatString4 = null;

    
    this.dataObject5 = new BDADataObject();
    this.textBox5 = new BDATextBox();
    this.label5 = "";
    this.alertImage5 = 0;//无 = 0,箭头 = 1,红绿灯 = 2
    this.imageColor5 = 0;//比主数据对象高为红色 = 0,比主数据对象高为绿色 = 1,正数为红色 = 2,正数为绿色 = 3
    this.arrowDirection5 = 0;//比主数据低向上 = 0,正数向上 = 1
    this.formatString5 = null;
    
    this.dataObject6 = new BDADataObject();
    this.textBox6 = new BDATextBox();
    this.label6 = "";
    this.alertImage6 = 0;//无 = 0,箭头 = 1,红绿灯 = 2
    this.imageColor6 = 0;//比主数据对象高为红色 = 0,比主数据对象高为绿色 = 1,正数为红色 = 2,正数为绿色 = 3
    this.arrowDirection6 = 0;//比主数据低向上 = 0,正数向上 = 1
    this.formatString6 = null;

    this.reportLink = new ReportLink();
    this.customColorApplyOtherThemes = false;

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["mainDataObject", "mainTextBox", "mainLabelTextBox", "mainUnitTextBox", "mainTileWarning",
        "dataObject1", "textBox1", "dataObject2", "textBox2", "dataObject3", "textBox3", "dataObject4", "textBox4", "dataObject5", "textBox5", "dataObject6", "textBox6"]),jObject);
    };
}

function TileWarning(){
    this.dataObject = new BDADataObject();
    this.operation = 0;
    this.compareValueType = 0;//0:常量  1:对象
    this.compareObject = new BDADataObject();
    this.compareConstants = [];
    this.color = 0;
    this.backgroundColor = 0;

    this.init = function(jObject){
        initWithObject(this, ["dataObject", "compareObject"],jObject);
    };
}

function GaugeBlocks(){
    var me = this;
    var aryGaugeBlocks = [];

    this.count = function(){
        return aryGaugeBlocks.length;
    };
    this.clear = function(){
        aryGaugeBlocks = [];
    };
    this.add = function (gaugeBlock) {
        aryGaugeBlocks.push(gaugeBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryGaugeBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryGaugeBlocks.length; i++){
                if(aryGaugeBlocks[i].blackID == indexOrKey){
                    return aryGaugeBlocks[i];
                }
            }
        }
    };
    this.remove = function (gaugeBlock) {
        for(var i = 0; i < aryGaugeBlocks.length; i++){
            if(aryGaugeBlocks[i].blackID==gaugeBlock.blackID){
                k = i;
                break;
            }
        }
        aryGaugeBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, GaugeBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryGaugeBlocks;
    };
}

function GaugeBlock(){
    var me = this;
    Block.call(this);

    this.measure = new BDADataObject();
    this.formatString = null;
    this.gaugeWarning = new GaugeWarning();
    this.reportLink = new ReportLink();

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["measure", "gaugeWarning", "reportLink"]),jObject);
    };
}

function GaugeWarnings(){
    var me = this;
    var aryGaugeWarnings = [];

    this.count = function(){
        return aryGaugeWarnings.length;
    };
    this.clear = function(){
        aryGaugeWarnings = [];
    };
    this.add = function (gaugeWarning) {
        aryGaugeWarnings.push(gaugeWarning);
    };
    this.item = function (indexOrKey) {
        return aryGaugeWarnings[indexOrKey];
    };
    this.remove = function (gaugeWarning) {
        for(var i = 0; i < aryGaugeWarnings.length; i++){
            if(aryGaugeWarnings[i]==gaugeWarning){
                k = i;
                break;
            }
        }
        aryGaugeWarnings.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, GaugeWarning.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryGaugeWarnings;
    };
}

function GaugeWarning(){
    var me = this;

    this.warningEnabled = false;
    this.thresholdType = 0;
    this.warningType = 0;
    this.targetMeasure = new BDADataObject();
    this.intervals = new Intervals();
    
    this.init = function(jObject){
        initWithObject(this, ["targetMeasure", "intervals"],jObject);
    };
}

function MapBlocks(){
    var me = this;
    var aryMapBlocks = [];

    this.count = function(){
        return aryMapBlocks.length;
    };
    this.clear = function(){
        aryMapBlocks = [];
    };
    this.add = function (mapBlock) {
        aryMapBlocks.push(mapBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryMapBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryMapBlocks.length; i++){
                if(aryMapBlocks[i].blackID == indexOrKey){
                    return aryMapBlocks[i];
                }
            }
        }
    };
    this.remove = function (mapBlock) {
        for(var i = 0; i < aryMapBlocks.length; i++){
            if(aryMapBlocks[i].blackID==mapBlock.blackID){
                k = i;
                break;
            }
        }
        aryMapBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, MapBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryMapBlocks;
    };
}

function MapBlock(){
    var me = this;
    Block.call(this);

    this.mapCode = null;
    this.locationDimension = new BDADataObject();
    this.mainMeasure = new BDADataObject();
    this.otherMeasures = new BDADataObjects();
    this.reportLink = new ReportLink();
    this.linkage = new Linkage();

    this.geoLevel = 0;
    this.haveChildMap = 0;

    this.colorSequence = [];
    this.mapLegend = new MapLegend();

    
    this.mapDefaultColor = 0;
    this.mapHoverColor = 0;
    
    this.mapBorderColor = 0;
    this.mapBorderWidth = 1;

    this.symbolType = 1;//圆形 = 0, 长方形 = 1, 圆角长方形 = 2, 三角形 = 3, 菱形 = 4, 水滴 = 5, 箭头 = 6
    this.symbolSize = 10;
    this.symbolSizeFixed = true;

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["locationDimension", "mainMeasure", "otherMeasures", "reportLink", "linkage", "mapLegend"]),jObject);
    };
}

function MapLegend(){
    var me = this;

    this.legendPosition = false;
    this.legendRanges = new LegendRanges();
    this.fontColor = 0;
    
    this.init = function(jObject){
        initWithObject(this, ["legendRanges"],jObject);
    };
}

function LegendRanges(){
    var me = this;
    var aryLegendRanges = [];

    this.count = function(){
        return aryLegendRanges.length;
    };
    this.clear = function(){
        aryLegendRanges = [];
    };
    this.add = function (legendRange) {
        aryLegendRanges.push(legendRange);
    };
    this.item = function (indexOrKey) {
        return aryLegendRanges[indexOrKey];
    };
    this.remove = function (legendRange) {
        for(var i = 0; i < aryLegendRanges.length; i++){
            if(aryLegendRanges[i]==legendRange){
                k = i;
                break;
            }
        }
        aryLegendRanges.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, LegendRange.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryLegendRanges;
    };
}

function LegendRange(){
    this.label = null;
    this.start = null;
    this.end = null;
    this.color = 0;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function LabelBlocks(){
    var me = this;
    var aryLabelBlocks = [];

    this.count = function(){
        return aryLabelBlocks.length;
    };
    this.clear = function(){
        aryLabelBlocks = [];
    };
    this.add = function (labelBlock) {
        aryLabelBlocks.push(labelBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryLabelBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryLabelBlocks.length; i++){
                if(aryLabelBlocks[i].blackID == indexOrKey){
                    return aryLabelBlocks[i];
                }
            }
        }
    };
    this.remove = function (labelBlock) {
        for(var i = 0; i < aryLabelBlocks.length; i++){
            if(aryLabelBlocks[i].blackID==labelBlock.blackID){
                k = i;
                break;
            }
        }
        aryLabelBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, LabelBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryLabelBlocks;
    };
}

function LabelBlock(){
    var me = this;
    Block.call(this);

    this.labelContent = "";
    this.labelTextBox = new BDATextBox();
    this.textScroll = false;
    this.scrollDirection = 0;//左 = 0,上 = 1
    this.scrollTimePerPx = 30;

    this.dataObject = new BDADataObject();
    this.images = new ReportImages();
    this.carouselInterval = 5;
    this.tileMode = 0;//拉伸覆盖 = 0,原始尺寸 = 1,保持纵横比缩放 = 2
    this.showCircleImage = false;
    this.imageRadius = "0, 0, 0, 0";

    this.freeCellType = 0;//文本 = 0,超级链接 = 1,HTML = 2,数据对象 = 3,图像URL = 4
    
    this.reportLink = new ReportLink();

    this.dateTimeFormatString = "YYYY-MM-dd HH:mm:ss";

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["labelTextBox", "dataObject", "images", "reportLink"]),jObject);
    };
}

function ReportContainerBlocks(){
    var me = this;
    var aryReportContainerBlocks = [];

    this.count = function(){
        return aryReportContainerBlocks.length;
    };
    this.clear = function(){
        aryReportContainerBlocks = [];
    };
    this.add = function (reportContainerBlock) {
        aryReportContainerBlocks.push(reportContainerBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryReportContainerBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryReportContainerBlocks.length; i++){
                if(aryReportContainerBlocks[i].blackID == indexOrKey){
                    return aryReportContainerBlocks[i];
                }
            }
        }
    };
    this.remove = function (reportContainerBlock) {
        for(var i = 0; i < aryReportContainerBlocks.length; i++){
            if(aryReportContainerBlocks[i].blackID==reportContainerBlock.blackID){
                k = i;
                break;
            }
        }
        aryReportContainerBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, ReportContainerBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryReportContainerBlocks;
    };
}

function ReportContainerBlock(){
    var me = this;
    Block.call(this);

    this.reportID = null;
    this.reportLinkFilters = new ReportLinkFilters();

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["reportLinkFilters"]),jObject);
    };
}

function TabControlBlocks(){
    var me = this;
    var aryTabControlBlocks = [];

    this.count = function(){
        return aryTabControlBlocks.length;
    };
    this.clear = function(){
        aryTabControlBlocks = [];
    };
    this.add = function (tabControlBlock) {
        aryTabControlBlocks.push(tabControlBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryTabControlBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryTabControlBlocks.length; i++){
                if(aryTabControlBlocks[i].blackID == indexOrKey){
                    return aryTabControlBlocks[i];
                }
            }
        }
    };
    this.remove = function (tabControlBlock) {
        for(var i = 0; i < aryTabControlBlocks.length; i++){
            if(aryTabControlBlocks[i].blackID==tabControlBlock.blackID){
                k = i;
                break;
            }
        }
        aryTabControlBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, TabControlBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTabControlBlocks;
    };
}
function TabControlBlock(){
    var me = this;
    Block.call(this);

    this.tabHeadLayoutStyle = 0;//拉伸 = 0,靠左 = 1
    this.tabHeadLocation = 0;//上 = 0,下 = 1
    this.carousel = false;
    this.carouselInterval = 20;
    this.tabHeadPadding = "4, 4, 4, 4";

    this.tabHeads = new TabHeads();
    this.tabBodys = new TabBodys();

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["tabHeads", "tabBodys"]),jObject);
    };
}

function TabHeads(){
    var me = this;
    var aryTabHeads = [];

    this.count = function(){
        return aryTabHeads.length;
    };
    this.clear = function(){
        aryTabHeads = [];
    };
    this.add = function (tabHead) {
        aryTabHeads.push(tabHead);
    };
    this.item = function (indexOrKey) {
        return aryTabHeads[indexOrKey];
    };
    this.remove = function (tabHead) {
        for(var i = 0; i < aryTabHeads.length; i++){
            if(aryTabHeads[i]==tabHead){
                k = i;
                break;
            }
        }
        aryTabHeads.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, TabHead.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTabHeads;
    };
}

function TabHead(){
    var me = this;

    this.width = 64;
    this.height = 32;// 0:从当前报表的过滤条件获取用户输入值 1:从当前图表的数据对象获取上下文值 2:常量 3:空值
    
    this.icon = new ReportImage();
    this.iconLocation = 0;//左 = 0,上 = 1,右 = 2,下 = 3
    this.text = null;
    this.textFont = new BDAFont();
    this.textColor = 0;
    this.selectedTextColor = 0;
    
    this.borderWidth = "0, 0, 1, 0";
    this.borderColor = 0;
    this.selectedBorderColor = 0;
    
    this.backgroundColor = 0;
    this.selectedBackgroundColor = 0;
    this.backgroundImage = new ReportImage();
    this.selectedBackgroundImage = new ReportImage();
    
    this.init = function(jObject){
        initWithObject(this, ["icon", "textFont", "backgroundImage", "selectedBackgroundImage"],jObject);
    };
}

function TabBodys(){
    var me = this;
    var aryTabBodys = [];

    this.count = function(){
        return aryTabBodys.length;
    };
    this.clear = function(){
        aryTabBodys = [];
    };
    this.add = function (tabBody) {
        aryTabBodys.push(tabBody);
    };
    this.item = function (indexOrKey) {
        return aryTabBodys[indexOrKey];
    };
    this.remove = function (tabBody) {
        for(var i = 0; i < aryTabBodys.length; i++){
            if(aryTabBodys[i]==tabBody){
                k = i;
                break;
            }
        }
        aryTabBodys.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, TabBody.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTabBodys;
    };
}
function TabBody(){
    var me = this;

    this.rows = 1;
    this.columns = 1;
    this.blockIDs = [];
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function ButtonBlocks(){
    var me = this;
    var aryButtonBlocks = [];

    this.count = function(){
        return aryButtonBlocks.length;
    };
    this.clear = function(){
        aryButtonBlocks = [];
    };
    this.add = function (buttonBlock) {
        aryButtonBlocks.push(buttonBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryButtonBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryButtonBlocks.length; i++){
                if(aryButtonBlocks[i].blackID == indexOrKey){
                    return aryButtonBlocks[i];
                }
            }
        }
    };
    this.remove = function (buttonBlock) {
        for(var i = 0; i < aryButtonBlocks.length; i++){
            if(aryButtonBlocks[i].blackID==buttonBlock.blackID){
                k = i;
                break;
            }
        }
        aryButtonBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, ButtonBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryButtonBlocks;
    };
}


function ButtonBlock(){
    var me = this;
    Block.call(this);

    this.contentType = 0;//Text = 0,Image = 1
    this.icon = new ReportImage();
    this.iconLocation = 0;//左 = 0,上 = 1,右 = 2,下 = 3
    this.text = null;
    this.image = new ReportImage();
    this.selectedImage = new ReportImage();
    this.imageDataObject = new BDADataObject();
    this.tileMode = 0;//左 = 0,上 = 1,右 = 2,下 = 3
    this.textBox = new BDATextBox();
    this.selectedTextBox = new BDATextBox();
    this.selectedBorderWidth = "1, 1, 1, 1";
    this.selectedBorderColor = 0;

    this.defaultSelected = false;
    this.groupName = "";
    
    this.carousel = false;
    this.carouselInterval = 20;
    this.index = 0;
    
    this.dataObject = new BDADataObject();

    this.subReports = new SubReports();
    this.reportLink = new ReportLink();
    this.linkageValue = null;

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["icon", "image", "selectedImage", "imageDataObject", "textBox", "selectedTextBox", "dataObject", "subReports", "reportLink"]),jObject);
    };
}

function SubReports(){
    var me = this;
    var arySubReports = [];

    this.count = function(){
        return arySubReports.length;
    };
    this.clear = function(){
        arySubReports = [];
    };
    this.add = function (subReport) {
        arySubReports.push(subReport);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return arySubReports[indexOrKey];
        }else{
            for(var i = 0; i < arySubReports.length; i++){
                if(arySubReports[i].blackID == indexOrKey){
                    return arySubReports[i];
                }
            }
        }
    };
    this.remove = function (subReport) {
        for(var i = 0; i < arySubReports.length; i++){
            if(arySubReports[i].blackID==subReport.blackID){
                k = i;
                break;
            }
        }
        arySubReports.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, SubReport.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return arySubReports;
    };
}

function SubReport(){
    var me = this;

    this.blockID = null;
    this.subReportID = null;
    this.reportLinkFilters = new ReportLinkFilters();
    
    this.init = function(jObject){
        initWithObject(this, ["reportLinkFilters"],jObject);
    };
}

function EquipmentBlocks(){
    var me = this;
    var aryEquipmentBlocks = [];

    this.count = function(){
        return aryEquipmentBlocks.length;
    };
    this.clear = function(){
        aryEquipmentBlocks = [];
    };
    this.add = function (equipmentBlock) {
        aryEquipmentBlocks.push(equipmentBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryEquipmentBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryEquipmentBlocks.length; i++){
                if(aryEquipmentBlocks[i].blackID == indexOrKey){
                    return aryEquipmentBlocks[i];
                }
            }
        }
    };
    this.remove = function (equipmentBlock) {
        for(var i = 0; i < aryEquipmentBlocks.length; i++){
            if(aryEquipmentBlocks[i].blackID==equipmentBlock.blackID){
                k = i;
                break;
            }
        }
        aryEquipmentBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, EquipmentBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryEquipmentBlocks;
    };
}

function EquipmentBlock(){
    var me = this;
    Block.call(this);

    this.measures = new BDADataObjects();
    this.labelTextBox = new BDATextBox();
    this.valueTextBox = new BDATextBox();
    this.equipmentDimension = new BDADataObject();
    this.statusDimension = new BDADataObject();
    this.fromDateDimension = new BDADataObject();
    this.toDateDimension = new BDADataObject();

    this.runningStyle = new EquipmentStatusStyle();
    this.idleStyle = new EquipmentStatusStyle();
    this.warningStyle = new EquipmentStatusStyle();
    this.breakdownStyle = new EquipmentStatusStyle();

    this.timeUnit = 0;//毫秒 = 0,秒 = 1,分钟 = 2,小时 = 3,天 = 4

    this.showScale = true;
    this.scaleFont = new BDAFont();
    this.scaleColor = 0;
    
    this.xScaleLineColor = 0;
    this.xScaleLineWidth = 1;
    this.y1ScaleLineColor = 0;
    this.y1ScaleLineWidth = 1;
    
    this.showGridLine = false;
    this.showTick = false;

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["measures", "labelTextBox", "valueTextBox", "equipmentDimension", "statusDimension", "fromDateDimension", "toDateDimension", "runningStyle", "idleStyle", "warningStyle", "breakdownStyle"]),jObject);
    };
}

function EquipmentStatusStyle(){
    this.statusDimensionValue = "";
    this.borderColor = 0;
    this.equipmentNameColor = 0;
    this.flashing = false;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function GanttBlocks(){
    var me = this;
    var aryGanttBlocks = [];

    this.count = function(){
        return aryGanttBlocks.length;
    };
    this.clear = function(){
        aryGanttBlocks = [];
    };
    this.add = function (ganttBlock) {
        aryGanttBlocks.push(ganttBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryGanttBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryGanttBlocks.length; i++){
                if(aryGanttBlocks[i].blackID == indexOrKey){
                    return aryGanttBlocks[i];
                }
            }
        }
    };
    this.remove = function (ganttBlock) {
        for(var i = 0; i < aryGanttBlocks.length; i++){
            if(aryGanttBlocks[i].blackID==ganttBlock.blackID){
                k = i;
                break;
            }
        }
        aryGanttBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, GanttBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryGanttBlocks;
    };
}

function GanttBlock(){
    var me = this;
    Block.call(this);

    this.jobDimension = new BDADataObject();
    this.statusDimension = new BDADataObject();
    this.startDate = new BDADataObject();
    this.endDate = new BDADataObject();
    this.completeness = new BDADataObject();

    this.ontimeDimensionValue = null;
    this.ontimeColor = 0;
    this.delayedDimensionValue = null;
    this.delayedColor = 0;

    this.showScale = true;
    this.scaleFont = new BDAFont();
    this.scaleColor = 0;
    this.scaleFormat = 0;//MonthDay = 0,Month = 1,YearQuarter = 2,Year = 3,YearMonthDay = 4
    
    this.xScaleLineColor = 0;
    this.xScaleLineWidth = 1;
    this.y1ScaleLineColor = 0;
    this.y1ScaleLineWidth = 0;
    this.y2ScaleLineColor = 0;
    this.y2ScaleLineWidth = 0;
    
    this.dataShow = true;
    this.dataFont = new BDAFont();
    this.dataHoverShow = true;
    this.dataHoverFont = new BDAFont();
    this.dataHoverColor = 0;
    this.dataColor = 0;
    
    this.showGridLine = false;
    this.barWidth = 25;

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["jobDimension", "statusDimension", "startDate", "endDate", "completeness", "scaleFont", "dataFont", "dataHoverFont"]),jObject);
    };
}

function FreeTableBlocks(){
    var me = this;
    var aryFreeTableBlocks = [];

    this.count = function(){
        return aryFreeTableBlocks.length;
    };
    this.clear = function(){
        aryFreeTableBlocks = [];
    };
    this.add = function (freeTableBlock) {
        aryFreeTableBlocks.push(freeTableBlock);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryFreeTableBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryFreeTableBlocks.length; i++){
                if(aryFreeTableBlocks[i].blackID == indexOrKey){
                    return aryFreeTableBlocks[i];
                }
            }
        }
    };
    this.remove = function (freeTableBlock) {
        for(var i = 0; i < aryFreeTableBlocks.length; i++){
            if(aryFreeTableBlocks[i].blackID==freeTableBlock.blackID){
                k = i;
                break;
            }
        }
        aryFreeTableBlocks.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, FreeTableBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryFreeTableBlocks;
    };
}

function FreeTableBlock(){
    var me = this;
    Block.call(this);

    this.row = 6;
    this.column = 6;

    this.tableRows = new TableRows();

    this.cellHeight = 30;
    this.padding = "10, 10, 10, 10";

    this.highlightWhenSelected = null;
    this.highlightColor = -10649147;

    this.init = function(jObject){
        initWithObject(this, this.superObjProperties.concat(["tableRows"]),jObject);
    };
}