//#region 
class Error{
    constructor(){
        this.message = "";
        this.row = 0;
        this.column = 0;
    }
}

class Token {
    constructor(){
        this.type = TokenType.Identifier;
        this.value = "";
    }
}

class Tokens extends Array{

}

class TokenType {
    constructor(name) {
        this.name = name;
    }

    getName() {
        return this.name;
    }
}

TokenType.Identifier = new TokenType(0);
TokenType.Function = new TokenType(1);
TokenType.Operator = new TokenType(2);
TokenType.Dot = new TokenType(3);
// 左小括号
TokenType.ParenthesesLeft = new TokenType(4);
// 右小括号
TokenType.ParenthesesRight = new TokenType(5);
// 左中括号
TokenType.SquareBracketLeft = new TokenType(6);
// 右中括号
TokenType.SquareBracketRight = new TokenType(7);
TokenType.Number = new TokenType(8);
TokenType.String = new TokenType(9);
// 逗号
TokenType.Comma = new TokenType(10);
TokenType.Equals = new TokenType(11);
// 左大括号
TokenType.BraceLeft = new TokenType(12);
// 右大括号
TokenType.BraceRight = new TokenType(13);
// 反引号 `
TokenType.Backticks = new TokenType(14);

Object.freeze(TokenType);
//#endregion
class Analyzer{
    //状态
    static STATE_INIT = 0;
    static STATE_IDENTIFYER = 1;
    static STATE_OPERATOR = 2;
    static STATE_NUMBER = 3;
    static STATE_STRING = 4;
    static STATE_FORCE_IDENTIFYER_SQUAREBRACKET = 5;//用于[My Table]
    static STATE_FORCE_IDENTIFYER_BACKTICKS = 6;//用于`My Table`

    //输入类型
    static INPUT_BLANK = 0;//空格
    static INPUT_OPERATOR = 1;//算数符
    static INPUT_SINGLE_QUOTES = 2;//单引号
    static INPUT_COMMA = 3;//逗号
    static INPUT_LETTER = 4;//英文字母下划线
    static INPUT_NUMBER = 5;//数字
    static INPUT_SQUAREBRACKET_LEFT = 6;//左方括号
    static INPUT_SQUAREBRACKET_RIGHT = 7;//右方括号
    static INPUT_PARENTHESES_LEFT = 8;//左小括号
    static INPUT_PARENTHESES_RIGHT = 9;//右小括号
    static INPUT_DOT = 10;//点
    static INPUT_BRACE_LEFT = 11;//左大括号
    static INPUT_BRACE_RIGHT = 12;//右大括号
    static INPUT_BACKTICKS = 13;//反引号 `

    static tokensDic = {};

    constructor(){
        this.action = [];

        let initFuncArray = [];
        let identifyerFuncArray = [];
        let operatorFuncArray = [];
        let numberFuncArray = [];
        let stringFuncArray = [];
        let force1FuncArray = [];
        let force2FuncArray = [];
        this.action.push(initFuncArray);
        this.action.push(identifyerFuncArray);
        this.action.push(operatorFuncArray);
        this.action.push(numberFuncArray);
        this.action.push(stringFuncArray);
        this.action.push(force1FuncArray);
        this.action.push(force2FuncArray);

        //#region 状态 INIT
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_BLANK] = function(ch){};
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_SINGLE_QUOTES] = function(ch){
            Analyzer.mState = Analyzer.STATE_STRING;
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_LETTER] = function(ch){
            Analyzer.mState = Analyzer.STATE_IDENTIFYER;
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_NUMBER] = function(ch){
            Analyzer.mState = Analyzer.STATE_NUMBER;
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_OPERATOR] = function(ch){
            Analyzer.mState = Analyzer.STATE_OPERATOR;
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_PARENTHESES_LEFT] = function(ch){
            Analyzer.mPriority += 100;
            let token = new Token();
            token.type = TokenType.ParenthesesLeft;
            token.value = ch;
            Analyzer.tokens.push(token);
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_PARENTHESES_RIGHT] = function(ch){
            Analyzer.mPriority -= 100;
            let token = new Token();
            token.type = TokenType.ParenthesesRight;
            token.value = ch;
            Analyzer.tokens.push(token);
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_SQUAREBRACKET_LEFT] = function(ch){
            Analyzer.mState = Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET;
            Analyzer.mPriority += 10;
            let token = new Token();
            token.type = TokenType.SquareBracketLeft;
            token.value = ch;
            Analyzer.tokens.push(token);
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_BACKTICKS] = function(ch){
            Analyzer.mState = Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS;
            Analyzer.mPriority += 10;
            let token = new Token();
            token.type = TokenType.Backticks;
            token.value = ch;
            Analyzer.tokens.push(token);
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_BRACE_LEFT] = function(ch){
            Analyzer.mPriority += 1;
            let token = new Token();
            token.type = TokenType.BraceLeft;
            token.value = ch;
            Analyzer.tokens.push(token);
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_BRACE_RIGHT] = function(ch){
            Analyzer.mPriority -= 1;
            let token = new Token();
            token.type = TokenType.BraceRight;
            token.value = ch;
            Analyzer.tokens.push(token);
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_DOT] = function(ch){
            let token = new Token();
            token.type = TokenType.Dot;
            token.value = ch;
            Analyzer.tokens.push(token);
        };
        this.action[Analyzer.STATE_INIT][Analyzer.INPUT_COMMA] = function(ch){
            let token = new Token();
            token.type = TokenType.Comma;
            token.value = ch;
            Analyzer.tokens.push(token);
        };
        //#endregion

        //#region 状态 IDENTIFYER
        this.action[Analyzer.STATE_IDENTIFYER][Analyzer.INPUT_BLANK] = function(ch){
            let token = new Token();
            token.type = TokenType.Identifier;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);
            Analyzer.stringBuilder.length = 0;
        };
        this.action[Analyzer.STATE_IDENTIFYER][Analyzer.INPUT_LETTER] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_IDENTIFYER][Analyzer.INPUT_NUMBER] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_IDENTIFYER][Analyzer.INPUT_DOT] = function(ch){
            let token = new Token();
            token.type = TokenType.Identifier;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            let token2 = new Token();
            token2.type = TokenType.Dot;
            token2.value = ch;
            Analyzer.tokens.push(token2);

            Analyzer.mState = Analyzer.STATE_INIT;
        };
        this.action[Analyzer.STATE_IDENTIFYER][Analyzer.INPUT_OPERATOR] = function(ch){
            let token = new Token();
            token.type = TokenType.Identifier;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.stringBuilder.push(ch);

            Analyzer.mState = Analyzer.STATE_OPERATOR;
        };
        this.action[Analyzer.STATE_IDENTIFYER][Analyzer.INPUT_PARENTHESES_LEFT] = function(ch){
            let token = new Token();
            token.type = TokenType.Identifier;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mPriority += 100;

            let token2 = new Token();
            token2.type = TokenType.ParenthesesLeft;
            token2.value = ch;
            Analyzer.tokens.push(token2);

            Analyzer.mState = Analyzer.STATE_INIT;
        };
        this.action[Analyzer.STATE_IDENTIFYER][Analyzer.INPUT_PARENTHESES_RIGHT] = function(ch){
            let token = new Token();
            token.type = TokenType.Identifier;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mPriority -= 100;

            let token2 = new Token();
            token2.type = TokenType.ParenthesesRight;
            token2.value = ch;
            Analyzer.tokens.push(token2);

            Analyzer.mState = Analyzer.STATE_INIT;
        };
        this.action[Analyzer.STATE_IDENTIFYER][Analyzer.INPUT_BRACE_RIGHT] = function(ch){
            let token = new Token();
            token.type = TokenType.Identifier;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mPriority -= 1;

            let token2 = new Token();
            token2.type = TokenType.BraceRight;
            token2.value = ch;
            Analyzer.tokens.push(token2);

            Analyzer.mState = Analyzer.STATE_INIT;
        };
        this.action[Analyzer.STATE_IDENTIFYER][Analyzer.INPUT_COMMA] = function(ch){
            let token = new Token();
            token.type = TokenType.Identifier;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            let token2 = new Token();
            token2.type = TokenType.Comma;
            token2.value = ch;
            Analyzer.tokens.push(token2);

            Analyzer.mState = Analyzer.STATE_INIT;
        };
        //#endregion

        //#region 状态 OPERATOR
        this.action[Analyzer.STATE_OPERATOR][Analyzer.INPUT_BLANK] = function(ch){
            let token = new Token();
            token.type = TokenType.Operator;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mState = Analyzer.STATE_INIT;
        };
        this.action[Analyzer.STATE_OPERATOR][Analyzer.INPUT_SINGLE_QUOTES] = function(ch){
            let token = new Token();
            token.type = TokenType.Operator;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mState = Analyzer.STATE_STRING;
        };
        this.action[Analyzer.STATE_OPERATOR][Analyzer.INPUT_LETTER] = function(ch){
            let token = new Token();
            token.type = TokenType.Operator;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mState = Analyzer.STATE_IDENTIFYER;

            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_OPERATOR][Analyzer.INPUT_NUMBER] = function(ch){
            let token = new Token();
            token.type = TokenType.Operator;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mState = Analyzer.STATE_NUMBER;

            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_OPERATOR][Analyzer.INPUT_OPERATOR] = function(ch){
            Analyzer.stringBuilder.push(ch);

            let token = new Token();
            token.type = TokenType.Operator;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mState = Analyzer.STATE_INIT;
        };
        this.action[Analyzer.STATE_OPERATOR][Analyzer.INPUT_PARENTHESES_LEFT] = function(ch){
            let token = new Token();
            token.type = TokenType.Operator;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;
            
            Analyzer.mPriority += 100;

            Analyzer.mState = Analyzer.STATE_INIT;

            let token2 = new Token();
            token2.type = TokenType.ParenthesesLeft;
            token2.value = ch;
            Analyzer.tokens.push(token2);
        };
        this.action[Analyzer.STATE_OPERATOR][Analyzer.INPUT_SQUAREBRACKET_LEFT] = function(ch){
            let token = new Token();
            token.type = TokenType.Operator;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;
            
            Analyzer.mPriority += 10;

            Analyzer.mState = Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET;

            let token2 = new Token();
            token2.type = TokenType.SquareBracketLeft;
            token2.value = ch;
            Analyzer.tokens.push(token2);
        };
        this.action[Analyzer.STATE_OPERATOR][Analyzer.INPUT_BACKTICKS] = function(ch){
            let token = new Token();
            token.type = TokenType.Operator;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;
            
            Analyzer.mPriority += 10;

            Analyzer.mState = Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS;

            let token2 = new Token();
            token2.type = TokenType.Backticks;
            token2.value = ch;
            Analyzer.tokens.push(token2);
        };
        this.action[Analyzer.STATE_OPERATOR][Analyzer.INPUT_BRACE_LEFT] = function(ch){
            let token = new Token();
            token.type = TokenType.Operator;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;
            
            Analyzer.mPriority += 1;

            Analyzer.mState = Analyzer.STATE_INIT;

            let token2 = new Token();
            token2.type = TokenType.BraceLeft;
            token2.value = ch;
            Analyzer.tokens.push(token2);
        };
        //#endregion

        //#region 状态 NUMBER
        this.action[Analyzer.STATE_NUMBER][Analyzer.INPUT_BLANK] = function(ch){
            let token = new Token();
            token.type = TokenType.Number;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;
            
            Analyzer.mState = Analyzer.STATE_INIT;
        };
        this.action[Analyzer.STATE_NUMBER][Analyzer.INPUT_NUMBER] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_NUMBER][Analyzer.INPUT_OPERATOR] = function(ch){
            let token = new Token();
            token.type = TokenType.Number;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;
            
            Analyzer.mState = Analyzer.STATE_OPERATOR;

            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_NUMBER][Analyzer.INPUT_PARENTHESES_RIGHT] = function(ch){
            let token = new Token();
            token.type = TokenType.Number;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mPriority -= 100;
            
            Analyzer.mState = Analyzer.STATE_INIT;

            let token2 = new Token();
            token2.type = TokenType.ParenthesesRight;
            token2.value = ch;
            Analyzer.tokens.push(token2);
        };
        this.action[Analyzer.STATE_NUMBER][Analyzer.INPUT_DOT] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_NUMBER][Analyzer.INPUT_COMMA] = function(ch){
            let token = new Token();
            token.type = TokenType.Number;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mState = Analyzer.STATE_INIT;

            let token2 = new Token();
            token2.type = TokenType.Comma;
            token2.value = ch;
            Analyzer.tokens.push(token2);
        };
        //#endregion

        //#region  状态 STRING
        this.action[Analyzer.STATE_STRING][Analyzer.INPUT_BLANK] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_STRING][Analyzer.INPUT_SINGLE_QUOTES] = function(ch){
            let token = new Token();
            token.type = TokenType.String;
            token.value = "'" + Analyzer.stringBuilder.join("") + "'";
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mState = Analyzer.STATE_INIT;
        };
        this.action[Analyzer.STATE_STRING][Analyzer.INPUT_LETTER] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_STRING][Analyzer.INPUT_NUMBER] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_STRING][Analyzer.INPUT_OPERATOR] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_STRING][Analyzer.INPUT_DOT] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        //#endregion

        //#region 状态 FORCE_IDENTIFYER_SQUAREBRACKET
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET][Analyzer.INPUT_SQUAREBRACKET_RIGHT] = function(ch){
            let token = new Token();
            token.type = TokenType.Identifier;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mPriority -= 10;

            Analyzer.mState = Analyzer.STATE_INIT;
            
            let token2 = new Token();
            token2.type = TokenType.SquareBracketRight;
            token2.value = ch;
            Analyzer.tokens.push(token2);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET][Analyzer.INPUT_LETTER] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET][Analyzer.INPUT_BLANK] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET][Analyzer.INPUT_NUMBER] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET][Analyzer.INPUT_OPERATOR] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET][Analyzer.INPUT_DOT] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET][Analyzer.INPUT_PARENTHESES_LEFT] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET][Analyzer.INPUT_PARENTHESES_RIGHT] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_SQUAREBRACKET][Analyzer.INPUT_COMMA] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        //#endregion

        //#region 状态 FORCE_IDENTIFYER_BACKTICKS
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS][Analyzer.INPUT_SQUAREBRACKET_RIGHT] = function(ch){
            let token = new Token();
            token.type = TokenType.Identifier;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;

            Analyzer.mPriority -= 10;

            Analyzer.mState = Analyzer.STATE_INIT;
            
            let token2 = new Token();
            token2.type = TokenType.Backticks;
            token2.value = ch;
            Analyzer.tokens.push(token2);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS][Analyzer.INPUT_LETTER] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS][Analyzer.INPUT_BLANK] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS][Analyzer.INPUT_NUMBER] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS][Analyzer.INPUT_OPERATOR] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS][Analyzer.INPUT_DOT] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS][Analyzer.INPUT_PARENTHESES_LEFT] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS][Analyzer.INPUT_PARENTHESES_RIGHT] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        this.action[Analyzer.STATE_FORCE_IDENTIFYER_BACKTICKS][Analyzer.INPUT_COMMA] = function(ch){
            Analyzer.stringBuilder.push(ch);
        };
        //#endregion
    }
    static stringBuilder = [];
    static mState = Analyzer.STATE_INIT;
    static mPriority = 0;
    static tokens = new Tokens();

    //
    analysis(expression){
        if(Analyzer.tokensDic[expression]){
            return Analyzer.tokensDic[expression];
        }
        let row = 1;
        let col = 0;
        Analyzer.stringBuilder = [];
        Analyzer.mState = Analyzer.STATE_INIT;
        Analyzer.mPriority = 0;
        Analyzer.tokens = new Tokens();

        for(let i = 0; i < expression.length; i++){
            col++;
            let ch = expression.charAt(i);
            let inputType = Analyzer.INPUT_BLANK;
            if(Analyzer.mState == Analyzer.STATE_STRING && ch != '\'' && ch != '\"'){
                inputType = Analyzer.INPUT_LETTER;
            }else{
                switch(true){
                    case ch == ' ':
                        inputType = Analyzer.INPUT_BLANK;
                        break;
                    case ch.charCodeAt(0) == 13:
                        inputType = Analyzer.INPUT_BLANK;
                        break;
                    case ch.charCodeAt(0) == 10:
                        inputType = Analyzer.INPUT_BLANK;
                        row++;
                        col = 0;
                        break;
                    case ch == '\'':
                        inputType = Analyzer.INPUT_SINGLE_QUOTES;
                        break;
                    case ch == '\"':// 19-05-15 增加双引号
                        inputType = Analyzer.INPUT_SINGLE_QUOTES;
                        break;
                    case (ch >= 'A' && ch <= 'Z') || (ch >= 'a' && ch <= 'z') || (ch == "_") || (ch == "@"):
                        inputType = Analyzer.INPUT_LETTER;
                        break;
                    case ch >= '0' && ch <= '9':
                        inputType = Analyzer.INPUT_NUMBER;
                        break;
                    case ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '%' || ch == '^' || ch == '!' || ch == '=' || ch == '&' || ch == '|' || ch == '>' || ch == '<':
                        inputType = Analyzer.INPUT_OPERATOR;
                        break;
                    case ch == '(':
                        if (Analyzer.mPriority % 10 != 0){
                            let error = new Error();
                            error.message = "无法识别字符" + ch + "。";
                            error.row = row;
                            error.column = col;
                            return error;
                        }
                        inputType = Analyzer.INPUT_PARENTHESES_LEFT;
                        break;
                    case ch == ')':
                        if (Analyzer.mPriority % 10 != 0){
                            let error = new Error();
                            error.message = "无法识别字符" + ch + "。";
                            error.row = row;
                            error.column = col;
                            return error;
                        }
                        inputType = Analyzer.INPUT_PARENTHESES_RIGHT;
                        break;
                    case ch == '[':
                        inputType = Analyzer.INPUT_SQUAREBRACKET_LEFT;
                        break;
                    case ch == ']':
                        inputType = Analyzer.INPUT_SQUAREBRACKET_RIGHT;
                        break;
                    case ch == '`':
                        inputType = Analyzer.INPUT_BACKTICKS;
                        break;
                    case ch == '{':
                        inputType = Analyzer.INPUT_BRACE_LEFT;
                        break;
                    case ch == '}':
                        inputType = Analyzer.INPUT_BRACE_RIGHT;
                        break;
                    case ch == '.':
                        inputType = Analyzer.INPUT_DOT;
                        break;
                    case ch == ',':
                        inputType = Analyzer.INPUT_COMMA;
                        break;
                    default:
                        if (ch.charCodeAt(0) > 127)
                            inputType = Analyzer.INPUT_LETTER;
                        else{
                            let error = new Error();
                            error.message = "无法识别字符" + ch + "。";
                            error.row = row;
                            error.column = col;
                            return error;
                        }
                        break;
                }
            }

            if(this.action[Analyzer.mState][inputType]){
                this.action[Analyzer.mState][inputType](ch);
            }else{
                let error = new Error();
                error.message = "无法识别字符" + ch + "。";
                error.row = row;
                error.column = col;
                return error;
            }
        }


        if(Analyzer.mPriority != 0){
            let error = new Error();
            error.message = "括号错误。";
            error.row = row;
            error.column = col;
            return error;
        }
        if(Analyzer.mState == Analyzer.STATE_OPERATOR){
            let error = new Error();
            error.message = "操作符不能放置在最末端。";
            error.row = row;
            error.column = col;
            return error;
        }
        if(Analyzer.mState == Analyzer.STATE_STRING){
            let error = new Error();
            error.message = "字符串读取错误。";
            error.row = row;
            error.column = col;
            return error;
        }
        if(Analyzer.mState == Analyzer.STATE_IDENTIFYER){
            let token = new Token();
            token.type = TokenType.Identifier;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;
        }else if(Analyzer.mState == Analyzer.STATE_NUMBER){
            let token = new Token();
            token.type = TokenType.Number;
            token.value = Analyzer.stringBuilder.join("");
            Analyzer.tokens.push(token);

            Analyzer.stringBuilder.length = 0;
        }

        Analyzer.tokensDic[expression] = Analyzer.tokens;
        return Analyzer.tokens;
    }
}
