function DataSources(){
    var me = this;
    var aryDataSources = [];

    this.count = function(){
        return aryDataSources.length;
    };
    this.clear = function(){
        aryDataSources = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryDataSources[indexOrKey];
        }else{
            for(var i = 0; i < aryDataSources.length; i++){
                if(aryDataSources[i].dataSourceID == indexOrKey){
                    return aryDataSources[i];
                }
            }
        }
    };
    this.add = function (dataSource) {
        aryDataSources.push(dataSource);
    };
    this.remove = function (dataSource) {
        for(var i = 0; i < aryDataSources.length; i++){
            if(aryDataSources[i].dataSourceID==dataSource.dataSourceID){
                k = i;
                break;
            }
        }
        aryDataSources.splice(k,1);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.dataSourcePath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jArray){
        initWithArray(this, DataSource.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryDataSources;
    };
}

function DataSource(){
    var me = this;
    this.dataSourceID = null;
    this.dataSourceName = null;
    this.dataSourceType = null;

    this.createUserID = null;
    this.createUserName = null;
    this.createDate = null;
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function DatabaseLinks(){
    var me = this;
    var aryDatabaseLinks = [];

    this.count = function(){
        return aryDatabaseLinks.length;
    };
    this.clear = function(){
        aryDatabaseLinks = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryDatabaseLinks[indexOrKey];
        }else{
            for(var i = 0; i < aryDatabaseLinks.length; i++){
                if(aryDatabaseLinks[i].dataSourceID == indexOrKey){
                    return aryDatabaseLinks[i];
                }
            }
        }
    };
    this.add = function (databaseLink) {
        aryDatabaseLinks.push(databaseLink);
    };
    this.remove = function (databaseLink) {
        for(var i = 0; i < aryDatabaseLinks.length; i++){
            if(aryDatabaseLinks[i].dataSourceID==databaseLink.dataSourceID){
                k = i;
                break;
            }
        }
        aryDatabaseLinks.splice(k,1);
    };
    this.addItem = function(databaselink,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath;
        var obj = JSON.stringify(databaselink);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var dataSourceID = request.getResponseHeader('location').split('/databaseLinks/')[1];
                databaselink.dataSourceID = dataSourceID;
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(databaseLink,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + databaseLink.dataSourceID;
        var obj = JSON.stringify(databaseLink);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                databaseLink.initByID(asyncOrSync,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + dataSourceID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(dataSourceID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getDatabaseLinkByName = function(name){
        for(var i = 0; i < aryDatabaseLinks.length; i++){
            if(aryDatabaseLinks[i].dataSourceName == name){
                return aryDatabaseLinks[i];
            }
        }
        return null;
    }
    this.init = function(jArray){
        initWithArray(this, DatabaseLink.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryDatabaseLinks;
    };
}


function DatabaseLink(){
    var me = this;
    DataSource.call(this);
    this.databaseIP = null;
    this.databasePort = null;
    this.userName = null;
    this.password = null;

    this.serviceType = null;

    this.databaseTypeName = null;
    this.databaseName = null;

    this.getTablesInterface = null;
    this.getFieldsInterface = null;
    this.executeSqlInterface = null;


    this.executeSQL = function(sqlText,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + this.dataSourceID + "/SQLs";
        var obj = {
            sql: sqlText
        };
        obj = JSON.stringify(obj);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getBusinessData = function(sqlText,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + this.dataSourceID + "/sql/businessData?valueAsString=1&recordCount=200";
        var obj = {
            sql: sqlText
        };
        obj = JSON.stringify(obj);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getDatabaseNames =  function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/databaseNames?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.testConnections = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/connections?"+parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.initByID = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/"+this.dataSourceID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function DatabaseTypes(){
    var me = this;
    var aryDatabaseTypes = [];

    this.count = function(){
        return aryDatabaseTypes.length;
    };
    this.clear = function(){
        aryDatabaseTypes = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryDatabaseTypes[indexOrKey];
        }else{
            for(var i = 0; i < aryDatabaseTypes.length; i++){
                if(aryDatabaseTypes[i].databaseTypeID == indexOrKey){
                    return aryDatabaseTypes[i];
                }
            }
        }
    };
    this.add = function (databaseType) {
        aryDatabaseTypes.push(databaseType);
    };
    this.remove = function (databaseType) {
        for(var i = 0; i < aryDatabaseTypes.length; i++){
            if(aryDatabaseTypes[i].databaseTypeID==databaseType.databaseTypeID){
                k = i;
                break;
            }
        }
        aryDatabaseTypes.splice(k,1);
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseTypePath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jArray){
        initWithArray(this, DatabaseType.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryDatabaseTypes;
    };
}

function DatabaseType(){
    this.databaseTypeName = null;
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function ExcelFiles(){
    var me = this;
    var aryExcelFiles = [];

    this.count = function(){
        return aryExcelFiles.length;
    };
    this.clear = function(){
        aryExcelFiles = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryExcelFiles[indexOrKey];
        }else{
            for(var i = 0; i < aryExcelFiles.length; i++){
                if(aryExcelFiles[i].dataSourceID == indexOrKey){
                    return aryExcelFiles[i];
                }
            }
        }
    };
    this.add = function (excelFile) {
        aryExcelFiles.push(excelFile);
    };
    this.remove = function (excelFile) {
        for(var i = 0; i < aryExcelFiles.length; i++){
            if(aryExcelFiles[i].dataSourceID==excelFile.dataSourceID){
                k = i;
                break;
            }
        }
        aryExcelFiles.splice(k,1);
    };
    this.addItem = function(excelFile, excel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath;
        var obj = JSON.stringify(excelFile);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                excelFile.dataSourceID = request.getResponseHeader('location').split('/excelFiles/')[1];
                me.addExcel(excel,excelFile.dataSourceID,asyncOrSync,succ,fail);
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addExcel = function(excel,dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/" + dataSourceID + "/file";
        var obj = excel;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/" + dataSourceID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(dataSourceID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.isExist = function(excelFileName,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/excelFileNames?excelFileName="+encodeURIComponent(excelFileName);
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ(request.status);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(XHR.status == 404){
                    succ(404);
                }else{
                    if(!$Utils.request.isJson(XHR.responseText)){
                        fail(XHR.status,XHR.responseText);
                    }else{
                        fail(XHR.status,JSON.parse(XHR.responseText).error);
                    }
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getExcelFileByName = function(name){
        for(var i = 0; i < aryExcelFiles.length; i++){
            if(aryExcelFiles[i].dataSourceName == name){
                return aryExcelFiles[i];
            }
        }
        return null;
    }

    this.init = function(jArray){
        initWithArray(this, ExcelFile.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryExcelFiles;
    };
}
function ExcelFile(){
    var me = this;
    
    DataSource.call(this);
    this.excelFileName = null;
    this.sheetName = null;
    this.rangeType = null;
    this.range = null;
    this.columns = new BDAColumns();
    this.custom = false;

    this.getItemByDataSourceID = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/" + dataSourceID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getExcelSheetData = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/" + this.dataSourceID + "/businessData?recordCount=200&formatDate=1";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.download = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/" + this.dataSourceID + "/file";
        var obj = "";
        var dataType = 'blob';
        var succCallback = function(data){
            succ(data);
        }
        var failCallback = function(status,statusText){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(status || status == 0){
                fail(status,statusText);
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.downLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    
    this.init = function(jObject){
        initWithObject(this, ["columns"],jObject);
    };
}

function BDAColumns(){
    var me = this;
    var aryBDAColumns = [];

    this.count = function(){
        return aryBDAColumns.length;
    };
    this.clear = function(){
        aryBDAColumns = [];
    };
    this.add = function (column) {
        aryBDAColumns.push(column);
    };
    this.item = function (indexOrKey) {
        return aryBDAColumns[indexOrKey];
    };
    this.remove = function (bdaColumn) {
        for(var i = 0; i < aryBDAColumns.length; i++){
            if(aryBDAColumns[i]==bdaColumn){
                k = i;
                break;
            }
        }
        aryBDAColumns.splice(k,1);
    };
    
    this.init = function(jArray){
        initWithArray(this, BDAColumn.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryBDAColumns;
    };
}
function BDAColumn(){
    this.columnName = null;
    this.valueRange = null;
    this.dataType = 0;
    this.custom = false;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function Tables(){
    var me = this;
    var aryTables = [];

    this.count = function(){
        return aryTables.length;
    };
    this.clear = function(){
        aryTables = [];
    };
    this.add = function (table) {
        aryTables.push(table);
    };
    this.remove = function (table) {
        for(var i= 0; i < aryTables.length; i++){
            if(aryTables[i].tableName==table.tableName){
                k = i;
                break;
            }
        }
        aryTables.splice(k,1);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryTables[indexOrKey];
        }else{
            for(var i = 0; i < aryTables.length; i++){
                if(aryTables[i].tableName == indexOrKey){
                    return aryTables[i];
                }
            }
        }
    };

    this.getItems = function (datasourceID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + datasourceID + "/tables";
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    this.getTableFields = function (datasourceID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + datasourceID + "/tables/fields";
        var obj = JSON.stringify(aryTables);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                var tempTables = new Tables();
                tempTables.init(data.items);
                for (var i = 0; i < tempTables.count(); i++) {
                    var tempObj = tempTables.item(i);
                    me.item(tempObj.tableName).tableFields = tempObj.tableFields;
                }
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    this.init = function(jArray){
        initWithArray(this, Table.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTables;
    };
}

function Table(){
    var me = this;

    this.tableName = null;
    /// <summary>
    /// 0:表 1:视图 2:同义词
    /// </summary>
    this.tableType = 0;
    this.tableFields = new TableFields();
    this.getTableData = function (datasourceID, asyncOrSync, succ, fail, recordCount = -1) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + datasourceID + "/tables/" + encodeURIComponent(this.tableName) + "/businessData";
        if (recordCount != -1) {
            url += "?recordCount=" + recordCount;
        }
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                succ(data.items);
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    
    this.init = function(jObject){
        initWithObject(this, ["tableFields"],jObject);
    };
}

function TableFields(){
    var me = this;
    var aryTableFields = [];

    this.count = function(){
        return aryTableFields.length;
    };
    this.clear = function(){
        aryTableFields = [];
    };
    this.add = function (tableField) {
        aryTableFields.push(tableField);
    };
    this.remove = function (tableField) {
        for(var i= 0; i < aryTableFields.length; i++){
            if(aryTableFields[i].fieldName==tableField.fieldName){
                k = i;
                break;
            }
        }
        aryTableFields.splice(k,1);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryTableFields[indexOrKey];
        }else{
            for(var i = 0; i < aryTableFields.length; i++){
                if(aryTableFields[i].fieldName == indexOrKey){
                    return aryTableFields[i];
                }
            }
        }
    };
    this.resortOrderByAsc = function () {
        aryTableFields.sort(function (a, b) {
            var fisrstValue = a.fieldName || "";
            var nextValue = b.fieldName || "";
            // 判断是否为数字开始; 为啥要判断?看上图源数据
            if ((Number(fisrstValue) == 0 || Number(fisrstValue)) && (Number(nextValue) == 0 || Number(nextValue))) {
                // 提取起始数字, 然后比较返回
                return fisrstValue - nextValue;
                // 如包含中文, 按照中文拼音排序
            }
            else if (isChinese(fisrstValue) && isChinese(nextValue)) {
                // 按照中文拼音, 比较字符串
                return fisrstValue.localeCompare(nextValue, 'zh-CN')
            }
            else {
                // 排序数字和字母
                return fisrstValue.localeCompare(nextValue, 'en');
            }
        })
    };
    this.resortOrderByDesc = function () {
        aryTableFields.sort(function arrSortMaxToMin(a, b) {
            var fisrstValue = a.fieldName || "";
            var nextValue = b.fieldName || "";
            // 判断是否为数字开始; 为啥要判断?看上图源数据
            if ((Number(fisrstValue) == 0 || Number(fisrstValue)) && (Number(nextValue) == 0 || Number(nextValue))) {
                // 提取起始数字, 然后比较返回
                return nextValue - fisrstValue;
                // 如包含中文, 按照中文拼音排序
            } else if (isChinese(fisrstValue) && isChinese(nextValue)) {
                // 按照中文拼音, 比较字符串
                //return a[sortId].localeCompare(b[sortId], 'zh-CN');
                return nextValue.localeCompare(fisrstValue, 'zh-CN');
            } else {
                // 排序数字和字母
                return nextValue.localeCompare(fisrstValue, 'en');
            }

        })
    };

    this.init = function(jArray){
        initWithArray(this, TableField.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTableFields;
    };

    function isChinese(str) {
        // 中文万国码正则
        var repx = new RegExp("^[\u4e00-\u9fa5]");
        if (repx.test(str)) {
            return true;
        } else {
            return false;
        }
    }
}

function TableField(){
    var me = this;

    this.fieldName = null;
    this.comment = "";
    this.dataType = 0;//Character = 0,DateTime = 1,Decimal = 2,ImageUrl = 3,ImageBinary = 4
    this.visible = true;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}