
function BizDbSettings(){
    var me = this;
    var aryDbSettings = [];

    this.count = function(){
        return aryDbSettings.length;
    };
    this.clear = function(){
        aryDbSettings = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryDbSettings[indexOrKey];
        }else{
            for(var i = 0; i < aryDbSettings.length; i++){
                if(aryDbSettings[i].databaseSettingID == indexOrKey){
                    return aryDbSettings[i];
                }
            }
        }
    };
    this.add = function (dbSetting) {
        aryDbSettings.push(dbSetting);
    };
    this.remove = function (dbSetting) {
        for(var i = 0; i < aryDbSettings.length; i++){
            if(aryDbSettings[i].databaseSettingID==dbSetting.databaseSettingID){
                k = i;
                break;
            }
        }
        aryDbSettings.splice(k,1);
    };
    this.addItem = function(dbSetting,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath;
        var obj = JSON.stringify(dbSetting);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var databaseSettingID = request.getResponseHeader('location').split('/dbSettings/')[1];
                dbSetting.databaseSettingID = databaseSettingID;
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(dbSetting,asyncOrSync,succ,fail){
        // var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath + "/" + dbSetting.databaseSettingID;
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath;
        var obj = JSON.stringify(dbSetting);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                var temp = new BizDbSettings();
                var newSucc = function(){
                    dbSetting.databaseSettingID = temp.item(0).databaseSettingID;
                    succ();
                }
                temp.getItems(1, false, newSucc, fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(databaseSettingID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath + "/" + databaseSettingID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(databaseSettingID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    

    this.init = function(jArray){
        initWithArray(this, BizDbSetting.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryDbSettings;
    };
}

function BizDbSetting(){
    this.databaseSettingID = null;
    this.bizSystemName = null;
    this.databaseIP = null;
    this.databasePort = null;
    this.databaseTypeName = null;
    this.databaseName = null;
    this.userName = null;
    this.password = null;

    this.testConnections = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath + "/connection?"+parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    }
    this.getDatabaseNames = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath + "/databaseNames?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                succ(data.items);
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.executeSQL = function(sqlText,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.initializationsPath;
        var textObject = {};
        textObject.SQL = sqlText;
        var obj = JSON.stringify(textObject);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function BDAJobs(){
    var me = this;
    var aryJobs = [];

    this.count = function(){
        return aryJobs.length;
    };
    this.clear = function(){
        aryJobs = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryJobs[indexOrKey];
        }else{
            for(var i = 0; i < aryJobs.length; i++){
                if(aryJobs[i].jobID == indexOrKey){
                    return aryJobs[i];
                }
            }
        }
    };
    this.add = function (job) {
        aryJobs.push(job);
    };
    this.remove = function (job) {
        for(var i = 0; i < aryJobs.length; i++){
            if(aryJobs[i].jobID==job.jobID){
                k = i;
                break;
            }
        }
        aryJobs.splice(k,1);
    };
    this.addItem = function(job,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath;
        var obj = JSON.stringify(job);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var jobID = request.getResponseHeader('location').split('/jobs/')[1];
                job.jobID = jobID;
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(job,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath + "/" + job.jobID;
        var obj = JSON.stringify(job);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(jobID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath + "/" + jobID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(jobID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getJobByName = function(name){
        for(var i = 0; i < aryJobs.length; i++){
            if(aryJobs[i].jobName == name){
                return aryJobs[i];
            }
        }
        return null;
    };

    this.init = function(jArray){
        initWithArray(this, BDAJob.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryJobs;
    };
}
function BDAJob(){
    this.jobID = null;
    this.jobName = null;
    this.frequency = 0;//每天 = 0,每周 = 1,每月 = 2
    this.frequencyType = 0;//执行一次 = 0,间隔执行 = 1
    this.oneTimeStartDate = null;
    this.interval = null;
    this.intervalStartTime = null;
    this.intervalEndTime = null;
    this.emailAddress = null;
    this.enabled = null;
    this.jobStatus = 0;//空闲 = 0,正在执行中 = 1
    this.transforms = new BDATransforms();

    this.getItemByID = function(jobID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath + "/" + jobID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.changeTransfroms = function(jStrTransform,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobTransformsPath + "/" + this.jobID;
        var obj = JSON.stringify(jStrTransform);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jObject){
        initWithObject(this, ["transforms"],jObject);
    };
}
function BDATransforms(){
    var me = this;
    var aryTransforms = [];

    this.count = function(){
        return aryTransforms.length;
    };
    this.clear = function(){
        aryTransforms = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryTransforms[indexOrKey];
        }else{
            for(var i = 0; i < aryTransforms.length; i++){
                if(aryTransforms[i].transformID == indexOrKey){
                    return aryTransforms[i];
                }
            }
        }
    };
    this.add = function (transform) {
        aryTransforms.push(transform);
    };
    this.remove = function (transform) {
        for(var i = 0; i < aryTransforms.length; i++){
            if(aryTransforms[i].transformID==transform.transformID){
                k = i;
                break;
            }
        }
        aryTransforms.splice(k,1);
    };
    this.addItem = function(transform,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath;
        var obj = JSON.stringify(transform);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var transformID = request.getResponseHeader('location').split('/transforms/')[1];
                transform.transformID = transformID;
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(transform,asyncOrSync,succ,fail, param){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath + "/" + transform.transformID;
        if(param){
            url = url + param;
        }
        var obj = JSON.stringify(transform);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(transformID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath + "/" + transformID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(transformID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail, param){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath + "?moduleID="+moduleID;
        if(param){
            url = url + param;
        }
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getTransformByName = function(name){
        for(var i = 0; i < aryTransforms.length; i++){
            if(aryTransforms[i].transformName == name){
                return aryTransforms[i];
            }
        }
        return null;
    };

    this.init = function(jArray){
        initWithArray(this, BDATransform.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTransforms;
    };
}

function BDATransform(){
    this.transformID = null;
    this.transformName = null;
    this.transformType = 0;//维度表 = 0,事实表 = 1
    this.targetTable = null;
    this.targetTableDescription = null;
    this.sourceTable = null;
    this.sourceTableDescription = null;
    this.transformLogicType = 0;//SQL = 0,后台代码 = 1
    this.transformLogic = null;
    this.preseted = null;
    this.lastExecuteDate = null;
    this.flag = false;//true为保密

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}
function JobTransforms(){
    var me = this;
    var aryJobTransforms = [];

    this.count = function(){
        return aryJobTransforms.length;
    };
    this.clear = function(){
        aryJobTransforms = [];
    };
    this.item = function (indexOrKey) {
        return aryJobTransforms[indexOrKey];
    };
    this.add = function (job) {
        aryJobTransforms.push(job);
    };
    this.remove = function (jobTransform) {
        for(var i = 0; i < aryJobTransforms.length; i++){
            if(aryJobTransforms[i]==jobTransform){
                k = i;
                break;
            }
        }
        aryJobTransforms.splice(k,1);
    };
    this.addItem = function(jobTransform,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobTransformsPath;
        var obj = JSON.stringify(jobTransform);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(jobTransform,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobTransformsPath + "/" + job.transformID;
        var obj = JSON.stringify(jobTransform);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(transformID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobTransformsPath + "/" + transformID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(transformID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobTransformsPath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jArray){
        initWithArray(this, JobTransform.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryJobTransforms;
    };
}

function JobTransform(){
    this.jobID = null;
    this.transformID = null;
    this.sequence = null;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}
function SqlEntry(){
    this.id = null;
    this.name = null;
    this.parentID = null;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}
function SqlScript(){
    SqlEntry.call(this);
    this.text = null;
    this.showText = null;
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}
function SqlFolder(){
    SqlEntry.call(this);
    this.sqlEntrys = [];
    this.item = function (childName) {
        for(var i = 0; i < this.sqlEntrys.length; i++){
            if(this.sqlEntrys[i].name == childName){
                return this.sqlEntrys[i];
            }
        }
        return null;
    };
    this.add = function(sqlEntry){
        for(var i = 0; i < this.sqlEntrys.length; i++){
            if(this.sqlEntrys[i].name == sqlEntry.name){
                return;
            }
        }
        this.sqlEntrys.push(sqlEntry);
    };
    this.remove = function (sqlEntry) {
        var k = -1;
        for(var i= 0;i<this.sqlEntrys.length;i++){
            if(this.sqlEntrys[i].id==sqlEntry.id){
                k = i;
                break;
            }
        }
        this.sqlEntrys.splice(k,1);
    };
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}