function BusinessObjectFolders(){
    var aryBusinessObjectFolders = [];

    
    this.count = function () {
        return aryBusinessObjectFolders.length;
    };
    this.add = function (businessObjectFolder) {
        aryBusinessObjectFolders.push(businessObjectFolder);
    };
    this.clear = function(){
        aryBusinessObjectFolders = [];
    };
    this.remove = function (businessObjectFolder) {
        for(var i= 0; i < aryBusinessObjectFolders.length; i++){
            if(aryBusinessObjectFolders[i].folderID==businessObjectFolder.folderID){
                k = i;
                break;
            }
        }
        aryBusinessObjectFolders.splice(k,1);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryBusinessObjectFolders[indexOrKey];
        }else{
            for(var i = 0; i < aryBusinessObjectFolders.length; i++){
                if(aryBusinessObjectFolders[i].folderID == indexOrKey){
                    return aryBusinessObjectFolders[i];
                }
            }
        }
    };
    
    this.init = function(jArray){
        initWithArray(this, BusinessObjectFolder.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryBusinessObjectFolders;
    };
}

function BusinessObjectFolder(){
    this.folderID = null;
    this.folderName = null;
    this.description = null;
    this.folderParentID = null;
    this.sortIndex = null;
    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function BusinessObjects() {
    var me = this;
    var aryBusinessObjects = [];

    this.count = function () {
        return aryBusinessObjects.length;
    };
    this.clear = function () {
        aryBusinessObjects = [];
    };
    this.add = function (businessObject) {
        aryBusinessObjects.push(businessObject);
    };
    this.remove = function (businessObject) {
        for (var i = 0; i < aryBusinessObjects.length; i++) {
            if (aryBusinessObjects[i].businessObjectID == businessObject.businessObjectID) {
                k = i;
                break;
            }
        }
        aryBusinessObjects.splice(k, 1);
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return aryBusinessObjects[indexOrKey];
        } else {
            for (var i = 0; i < aryBusinessObjects.length; i++) {
                if (aryBusinessObjects[i].businessObjectID == indexOrKey) {
                    return aryBusinessObjects[i];
                }
            }
        }
        return null;
    };

    this.init = function (jArray) {
        initWithArray(this, BusinessObject.prototype.constructor, jArray);
    };
    this.toJSON = function () {
        return aryBusinessObjects;
    };
}

function BusinessObject() {
    this.businessObjectID = null;
    this.businessObjectName = null;
    this.businessObjectFolderID = null;
    this.aggregateFunction = null;
    this.aggregateAware = null;
    this.valueOrder = null;
    this.formatString = null;
    this.businessObjectType = null;
    this.dataType = null;
    this.columnName = null;//excel模型才有
    this.expressionText = null;//"SUM(Sale_Order_Lines.days * Sale_Order_Lines.guests * Services.price)"
    this.expressionList = null;//["SUM(Sale_Order_Lines.days * Sale_Order_Lines.guests * Services.price)"]
    this.tableNamesList = null;//[["Sale_Order_Lines","Services"]]
    this.sortIndex = null;


    this.init = function (jObject) {
        initWithObject(this, [], jObject);
    };
}