function BusinessModels(){
    var me = this;
    var aryBusinessModels = [];

    this.count = function(){
        return aryBusinessModels.length;
    };
    this.clear = function(){
        aryBusinessModels = [];
    };
    this.add = function (businessModel) {
        aryBusinessModels.push(businessModel);
    };
    this.remove = function (businessModel) {
        for(var i= 0; i < aryBusinessModels.length; i++){
            if(aryBusinessModels[i].businessModelID==businessModel.businessModelID){
                k = i;
                break;
            }
        }
        aryBusinessModels.splice(k,1);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryBusinessModels[indexOrKey];
        }else{
            for(var i = 0; i < aryBusinessModels.length; i++){
                if(aryBusinessModels[i].businessModelID == indexOrKey){
                    return aryBusinessModels[i];
                }
            }
        }
        return null;
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getUsedCount = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "/count?dataSourceID="+dataSourceID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.property);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jArray){
        initWithArray(this, BusinessModel.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryBusinessModels;
    };
}

function BusinessModel(){
    this.businessModelID = null;
    this.businessModelName = null;
    this.businessModelType = null;
    this.description = null;
    this.dataSourceID = null;
    this.dataSourceName = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = null;
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function RelationModels(){
    var me = this;
    var aryRelationModels = [];

    this.count = function(){
        return aryRelationModels.length;
    };
    this.clear = function(){
        aryRelationModels = [];
    };
    this.add = function (relationModel) {
        aryRelationModels.push(relationModel);
    };
    this.remove = function (relationModel) {
        for(var i= 0;i<aryRelationModels.length;i++){
            if(aryRelationModels[i].businessModelID==relationModel.businessModelID){
                k = i;
                break;
            }
        }
        aryRelationModels.splice(k,1);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryRelationModels[indexOrKey];
        }else{
            for(var i = 0; i < aryRelationModels.length; i++){
                if(aryRelationModels[i].businessModelID == indexOrKey){
                    return aryRelationModels[i];
                }
            }
        }
    };
    this.addItem = function(relationModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.relationModelPath;
        var obj = JSON.stringify(relationModel);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var businessModelID = request.getResponseHeader('location').split('/relationModels/')[1];
                relationModel.businessModelID = businessModelID;
                relationModel.initByModelID(asyncOrSync,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(relationModel,asyncOrSync,succ,fail, param){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.relationModelPath + "/" + relationModel.businessModelID;
        if(param){
            url = url + param;
        }
        var obj = JSON.stringify(relationModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                relationModel.initByModelID(asyncOrSync,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editSimpleProperties = function(relationModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.relationModelPath + "/" + relationModel.businessModelID + "/simpleProperties";
        var obj = JSON.stringify(relationModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                relationModel.initByModelID(asyncOrSync,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.relationModelPath + "/" + businessModelID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(businessModelID))
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID="+moduleID+"&businessModelType=0";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getModelByName = function(modelName){
        for(var i = 0; i < aryRelationModels.length; i++){
            if(aryRelationModels[i].businessModelName == modelName){
                return aryRelationModels[i];
            }
        }
        return null;
    }
    
    this.init = function(jArray){
        initWithArray(this, RelationModel.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryRelationModels;
    };
}

function RelationModel(){
    var me = this;
    BusinessModel.call(this);

    this.relationDiagramFolders = new RelationDiagramFolders();
    this.relationDiagrams = new RelationDiagrams();
    this.businessObjectFolders = new BusinessObjectFolders();
    this.businessObjects = new BusinessObjects();
    this.queryTableRestrictions = new QueryTableRestrictions();


    this.initByModelID = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.relationModelPath + "/" + this.businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.checkQueryRestrictions = function(){
        for(var i = 0; i < this.queryTableRestrictions.count(); i++){
            var queryRestriction = this.queryTableRestrictions.item(i);
            if(!this.relationDiagrams.containTableAlias(queryRestriction.tableAlias)){
                return new BDAResult(false, Message = "查询限制中的表 " + queryRestriction.tableAlias + " 不存在与任意一个关系图中。");
            }
        }
        return new BDAResult(true);
    }

    this.getDimensionDiagrams = function(){
        var dimensionDiagrams = new RelationDiagrams();
        for(var i = 0; i < this.relationDiagrams.count(); i++){
            if(this.relationDiagrams.item(i).relationDiagramType == 0){
                dimensionDiagrams.add(this.relationDiagrams.item(i));
            }
        }
        return dimensionDiagrams;
    }
    this.getFactDiagrams = function(){
        var factDiagrams = new RelationDiagrams();
        for(var i = 0; i < this.relationDiagrams.count(); i++){
            if(this.relationDiagrams.item(i).relationDiagramType == 0){
                factDiagrams.add(this.relationDiagrams.item(i));
            }
        }
        return factDiagrams;
    }

    //#region 检测BusinessObject表达式
    this.analyzeExpression = function(expressionText, databaseTypeName){
        var newExpressionList = [];
        try {
            newExpressionList = this.getExpressionList(expressionText);
        } catch (error) {
            return new BDAResult(false,error);
        }
        var tableBlocks = this.relationDiagrams.getTableBlocks();
        var tableNamesList = [];
        for(var i = 0; i < newExpressionList.length; i++){
            tableNamesList.push(this.getTableAliass(newExpressionList[i]));
        }

        var result = new BDAResult(true);
        var stringBuilder = [];
        for(var i = 0; i < newExpressionList.length; i++){
            if(!result.result) break;
            stringBuilder.length = 0;
            stringBuilder.push("SELECT ");
            stringBuilder.push(newExpressionList[i]);
            if(tableNamesList[i].length > 0){
                stringBuilder.push(" FROM ");
                for(var j = 0; j < tableNamesList[i].length; j++){
                    var tableName = tableNamesList[i][j];
                    if(tableBlocks.containTableAlias(tableName)){
                        stringBuilder.push(tableBlocks.getTableNameByTableAlias(tableName)+" "+tableName);
                    }else{
                        stringBuilder.push(tableName);
                    }
                    if(j != tableNamesList[i].length - 1){
                        stringBuilder.push(",");
                    }

                }
                stringBuilder.push(" WHERE 0 = 1");
            }else{
                if("MySql" == databaseTypeName || "Hive" == databaseTypeName || "Oracle" == databaseTypeName){
                    stringBuilder.push(" FROM dual ");
                }
            }
            var sql = stringBuilder.join("");

            var databaseLink = new DatabaseLink();
            databaseLink.dataSourceID = this.dataSourceID;
            databaseLink.executeSQL(sql, false, function () { }, function (status, errorMsg){
                result.result = false;
                result.message = status+"# "+errorMsg;
            });
        }
        return result;
    }

    this.getExpressionList = function(expressionText){
        var expressionList = [];
        var rawExpression = expressionText;
        if(rawExpression.toLocaleLowerCase().startsWith("@aggregate_aware")){
            var parenthesesLeft = rawExpression.indexOf('(');
            var parenthesesRight = rawExpression.indexOf(')');
            var paExpression = rawExpression.substring(parenthesesLeft + 1,parenthesesRight);
            var priority = 0;
            var indexList = [];
            indexList.push(-1);
            for(var i = 0; i < paExpression.length; i++){
                if(paExpression[i] == '(') {
                    priority += 10;
                }else if(paExpression[i] == ')'){
                    priority -= 10;
                }else if(paExpression[i] == ',' && priority == 0){
                    indexList.push(i);
                }
            }
            for(var i = 0; i < indexList.length - 1; i++){
                expressionList.push(paExpression.substring(indexList[i] + 1, indexList[i + 1]).trim());
            }
            expressionList.push(paExpression.substring(indexList[indexList.length - 1] + 1).trim());
            if(expressionList.length <= 1){
                throw "参数个数必须大于等于2";
            }
        }else{
            expressionList.push(rawExpression);
        }
        expressionList.reverse();
        return expressionList;
    }

    this. getTableAliass = function(expression){
        var result = [];
        var matches = [...expression.matchAll(/(?<![\w.\[`])(\[.*?\]|`.*?`|\w+)\s*\./gi)];
        for(var i = 0; i < matches.length; i++){
            var tableAlias = matches[i][1];
            var numRe = /^[0-9]/gm;
            if(numRe.test(tableAlias)){
                continue;
            }
            if(tableAlias[0] == '[' && tableAlias[tableAlias.length - 1] == ']'){
                tableAlias = tableAlias.substring(1, tableAlias.length - 1);
            }else if(tableAlias[0] == '`' && tableAlias[tableAlias.length - 1] == '`'){
                tableAlias = tableAlias.substring(1, tableAlias.length - 1);
            }else if(result.indexOf(tableAlias) != -1){
                continue;
            }
            result.push(tableAlias);
        }
        return result;
    }

    this.analyzeFilterSyntax = function(expression){
        var result = new BDAResult(true);

        var tableBlocks = this.relationDiagrams.getTableBlocks();
        var stringBuilder = [];
        var tableNames = this.getTableAliass(expression);

        stringBuilder.push("SELECT ");
        if(tableNames.length > 0){
            stringBuilder.push("1");
            stringBuilder.push(" FROM ");
            for(var i = 0; i < tableNames.length; i++){
                if(tableBlocks.containTableAlias(tableNames[i])){
                    stringBuilder.push(tableBlocks.getTableNameByTableAlias(tableNames[i]));
                }else{
                    stringBuilder.push(tableNames[i]);
                }
                if(i != tableNames.length - 1){
                    stringBuilder.push(",");
                }
            }
            stringBuilder.push(" WHERE ");
            //TODO ReplacePromptFunction
            stringBuilder.push(this.replacePromptFunction(expression));
            var sql = stringBuilder.join("");

            var databaseLink = new DatabaseLink();
            databaseLink.dataSourceID = this.dataSourceID;
            databaseLink.executeSQL(sql,false,function(){},function(status,errorMsg){
                result.result = false;
                result.message = status+"# "+errorMsg;
            });
        }else{
            result.result = false;
            result.message = "找不到表名。";
        }

        return result;
    }

    this.analyzePromptFunction = function(expression){
        var lexicalAnalyzer = new Analyzer();
        var obj = lexicalAnalyzer.analysis(expression);
        if(obj instanceof Error){
            return new BDAResult(false, "行：" + obj.row + "，列：" + obj.column + "# " + obj.message);
        }else if(obj instanceof Tokens){
            var prompt = "";
            var businessObjectName = "";
            var defFormat = "";
            var tokens = obj;
            var promptCount = 0;
            var offset = 0;
            for(var i = 0; i < tokens.length; i++){
                if(tokens[i].type == TokenType.Identifier && "@prompt" == tokens[i].value.toLocaleLowerCase()){
                    if(tokens.length < i + 9 ||
                        tokens[i + 1].type != TokenType.ParenthesesLeft ||
                        tokens[i + 2].type != TokenType.String ||
                        tokens[i + 3].type != TokenType.Comma ||
                        tokens[i + 4].type != TokenType.SquareBracketLeft ||
                        tokens[i + 5].type != TokenType.Identifier ||
                        tokens[i + 6].type != TokenType.SquareBracketRight ||
                        tokens[i + 7].type != TokenType.Comma ||
                        tokens[i + 8].type != TokenType.String ||
                        tokens[i + 9].type != TokenType.ParenthesesRight){
                        offset = -3;
                        if(tokens.length < i + 6 ||
                            tokens[i + 1].type != TokenType.ParenthesesLeft ||
                            tokens[i + 2].type != TokenType.String ||
                            tokens[i + 3].type != TokenType.Comma ||
                            tokens[i + 4].type != TokenType.Comma ||
                            tokens[i + 5].type != TokenType.String ||
                            tokens[i + 6].type != TokenType.ParenthesesRight){
                            return new BDAResult(false, "@prompt函数格式不正确。");
                        }
                    }
                    if(promptCount == 0){
                        var formatList = [];
                        formatList.push("");
                        formatList.push("today");
                        formatList.push("yesterday");
                        formatList.push("currentMonthFirstDay");
                        formatList.push("currentYearFirstDay");
                        formatList.push("currentWeek");
                        formatList.push("previousWeek");
                        formatList.push("currentYearFirstWeek");
                        formatList.push("currentMonth");
                        formatList.push("previousMonth");
                        formatList.push("currentYearFirstMonth");
                        formatList.push("currentQuarter");
                        formatList.push("previousQuarter");
                        formatList.push("currentYear");
                        formatList.push("previousYear");

                        prompt = trim(tokens[i + 2].value, "\'");
                        if(prompt.length = 0){
                            return new BDAResult(false, "提示语不能为空。");
                        }
                        if(offset == 0){
                            businessObjectName = tokens[i + offset + 5].value;
                            if(!this.businessObjects.existName(businessObjectName)){
                                return new BDAResult(false, "无法识别业务对象 " + businessObjectName + " 。");
                            }
                        }
                        defFormat = trim(tokens[i + offset + 8].value, "\'");
                        if(formatList.indexOf(defFormat) == -1){
                            return new BDAResult(false, "无法识别缺省值 " + defFormat + " 。");
                        }
                    }else {
                        if(prompt != trim(tokens[i + 2].value, "\'")){
                            return new BDAResult(false, "至少两个@Prompt函数的提示语不一致。");
                        }
                        if(tokens[i + offset + 5].value != businessObjectName){
                            return new BDAResult(false, "至少两个@Prompt函数的数据对象不一致。");
                        }
                        if(tokens[i + offset + 8].value != defFormat){
                            return new BDAResult(false, "至少两个@Prompt函数的默认值不一致。");
                        }
                    }
                    promptCount++;
                    i += (9 + offset);


                }
            }
        }
        return new BDAResult(true);
    }

    this.replacePromptFunction = function(expression){
        return expression.replace(/@prompt\s*\(\s*'(.*?)'\s*,\s*(\[(.*?)\])?\s*,\s*'([A-Za-z]*?)'\s*\)/gi, "'2020-01-01'");
    }
    //#endregion

    this.init = function(jObject){
        initWithObject(this, ["relationDiagramFolders", "relationDiagrams",
        "businessObjectFolders", "businessObjects", "queryTableRestrictions"],jObject);
    };
}

function RelationDiagramFolders(){
    var me = this;
    var aryRelationDiagramFolders = [];

    this.count = function(){
        return aryRelationDiagramFolders.length;
    };
    this.add = function (relationDiagramFolder) {
        aryRelationDiagramFolders.push(relationDiagramFolder);
    };
    this.clear = function(){
        aryRelationDiagramFolders = [];
    };
    this.remove = function (relationDiagramFolder) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(aryRelationDiagramFolders[i].folderID==relationDiagramFolder.folderID){
                k = i;
                break;
            }
        }
        aryRelationDiagramFolders.splice(k,1);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryRelationDiagramFolders[indexOrKey];
        }else{
            for(var i = 0; i < aryRelationDiagramFolders.length; i++){
                if(aryRelationDiagramFolders[i].folderID == indexOrKey){
                    return aryRelationDiagramFolders[i];
                }
            }
        }
    };

    this.init = function(jArray){
        initWithArray(this, RelationDiagramFolder.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryRelationDiagramFolders;
    };
}

function RelationDiagramFolder(){
    this.relationDiagramType = 0;
    this.folderID = null;
    this.folderName = null;
    this.description = null;

    this.folderParentID = null;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function RelationDiagrams(){
    var me = this;
    var aryRelationDiagrams = [];

    this.count = function(){
        return aryRelationDiagrams.length;
    };
    this.clear = function(){
        aryRelationDiagrams = [];
    };
    this.add = function (relationDiagram) {
        aryRelationDiagrams.push(relationDiagram);
    };
    this.remove = function (relationDiagram) {
        for(var i= 0, k; i < aryRelationDiagrams.length; i++){
            if(aryRelationDiagrams[i].relationDiagramID==relationDiagram.relationDiagramID){
                k = i;
                break;
            }
        }
        aryRelationDiagrams.splice(k,1);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryRelationDiagrams[indexOrKey];
        }else{
            for(var i = 0; i < aryRelationDiagrams.length; i++){
                if(aryRelationDiagrams[i].relationDiagramID == indexOrKey){
                    return aryRelationDiagrams[i];
                }
            }
        }
    };
    this.getTableBlocks = function(){
        let tableBlocks = new TableBlocks();
        for(let i = 0; i < this.count(); i++){
            for(let j = 0; j < this.item(i).tableBlocks.count(); j++){
                if(!tableBlocks.containTableAlias(this.item(i).tableBlocks.item(j).tableAlias)){
                    tableBlocks.add(this.item(i).tableBlocks.item(j));
                }
            }
        }

        return tableBlocks;
    };
    this.getTableBlockByTableAlias = function(tableAlias){
        for(let i = 0; i < this.count(); i++){
            for (let j = 0; j < this.item(i).tableBlocks.count(); j++){
                let tableBlock = this.item(i).tableBlocks.item(j);
                if (tableBlock.tableAlias == tableAlias){
                    return tableBlock;
                }
            }
        }
        return null;
    };
    this.checkTableBlocks = function(){
        let result = new BDAResult();
        result.result = true;
        let dimensionTableAliasSet = [];
        let factTableAliasSet = [];
        let dimensionDiagrams = this.getDimensionRelationDiagrams();
        let factDiagrams = this.getFactRelationDiagrams();
        for(let i = 0; i < dimensionDiagrams.count(); i++){
            for (let j = 0; j < dimensionDiagrams.item(i).tableBlocks.count(); j++){
                let tableBlock = dimensionDiagrams.item(i).tableBlocks.item(j);
                if (dimensionTableAliasSet.indexOf(tableBlock.tableAlias) == -1){
                    dimensionTableAliasSet.push(tableBlock.tableAlias);
                }else{
                    result.result = false;
                    result.message = "表 " + tableBlock.tableAlias + " 存在于两个或以上的维度表关系图中。所有在维度表关系图中的表名必须唯一。";
                    return result;
                }
            }
        }
        for(let i = 0; i < factDiagrams.count(); i++){
            for(let j = 0; j < factDiagrams.item(i).tableBlocks.count(); j++){
                let tableBlock = factDiagrams.item(i).tableBlocks.item(j);
                if(factTableAliasSet.indexOf(tableBlock.tableAlias) == -1){
                    factTableAliasSet.push(tableBlock.tableAlias);
                }else{
                    if (dimensionTableAliasSet.indexOf(tableBlock.tableAlias) == -1) {
                        result.result = false;
                        result.message = "表 " + tableBlock.tableAlias + " 存在于两个或以上的事实表关系图中，请使用别名表来解决这个问题。";
                        return result;
                    }
                }
            }
        }
        return result;
    };
    this.checkTableJoinsConsistency = function(){
        for(let i = 0; i < this.count(); i++){
            let result = this.item(i).checkJoinTypeAndCardinalityConsistency();
            if(!result.result){
                return result;
            }
        }
        return new BDAResult(true);
    };
    this.checkConnectivityAndLoop = function(){
        for(let i = 0; i < this.count(); i++){
            let result = this.item(i).checkConnectivityAndLoop();
            if(!result.result){
                return result;
            }
        }
        return new BDAResult(true);
    };
    this.checkIntersection = function(){
        let result = new BDAResult();
        result.result = true;
        let dimensionDiagrams = this.getDimensionRelationDiagrams();
        let factDiagrams = this.getFactRelationDiagrams();
        for(let i = 0; i < factDiagrams.count(); i++){
            let dragramNames = "#";
            for(let j = 0; j < factDiagrams.item(i).tableBlocks.count(); j++){
                for(let k = 0; k < dimensionDiagrams.count(); k++){
                    if (dimensionDiagrams.item(k).tableBlocks.containTableAlias(factDiagrams.item(i).tableBlocks.item(j).tableAlias)){
                        if (dragramNames.indexOf("#" + dimensionDiagrams.item(k).relationDiagramName + "#") != -1){
                            result.result = false;
                            result.message = "事实表关系图 " + factDiagrams.item(i).relationDiagramName + " 与维度表关系图 " + dimensionDiagrams.item(k).relationDiagramName + " 有两个或以上相同的表。";
                            return result;
                        }
                        dragramNames += dimensionDiagrams.item(k).relationDiagramName + "#";
                    }
                }
            }
        }
        return result;
    };
    this.containTableAlias = function (tableAlias){
        for(let i = 0; i < this.count(); i++){
            if(this.item(i).containTableAlias(tableAlias)){
                return true;
            }
        }
        return false;
    };
    this.getDefaultTableAlias = function (originalName) {
        var resultName = originalName;
        if (!this.containTableAlias(resultName)) {
            return resultName;
        } else {
            for (var i = 1; ; i++) {
                if (!this.containTableAlias(resultName + i)) {
                    return resultName + i;
                }
            }
        }
    };
    this.init = function(jArray){
        initWithArray(this, RelationDiagram.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryRelationDiagrams;
    };
    this.getDimensionRelationDiagrams = function(){
        let dimensionDiagrams = new RelationDiagrams();
        for (let i = 0; i < this.count(); i++){
            if (this.item(i).relationDiagramType == 0){
                dimensionDiagrams.add(this.item(i));
            }
        }
        return dimensionDiagrams;
    };
    this.getFactRelationDiagrams = function(){
        let factDiagrams = new RelationDiagrams();
        for (let i = 0; i < this.count(); i++) {
            if (this.item(i).relationDiagramType == 1) {
                factDiagrams.add(this.item(i));
            }
        }
        return factDiagrams;
    };
}

function RelationDiagram(){
    var me = this;

    this.relationDiagramID = null;
    this.relationDiagramName = null;

    this.folderID = null;
    this.sourceID = null;//U8的值为：d84f83f4-8290-4fec-8edc-03d4fe172dcb

    this.relationDiagramType = 0;//DimensionDiagram = 0,FactDiagram = 1
    this.tableBlocks = new TableBlocks();
    this.tableJoins = new TableJoins();
    this.width = 0;
    this.height = 0;

    
    this.checkConnectivityAndLoop = function(){
        if(this.tableBlocks.count() <= 1){
            return new BDAResult(true);
        }
        var simpleJoinList = this.getSimpleJoinList();
        var tableList = new Array();
        if(this.tableBlocks.count() != simpleJoinList.length + 1){
            var result = new BDAResult();
            result.result = false;
            if(this.tableBlocks.count < simpleJoinList.length + 1){
                result.message = "关系图 " + this.relationDiagramName + " 存在环路。"
            }else{
                result.message = "关系图 " + this.relationDiagramName + " 不是连通图。"
            }
            return result;
        }

        //记录断层连接
        var faultList = new Array();
        tableList.push(simpleJoinList[0].split('#')[0]);
        tableList.push(simpleJoinList[0].split('#')[1]);
        for(var i = 1; i < simpleJoinList.length; i++){
            var te1Name = simpleJoinList[i].split('#')[0];
            var te2Name = simpleJoinList[i].split('#')[1];
            if(tableList.indexOf(te1Name) != -1){
                if(tableList.indexOf(te2Name) != -1){
                    return new BDAResult(false, "关系图 " + this.relationDiagramName + " 存在环路。");
                }
                tableList.push(te2Name);
            }else if(tableList.indexOf(te2Name) != -1){
                tableList.push(te1Name);
            }else{
                faultList.push(simpleJoinList[i]);
            }
        }

        var count = 0;
        var maxCount = (faultList.length + 1) * faultList.length / 2;
        while(count < maxCount && faultList.length > 0){
            var index = count % faultList.length;
            var te1Name = faultList[index].split('#')[0];
            var te2Name = faultList[index].split('#')[1];
            if(tableList.indexOf(te1Name) != -1){
                tableList.push(te2Name);
                faultList.splice(index, 1);
            }else if(tableList.indexOf(te2Name) != -1){
                tableList.push(te1Name);
                faultList.splice(index, 1);
            }
            count++;
        }
        if(faultList.length > 0 || tableList.length != this.tableBlocks.count()){
            return new BDAResult(false, "关系图 " + this.relationDiagramName + " 不是连通图。");
        }
        return new BDAResult(true);
    }

    this.getSimpleJoinList = function(){
        var simpleJoinList = [];
        for(var i = 0; i < this.tableJoins.count(); i++){
            var table1Alias = this.tableJoins.item(i).table1Alias;
            var table2Alias = this.tableJoins.item(i).table2Alias;
            var simpleJoin = table1Alias > table2Alias ? table2Alias+"#"+table1Alias:table1Alias+"#"+table2Alias;
            if(simpleJoinList.indexOf(simpleJoin) == -1){
                simpleJoinList.push(simpleJoin);
            }
        }
        return simpleJoinList;
    }
    
    this.checkJoinTypeAndCardinalityConsistency = function(){
        var simpleJoinListDic = new HashTable();
        for(var i = 0; i < this.tableJoins.count(); i++){
            var table1Alias = this.tableJoins.item(i).table1Alias;
            var table2Alias = this.tableJoins.item(i).table2Alias;
            var simpleJoin = table1Alias > table2Alias ? table2Alias+"#"+table1Alias:table1Alias+"#"+table2Alias;
            if(!simpleJoinListDic.containsKey(simpleJoin)){
                simpleJoinListDic.add(simpleJoin, []);
            }
            simpleJoinListDic.getValue(simpleJoin).push(this.tableJoins.item(i));
        }
        var simpleJoinLists = simpleJoinListDic.getValues();
        for(var i = 0; i < simpleJoinLists.length; i++){
            var simpleJoinList = simpleJoinLists[i];
            if(simpleJoinList.length > 1){
                var table1Alias = simpleJoinList[0].table1Alias;
                var table2Alias = simpleJoinList[0].table2Alias;

                var joinType = simpleJoinList[0].joinType;
                var cardinality = simpleJoinList[0].cardinality;
                for(var j = 1; j < simpleJoinList.length; j++){
                    if(simpleJoinList[j].table1Alias == table1Alias){
                        if(joinType != simpleJoinList[j].joinType){
                            return new BDAResult(false, "关系图 " + this.relationDiagramName + " 中的表 " + table1Alias + " 和表 " + table2Alias + " 存在两条或以上连接类型不一致的表连接。");
                        }
                        if(cardinality != simpleJoinList[j].cardinality){
                            return new BDAResult(false, "关系图 " + this.relationDiagramName + " 中的表 " + table1Alias + " 和表 " + table2Alias + " 存在两条或以上基数不一致的表连接。");
                        }
                    }
                    else{
                        //0:InnerJoin,1:LeftOuterJoin,2:RightOuterJoin
                        if((joinType == 0 && simpleJoinList[j].joinType != 0) ||
                            (joinType == 1 && simpleJoinList[j].joinType != 2) ||
                            (joinType == 2 && simpleJoinList[j].joinType != 1)){
                                return new BDAResult(false, Message = "关系图 " + this.RelationDiagramName + " 中的表 " + table1Alias + " 和表 " + table2Alias + " 存在两条或以上连接类型不一致的表连接。");
                            }

                        //0:OneToOne,1:OneToMore,2:MoreToOne
                        if((cardinality == 0 && simpleJoinList[j].cardinality != 0) ||
                            (cardinality == 1 && simpleJoinList[j].cardinality != 2) ||
                            (cardinality == 2 && simpleJoinList[j].cardinality != 1)){
                                return new BDAResult(false, Message = "关系图 " + this.RelationDiagramName + " 中的表 " + table1Alias + " 和表 " + table2Alias + " 存在两条或以上基数不一致的表连接。");
                            }
                    }
                }
            }
        }
        return new BDAResult(true);
    }

    this.getDefaultTableAlias = function(originalName){
        var resultName = originalName;
        if(!this.tableBlocks.containTableAlias(resultName)){
            return resultName;
        }else{
            for(var i = 1; ; i++){
                if(!this.tableBlocks.containTableAlias(resultName + i)){
                    return resultName + i;
                }
            }
        }
    }

    this.containTableAlias = function(tableAlias){
        return this.tableBlocks.containTableAlias(tableAlias);
    }

    this.init = function(jObject){
        initWithObject(this, ["tableBlocks", "tableJoins"],jObject);
    };
    
}

function TableBlocks(){
    var aryTableBlocks = [];

    this.count = function(){
        return aryTableBlocks.length;
    };
    this.clear = function(){
        aryTableBlocks = [];
    };
    this.add = function (tableBlock) {
        aryTableBlocks.push(tableBlock);
    };
    this.remove = function (tableBlock) {
        for(var i= 0; i < aryTableBlocks.length; i++){
            if(aryTableBlocks[i].tableBlockID==tableBlock.tableBlockID){
                k = i;
                break;
            }
        }
        aryTableBlocks.splice(k,1);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryTableBlocks[indexOrKey];
        }else{
            for(var i = 0; i < aryTableBlocks.length; i++){
                if(aryTableBlocks[i].tableBlockID == indexOrKey){
                    return aryTableBlocks[i];
                }
            }
        }
    };


    this.containTableAlias = function(tableAlias){
        for(var i = 0; i < aryTableBlocks.length; i++){
            if(aryTableBlocks[i].tableAlias == tableAlias){
                return true;
            }
        }
        return false;
    }

    
    this.getTableBlockByAlias = function(tableAlias){
        for(var i = 0; i < aryTableBlocks.length; i++){
            if(aryTableBlocks[i].tableAlias == tableAlias){
                return aryTableBlocks[i];
            }
        }
        return null;
    }
    
    this.getTableNameByTableAlias = function(tableAlias){
        for(var i = 0; i < aryTableBlocks.length; i++){
            if(aryTableBlocks[i].tableAlias == tableAlias){
                return aryTableBlocks[i].table.tableName;
            }
        }
        return "";
    }

    this.init = function(jArray){
        initWithArray(this, TableBlock.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTableBlocks;
    };
}

function TableBlock(){
    this.tableBlockID = null;
    this.table = new Table();
    this.tableAlias = null;
    this.x = 0;
    this.y = 0;
    this.width = 0;
    this.height = 0;
    this.fieldSort = 0;//Default = 0,Asc = 1,Desc = 2
    
    this.init = function(jObject){
        initWithObject(this, ["table"],jObject);
    };
}

function TableJoins(){
    var me = this;
    var aryTableJoins = [];

    this.count = function(){
        return aryTableJoins.length;
    };
    this.clear = function(){
        aryTableJoins = [];
    };
    this.add = function (tableJoin) {
        aryTableJoins.push(tableJoin);
    };
    this.remove = function (tableJoin) {
        var k = -1;
        for(var i= 0;i<aryTableJoins.length;i++){
            if(aryTableJoins[i].tableJoinID==tableJoin.tableJoinID){
                k = i;
                break;
            }
        }
        aryTableJoins.splice(k,1);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryTableJoins[indexOrKey];
        }else{
            for(var i = 0; i < aryTableJoins.length; i++){
                if(aryTableJoins[i].tableJoinID == indexOrKey){
                    return aryTableJoins[i];
                }
            }
        }
    };

    this.init = function(jArray){
        initWithArray(this, TableJoin.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTableJoins;
    };
}

function TableJoin(){
    var me = this;

    this.tableJoinID = null;
    this.table1Alias = null;
    this.table1Field1 = null;
    this.table1Field2 = null;
    this.table2Alias = null;
    this.table2Field1 = null;
    this.table2Field2 = null;
    this.operator = null;
    this.joinType = 0;//InnerJoin = 0, LeftOuterJoin = 1, RightOuterJoin = 2
    this.cardinality = 0;// OneToOne = 0, OneToMore = 1, MoreToOne = 2, MoreToMore = 3
    this.expression = "";

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}

function QueryTableRestrictions(){
    var me = this;
    var aryQueryTableRestrictions = [];

    this.count = function(){
        return aryQueryTableRestrictions.length;
    };
    this.clear = function(){
        aryQueryTableRestrictions = [];
    };
    this.add = function (queryTableRestriction) {
        aryQueryTableRestrictions.push(queryTableRestriction);
    };
    this.remove = function (queryTableRestriction) {
        for(var i= 0;i<aryQueryTableRestrictions.length;i++){
            if(aryQueryTableRestrictions[i]==queryTableRestriction){
                k = i;
                break;
            }
        }
        aryQueryTableRestrictions.splice(k,1);
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryQueryTableRestrictions[indexOrKey];
        }
    };

    this.init = function(jArray){
        initWithArray(this, QueryTableRestriction.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryQueryTableRestrictions;
    };
}

function QueryTableRestriction(){
    this.tableAlias = null;
    this.whereClause = null;

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function TableModels(){
    var me = this;
    var aryTableModels = [];

    this.count = function(){
        return aryTableModels.length;
    };
    this.clear = function(){
        aryTableModels = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryTableModels[indexOrKey];
        }else{
            for(var i = 0; i < aryTableModels.length; i++){
                if(aryTableModels[i].businessModelID == indexOrKey){
                    return aryTableModels[i];
                }
            }
        }
    };
    this.add = function (tableModel) {
        aryTableModels.push(tableModel);
    };
    this.remove = function (tableModel) {
        for(var i = 0; i < aryTableModels.length; i++){
            if(aryTableModels[i].businessModelID==tableModel.businessModelID){
                k = i;
                break;
            }
        }
        aryTableModels.splice(k,1);
    };
    this.addItem = function(tableModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.tableModelPath;
        var obj = JSON.stringify(tableModel);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var businessModelID = request.getResponseHeader('location').split('/tableModels/')[1];
                tableModel.businessModelID = businessModelID;
                tableModel.initByModelID(asyncOrSync,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(tableModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.tableModelPath + "/" + tableModel.businessModelID;
        var obj = JSON.stringify(tableModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                tableModel.initByModelID(tableModel.businessModelID,true,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(businessModelID,moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.tableModelPath + "/" + businessModelID + "?moduleID=" + moduleID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(businessModelID))
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID=" + moduleID + "&businessModelType=1";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getModelByName = function(modelName){
        for(var i = 0; i < aryTableModels.length; i++){
            if(aryTableModels[i].businessModelName == modelName){
                return aryTableModels[i];
            }
        }
        return null;
    };

    this.init = function(jArray){
        initWithArray(this, TableModel.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryTableModels;
    };
}
function TableModel(){
    var me = this;
    BusinessModel.call(this);
    this.tableName = null;
    this.businessObjects = new BusinessObjects();

    this.initByModelID = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.tableModelPath + "/" + businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jObject){
        initWithObject(this, ["businessObjects"],jObject);
    };
}

function SqlModels(){
    var me = this;
    var arySqlModels = [];

    this.count = function(){
        return arySqlModels.length;
    };
    this.clear = function(){
        arySqlModels = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return arySqlModels[indexOrKey];
        }else{
            for(var i = 0; i < arySqlModels.length; i++){
                if(arySqlModels[i].businessModelID == indexOrKey){
                    return arySqlModels[i];
                }
            }
        }
    };
    this.add = function (sqlModel) {
        arySqlModels.push(sqlModel);
    };
    this.remove = function (sqlModel) {
        for(var i = 0; i < arySqlModels.length; i++){
            if(arySqlModels[i].businessModelID==sqlModel.businessModelID){
                k = i;
                break;
            }
        }
        arySqlModels.splice(k,1);
    };
    this.addItem = function(sqlModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.sqlModelPath;
        var obj = JSON.stringify(sqlModel);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var businessModelID = request.getResponseHeader('location').split('/sqlModels/')[1];
                sqlModel.businessModelID = businessModelID;
                sqlModel.initByModelID(asyncOrSync,succ,fail);

            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(sqlModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.sqlModelPath + "/" + sqlModel.businessModelID;
        var obj = JSON.stringify(sqlModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                sqlModel.initByModelID(sqlModel.businessModelID,true,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(businessModelID,moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.sqlModelPath + "/" + businessModelID + "?moduleID=" + moduleID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(businessModelID));
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID=" + moduleID + "&businessModelType=2";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getModelByName = function(modelName){
        for(var i = 0; i < arySqlModels.length; i++){
            if(arySqlModels[i].businessModelName == modelName){
                return arySqlModels[i];
            }
        }
        return null;
    };
    
    this.init = function(jArray){
        initWithArray(this, SqlModel.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return arySqlModels;
    };
}

function SqlModel(){
    var me = this;
    BusinessModel.call(this);
    this.sqlText = null;
    this.businessObjects = new BusinessObjects();

    this.initByModelID = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.sqlModelPath + "/" + businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jObject){
        initWithObject(this, ["businessObjects"],jObject);
    };
}


function ExcelModels(){
    var me = this;
    var aryExcelModels = [];

    this.count = function(){
        return aryExcelModels.length;
    };
    this.clear = function(){
        aryExcelModels = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryExcelModels[indexOrKey];
        }else{
            for(var i = 0; i < aryExcelModels.length; i++){
                if(aryExcelModels[i].businessModelID == indexOrKey){
                    return aryExcelModels[i];
                }
            }
        }
    };
    this.add = function (excelModel) {
        aryExcelModels.push(excelModel);
    };
    this.remove = function (excelModel) {
        for(var i = 0; i < aryExcelModels.length; i++){
            if(aryExcelModels[i].businessModelID==excelModel.businessModelID){
                k = i;
                break;
            }
        }
        aryExcelModels.splice(k,1);
    };
    this.addItem = function(excelModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelModelPath;
        var obj = JSON.stringify(excelModel);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var businessModelID = request.getResponseHeader('location').split('/excelModels/')[1];
                excelModel.businessModelID = businessModelID;
                excelModel.initByModelID(asyncOrSync,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(excelModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelModelPath + "/" + excelModel.businessModelID;
        var obj = JSON.stringify(excelModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                excelModel.initByModelID(excelModel.businessModelID,true,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(businessModelID,moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelModelPath + "/" + businessModelID + "?moduleID=" + moduleID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(businessModelID))
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID=" + moduleID + "&businessModelType=3";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    
    this.getModelByName = function(modelName){
        for(var i = 0; i < aryExcelModels.length; i++){
            if(aryExcelModels[i].businessModelName == modelName){
                return aryExcelModels[i];
            }
        }
        return null;
    };

    this.init = function(jArray){
        initWithArray(this, ExcelModel.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryExcelModels;
    };
}
function ExcelModel(){
    var me = this;
    BusinessModel.call(this);
    this.excelFileName = null;
    this.businessObjects = new BusinessObjects();

    this.initByModelID = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelModelPath + "/" + businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jObject){
        initWithObject(this, ["businessObjects"],jObject);
    };
}