function SystemSettings(){
	var me = this;
    var arySystemSettings = [];
    
    this.count = function(){
        return arySystemSettings.length;
    };
    this.clear = function(){
        arySystemSettings = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return arySystemSettings[indexOrKey];
        }else{
            for(var i = 0; i < arySystemSettings.length; i++){
                if(arySystemSettings[i]["systemSettingKey"] == indexOrKey){
                    return arySystemSettings[i]["systemSettingValue"];
                }
            }
        }
    };
    this.add = function (systemSetting) {
        arySystemSettings.push(systemSetting);
    };
    this.remove = function (systemSetting) {
        for(var i = 0; i < arySystemSettings.length; i++){
            if(arySystemSettings[i].systemSettingKey==systemSetting.systemSettingKey){
                k = i;
                break;
            }
        }
        arySystemSettings.splice(k,1);
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.systemSettingsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.update = function(systemSettings,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.systemSettingsPath;
        var obj = JSON.stringify(systemSettings);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jArray){
        initWithArray(this, SystemSetting.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryReportFolders;
    }
}
function SystemSetting(){
    this.systemSettingKey = null;
    this.systemSettingValue = null;

    
    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };
}


function BDAFiles(){
    var me = this;
    var aryFiles = [];

    this.count = function(){
        return aryFiles.length;
    };
    this.clear = function(){
        aryFiles = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryFiles[indexOrKey];
        }else{
            for(var i = 0; i < aryFiles.length; i++){
                if(aryFiles[i].id == indexOrKey){
                    return aryFiles[i];
                }
            }
        }
    };
    this.add = function (bdaFile) {
        aryFiles.push(bdaFile);
    };
    this.remove = function (bdaFile) {
        for(var i = 0; i < aryFiles.length; i++){
            if(aryFiles[i].id==bdaFile.id){
                k = i;
                break;
            }
        }
        aryFiles.splice(k,1);
    };
    
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/customFiles";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getBDAFileByName = function(fileName, folderID){
        for(var i = 0; i < aryFiles.length; i++){
            if(aryFiles[i].fileName == fileName && aryFiles[i].folderID == folderID){
                return aryFiles[i];
            }
        }
        return null;
    };
    this.init = function(jArray){
        initWithArray(this, BDAFile.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryFiles;
    };
}

function BDAFile(){
    var me = this;
    this.id = null;
    this.fileName = null;
    this.folderID = null;
    this.fileType = 0;//Folder = 0,File = 1
  

    this.uploadResource = function(resource,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/customFiles";
        var obj = resource;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };

}

function BDAResources(){
    var me = this;
    var aryResources = [];

    this.count = function(){
        return aryResources.length;
    };
    this.clear = function(){
        aryResources = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryResources[indexOrKey];
        }else{
            for(var i = 0; i < aryResources.length; i++){
                if(aryResources[i].id == indexOrKey){
                    return aryResources[i];
                }
            }
        }
    };
    this.add = function (bdaResource) {
        aryResources.push(bdaResource);
    };
    this.remove = function (bdaResource) {
        for(var i = 0; i < aryResources.length; i++){
            if(aryResources[i].id==bdaResource.id){
                k = i;
                break;
            }
        }
        aryResources.splice(k,1);
    };
    
    this.getBDAFileByName = function(resourceName){
        for(var i = 0; i < aryResources.length; i++){
            if(aryResources[i].fileName == resourceName){
                return aryResources[i];
            }
        }
        return null;
    };
    this.init = function(jArray){
        initWithArray(this, BDAResource.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryResources;
    };
}
function BDAResource(){
    var me = this;
    this.id = null;
    this.name = null;
    this.path = null;

    this.uploadResource = function(resource,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/customFiles";
        var obj = resource;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.downloadResource = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/resource/report/custom" + this.path;
        var obj = {};
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data);
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(jObject){
        initWithObject(this, [],jObject);
    };

}

function BDAPackages(){
	var me = this;
    var aryFiles = [];

    this.count = function(){
        return aryFiles.length;
    };
    this.clear = function(){
        aryFiles = [];
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return aryFiles[indexOrKey];
        }else{
            for(var i = 0; i < aryFiles.length; i++){
                if(aryFiles[i].folderID == indexOrKey){
                    return aryFiles[i];
                }
            }
        }
    };
    this.add = function (bdaFile) {
        aryFiles.push(bdaFile);
    };
    this.remove = function (bdaFile) {
        for(var i = 0; i < aryFiles.length; i++){
            if(aryFiles[i].id==bdaFile.id){
                k = i;
                break;
            }
        }
        aryFiles.splice(k,1);
    };
    this.getCloudItems = function(basrPath,asyncOrSync,succ,fail){
        var url = basrPath + "/packages";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    

    this.init = function(jArray){
        initWithArray(this, BDAFile.prototype.constructor, jArray);
    };
    this.toJSON = function(){
        return aryFiles;
    }
}
