/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-23 09:56:56
 * @LastEditTime: 2020-11-03 17:42:05
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, form = layui.form, layer = layui.layer;
    var userNameType = $(".progress-bar").attr("data-ID");
    var user = new User();
    var users = new Users();
    var mMobileNumber = new MobileNumber();
    var mEmailAddress = new EmailAddress();
    var logins = new Logins();
    var countdown = 60;
    var timer = null;
    var verificationCode = null;
    var countDate = 6;

    initMain();

    function initMain(){
        $Utils.loading.close();
        $(".ui-dialog-close,.protocol-button a").click(function(){
            window.location = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/html/login/login.html";
        });
        
        $(".protocol-button button").click(function(){
            $(".ui-dialog,.ui-mask").hide();
        });

        $("input").focus(function(){
            $(this).parent("div").css("border-color","#999");
        });
        
        $("input").blur(function(){
            $(this).parent("div").css("border-color","#ddd");
        });

        initUserNameStep();
    }

    function initUserNameStep(){
        $("#getPhoneCode").hover(function(){
            $(this).css("border-left","1px solid #666");
            $(".phonecode-left").css("border-right",0);
        },function(){
            $(this).css("border-left",0);
            $(".phonecode-left").css("border-right","1px solid #ddd");
        });
        
        $("#phone-number").blur(function(){
            var inputValue = $.trim($(this).val());
            if(!inputValue){
                $(".phone-num").html("");
            }else{
                if(userNameType == 1){
                    if(inputValue.indexOf("@") == -1){
                        $(".phone-num").html("格式错误！").css("color","rgb(255,153,17)");
                        return;
                    }
                }
            }
        });
        
        $("#phone-number").bind("input porpertychange",function(){ 
            if($(this).val()==""){
                $(".phone-num").html("");
                $(".item-getcode-wrap").show();
                $(".item-phonecode-wrap").hide();
            }
        });

        $(".item-getcode-wrap").on("click",".close-validate",function(){
            $(".validate-box").hide();
        });

        bindSlideBarEvent();
        bindReacquireCodeButtonEvent();
        bindUserTypeChangeButtonEvent();

        $("#step1-next").click(function(){
            if(verificationCode){
                if(validateStepOneNext()){
                    showStepTwo();
                }
            }else{
                if(!$("#phone-number").val()){
                    if(userNameType==0){
                        $(".phone-num").html("请输入手机号码。").css("color","rgb(255,153,17)");
                    }else if(userNameType==1){
                        $(".phone-num").html("请输入邮箱。").css("color","rgb(255,153,17)");
                    }
                }else{
                    $(".phone-num").html("请完成验证。").css("color","rgb(255,153,17)");
                }
            }
        });
    }

    function bindSlideBarEvent(){
        clickShowSlideBarEvent();
        slideBarChangeEvent();
    }

    function clickShowSlideBarEvent(){
        $("#phone-validate").click(function(){
            $(".item-phonecode-wrap").hide();
            $(".validate-box").html("");
            var str = "<h2>滑动滑块，完成验证<span class='close-validate'><i class='iconfont icon-shanchu'></i></span></h2><div id='slide_box'><div id='slide_xbox'><div id='btn'>&gt;&gt;</div></div>请按住滑块，拖动到最右边</div><a class='arrow'></a>";
            $(".validate-box").html(str);
            
            if(userNameType == 0){
                if(!$.trim($("#phone-number").val())){
                    $(".phone-num").html("请输入手机号码！").css("color","rgb(255,153,17)");
                    return;
                }else{
                    user.userName = $.trim($("#phone-number").val());
                    user.mobileNumber = $.trim($("#phone-number").val());
                }
            }else if(userNameType ==1){
                if(!$.trim($("#phone-number").val())){
                    $(".phone-num").html("请输入邮箱！").css("color","rgb(255,153,17)");
                    return;
                }else{
                    if($.trim($("#phone-number").val()).indexOf("@") == -1){
                        $(".phone-num").html("格式错误！").css("color","rgb(255,153,17)");
                        return;
                    }else{
                        user.userName = $.trim($("#phone-number").val());
                        user.emailAddress = $.trim($("#phone-number").val());
                    }
                }
            }
            $(".phone-num").html("");
            $(".validate-box").show();
            $Utils.slide();
        });
    }

    function slideBarChangeEvent(){
        $("#validate-hidden").change(function(){ 
            if($(this).val()==1){
                $(".validate-box").hide();
                checkExistenceAndShowOTP(user.userName);
            }
        });
    }

    function checkExistenceAndShowOTP(){
		var succ = function(status){
			if(status==404){
                showOTP();
                getAndshowOTP();
                showReacquireCode();
			}else{
                if(userNameType == 0){
                    $(".phone-num").html("手机号码已注册。").css("color","rgb(255,153,17)");
                }else{
                    $(".phone-num").html("邮箱已注册。").css("color","rgb(255,153,17)");
                }
			}
		};
		var fail = function(errorStatus,msg){
            $Utils.openWindow.failWindow("核查账号是否注册",errorStatus,msg);
        };
		if(userNameType == 0){
			mMobileNumber.validate(user.userName,true,succ,fail);
		}else{
			mEmailAddress.validate(user.userName,true,succ,fail);
		}
	}

    function showOTP(){
        $(".item-getcode-wrap").hide();
        $(".phone-code").html("");
        $(".item-phonecode-wrap").show();
    }

    function getAndshowOTP(){
        var succ = function(data){
            verificationCode = data;
        };
        var fail = function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取验证码",errorStatus,msg);
        };
        if(userNameType == 0){
			mMobileNumber.getOTP(user.userName,true,succ,fail);
		}else{
			mEmailAddress.getOTP(user.userName,true,succ,fail);
		}
    }

    function showReacquireCode(){
        countdown = 60;
        clearTimeout(timer);
        settime($("#getPhoneCode"));
    }

    function settime(elem) { //发送验证码倒计时
	    if (countdown == 0) { 
	        elem.attr("disabled",false); 
	        elem.removeClass("btn-code-disable");
	        elem.html("重新获取");
	        countdown = 60; 
	        return;
	    } else { 
	        elem.attr("disabled",true);
	        elem.addClass("btn-code-disable");
	        elem.html(countdown + "s后重新发送");
	        countdown--; 
	    } 
		timer = setTimeout(function() { 
		    settime(elem) 
		},1000)
    }
    
    function bindReacquireCodeButtonEvent(){
        $("#getPhoneCode").click(function(){
            if(!$(this).attr("disabled") && (user.userName == $("#phone-number").val())){
                getAndshowOTP();
                showReacquireCode();
                $("#getPhoneCode").css("border-left","1px solid #ddd");
            }else if(user.userName != $("#phone-number").val()){
                $(".item-getcode-wrap").show();
                $(".item-phonecode-wrap").hide();
                if(userNameType == 0){
                    $(".phone-num").html("号码不一致，请重新验证！").css("color","rgb(255,153,17)");
                }else if(userNameType == 1){
                    $(".phone-num").html("邮箱不一致，请重新验证！").css("color","rgb(255,153,17)");
                }
            }
        });
    }
    
    function bindUserTypeChangeButtonEvent(){
        $(".switch-register a").click(function(){
            againInit();
            if(userNameType == 0){
                setMobileNumberMessage(this);
            }else if(userNameType == 1){
                setEmailAddressMessage(this);
            }
        });
    }

    function againInit(){
        $("input").val("");
        user = new User();
        verificationCode = null;
        countdown = 60;
        timer = null;
        userNameType = ((userNameType == 1) ? 0 : 1);
        
        $(".item-getcode-wrap").show();
        $(".pro-line1,.pro-line2").removeClass("cur-line");
        $(".pro-step2,.pro-step3").removeClass("cur-step");
        $("#step2-wrap,#step3-wrap").css("display","none");
        $("#step1-wrap").css("display","block");
        $(".item-phonecode-wrap").hide();
    }

    function setMobileNumberMessage(elem){
        $(".progress-bar").attr("data-ID",0);
		$(".top span").html("欢迎注册");
		$(".pro-step1 p").html("验证手机号");
		$(".i-def").html("");
		document.getElementById("phone-number").setAttribute("placeholder", "建议使用常用手机号");
		document.getElementById("phone-number").setAttribute("type", "tel");
		document.getElementById("phone-number").setAttribute("maxlength", 16);
		$(".item-phonecode-wrap .phonecode-left label").html("手机验证码");
		$(".progress-bar .person-pro-step2").css("margin-left","107px");
		$(".input-tip span").html("");
		$(elem).html("邮箱注册");
    }

    function setEmailAddressMessage(elem){
		$(".progress-bar").attr("data-ID",1);
		$(".top span").html("邮箱注册");
		$(".pro-step1 p").html("验证邮箱");
		$(".i-def").html("");
		document.getElementById("phone-number").setAttribute("placeholder","建议使用常用邮箱");
		document.getElementById("phone-number").setAttribute("type","email");
		document.getElementById("phone-number").setAttribute("maxlength",32);
		$(".item-phonecode-wrap .phonecode-left label").html("邮箱验证码");
		$(".progress-bar .person-pro-step2").css("margin-left","120px");
		$(".input-tip span").html("");
		$(elem).html("手机注册");
    }

    function validateStepOneNext(){
        if(!$("#phone-number").val()){
            $(".item-getcode-wrap").show();
            $(".item-phonecode-wrap").hide();
            if(userNameType == 0){
                $(".phone-num").html("请输入手机号码。").css("color","rgb(255,153,17)");
            }else if(userNameType == 1){
                $(".phone-num").html("请输入邮箱。").css("color","rgb(255,153,17)");
            }
            return false;
        }else if(user.userName != $("#phone-number").val()){
            $(".item-getcode-wrap").show();
            $(".item-phonecode-wrap").hide();
            $(".phone-num").html("当前账号与接收验证码账号不一致，请重新验证。").css("color","rgb(255,153,17)");
            return false;
        }else if($("#phoneCode").val() == ""){
            $(".phone-code").html("请输入验证码！").css("color","rgb(255,153,17)");
            return false;
        }else if(verificationCode != $("#phoneCode").val()){
            $(".phone-code").html("验证码不正确！").css("color","rgb(255,153,17)");
            return false;
        }else if(verificationCode == $("#phoneCode").val()){
            return true;
        }
    }

    function showStepTwo(){
        $("#step1-wrap").hide();
        $("#step2-wrap").show();
        $(".pro-line1").addClass("cur-line");
        $(".pro-step2").addClass("cur-step");

        $("#form-register").click(function(){
            $(".input-tip span").html("");            
            if(validateMessage()){
                $Utils.loading.open();
                if(userNameType == 0){
                    user.fullName = $.trim($("#form-account").val());
                    user.password = $("#form-pwd").val();
                    user.registerMethod = "0";
                    user.emailAddress = "";
                }else if(userNameType == 1){
                    user.fullName = $.trim($("#form-account").val());
                    user.password = $("#form-pwd").val();
                    user.mobileNumber = "";
                    user.registerMethod = "1";
                }                
                subRegister();
                $(".input-tip span").html("");
            }
            
        });
    }

    function validateMessage(){
        var fullName = $.trim($("#form-account").val());
        var password = $("#form-pwd").val();
        var confirmPassword = $("#form-equalTopwd").val();
		if(fullName == ""){
			$(".tip-full-name span").html("全名不能为空。").css("color","rgb(255,153,17)");
			return false;
		}
		if(password == ""){
			$(".tip-password span").html("密码不能为空。").css("color","rgb(255,153,17)");
			return false;
		}
		if(password.indexOf(" ") != -1){
			$(".tip-password span").html("密码不能包含空格。").css("color","rgb(255,153,17)");
			return false;
		}
		if(confirmPassword==""){
			$(".tip-confirm-password span").html("确认密码不能为空。").css("color","rgb(255,153,17)");
			return false;
		}
		if(confirmPassword != password){
			$(".tip-confirm-password span").html("两次输入的密码不一致。").css("color","rgb(255,153,17)");
			return false;
		}
		
		return true;
    }

    function subRegister(){
		var succ = function(){
            $Utils.loading.close();
			layer.msg("恭喜您成功注册云智算公有云平台，现在您可以开启迄今为止移动功能最强的数据探索之旅。",{icon:1});
			showRegister();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("注册",errorStatus,msg);
		};
		users.addItemByOTP(user,verificationCode,true,succ,fail);
    }
    
    function showRegister(){
		$(".pro-step3").addClass("cur-step");
		$(".pro-line2").addClass("cur-line");
		$(".switch-register").hide();
		$("#step2-wrap").hide();
		$("#step3-wrap").show();
		countDown();
    }
    
    function countDown(){
		if (countDate == 0) { 
			actionPost();
	    } else { 
	        $("#step3-wrap span").html(countDate);
	        countDate--; 
	    } 
		setTimeout(function() { 
		    countDown() 
		},1000)
    }

    function decrypt(word){
        var key = CryptoJS.enc.Utf8.parse("qwertyui87654321");
        var decrypt = CryptoJS.AES.decrypt(word, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
        return CryptoJS.enc.Utf8.stringify(decrypt).toString();
    }

    function encrypt(word){
        var key = CryptoJS.enc.Utf8.parse("qwertyui87654321");
        var srcs = CryptoJS.enc.Utf8.parse(word);
        var encrypted = CryptoJS.AES.encrypt(srcs, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
        return encrypted.toString();
    }
    
    function actionPost(){
        var succ = function(data){
			locationURL(data)
		};
		var fail = function(errorStatus,msg){
			$Utils.openWindow.failWindow("登录",errorStatus,msg);
        };
        var login = {};
        login.userName = user.userName;
        login.password = encrypt(user.password);
        login.deviceTypeID = $AppVars.deviceTypeID;
		login.osID = $AppVars.osID;
		logins.addItem(login,true,succ,fail);
    }

    function locationURL(loginID){
		$Utils.cookie.addCookie(window.location.host+"-loginID",loginID);
		if(document.cookie == ""){
			var str = "浏览器阻止了cookie，请设置浏览器允许cookie。"
			$Utils.openWindow.failWindow(str);
		}else{
			window.location.href = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/index.html";	
		}
    }
    
    $Utils.capitalTip("form-pwd");
	$Utils.capitalTip("form-equalTopwd");
    
}();