/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-03-19 09:44:29
 * @LastEditTime: 2021-04-16 14:24:05
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, form = layui.form, layer = layui.layer, table = layui.table;
    var show_num = [];
    var logins = new Logins();
    var organizations = new Organizations();
    var server = new Server();
    var showCode = true;
    var storage = window.sessionStorage;
    var os = function () {
        var ua = navigator.userAgent,
            isWindowsPhone = /(?:Windows Phone)/.test(ua),
            isSymbian = /(?:SymbianOS)/.test(ua) || isWindowsPhone,
            isAndroid = /(?:Android)/.test(ua),
            isFireFox = /(?:Firefox)/.test(ua),
            isChrome = /(?:Chrome|CriOS)/.test(ua),
            isTablet = /(?:iPad|PlayBook)/.test(ua) || (isAndroid && !/(?:Mobile)/.test(ua)) || (isFireFox && /(?:Tablet)/.test(ua)),
            isPhone = /(?:iPhone)/.test(ua) && !isTablet,
            isPc = !isPhone && !isAndroid && !isSymbian;
        return {
            isTablet: isTablet,
            isPhone: isPhone,
            isAndroid: isAndroid,
            isPc: isPc
        };
    }();
    if (!os.isPc) {
        $(".left-box").remove();
    }
    storage.removeItem(window.location.host+"-openClient");

    getServer();

    function decrypt(word){
        var key = CryptoJS.enc.Utf8.parse("qwertyui87654321");
        var decrypt = CryptoJS.AES.decrypt(word, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
        return CryptoJS.enc.Utf8.stringify(decrypt).toString();
    }

    function encrypt(word){
        var key = CryptoJS.enc.Utf8.parse("qwertyui87654321");
        var srcs = CryptoJS.enc.Utf8.parse(word);
        var encrypted = CryptoJS.AES.encrypt(srcs, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
        return encrypted.toString();
    }

    function getServer(){
        var succ = function () {
            $Utils.loading.close();
            if (server.edition == 1) {
                $(".change-organization").remove();
                $(".user-operation").remove();
                $(".canvas-code").remove();
                showCode = false;
            }
            if (server.edition == 2) {
                $(".user-operation").remove();
                $(".canvas-code").remove();
                showCode = false;
            }
            if (server.edition == 3 || server.edition == 4) {
                $(".remember-password").remove();
            }

            if (server.ssoStatus) {
                $(".change-organization").remove();
                $(".user-operation").remove();
            }

            $(".layui-form .layui-form-item:last-child").css("margin-bottom", 0);

            if (location.href.indexOf("token=") != -1 && location.href.indexOf("userName=") != -1 && location.href.indexOf("ssoLogin=") != -1) {
                if ((location.href.split("ssoLogin=")[1]).split("&")[0] == 1) {
                    ssoLogin((location.href.split("token=")[1]).split("&")[0], (location.href.split("userName=")[1]).split("&")[0]);
                } else {
                    initPage();
                }
            } else {
                initPage();
            }
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $(".change-organization").remove();
            $(".user-operation").remove();
            $(".canvas-code").remove();
            showCode = false;
            $(".layui-form .layui-form-item:last-child").css("margin-bottom", 0);
            initPage();
        };
        server.getItem(true,succ,fail);
    }

    function initPage(){
        $(".form-box,#particles").removeAttr("style");
        if(showCode){
            $Utils.drawCode(show_num);

            $("#canvas").click(function(){
                $Utils.drawCode(show_num);
            });
        }

        form.on("submit(loginSubmit)",function(obj){
            if(validataCode(obj.field.code)){
                loginByUserName(obj);
            }
            return false;
        });

        if($Utils.cookie.getCookie(window.location.host+"-rememberName") && $Utils.cookie.getCookie(window.location.host+"-rememberWord")){
            form.val("loginForm",{
                userName: $Utils.cookie.getCookie(window.location.host+"-rememberName"),
                password: decrypt($Utils.cookie.getCookie(window.location.host+"-rememberWord")),
                rememberPassword: 1
            });
        }

        $(".change-organization").click(function(){
            var formData = form.val("loginForm");
            if (formData.userName == "") {
                layer.msg("用户名不能为空。", { icon: 2 });
                $(".login input[name=userName]").focus();
                return false;
            }
            if (formData.password == "") {
                layer.msg("密码不能为空。", { icon: 2 });
                $(".login input[name=password]").focus();
                return false;
            }
            // loadOrganizations();
            getAndLoadOrganizations(formData);
        });
    }

    function getAndLoadOrganizations(formData) {
        $Utils.loading.open();
        var succ = function (data) {
            $Utils.loading.close();
            loadOrganizations(formData, data);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取用户所属组织", errorStatus, msg);
        };
        organizations.getItemsByUserName(formData.userName, encrypt(formData.password), true, succ, fail);
    }

    function loadOrganizations(formData, defaultOrganizationID){
        layer.open({
            type: 1,
            title: ["切换登录组织", "font-size: 14px"],
            btn: ["确定","取消"],
            resize: false,
            skin: "login-organization",
            area: ["560px", "420px"],
            content: '<table class="layui-hide" id="organizationList" lay-filter="organizationList"></table>',
            success: function(){
                loadOrganizationTable(defaultOrganizationID);
            },
            yes: function (index, layero) {
                if (table.checkStatus('organizationList').data.length){
                    $Utils.loading.open();
                    var organizationID = table.checkStatus('organizationList').data[0].organizationID
                    var succ = function () {
                        $Utils.loading.close();
                        layer.close(index);
                        layer.msg("切换成功。",{icon:1});
                    };
                    var fail = function (errorStatus, msg) {
                        $Utils.loading.close();
                        $Utils.openWindow.failWindow("修改用户登录组织", errorStatus, msg);
                    };
                    var userObj = {
                        userName: formData.userName,
                        password: encrypt(formData.password)
                    };
                    organizations.editDefaultOrganizationByUserName(userObj, organizationID, true, succ, fail);
                } else {
                    layer.close(index);
                }
            }
        });
    }

    function loadOrganizationTable(defaultOrganizationID){
        var tableHead = [
            [
                { type: "radio" },
                { field: "organizationCode", title: "组织编码"},
                { field: "organizationName", title: "组织名称"}
            ]
        ];
        var tableBody = [];
        for(var i = 0; i < organizations.count; i++){
            var obj = organizations.item(i);
            if(obj.organizationID == defaultOrganizationID){
                obj.LAY_CHECKED = true;
            }
            tableBody.push(obj);
        }
        table.render({
            elem: '#organizationList',
            height: 300,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: tableBody,
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: tableBody.length
        });
    }

    function ssoLogin(token,userName){
        var succ = function(data){
            $Utils.loading.close();
            locationURL(data,1);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            if(errorStatus == 403){
                layer.open({
                    type: 0,
                    title: "登录",
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window login-certificate",
                    content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+errorStatus+'# '+msg+"<br><br><a href='http://sales.yunzhisuan.com/salesweb' target='_blank'>安装证书</a><br><a href='"+$AppConstants.webHostName+$AppConstants.webPort+$AppConstants.projectName+"/html/hardwareInfo/hardwareInfo.html' target='_blank'>获取服务器标识</a></div></div>",
                    btn: ["确定"],
                    success: function(layero,index){
                        initPage();
                    }
                });
            }else{
                $Utils.openWindow.failWindow("登录",errorStatus,msg);
                initPage();
            }
        };
        var tempObj = {};
        tempObj.userName = userName;
        tempObj.token = token;
		tempObj.deviceTypeID = $AppVars.deviceTypeID;
		tempObj.osID = $AppVars.osID;
        logins.addItemBySso(tempObj,true,succ,fail);
    }

    function validataCode(code){
        if(showCode){
            if(code.toUpperCase() != show_num.join("").toUpperCase()){
                layer.msg("验证码不正确！",{icon:2});
                $Utils.drawCode(show_num);
                return false;
            }
        }
        return true;
    }

    function loginByUserName(obj){
        var tempObj = {};
        tempObj.userName = obj.field.userName;
        tempObj.password = encrypt(obj.field.password);
		tempObj.deviceTypeID = $AppVars.deviceTypeID;
		tempObj.osID = $AppVars.osID;
        var succ = function(data){
            $Utils.loading.close();
            var formData = form.val("loginForm");
            if(formData.rememberPassword){
                $Utils.cookie.addCookie(window.location.host+"-rememberName",tempObj.userName,30);
                $Utils.cookie.addCookie(window.location.host+"-rememberWord",tempObj.password,30);
            }else{
                $Utils.cookie.deleteCookie(window.location.host+"-rememberName");
                $Utils.cookie.deleteCookie(window.location.host+"-rememberWord");
            }
            locationURL(data,0);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            if(errorStatus == 403){
                layer.open({
                    type: 0,
                    title: "登录",
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window login-certificate",
                    content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+errorStatus+'# '+msg+"<br><br><a href='http://sales.yunzhisuan.com/salesweb' target='_blank'>安装证书</a><br><a href='"+$AppConstants.webHostName+$AppConstants.webPort+$AppConstants.projectName+"/html/hardwareInfo/hardwareInfo.html' target='_blank'>获取服务器标识</a></div></div>",
                    btn: ["确定"],
                    success: function(layero,index){}
                });
            }else{
                $Utils.openWindow.failWindow("登录",errorStatus,msg);
                if(showCode){
                    $Utils.drawCode(show_num);
                }
            }
        };
        logins.addItem(tempObj,true,succ,fail);
    }

    function locationURL(loginID,isSso){
		$Utils.cookie.addCookie(window.location.host+"-loginID",loginID);
		if(document.cookie == ""){
			var str = "浏览器阻止了cookie，请设置浏览器允许cookie！"
			$Utils.openWindow.failWindow(str);
		}else{
            var url = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/index.html";
            if(isSso){
                url = url + "?isSsoLogin=1";
            }
            if(location.href.indexOf("hideHeader=") != -1 && (location.href.split("hideHeader=")[1]).split("&")[0] == 1){
                if(isSso){
                    url = url + "&hideHeader=1";
                }else{
                    url = url + "?hideHeader=1";
                }
            }
            window.location.href = url;
		}
	}

    document.addEventListener('DOMContentLoaded', function () {
        particleground(document.getElementById('particles'), {
            dotColor:'#666',
            lineColor:'#666'
        });
    }, false);
}();