!function(){
    var $ = layui.jquery, layer = layui.layer, element = layui.element;
    var organizationSystemSettings = new OrganizationSystemSettings();
    var logins = new Logins();
    var user = new User();
    var organizations = new Organizations();
    var organizationUsers = new OrganizationUsers();
    var userThemes = new UserThemes();
    var license = new License();
    var server = new Server();
    var userModules = [];
    var storage = window.sessionStorage;
    $AppVars.visibleAreaHeight = $(window).height();

    //集成时，别的系统提前拿到云智算登录ID，拼在URL后
    if(location.href.indexOf("loginID=") != -1){
        storage.setItem(window.location.host+"soLoginID",(location.href.split("loginID=")[1]).split("&")[0]);
    }
    if(location.href.indexOf("isSsoLogin=") != -1){
        storage.setItem(window.location.host+"isSsoLogin",(location.href.split("isSsoLogin=")[1]).split("&")[0]);
    }

    //集成时，别的系统需要云智算不显示顶部，需在URL后拼上hideHeader=1
    if(location.href.indexOf("hideHeader=") != -1 && (location.href.split("hideHeader=")[1]).split("&")[0] == 1){
        $("body").addClass("hide-header");
    }

    if($Utils.cookie.getCookie(window.location.host+"-loginID") || storage.getItem(window.location.host+"soLoginID")){
        getLogin($Utils.cookie.getCookie(window.location.host+"-loginID") || storage.getItem(window.location.host+"soLoginID"));
    }else{
        window.location.href = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/html/login/login.html";
    }

    //打开客户端时，如果使用IE浏览器，并且没有安装过客户端，因为IE打开客户端会弹出界面覆盖，返回后会刷新页面，记录这个值防止IE会弹不出客户端下载窗口
    if(storage.getItem(window.location.host+"-openClient") == 0){
        $Utils.openDownLoadWindow();
    }

    function getLogin(loginID){
        var succ = function(){
            if(logins.item(0).logouted == 1){
                window.location.href = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/html/login/login.html";
            }
            $AppVars.gLogin = logins.item(0);
            $AppVars.token = logins.item(0).token;
            $Utils.cookie.addCookie(window.location.host + "-token", $AppVars.token);
            getOtherData();
            initPage();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取登录信息",errorStatus,msg);
        };
        logins.getItemByID(loginID,true,succ,fail);
    }

    function getOtherData(){
		getUser();
        getUserModules();
        getOrganizations();
        getOrganizationUsers();
        getUserTheme();
        getLicense();
        getVersion();
        getSystemSettings();
        // getZip();
    }

    function getUser(){
		var succ = function(){
			$AppVars.gUser = user;
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取用户",errorStatus,msg);
		};
		user.getItemByID($AppVars.gLogin.userID,false,succ,fail);
	}

    function getUserModules(){
        var succ = function(data){
			userModules = data;
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取模块",errorStatus,msg);
		};
		user.getModules(false,succ,fail);
    }

    function getOrganizations(){
        var succ = function(){
            $AppVars.gOrganizations = organizations;
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取组织",errorStatus,msg);
		};
        organizations.getItemsByUserID($AppVars.gLogin.userID,false,succ,fail);
    }

    function getOrganizationUsers(){
        var succ = function(){
            $AppVars.gOrganizationUsers = organizationUsers;
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取组织用户",errorStatus,msg);
		};
        organizationUsers.getItemsByUserID($AppVars.gLogin.userID,false,succ,fail);
    }

    function getUserTheme(){
		var succ = function(){
			$AppVars.gUserTheme = userThemes.item(0);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取用户主题",errorStatus,msg);
		};

		userThemes.getThemeByUserID($AppVars.gLogin.userID,false,succ,fail);
    }
    
    function getLicense(){
        var succ = function(){
            $AppVars.gLicense = license;
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取版本",errorStatus,msg);
		};
        license.initFromServer(false,succ,fail);
    }

    function getSystemSettings(){
        var succ = function(){
            $AppVars.gOrganizationSystemSettings = organizationSystemSettings;
            $AppVars.queryTimeOut = $AppVars.gOrganizationSystemSettings.item("queryTimeOut").systemSettingValue;
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取组织设置",errorStatus,msg);
		};
        organizationSystemSettings.getItems(false,succ,fail);
    }

    function getVersion(){
        var succ = function () {
            $AppVars.serverEdition = server.edition;
            if (server.edition != 3) {
                $(".user-setting-organization").remove();
            }
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $(".user-setting-organization").remove();
        };
        server.getItem(false, succ, fail);
    }

    function initPage(){
        if($AppVars.gUser.portrait){
            $(".face-img").attr("src",$AppConstants.hostName + $AppConstants.port+"/bdasystem/" + $AppVars.gUser.portrait);
        }
        $(".fullName").html($AppVars.gUser.fullName);
        $(".self-report,.theme-setting").hide();
        reloadSystem();
        $("#resizor").show(200);

        $(".setting li:first-child dd").click(function(){
            if($(this).index() == 0){
                getUserSettingHtml('html/userSetting/userMessage.html',0);
            }else{
                getUserSettingHtml('html/userSetting/password.html',1);
            }
        });

        $(".left-menu > ul").on("click","li",function(){
            if(!$(this).hasClass("current-module")){
                $(this).addClass("current-module").siblings("li").removeClass("current-module");
                loadMenus($(this).attr("data-moduleid"));
                $(".show-hide").removeClass("show");
                $("#resizor").removeAttr("style");
            }
        });

        $(".close-down-load-box").click(function(){
            $(".down-load-mark,.down-load-box").hide();
        });

        loadUserModulesList();
        $Utils.loading.close();

        bindTopNavEvent();
        bindLeftNavEvent();
        createVersions();

        $(".show-hide").click(function(){
            if($(this).hasClass("show")){
                $(this).removeClass("show");
                $(".right-main").removeClass("magnify-right");
                $(".mouseup-size").show(200);
            }else{
                $(".mouseup-size").hide(200);
                $(this).addClass("show");
                $(".right-main").addClass("magnify-right");
            }
        });

        $(".mouseup-size").mousedown(function(e){
            var positionDiv = $(this).offset();
            var distenceX = e.pageX - positionDiv.left;
            var x = 0;
            var leftEnd = $("section").hasClass("only-one")?40:100;
            var rightEnd = $("section").hasClass("only-one")?600:660;
            $(".mouseup-mark").show();
            var isMove = false;

            $(document.body).mousemove(function(e){
                isMove = true;
                x = e.pageX - distenceX;
                if(x < leftEnd){
                    x = leftEnd
                }else if(x > rightEnd){
                    x = rightEnd;
                }
                $(".mouseup-size").css({
                    "left": x-3,
                    "border-left": "1px #666 dashed"
                });
            });

            $(document.body).mouseup(function() {
                if(isMove){
                    $(".right-main,.mouseup-mark").css({
                        "left": x
                    });
                    // if(($("section").hasClass("only-one") && x > 220) || (!$("section").hasClass("only-one") && x > 280)){
                        $(".BDA-right > .left-menu-cnt").css({
                            "width": $("section").hasClass("only-one")?x:(x-60)
                        });
                    // }else{
                    //     $(".BDA-right > .left-menu-cnt").css({
                    //         "width": 220
                    //     });
                    // }
    
                    $(".mouseup-size").css({
                        "border-color": "transparent"
                    });
    
                    $(".mouseup-mark").hide();
                }
                
                $(document.body).off('mousemove');
                $(document.body).off('mouseup');
            });
            return false;
        });

        if($AppVars.gLogin.thirdPartyLogin){
            $(".user-setting").find("dl").remove();
            $(".more-setting dl dd").each(function(){
                if($(this).find("a").attr("data-index") == 6 || $(this).find("a").attr("data-index") == 11){
                    $(this).remove();
                }
            });
        }
    }

    function createVersions(){
        // var zipName = data.packagePath.substring(data.packagePath.lastIndexOf("\/"),data.packagePath.length);
        // var url = data.packagePath;
        $(".file-name span").text("云智算客户端");
        $(".down-load-button a").attr("href",$AppConstants.hostName + $AppConstants.port + "/app/client/Yunzhisuan Windows Client.zip");
    }

    function loadUserModulesList(){
        var str = '';
        if(userModules.indexOf(4) != -1){
            str += "<li data-moduleid='4' title='数据整理'><i class='iconfont bda-danganzhengli'></i></li>";
        }
        if(userModules.indexOf(2) != -1){
            str += "<li data-moduleid='2' title='业务建模'><i class='iconfont bda-yewujianmo'></i></li>";
        }
        if(userModules.indexOf(3) != -1){
            str += "<li data-moduleid='3' title='报表设计'><i class='iconfont bda-baobiaotongji'></i></li>";
        }
        if(userModules.indexOf(0) != -1){
            str += "<li data-moduleid='0' title='数据探索'><i class='iconfont bda-shujutansuo'></i></li>";
        }
        if(userModules.indexOf(1) != -1){
            str += "<li data-moduleid='1' title='系统管理'><i class='iconfont bda-xitongguanli'></i></li>";
        }
        if(userModules.indexOf(1) == -1){
            $(".more-setting dd").each(function(){
                if($(this).find("a").attr("data-index") != 1 && $(this).find("a").attr("data-index") != 6){
                    $(this).hide();
                }
            });
        }
        if(userModules.length <= 1){
            $(".BDA-left").hide();
            $("section").addClass("only-one");
        }
        if(userModules.length == 0){
            layer.open({
                type: 0,
                title: "云智算",
                closeBtn: 1,
                shadeClose: true,
                resize: false,
                area: ["480px","270px"],
                skin: "delete-window",
                content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-tips'></i></div><div class='fr fail-content'>您没有任何模块权限，请联系系统管理员分配权限。</div></div>",
                btn: ["确定"]
            });
        }
        $(".left-menu > ul").append(str);
        $(".left-menu > ul li:first-child").trigger("click");
    }

    function loadMenus(moduleID){
        $(".BDA-right").html("");
        $(".mouseup-size,.mouseup-mark").removeAttr("style");
        $Utils.loading.open();
        $(".self-report,.theme-setting,.left-theme,.left-self").hide();
        var url = "";
        if(moduleID == 0){
            $(".self-report,.theme-setting,.left-theme,.left-self").show();
            url = "html/iFind/iFind.html";
        }
        if(moduleID == 1){
            url = "html/iControl/iControl.html";
        }
        if(moduleID == 2){
            url = "html/iBusinessModel/businessModel.html";
        }
        if(moduleID == 3){
            url = "html/iReport/iReport.html";
        }
        if(moduleID == 4){
            url = "html/iDataOrganize/dataOrganize.html";
        }
        getMenuHtml(url);
    }

    function getMenuHtml(url){
        $.ajax({
            url: url,
            type: 'GET',
            success: function(data){
                $(".BDA-right").html("");
                $(".BDA-right").html(data);
            }
        });
    }

    function bindTopNavEvent(){
        element.on('nav(topNav)', function(elem) {
            if(elem.attr("data-index")){
                if(elem.attr("data-index") == 0){
                    getAndLoadHtml("html/settings/organization.html","组织",0);
                }
                if(elem.attr("data-index") == 1){
                    getAndLoadHtml("html/settings/personalization.html","个性化",1);
                }
                if(elem.attr("data-index") == 2){
                    getAndLoadHtml("html/settings/option.html","选项",2);
                }
                if(elem.attr("data-index") == 3){
                    getAndLoadHtml("html/settings/dateFormat.html","设置日期过滤缺省值的日期格式",3);
                }
                if(elem.attr("data-index") == 4){
                    openClient(4);
                }
                if(elem.attr("data-index") == 5){
                    openClient(3);
                }
                if(elem.attr("data-index") == 6){
                    loadLogout();
                }
                if(elem.attr("data-index") == 7){
                    getAndLoadHtml("html/settings/theme.html","主题设置",7);
                }
                if(elem.attr("data-index") == 8){
                    openSelf();
                }
                if(elem.attr("data-index") == 9){
                    getUserSettingHtml("html/userSetting/userMessage.html","账号设置",false);
                }
                if(elem.attr("data-index") == 10){
                    getUserSettingHtml("html/userSetting/password.html","修改密码",true);
                }
                if(elem.attr("data-index") == 11){
                    getAndLoadAboutHtml("html/settings/about.html","关于 云智算");
                }
                if(elem.attr("data-index") == 12){
                    getAndLoadHtml("html/userSetting/organization.html","创建组织",0);
                }
            }
        });
    }

    function bindLeftNavEvent(){
        element.on('nav(systemSetting)', function(elem) {
            if(elem.attr("data-index")){
                if(elem.attr("data-index") == 0){
                    getAndLoadHtml("html/settings/organization.html","组织",0);
                }
                if(elem.attr("data-index") == 1){
                    getAndLoadHtml("html/settings/personalization.html","个性化",1);
                }
                if(elem.attr("data-index") == 2){
                    getAndLoadHtml("html/settings/option.html","选项",2);
                }
                if(elem.attr("data-index") == 3){
                    getAndLoadHtml("html/settings/dateFormat.html","设置日期过滤缺省值的日期格式",3);
                }
                if(elem.attr("data-index") == 4){
                    openClient(4);
                }
                if(elem.attr("data-index") == 5){
                    openClient(3);
                }
                if(elem.attr("data-index") == 6){
                    loadLogout();
                }
                if(elem.attr("data-index") == 7){
                    getAndLoadHtml("html/settings/theme.html","主题设置",7);
                }
                if(elem.attr("data-index") == 8){
                    openSelf();
                }
                if(elem.attr("data-index") == 11){
                    getAndLoadAboutHtml("html/settings/about.html","关于 云智算");
                }
            }
        });
    }

    function openClient(index){
        var url = "yzs:// /l " + $AppVars.gLogin.loginID + " /n1 " + index + " /i1 ";
        $Utils.openClient(url);
        // var url = "";

        // if (index == 4) {
        //     url = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/html/importWizard/?token=" + $AppVars.token;
        // } else if (index == 3) {
        //     var hasDO = 0;
        //     if (userModules.indexOf(4) != -1) {
        //         hasDO = 1;
        //     }
        //     url = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/html/exportWizard/?token=" + $AppVars.token + "&hasDO=" + hasDO;
        // }
        // layer.open({
        //     type: 2,
        //     title: index == 3 ? "导出向导" : "导入向导",
        //     btn: false,
        //     resize: false,
        //     area: ["800px", "643px"],
        //     content: [url, 'no']
        // }); 
    }

    function getAndLoadHtml(url,name,index){
        $.ajax({
            url: url,
            type: 'GET',
            success: function(data){
                loadHtml(data,name,index)
            }
        });
    }

    function loadHtml(strHtml,name,index){
        layer.open({
            type: 1,
            title: [name,"font-size: 14px"],
            btn: false,
            resize: false,
            area: (index==7?["400px","300px"]:(index==0?["800px","600px"]:(index==1?["560px","420px"]:["720px","540px"]))),
            content: strHtml
        });
    }

    function loadLogout(){
        layer.open({
            type: 0,
            title: "注销",
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否确定注销？</div></div>",
            btn: ["确定","取消"],
            success: function(layero,index){
                $(layero).find('.layui-layer-content').css('height','137px');
            },
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                logout();
            }
        });
    }

    function logout(){
        var succ = function(){
            $Utils.cookie.deleteCookie(window.location.host + "-loginID");
            $Utils.cookie.deleteCookie(window.location.host + "-token");
            window.location.href = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/html/login/login.html";
        };
		var fail = function(errorStatus,msg){
            $Utils.cookie.deleteCookie(window.location.host + "-loginID");
            $Utils.cookie.deleteCookie(window.location.host + "-token");
            window.location.href = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/html/login/login.html";
		};
        logins.deletItem($AppVars.gLogin.loginID,true,succ,fail);
    }

    function openSelf(){
        var url = $AppConstants.hostName + $AppConstants.port + "/app/selfAnalysis/selfAnalysisPC.jsp?token="+$AppVars.token+"&deviceTypeID="+$AppVars.deviceTypeID+"&themeID="+$AppVars.gUserTheme.themeID;
        layer.open({
            type: 2,
            title: "自助报表创建向导",
            btn: false,
            resize: false,
            area: ["800px","643px"],
            content: [url, 'no']
          }); 
    }
    
    function getUserSettingHtml(url,name,isPassword){
        $.ajax({
            url: url,
            type: 'GET',
            success: function(data){
                openUserSettingWindow(data,name,isPassword);
            }
        });
    }

    function openUserSettingWindow(htmlContent,name,isPassword){
        layer.open({
            type: 1,
            title: name,
            area: isPassword?['440px','330px']:['600px', '450px'], //宽高
            content: htmlContent,
            success: function(layero, index){
                
            }
        });
    }

    function getAndLoadAboutHtml(url,name){
        $.ajax({
            url: url,
            type: 'GET',
            success: function(data){
                loadAboutForm(data,name);
            }
        });
    }

    function loadAboutForm(strHtml,name){
        layer.open({
            type: 1,
            title: name,
            area: ['480px','270px'], //宽高
            content: strHtml,
            skin: "about-box",
            btn: ["确定"],
            success: function(layero, index){
                var succ = function(data,status,request){
                    if(request.status != 204){
                        $(".about-box .version").text("版本： "+data.item.version);
                    }
                };
                var fail = function(errorStatus,msg){
                    $Utils.loading.close();
                    $Utils.openWindow.failWindow("获取版本",errorStatus,msg);
                };
                var url = $AppConstants.hostName + $AppConstants.port+'/bdasystem/versions?moduleID=1&deviceTypeID=2&osID='+$Utils.getOsID();
                $Utils.request.getRequest(url,{},true,"json",succ,fail);  
            }
        });
    }

    window.reloadUserMessage = function(){
        getUser();
        if($AppVars.gUser.portrait){
            $(".face-img").attr("src",$AppConstants.hostName + $AppConstants.port+"/bdasystem/" + $AppVars.gUser.portrait);
        }
        $(".fullName").html($AppVars.gUser.fullName);
    };

    window.close = function () {
        layer.closeAll();
    };

    window.reloadSystem = function(data){
        if($AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo){
            var url = $AppConstants.hostName + $AppConstants.port + "/bdasystem/" + $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).organizationLogo
            $(".logo img").attr("src",url+"?time="+(new Date().getTime()));
        }else{
            $(".logo img").attr("src","images/defaultLogo.png");
        }

        var title = $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).systemName || "云智算";
        if ($AppVars.gLicense.controlExpireDate && ($AppVars.gLicense.effectiveDays <= 30)) {
            title += "<i>（还剩 " + $AppVars.gLicense.effectiveDays + " 天过期）</i>";
        }
        $(".logo span").html(title);
        document.title = $AppVars.gOrganizations.item($AppVars.gLogin.organizationID).systemName || "云智算";
        // if($AppVars.gOrganizations.item($AppVars.gLogin.organizationID).systemName){
        //     $(".logo span").text($AppVars.gOrganizations.item($AppVars.gLogin.organizationID).systemName);
        //     document.title = title;
        // }else{
        //     $(".logo span").text("云智算");
        //     document.title = title;
        // }
    };

    window.openLoading = function(){
        $Utils.loading.open();
    };

    window.closeLoading = function () {
        $Utils.loading.close();
    };

}();