!function () {
    var $ = layui.jquery, layer = layui.layer;
    var selectName = "";
    // var basePath = "http://sales.yunzhisuan.com/SalesManagement/resource/package/";
    var basePath = "http://sales.yunzhisuan.com/SalesManagement";
    window.initPackageListForm = function (selectPkgCallback, index) {
        getSystemSettings();
        getAndLoadPackage();

        $(".form-submit .layui-btn-cancel").click(function () {
            layer.close(index);
        });
        $("#submitButton").click(function () {
            selectPkgCallback(basePath + "/resource/package/" + selectName + ".pkg", selectName, index);
            layer.close(index);
        });
        $(".package-list").on("click", "dl", function () {
            if (!$(this).hasClass("select-dl")) {
                $(this).addClass("select-dl").siblings("dl").removeClass("select-dl");
            }
            selectName = $(this).children("dd").html();
        });
    };

    function getSystemSettings() {
        var succ = function () {
            var cloudPackageURL = systemSettings.item("cloudPackageURL");
            if (cloudPackageURL != null) {
                basePath = cloudPackageURL;
            }
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取设置列表", errorStatus, msg);
        };
        var systemSettings = new SystemSettings();
        systemSettings.getItems(false, succ, fail);
    }

    function getAndLoadPackage() {
        var succ = function (data) {
            $Utils.windowLoading.close();
            loadPkgList(data);

        };
        var fail = function (XHR, textStatus) {
            $Utils.windowLoading.close();
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                $Utils.openWindow.failWindow("获取业务包列表", "网络连接不可用。");
            } else if (textStatus == "timeout") {
                $Utils.openWindow.failWindow("获取业务包列表", "请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    $Utils.openWindow.failWindow("获取业务包列表", XHR.status, XHR.responseText);
                } else {
                    $Utils.openWindow.failWindow("获取业务包列表", XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                $Utils.openWindow.failWindow("获取业务包列表", "未知错误。");
            }
            return;
        };
        //TODO 读取SystemSetting
        var url = basePath + "/packages"
        var obj = "";
        $Utils.request.getRequest(url, obj, false, "json", succ, fail);
    }
    function loadPkgList(data) {

        for (var i = 0; i < data.items.length; i++) {

            var str = "<dl>\
            <dt><img src='"+ (basePath + "/resource/package/" + data.items[i].fileName) + ".png' width='100' height='75'></dt>\
            <dd>"+ data.items[i].fileName + "</dd>\
        </dl>";
            $(".package-list").append(str);
        }
        var aaa = data;
    }
}();