!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, tree = layui.tree, form = layui.form, excel = layui.excel;
    var selectFile = {};
    $AppVars.token = (location.href.split("token=")[1]).split("&")[0];

    var pageStack = [];

    var zipFile = null;

    var excelMap = {};
    var reportVisibilityMap = {};
    var resourceMap = {};

    var dbSetting = new BizDbSetting();
    var rootFolder = new SqlFolder();
    var selectedDDLSqls = [];
    var selectedDMLSqls = [];
    var allTransforms = new BDATransforms();
    var selectedTransforms = new BDATransforms();
    var jJobTransforms = [];
    var allJobs = new BDAJobs();
    var selectedJobs = new BDAJobs();
    var allExcelFiles = new ExcelFiles();
    var selectedExcelFiles = new ExcelFiles();
    var allDatabaseLinks = new DatabaseLinks();
    var selectedDatabaseLinks = new DatabaseLinks();
    var allRelationModels = new RelationModels();
    var selectedRelationModels = new RelationModels();
    var allTableModels = new TableModels();
    var selectedTableModels = new TableModels();
    var allSqlModels = new SqlModels();
    var selectedSqlModels = new SqlModels();
    var allExcelModels = new ExcelModels();
    var selectedExcelModels = new ExcelModels();
    var allReports = new Reports();
    var selectedReports = new Reports();
    var allReportFolders = new ReportFolders();
    var selectedReportFolders = new ReportFolders();
    var allResources = [];
    var selectedResources = [];

    var curTransforms = null;
    var curJobs = null;
    var curDatabaseLinks = null;
    var curExcelFiles = null;
    var curRelationModels = null;
    var curTableModels = null;
    var curSqlModels = null;
    var curExcelModels = null;
    var curReports = null;
    var curReportFolders = null;

    var idMap = new HashTable();
    var idMapReversal = new HashTable();
    var importDBSettingSucc = null;
    var importTransformSucc = null;
    var importJobSucc = null;
    var importDatabaseLinkSucc = null;
    var importExcelFileSucc = null;
    var importRelationModelSucc = null;
    var importTableModelSucc = null;
    var importSqlModelSucc = null;
    var importExcelModelSucc = null;
    var importReportFolderSucc = null;
    var importReportSucc = null;
    var updateReportResourceSucc = null;

    var tempReports = new Reports();
    initImport();

    function initImport(){
        $(".cancel").click(function(){
            window.parent.close();
        });
        initSelectPackagePages();
    }
    //#region 选择业务包
    function initSelectPackagePages(){
        $(".package .next-step").click(function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();

                if(dbSetting != null){
                    initDOSelectPage();
                }else{
                    initBusinessModelPage();
                }
            }
            return false;
        });

        bindSelectPackageEvent();
        $Utils.windowLoading.close();
        pageStack.push(".package");
    }
    function bindSelectPackageEvent(){
        $("#LAY-excel-import-excel").change(function(e) {
            $Utils.windowLoading.open();
            if(!Object.values) {
                Object.values = function values(obj) {
                    return Object.keys(obj).map(function(e){
                        return obj[e];
                    })
                };
            }
            var files = Object.values(e.target.files);
            e.target.value = '';
            zipFile = files[0];
            initAllZipInfo();

            // excelIsExist(files);
        });

        $("#local").click(function(){
            $("#LAY-excel-import-excel").click();
        });

        $("#cloud").click(function(){
            $.ajax({
                url: $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/html/importWizard/packageList.html",
                type: 'GET',
                success: function(data){
                    loadPackageListForm(data);
                }
            });
        });
    }
    function loadPackageListForm(strHtml){
        layer.open({
            type: 1,
            title: ["选择业务包","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initPackageListForm(selectPackage,index);
            }
        });
    }
    var selectPackage = function(packageUrl, packageName, index){
        var succ = function(data){
            var zip = new JSZip(data[0]);
            loadZip(zip, packageName);
            $Utils.windowLoading.close();
            // initAllZipInfo();
        };
        var fail = function(XHR,textStatus){
            $Utils.windowLoading.close();
            if(XHR.readyState == 0 && !window.navigator.onLine){
                $Utils.openWindow.failWindow("获取业务包","网络连接不可用。");
            }else if(textStatus == "timeout"){
                $Utils.openWindow.failWindow("获取业务包","请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    $Utils.openWindow.failWindow("获取业务包",XHR.status,XHR.responseText);
                }else{
                    $Utils.openWindow.failWindow("获取业务包",XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                $Utils.openWindow.failWindow("获取业务包","未知错误。");
            }
            return;
        };
        var obj = "";
        $Utils.windowLoading.open();
        $Utils.request.downLoadRequest(packageUrl,obj,true,"arraybuffer",succ,fail);

    };
    
    function initAllZipInfo(){
        excelMap = {};
        reportVisibilityMap = {};
        resourceMap = {};

        var reader = new FileReader();
        if (!reader) {
//             throw {code: 999, message: '不支持FileReader，请更换更新的浏览器'};
            $Utils.openWindow.failWindow("读取PKG文件",'不支持FileReader，请更换更新的浏览器');
        }
        reader.onload = function(ev) {
    
            var zip = new JSZip(ev.target.result);
            loadZip(zip,zipFile.name);
            
            
            $Utils.windowLoading.close();
        }
        reader.readAsArrayBuffer(zipFile);
    }
    function loadZip(zip, packageName){
        var files = zip.files;
        // var pkgInfo = files["pkg_info.txt"];
        var pkgInfo = files['pkg_info.txt']._data.getContent();
        var strPkgInfo = Utf16ArrayToStr(pkgInfo);
        
        var objPkgInfo = $.parseJSON(strPkgInfo);
        var encoding = objPkgInfo["encoding"];
        var config = null;
        if(encoding == "Unicode"){
            $Utils.windowLoading.close();
            alert("暂不支持Unicode编码，请用当前版本重新导出。");
        }else if(encoding == "UTF8"){
            //endsWith("cd")
            for(var item in files){
                var file = files[item];
                // if(file.name.indexOf(".config") == file.name.length - 7){
                if(file.name.endsWith(".config")){
                    var configFile = '';
                    configFile = Utf8ArrayToStr(file._data.getContent());
                    config = $.parseJSON(configFile);
                    break;
                }
            }
        }

        if(config != null){
            if(config["dbSetting"]){
                dbSetting = new BizDbSetting();
                dbSetting.init($.parseJSON(config["dbSetting"]));
                initTransforms(files);
                // allTransforms.init(config["transforms"]);
                initJobs(config["jobs"], files)
            }else{
                dbSetting = null;
            }
            

            var databaseLinks = config["databaseLinks"];
            var relationModels = config["relationModels"];
            var tableModels = config["tableModels"];
            var sqlModels = config["sqlModels"];
            var excelModels = config["excelModels"];
            var excelFiles = config["excelFiles"];

            var reportFolders = config["reportFolders"];
            var reports = config["reports"];

            var resources = config["resources"];

            initSqlScript(files);
            initDatabaseLinks(databaseLinks, files);
            initExcelFiles(excelFiles, files);
            initRelationModels(relationModels, files);
            initTableModels(tableModels, files);
            initSqlModels(sqlModels, files);
            initExcelModels(excelModels, files);
            initReportFolders(reportFolders);
            initReports(reports, files);
            initResources(resources);


            loadPackageInfo(config);
            $(".package-name").val(packageName);
            $(".package .next-step").attr("disabled", false)
        }
    }
    function loadPackageInfo(config){
        $(".pkg-company").html(config["公司"]);
        $(".pkg-product").html(config["产品"]);
        var des = config["描述"];
        // des = des.replace("/\n/g", "<br>")
        $(".pkg-description").html(des);

    }
    function initSqlScript(zipfiles){
        var sqlFolderDic = new HashTable();
        rootFolder = new SqlFolder();
        rootFolder.name = "SqlScripts";
        rootFolder.id = "SqlScripts/";
        rootFolder.parentID = "-1";
        sqlFolderDic.add(rootFolder.id, rootFolder);
        // var rootFolder = zipfiles["SqlScripts/"];
        for(var key in zipfiles){
        // for(var i = 0; i < zipfiles.length; i++){
            var zipfile = zipfiles[key];
            if(zipfile.name == "SqlScripts/" || !zipfile.name.startsWith('SqlScripts/')) continue;
            if(zipfile.name.endsWith(".sql") || zipfile.name.endsWith(".txt")){
                //这是文件
                var entryItem = new SqlScript();
                entryItem.id = zipfile.name;
                entryItem.name = getEntryName(zipfile.name);
                entryItem.parentID = getDirPath(zipfile.name);
                var content = zipfile._data.getContent();//密文
                var sText = Utf8ArrayToStr(content)
                entryItem.text = sText;
                try{
                    entryItem.showText = decrypt(sText, "1qazxsw23edcvfr4");
                }catch{
                    entryItem.showText = sText;
                }

                if(!sqlFolderDic.containsKey(entryItem.parentID)){
                    var sqlFolder = new SqlFolder();
                    sqlFolder.id = entryItem.parentID;
                    sqlFolder.name = getEntryName(entryItem.parentID);
                    entryItem.parentID = getDirPath(entryItem.parentID);
                    var aas = sqlFolderDic.getValue(getDirPath(sqlFolder.id));
                    aas.sqlEntrys.push(sqlFolder);
                    sqlFolderDic.add(sqlFolder.id, sqlFolder);
                }
                sqlFolderDic.getValue(entryItem.parentID).sqlEntrys.push(entryItem);
            }else if(zipfile.name.endsWith("/")){
                //这是文件夹
                var entryItem = new SqlFolder();
                entryItem.id = zipfile.name;
                entryItem.name = getEntryName(zipfile.name);
                entryItem.parentID = getDirPath(zipfile.name);
                sqlFolderDic.getValue(entryItem.parentID).sqlEntrys.push(entryItem);
                sqlFolderDic.add(entryItem.id, entryItem);
            }
        }
    }
    function getEntryName(fullName){
        var str1 = fullName.replace(new RegExp('\\/+$', 'g'), '')
        var index = str1.lastIndexOf("/");
        return str1.slice(index + 1);
    }
    function getDirPath(fullName){
        var str1 = fullName.replace(new RegExp('\\/+$', 'g'), '')
        var index = str1.lastIndexOf("/");
        return str1.slice(0,index + 1);
    }
    function initTransforms(zipfiles){
        if(zipfiles["transforms.json"]){
            var transformsFile = zipfiles["transforms.json"]._data.getContent();
            var strTransformsFile = Utf8ArrayToStr(transformsFile)
            
            var transformsObject = $.parseJSON(strTransformsFile);
    
            allTransforms.clear();
            allTransforms.init(transformsObject);
        }
    }
    function initJobs(jobTransforms, zipfiles){
        if(zipfiles["jobs.json"]){
            var jobsFile = zipfiles["jobs.json"]._data.getContent();
            var strJobsFile = Utf8ArrayToStr(jobsFile)
            
            var jobsObject = $.parseJSON(strJobsFile);
    
            allJobs.clear();
            allJobs.init(jobsObject);
        }
        jJobTransforms = jobTransforms;
    }
    function initDatabaseLinks(databaseLinks, zipfiles){
        allDatabaseLinks.clear();
        for(var i = 0; i < databaseLinks.length; i++){
            var dbkFile = zipfiles[databaseLinks[i]["dataSourceName"] + '.dbl']._data.getContent();
            var strDbkFile = Utf8ArrayToStr(dbkFile)
            
            var dbkObject = $.parseJSON(strDbkFile);
            var databaseLink = new DatabaseLink();
            databaseLink.init(dbkObject);
            allDatabaseLinks.add(databaseLink);
        }
    }
    function initExcelFiles(excelFiles, zipfiles){
        allExcelFiles.clear();
        for(var i = 0; i < excelFiles.length; i++){
            var utf8Array = zipfiles[excelFiles[i]["excelFileName"]]._data.getContent();
            excelMap[excelFiles[i]["excelFileID"]] = new Blob([utf8Array], { type: "application/octet-binary" });
            var excelFile = zipfiles[excelFiles[i]["excelFileName"] + '.exf']._data.getContent();
            var strExcelFile = Utf8ArrayToStr(excelFile)
            
            var excelFileObj = $.parseJSON(strExcelFile);
            var excelFile = new ExcelFile();
            excelFile.init(excelFileObj);
            allExcelFiles.add(excelFile);
        }
    }
    function initRelationModels(relationModels, zipfiles){
        var tempArray = [];
        for(var i = 0; i < relationModels.length; i++){
            var relationModel = zipfiles[relationModels[i]["relationModelName"] + '.rem']._data.getContent();
            var strRelationModel = Utf8ArrayToStr(relationModel)
            
            var relationModelObj = $.parseJSON(strRelationModel);
            tempArray.push(relationModelObj);
        }
        allRelationModels.init(tempArray);
    }
    function initTableModels(tableModels, zipfiles){
        var tempArray = [];
        for(var i = 0; i < tableModels.length; i++){
            var tableModel = zipfiles[tableModels[i]["tableModelName"] + '.tam']._data.getContent();
            var strTableModel = Utf8ArrayToStr(tableModel)
            
            var tableModelObj = $.parseJSON(strTableModel);
            tempArray.push(tableModelObj);
        }
        allTableModels.init(tempArray);
    }
    function initSqlModels(sqlModels, zipfiles){
        var tempArray = [];
        for(var i = 0; i < sqlModels.length; i++){
            var sqlModel = zipfiles[sqlModels[i]["sqlModelName"] + '.sqm']._data.getContent();
            var strSqlModel = Utf8ArrayToStr(sqlModel)
            
            var sqlModelObj = $.parseJSON(strSqlModel);
            tempArray.push(sqlModelObj);
        }
        allSqlModels.init(tempArray);
    }
    function initExcelModels(excelModels, zipfiles){
        var tempArray = [];
        for(var i = 0; i < excelModels.length; i++){
            var excelModel = zipfiles[excelModels[i]["excelModelName"] + '.exm']._data.getContent();
            var strExcelModel = Utf8ArrayToStr(excelModel)
            
            var excelModelObj = $.parseJSON(strExcelModel);
            tempArray.push(excelModelObj);
        }
        allExcelModels.init(tempArray);
    }
    function initReports(reports, zipfiles){
        var tempArray = [];
        for(var i = 0; i < reports.length; i++){
            var report = zipfiles[reports[i]["reportFileName"]]._data.getContent();
            if(reports[i].reportVisibility){
                reportVisibilityMap[reports[i].reportID] = reports[i].reportVisibility.split(",");
            }else{
                reportVisibilityMap[reports[i].reportID] = [];
            }
            var strReport = Utf8ArrayToStr(report)
            
            var reportObj = $.parseJSON(strReport);
            tempArray.push(reportObj);
            resourceMap[reports[i].reportID] = [];
            for(var item in zipfiles){
                var file = zipfiles[item];
                if(file.name.startsWith(reports[i].reportID) && file.options["dir"] == false){
                    var utf8Array = file._data.getContent();
                    var resourceObj = {};
                    resourceObj.name = file.name.split(reports[i].reportID+"/")[1];
                    resourceObj.blob = new Blob([utf8Array], { type: "application/octet-binary" });
                    resourceMap[reports[i].reportID].push(resourceObj);
                }
            }
        }
        allReports.init(tempArray);
    }
    function initReportFolders(reportFolders){
        allReportFolders.init(reportFolders);
    }
    function initResources(resources){
        if(resources){
            allResources = [];
            for(var i = 0; i < resources.length; i++){
                allResources.push(resources[i]);
            }
        }
    }
    //#endregion
    //#region 选择是否导入数据整理
    function initDOSelectPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".data-organize").show();
        $(".data-organize .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".data-organize").hide();
            pageStack.pop();
        });
        $(".data-organize .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                var data = form.val("package");
                if(data.chkDataOrganize){
                    loadDatabaseTpye();
                    initDBSettingPage();
                }else{
                    initBusinessModelPage();
                }
            }
            return false;
        });


        $Utils.windowLoading.close();
        pageStack.push(".data-organize");
    }
    //#endregion
    //#region 设置数据库连接信息
    function initDBSettingPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".dbSetting").show();
        $(".dbSetting .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".dbSetting").hide();
            pageStack.pop();
        });
        $(".dbSetting .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                if(validateDatabaseParameters()){
                    $Utils.windowLoading.open();
                    initDDLScriptSelectPage();
                }
            }
            return false;
        });

        $(".dbSetting").off("click").on("click",".test-link a",function(){
            var data = form.val("package");
            if(validateLinkParameters(data)){
                $Utils.loading.open();
                formTestConnections(data);
            }
        });
        $(".database-name .layui-edge").off("click").click(function(){
            var data = form.val("package");
            if(data.databaseTypeName == "MySql" || data.databaseTypeName == "SQLServer"){
                if(!$(".database-name-input").hasClass("database-name-selected")){
                    
                    $Utils.loading.open();
                    getAndLoadDatabase();
                }else{
                    if($(".database-name-input").hasClass("database-name-selected")){
                        $(".database-name-input").removeClass("database-name-selected");
                    }else{
                        $(".database-name-input").addClass("database-name-selected");
                    }
                }
            }
        });

        
        $(document).click(function(e){
            var target = $(e.target);
            if(target.closest(".database-name-input").length != 0 && $(".database-name-input").hasClass("database-name-selected")) return;
            $(".database-name-input").removeClass("database-name-selected");
        })

        $(".database-name input").focus(function(){
            $(".database-name-input").removeClass("database-name-selected");
        });

        $(".database-name .database-name-list").off("click").on("click","dd",function(){
            $(this).addClass("layui-this").siblings("dd").removeClass("layui-this");
            $(".database-name-input").removeClass("database-name-selected");
            form.val("package",{
                databaseName: $(this).text()
            });
        });

        $Utils.windowLoading.close();
        pageStack.push(".dbSetting");
    }
    function loadDatabaseTpye(){
        var databaseTypeName = document.getElementById("databaseTypeName");
        if(databaseTypeName.children.length > 0) return;
        var databaseTypes = new DatabaseTypes();
        var succ = function(){
            $Utils.loading.close();

            var defaultSelectIndex = 0; //加载时，默认选择第一个数据库类型和第一个数据库类型对应的第一个数据库版本；
            
            for(var i = 0; i < databaseTypes.count(); i++){
                var databaseType = databaseTypes.item(i);
                var option = document.createElement("option");
                option.setAttribute("value",databaseType.databaseTypeName);
                if(dbSetting == null){
                    if(i == 0){
                        option.setAttribute("selected",true);
                        defaultSelectIndex = 0;
                    }
                }else{
                    if(dbSetting.databaseTypeName == databaseType.databaseTypeName){
                        option.setAttribute("selected",true);
                        defaultSelectIndex = i;
                    }
                }
                option.innerText = databaseType.databaseTypeName;
                databaseTypeName.appendChild(option);
            }
            form.render();
        
            if(databaseTypes.item(defaultSelectIndex).databaseTypeName == "Access"){
                $(".acc-type").css("opacity",0);
                $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password]").removeAttr("lay-verify");
            }

            form.on("select(databaseTypeName)",function(data){
                if(data.value == "Access"){
                    $(".acc-type").css("opacity",0);
                    $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password]").removeAttr("lay-verify");
                }else{
                    $(".acc-type").css("opacity",1);
                    $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password],input[name=databaseName]").attr("lay-verify","required");
                }
                
                form.render();
            });
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据库类型列表",errorStatus,msg);
		};
		databaseTypes.getItems(false,succ,fail);
    }
    function validateLinkParameters(data){
        if(data.databaseTypeName == ""){
            layer.msg("请输入数据库类型！",{icon:2});
            return false;
        }
        if(data.databaseIP == ""){
            layer.msg("请输入主机名！",{icon:2});
            return false;
        }
        if(data.databasePort == ""){
            layer.msg("请输入端口！",{icon:2});
            return false;
        }
        if(data.userName == ""){
            layer.msg("请输入用户名！",{icon:2});
            return false;
        }
        if(data.databaseName == ""){
            layer.msg("请输入数据库名称！",{icon:2});
            return false;
        }
        return true;
    }
    function validateDatabaseParameters(){
        var data = form.val("package");
        if(data.databaseIP == ""){
            $Utils.loading.close();
            layer.msg("请输入数据库IP！",{icon:2});
            return false;
        }
        if(data.databasePort == ""){
            $Utils.loading.close();
            layer.msg("请输入数据库端口！",{icon:2});
            return false;
        }
        if(data.userName == ""){
            $Utils.loading.close();
            layer.msg("请输入用户名！",{icon:2});
            return false;
        }
        if(data.password == ""){
            $Utils.loading.close();
            layer.msg("请输入密码！",{icon:2});
            return false;
        }
        return true;
    }
    function getAndLoadDatabase(){
        var data = form.val("package");
        var parameters = "databaseTypeName="+encodeURIComponent(data.databaseTypeName)+"&databaseIP="+encodeURIComponent(data.databaseIP)+"&databasePort="+encodeURIComponent(data.databasePort)+
        "&userName="+encodeURIComponent(data.userName)+"&password="+encodeURIComponent(data.password);
        var succ = function(data){
            $Utils.loading.close();
            isFirst = false;
            showDatabases(data);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据库列表",errorStatus,msg);
        };
        dbSetting.getDatabaseNames(parameters,true,succ,fail);
    }
    function showDatabases(data){
        var databaseName = document.getElementById("databaseName");
        $(databaseName).empty();
        for(var i = 0; i < data.length; i++){
            var dd = document.createElement("dd");
            dd.setAttribute("data-value",data[i]);
            if(dbSetting){
                if(data[i] == dbSetting.databaseName){
                    dd.className = "layui-this";
                }
            }
            dd.innerText = data[i];
            databaseName.appendChild(dd);
        }
        $(".database-name-input").addClass("database-name-selected");
    }
    function formTestConnections(data){
        var bizDbSetting = new BizDbSetting();
        var parameters = "";
        parameters = "databaseTypeName="+encodeURIComponent(data.databaseTypeName)+"&databaseIP="+encodeURIComponent(data.databaseIP)+"&databasePort="+encodeURIComponent(data.databasePort)+
        "&userName="+encodeURIComponent(data.userName)+"&password="+encodeURIComponent(data.password)+"&databaseName="+encodeURIComponent(data.databaseName);
        var succ = function(){
            $Utils.loading.close();
            layer.msg("连接成功！",{icon:1});
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("测试连接",errorStatus,msg);
        };
        bizDbSetting.testConnections(parameters,true,succ,fail);
    }
    //#endregion
    //#region DDL列表
    function initDDLScriptSelectPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".script-ddl").show();
        $(".script-ddl .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".script-ddl").hide();
            pageStack.pop();
        });
        $(".script-ddl .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();

                saveSelectDDLScripts();

                initDMLScriptSelectPage();
            }
            return false;
        });

        loadDDLListTable();

        $Utils.windowLoading.close();
        pageStack.push(".script-ddl");
    }
    function loadDDLListTable(){
        var ddlScriptTableHead = [
            [
                {type: "checkbox"},
                {field: "name", title: "名称", sort: true},
                {title: "查看",templet: "#lookup",width: 80, align:"center"}
            ]
        ]
        var ddlScriptTableBody = [];
        var ddlFolder = null;
        for(var i = 0; i < rootFolder.sqlEntrys.length; i++){
            if(rootFolder.sqlEntrys[i].name == "DDL"){
                ddlFolder = rootFolder.sqlEntrys[i];
                break;
            }
        }
        if(ddlFolder){
            for(var i = 0; i < ddlFolder.sqlEntrys.length; i++){
                if(ddlFolder.sqlEntrys[i] instanceof SqlScript){
                    ddlScriptTableBody.push(ddlFolder.sqlEntrys[i]);
                }
            }
        }
        rootFolder.sqlEntrys
        table.render({
            elem: '#ddlScriptList',
            height: 450,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: ddlScriptTableBody,
            cols: ddlScriptTableHead,
            toolbar: false,
            autoSort: false,
            limit: ddlScriptTableBody.length
        });
    }
    function saveSelectDDLScripts(){
        selectedDDLSqls = [];
        
        var checkStatus = table.checkStatus('ddlScriptList');
        for(var i = 0; i < checkStatus.data.length; i++){
            var sqlSrcipt = checkStatus.data[i];
            selectedDDLSqls.push(sqlSrcipt);
        }
    }
    table.on("tool(scriptList)", function(obj){
        var sqlSrcipt = obj.data;
        if(obj.event == "lookupScirpt"){
            layer.open({
                type: 1,
                title: ["SQL脚本窗口","font-size: 14px"],
                btn: false,
                resize: false,
                area: ["760px","570px"],
                content: "<div class='show-sql-text'>" + sqlSrcipt.showText + "</div>"
            });
        }
    });
    //#endregion
    //#region DML列表
    function initDMLScriptSelectPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".script-dml").show();
        $(".script-dml .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".script-dml").hide();
            pageStack.pop();
        });
        $(".script-dml .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                var data = form.val("package");

                saveSelectDMLScripts();

                initTransformSelectPage();
            }
            return false;
        });

        loadDMLListTable();

        $Utils.windowLoading.close();
        pageStack.push(".script-dml");
    }
    function loadDMLListTable(){
        var dmlScriptTableHead = [
            [
                {type: "checkbox"},
                {field: "name", title: "名称", sort: true},
                {title: "查看",templet: "#lookup",width: 80, align:"center"}
            ]
        ]
        var dmlScriptTableBody = [];
        var dmlFolder = null;
        for(var i = 0; i < rootFolder.sqlEntrys.length; i++){
            if(rootFolder.sqlEntrys[i].name == "DML"){
                dmlFolder = rootFolder.sqlEntrys[i];
                break;
            }
        }
        if(dmlFolder){
            for(var i = 0; i < dmlFolder.sqlEntrys.length; i++){
                if(dmlFolder.sqlEntrys[i] instanceof SqlScript){
                    dmlScriptTableBody.push(dmlFolder.sqlEntrys[i]);
                }
            }
        }
        rootFolder.sqlEntrys
        table.render({
            elem: '#dmlScriptList',
            height: 450,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: dmlScriptTableBody,
            cols: dmlScriptTableHead,
            toolbar: false,
            autoSort: false,
            limit: dmlScriptTableBody.length
        });
    }
    function saveSelectDMLScripts(){
        selectedDMLSqls = [];
        
        var checkStatus = table.checkStatus('dmlScriptList');
        for(var i = 0; i < checkStatus.data.length; i++){
            var sqlSrcipt = checkStatus.data[i];
            selectedDMLSqls.push(sqlSrcipt);
        }
    }
    //#endregion
    //#region 选择转换
    function initTransformSelectPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".transform").show();
        $(".transform .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".transform").hide();
            pageStack.pop();
        });
        $(".transform .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();

                saveSelectTransforms();

                initJobSelectPage();
            }
            return false;
        });

        loadTransformTable();

        $Utils.windowLoading.close();
        pageStack.push(".transform");
    }
    function loadTransformTable(){
        var transformTableHead = [
            [
                {type: "checkbox"},
                {field: "transformName", title: "名称", sort: true}
            ]
        ]
        var transformTableBody = [];
        for(var i = 0; i < allTransforms.count(); i++){
            transformTableBody.push(allTransforms.item(i));
        }
        table.render({
            elem: '#transformList',
            height: 450,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: transformTableBody,
            cols: transformTableHead,
            toolbar: false,
            autoSort: false,
            limit: transformTableBody.length
        });
    }
    function saveSelectTransforms(){
        selectedTransforms.clear();
        
        var checkStatus = table.checkStatus('transformList');
        for(var i = 0; i < checkStatus.data.length; i++){
            selectedTransforms.add(checkStatus.data[i]);
        }
    }
    //#endregion
    
    //#region 选择作业
    function initJobSelectPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".job").show();
        $(".job .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".job").hide();
            pageStack.pop();
        });
        $(".job .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                saveSelectJobs();
                if(validateSelectJobs()){

                    initBusinessModelPage();
                }
            }
            return false;
        });

        loadJobTable();

        $Utils.windowLoading.close();
        pageStack.push(".job");
    }
    function loadJobTable(){
        var jobTableHead = [
            [
                {type: "checkbox"},
                {field: "jobName", title: "名称", sort: true}
            ]
        ]
        var jobTableBody = [];
        for(var i = 0; i < allJobs.count(); i++){
            jobTableBody.push(allJobs.item(i));
        }
        table.render({
            elem: '#jobList',
            height: 450,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: jobTableBody,
            cols: jobTableHead,
            toolbar: false,
            autoSort: false,
            limit: jobTableBody.length
        });
    }
    
    function validateSelectJobs(){
        for(var i = 0; i < selectedJobs.count(); i++){
            var transformIDs = getJobTransformIDs(selectedJobs.item(i).jobID);
            for(var j = 0; j < transformIDs.length; j++){
                if(selectedTransforms.item(transformIDs[j]) == null){
                    $Utils.openWindow.failWindow("导入作业", "无法导入作业 " + selectedJobs.item(i).jobName + " ,因为缺少转换 " + allTransforms.item(transformIDs[j]).transformName + " 。");
                    $Utils.windowLoading.close();
                    return false;
                }
            }
        }
        return true;
    }
    function getJobTransformIDs(jobID){
        for(var i = 0; i < jJobTransforms.length; i++){
            if(jJobTransforms[i]["id"] == jobID){
                return jJobTransforms[i]["transformIDs"];
            }
        }
        return [];
    }
    function saveSelectJobs(){
        selectedJobs.clear();
        
        var checkStatus = table.checkStatus('jobList');
        for(var i = 0; i < checkStatus.data.length; i++){
            selectedJobs.add(checkStatus.data[i]);
        }
    }
    //#endregion
    
    //#region 选择业务模型
    function initBusinessModelPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".business-model").show();
        $(".business-model .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".business-model").hide();
            pageStack.pop();
        });
        $(".business-model .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                saveSelectModels();
                
                initReportTreePage();
            }
            return false;
        });

        loadBusinessModelTable();

        $Utils.windowLoading.close();
        pageStack.push(".business-model");
    }
    function saveSelectModels(){
        selectedRelationModels.clear();
        selectedTableModels.clear();
        selectedSqlModels.clear();
        selectedExcelModels.clear();
        selectedDatabaseLinks.clear();
        selectedExcelFiles.clear();
        var checkStatus = table.checkStatus('modelList');
        for(var i = 0; i < checkStatus.data.length; i++){
            var selectedModel = checkStatus.data[i];
            if(selectedModel.businessModelType == 0){
                if(allDatabaseLinks.item(selectedModel.dataSourceID) != null){
                    selectedDatabaseLinks.add(allDatabaseLinks.item(selectedModel.dataSourceID));
                }
                selectedRelationModels.add(selectedModel);
            }else if(selectedModel.businessModelType == 1){
                if(allDatabaseLinks.item(selectedModel.dataSourceID) != null){
                    selectedDatabaseLinks.add(allDatabaseLinks.item(selectedModel.dataSourceID));
                }
                selectedTableModels.add(selectedModel);
            }else if(selectedModel.businessModelType == 2){
                if(allDatabaseLinks.item(selectedModel.dataSourceID) != null){
                    selectedDatabaseLinks.add(allDatabaseLinks.item(selectedModel.dataSourceID));
                }
                selectedSqlModels.add(selectedModel);
            }else if(selectedModel.businessModelType == 3){
                if(allExcelFiles.item(selectedModel.dataSourceID) != null){
                    selectedExcelFiles.add(allExcelFiles.item(selectedModel.dataSourceID));
                }
                selectedExcelModels.add(selectedModel);
            }
        }
    }
    function loadBusinessModelTable(){
        var businessModelTableHead = [
            [
                {type: "checkbox"},
                {field: "businessModelName", title: "名称", sort: true},
                {field: "businessModelType", title: "类型", sort: true, templet: function(d){
                    var typeString = "";
                    if(d.businessModelType == 0){
                        typeString = "关系模型";
                    }else if(d.businessModelType == 1){
                        typeString = "数据表模型";
                    }else if(d.businessModelType == 2){
                        typeString = "SQL模型";
                    }else if(d.businessModelType == 3){
                        typeString = "Excel模型";
                    }

                    return typeString;
                }},
                {field: "description", title: "描述", sort: true}
            ]
        ];

        var businessModelTableBody = [];
        for(var i = 0; i < allRelationModels.count(); i++){
            businessModelTableBody.push(allRelationModels.item(i));
        }
        for(var i = 0; i < allTableModels.count(); i++){
            businessModelTableBody.push(allTableModels.item(i));
        }
        for(var i = 0; i < allSqlModels.count(); i++){
            businessModelTableBody.push(allSqlModels.item(i));
        }
        for(var i = 0; i < allExcelModels.count(); i++){
            businessModelTableBody.push(allExcelModels.item(i));
        }
    
        table.render({
            elem: '#modelList',
            height: 450,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: businessModelTableBody,
            cols: businessModelTableHead,
            toolbar: false,
            autoSort: false,
            limit: businessModelTableBody.length
        });
    }
//#endregion
    //#region 选择报表
    function initReportTreePage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".report").show();
        $(".report .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".report").hide();
            pageStack.pop();
        });
        $(".report .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                saveSelectReportAndFolders();
                if(validateSelectReports() == true){
                    $Utils.windowLoading.open();
                    initConfirmMsgPage();
                }

            }
            return false;
        });

        initReportTree();

        $Utils.windowLoading.close();
        pageStack.push(".report");
    }
    function initReportTree(){
        var treeData = transformReportFolders();
        tree.render({
            elem: "#reportTree",
            data: treeData,
            showCheckbox: true,  //是否显示复选框
            id: "authority",
            isJump: false,
            onlyIconControl: true,
        });

        $("#reportTree").find(".layui-tree-iconClick").each(function(){
            
            if(!$(this).hasClass("layui-tree-icon")){
                $(this).find(".layui-icon").removeClass().addClass("iconfont bda-shilitubiao");
            }
        });
    }
    function saveSelectReportAndFolders(){
        selectedReportFolders.clear();
        selectedReports.clear();

        var checkData = tree.getChecked('authority');
        var folderIDs = [];
        var reportIDs = [];
        for(var i = 0; i < checkData.length; i++){
            if(checkData[i].folderID){
                folderIDs.push(checkData[i].folderID);
            }
            if(checkData[i].reportID){
                reportIDs.push(checkData[i].reportID);
            }
            if(checkData[i].children && checkData[i].children.length){
                getChildren(checkData[i].children, folderIDs, reportIDs);
            }
        }

        for(var i = 0; i < folderIDs.length; i++){
            selectedReportFolders.add(allReportFolders.item(folderIDs[i]));
        }
        for(var i = 0; i < reportIDs.length; i++){
            selectedReports.add(allReports.item(reportIDs[i]));
        }

    }
    function validateSelectReports(){
        for(var i = 0; i < selectedReports.count(); i++){
            var report = selectedReports.item(i);
            for(var j = 0; j < report.reportDesign.queries.count(); j++){
                var query = report.reportDesign.queries.item(j);
                if(query.modelType == 0 && selectedRelationModels.item(query.modelID) == null){
                    $Utils.openWindow.failWindow("导入报表", "无法导入报表 " + report.reportName + " ,因为缺少模型 " + query.modelName + " 。");
                    return false;
                }else if(query.modelType == 1 && selectedTableModels.item(query.modelID) == null){
                    $Utils.openWindow.failWindow("导入报表", "无法导入报表 " + report.reportName + " ,因为缺少模型 " + query.modelName + " 。");
                    return false;
                }else if(query.modelType == 2 && selectedSqlModels.item(query.modelID) == null){
                    $Utils.openWindow.failWindow("导入报表", "无法导入报表 " + report.reportName + " ,因为缺少模型 " + query.modelName + " 。");
                    return false;
                }else if(query.modelType == 3 && selectedExcelModels.item(query.modelID) == null){
                    $Utils.openWindow.failWindow("导入报表", "无法导入报表 " + report.reportName + " ,因为缺少模型 " + query.modelName + " 。");
                    return false;
                }
            }
        }
        return true;
    }
    function getChildren(checkData, folderIDs, reportIDs){
        for(var i = 0; i < checkData.length; i++){
            if(checkData[i].folderID){
                folderIDs.push(checkData[i].folderID);
            }
            if(checkData[i].reportID){
                reportIDs.push(checkData[i].reportID);
            }
            if(checkData[i].children && checkData[i].children.length){
                getChildren(checkData[i].children, folderIDs, reportIDs);
            }
        }
    }
    function transformReportFolders(){
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1",{title: "组织分析",id:"-1",folderID:"-1",folderParentID:"0",spread: true});
        for(var i = 0; i < allReportFolders.count(); i++){
            hashTable.add(allReportFolders.item(i).folderID,{title:allReportFolders.item(i).folderName,id:allReportFolders.item(i).folderID,folderID:allReportFolders.item(i).folderID,folderParentID:allReportFolders.item(i).folderParentID});
        }
        for(var i = 0; i < allReportFolders.count(); i++){
            var parentFolder = hashTable.getValue(allReportFolders.item(i).folderParentID);
            parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(allReportFolders.item(i).folderID));
        }
        for(var i = 0; i < allReports.count(); i++){
            var parentFolder = hashTable.getValue(allReports.item(i).folderID);
            parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push({title:allReports.item(i).reportName,id:allReports.item(i).reportID,folderParentID:allReports.item(i).folderID,reportID:allReports.item(i).reportID});
        }
        if(hashTable.getValue("-1").children){
            tempArr = hashTable.getValue("-1").children;
        }

        return tempArr;
    }
    //#endregion
    //#region 确认页面
    function initConfirmMsgPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".confirm").show();
        $(".confirm .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".confirm").hide();
            pageStack.pop();
        });
        $(".confirm .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                // $Utils.windowLoading.open();
                window.parent.openLoading();
                importSelectedItems();
                
            }
            return false;
        });

        initConfirmMsg();

        $Utils.windowLoading.close();
        pageStack.push(".confirm");
    }
    function initConfirmMsg(){
        var confirmMsg = "单击“完成”以执行以下操作：<br><br>";
        if(dbSetting){
            confirmMsg = confirmMsg + "导入数据整理模块<br>"
        }
        if(selectedRelationModels.count() > 0){
            confirmMsg = confirmMsg + "导入关系模型："
            for(var i = 0; i < selectedRelationModels.count(); i++){
                if(i == selectedRelationModels.count() - 1){
                    confirmMsg = confirmMsg + selectedRelationModels.item(i).businessModelName;
                }else{
                    confirmMsg = confirmMsg + selectedRelationModels.item(i).businessModelName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }
        if(selectedTableModels.count() > 0){
            confirmMsg = confirmMsg + "导入数据表模型："
            for(var i = 0; i < selectedTableModels.count(); i++){
                if(i == selectedTableModels.count() - 1){
                    confirmMsg = confirmMsg + selectedTableModels.item(i).businessModelName;
                }else{
                    confirmMsg = confirmMsg + selectedTableModels.item(i).businessModelName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }
        if(selectedSqlModels.count() > 0){
            confirmMsg = confirmMsg + "导入SQL模型："
            for(var i = 0; i < selectedSqlModels.count(); i++){
                if(i == selectedSqlModels.count() - 1){
                    confirmMsg = confirmMsg + selectedSqlModels.item(i).businessModelName;
                }else{
                    confirmMsg = confirmMsg + selectedSqlModels.item(i).businessModelName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }
        if(selectedExcelModels.count() > 0){
            confirmMsg = confirmMsg + "导入Excel模型："
            for(var i = 0; i < selectedExcelModels.count(); i++){
                if(i == selectedExcelModels.count() - 1){
                    confirmMsg = confirmMsg + selectedExcelModels.item(i).businessModelName;
                }else{
                    confirmMsg = confirmMsg + selectedExcelModels.item(i).businessModelName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }

        if(selectedReportFolders.count() > 0){
            confirmMsg = confirmMsg + "导入报表文件夹："
            for(var i = 0; i < selectedReportFolders.count(); i++){
                if(i == selectedReportFolders.count() - 1){
                    confirmMsg = confirmMsg + selectedReportFolders.item(i).folderName;
                }else{
                    confirmMsg = confirmMsg + selectedReportFolders.item(i).folderName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }

        if(selectedReports.count() > 0){
            confirmMsg = confirmMsg + "导入报表："
            for(var i = 0; i < selectedReports.count(); i++){
                if(i == selectedReports.count() - 1){
                    confirmMsg = confirmMsg + selectedReports.item(i).reportName;
                }else{
                    confirmMsg = confirmMsg + selectedReports.item(i).reportName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }

        $("#confirmMsg").html(confirmMsg);
    }
    function importSelectedItems(){
        importDBSettingSucc = null;
        importDatabaseLinkSucc = null; 
        importExcelFileSucc = null;
        importRelationModelSucc = null;
        importTableModelSucc = null;
        importSqlModelSucc = null;
        importExcelModelSucc = null;
        importReportFolderSucc = null;
        importReportSucc = null;
        idMap.clear();
        idMapReversal.clear();
        // $Utils.windowLoading.open();
        if(curRelationModels == null){
            curTransforms = new BDATransforms();
            curJobs = new BDAJobs();
            curDatabaseLinks = new DatabaseLinks();
            curExcelFiles = new ExcelFiles();
            curRelationModels = new RelationModels();
            curTableModels = new TableModels();
            curSqlModels = new SqlModels();
            curExcelModels = new ExcelModels();
            curReports = new Reports();
            curReportFolders = new ReportFolders();

            var succ = function(){
            };
            var failTrf = function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取转换列表",errorStatus,msg);
            };
            var failJob = function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取作业列表",errorStatus,msg);
            };
            var failDbl = function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取数据库连接列表",errorStatus,msg);
            };
            var failExf = function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取Excel文件列表",errorStatus,msg);
            };
            var failRem = function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取关系模型列表",errorStatus,msg);
            };
            var failTam = function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取数据表模型列表",errorStatus,msg);
            };
            var failSqm = function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取SQL模型列表",errorStatus,msg);
            };
            var failExm = function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取Excel模型列表",errorStatus,msg);
            };
            var failRep = function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取报表列表",errorStatus,msg);
            };
            var failFolder = function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取报表文件夹列表",errorStatus,msg);
            };

            if(dbSetting){
                curTransforms.getItems(1, false, succ, failTrf);
                curJobs.getItems(1, false, succ, failJob);
            }
            curDatabaseLinks.getItems(1, false, succ, failDbl);
            curExcelFiles.getItems(1, false, succ, failExf);
            curRelationModels.getItems(1, false, succ, failRem);
            curTableModels.getItems(1, false, succ, failTam);
            curSqlModels.getItems(1, false, succ, failSqm);
            curExcelModels.getItems(1, false, succ, failExm);
            curReports.getItems(1, false, succ, failRep);
            curReportFolders.getItems(false, succ, failFolder);
        }

        idMap.add("-1", "-1");
        importItems();
    }
    function importItems(){
        if(importDBSettingSucc != false &&
            importDatabaseLinkSucc != false && 
            importExcelFileSucc != false && 
            importRelationModelSucc != false && 
            importTableModelSucc != false && 
            importSqlModelSucc != false && 
            importExcelModelSucc != false && 
            importReportFolderSucc != false && 
            importReportSucc != false && 
            updateReportResourceSucc != false){
                if(importDBSettingSucc == null){
                    if(dbSetting) importDBSetting();
                    else { importDBSettingSucc = true;importItems(); } 
                }else if(importTransformSucc == null){
                    if(selectedTransforms.count() > 0) importTransform(selectedTransforms, 0);
                    else { importTransformSucc = true;importItems(); } 
                }else if(importJobSucc == null){
                    if(selectedJobs.count() > 0) importJob(selectedJobs, 0);
                    else { importJobSucc = true;importItems(); } 
                }
                else if(importDatabaseLinkSucc == null){
                    if(selectedDatabaseLinks.count() > 0) importDatabaseLink(selectedDatabaseLinks, 0);
                    else { importDatabaseLinkSucc = true;importItems(); } 
                }else if(importExcelFileSucc == null){
                    if(selectedExcelFiles.count() > 0) importExcelFile(selectedExcelFiles, 0);
                    else { importExcelFileSucc = true;importItems(); } 
                }else if(importRelationModelSucc == null){
                    if(selectedRelationModels.count() > 0) importRelationModel(selectedRelationModels, 0);
                    else { importRelationModelSucc = true;importItems(); } 
                }else if(importTableModelSucc == null){
                    if(selectedTableModels.count() > 0) importTableModel(selectedTableModels, 0);
                    else { importTableModelSucc = true;importItems(); } 
                }else if(importSqlModelSucc == null){
                    if(selectedSqlModels.count() > 0) importSqlModel(selectedSqlModels, 0);
                    else { importSqlModelSucc = true;importItems(); } 
                }else if(importExcelModelSucc == null){
                    if(selectedExcelModels.count() > 0) importExcelModel(selectedExcelModels, 0);
                    else { importExcelModelSucc = true;importItems(); } 
                }else if(importReportFolderSucc == null){
                    if(selectedReportFolders.count() > 0) importReportFolder(selectedReportFolders, 0);
                    else { importReportFolderSucc = true;importItems(); } 
                }else if(importReportSucc == null){
                    tempReports.clear();
                    if(selectedReports.count() > 0) importReport(selectedReports, 0);
                    else { importReportSucc = true;importItems(); } 
                }else if(updateReportResourceSucc == null){
                    if(selectedReports.count() > 0) updateReportsResource();
                    else { updateReportResourceSucc = true;importItems(); } 
                }else{
                    alert("导入成功");
                    window.parent.closeLoading();
                    window.parent.close();
                }
        }
    }
    function importDBSetting(){
        var dbSettings = new BizDbSettings();
        dbSettings.editItem(dbSetting, false, function(){
            ExecSqlScripts();
        },  function(errorStatus,msg){
            importDBSettingSucc = false;
            window.parent.closeLoading();
            $Utils.openWindow.failWindow("添加数据库设置",errorStatus,msg);
        });
    }
    function ExecSqlScripts(){
        var titles = [];
        var contents = [];

        for(var i = 0; i < selectedDDLSqls.length; i++){
            dbSetting.executeSQL(selectedDDLSqls[i].text, false, function(){

            }, function(errorStatus,msg){
                titles.push("执行sql" + selectedDDLSqls[i].Name);
                contents.push(msg);
            });
        }
        for(var i = 0; i < selectedDMLSqls.length; i++){
            dbSetting.executeSQL(selectedDMLSqls[i].text, false, function(){

            }, function(errorStatus,msg){
                titles.push("执行sql" + selectedDMLSqls[i].Name);
                contents.push(msg);
            });
        }

        if(titles.length > 0){
            var stringBuilder = "";
            for(var i = 0; i < titles.length; i++){
                if(i == titles.length - 1){
                    stringBuilder += titles[i] + ", " + contents[i];
                }else{
                    stringBuilder += titles[i] + ", " + contents[i] + "<br>";
                }
            }
            window.parent.closeLoading();
            layer.open({
                type: 0,
                title: "执行sql",
                resize: false,
                area: ["480px","270px"],
                skin: "delete-window",
                content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+stringBuilder+"</div></div>",
                btn: ["确定"],
                success: function(layero,index){

                },
                yes: function(index,layero){
                    layer.close(index);
                    importDBSettingSucc = true;
                    window.parent.openLoading();
                    importItems();
                }
            });
        }

    }
    function importTransform(transforms, i){
        var oldID = transforms.item(i).transformID;
        transforms.item(i).transformID = idMap.getValue(transforms.item(i).transformID);
        var tempTransforms = new BDATransforms();

        var succ = function(){
            idMap.add(oldID, transforms.item(i).transformID);
            if(i < transforms.count() - 1){
                importTransform(transforms, i + 1);
            }else{
                importTransformSucc = true;
                importItems();
            }
        }
        var fail = function(errorStatus,msg){
            if(msg.indexOf("名称不能重复") == -1){
                importTransformSucc = false;
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("添加转换",errorStatus,msg);
            }else{
                //弹出询问框，点击 是 覆盖，点击 跳过 忽略，点击 取消 关闭窗口
                var oldTransform = curTransforms.getTransformByName(transforms.item(i).transformName);
                var tipContent = "转换 " + transforms.item(i).transformName + " 已存在。<br><br>点击“覆盖”将使用业务包中的转换替换原转换；<br>点击“跳过”将保留原来的转换；<br>点击“取消”将不导入当前转换，并终止本次导入。"
                
                window.parent.closeLoading();
                layer.open({
                    type: 0,
                    title: "转换 " + transforms.item(i).transformName + " 已存在",
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+tipContent+"</div></div>",
                    btn: ["覆盖", "跳过", "取消"],
                    yes: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        if(oldTransform){
                            transforms.item(i).transformID = oldTransform.transformID;
                            tempTransforms.editItem(transforms.item(i), false, function(){
                                idMap.add(oldID, transforms.item(i).transformID);

                                if(i < transforms.count() - 1){
                                    importTransform(transforms, i + 1);
                                }else{
                                    importTransformSucc = true;
                                    importItems();
                                }
                            }, function(errorStatus,msg){
                                importTransformSucc = false;
                                window.parent.closeLoading();
                                $Utils.openWindow.failWindow("覆盖转换",errorStatus,msg);
                            }, "?ignoreFlag=1");
                        }
                    },
                    btn2: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        idMap.add(oldID, oldTransform.transformID);
                        if(i < transforms.count() - 1){
                            result = importTransform(transforms, i + 1);
                        }else{
                            importTransformSucc = true;
                            importItems();
                        }
                    },
                    btn3: function(index,layero){
                        layer.close(index);
                        window.parent.close();
                    }
                });
            }
        }

        tempTransforms.addItem(transforms.item(i), false, succ, fail);
    }
    function importJob(jobs, i){
        var oldID = jobs.item(i).jobID;
        jobs.item(i).jobID = idMap.getValue(jobs.item(i).jobID);
        var tempJobs = new BDAJobs();
    
        var succ = function(){
            idMap.add(oldID, jobs.item(i).jobID);
            var jobTransform = jJobTransforms[idMap[oldID]];
            for(var j = 0; j < jobTransform.length; j++){
                jobTransform[j]["transformID"] = idMap.getValue(jobTransform[j]["transformID"]);
            }
            jobs.item(i).changeTransfroms(jobTransform, false, function(){

            }, function(errorStatus,msg){
                importJobSucc = false;
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("修改作业 " + jobs.item(i).jobName + " 的转换",errorStatus,msg);
            });
            if(i < jobs.count() - 1){
                importJob(jobs, i + 1);
            }else{
                importJobSucc = true;
                importItems();
            }
        };
        var fail = function(errorStatus,msg){
            if(msg.indexOf("名称不能重复") == -1){
                importJobSucc = false;
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("添加作业",errorStatus,msg);
            }else{
                //弹出询问框，点击 是 覆盖，点击 跳过 忽略，点击 取消 关闭窗口
                var oldJob = curJobs.getJobByName(jobs.item(i).jobName);
                var tipContent = "作业 " + jobs.item(i).jobName + " 已存在。<br><br>点击“覆盖”将使用业务包中的作业替换原作业；<br>点击“跳过”将保留原来的作业；<br>点击“取消”将不导入当前作业，并终止本次导入。"
                
                window.parent.closeLoading();
                layer.open({
                    type: 0,
                    title: "作业 " + jobs.item(i).jobName + " 已存在",
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+tipContent+"</div></div>",
                    btn: ["覆盖", "跳过", "取消"],
                    yes: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        if(oldJob){
                            jobs.item(i).jobID = oldJob.jobID;
                            tempJobs.editItem(jobs.item(i), false, function(){
                                idMap.add(oldID, jobs.item(i).jobID);
    
                                if(i < jobs.count() - 1){
                                    importJob(jobs, i + 1);
                                }else{
                                    importJobSucc = true;
                                    importItems();
                                }
                            }, function(errorStatus,msg){
                                importJobSucc = false;
                                window.parent.closeLoading();
                                $Utils.openWindow.failWindow("覆盖作业",errorStatus,msg);
                            });
                        }
                    },
                    btn2: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        idMap.add(oldID, oldJob.jobID);
                        if(i < jobs.count() - 1){
                            result = importJob(jobs, i + 1);
                        }else{
                            importJobSucc = true;
                            importItems();
                        }
                    },
                    btn3: function(index,layero){
                        layer.close(index);
                        window.parent.close();
                    }
                });
            }
        };
    
        tempJobs.addItem(jobs.item(i), false, succ, fail);
    }
    function importDatabaseLink(databaseLinks, i){
        var databaseLink = databaseLinks.item(i);
        var oldID = databaseLink.dataSourceID;
        var oldDatabaseLink = curDatabaseLinks.getDatabaseLinkByName(databaseLink.dataSourceName)
        var tempDatabaseLinks = new DatabaseLinks();
        if(oldDatabaseLink != null){
            //修改
            var tipContent = "数据库连接 " + databaseLink.dataSourceName + " 已存在。<br><br>点击“覆盖”将使用业务包中的数据库连接替换原数据库连接；<br>点击“跳过”将保留原来的数据库连接；<br>点击“取消”将不导入当前数据库连接，并终止本次导入。"
            
            window.parent.closeLoading();
            layer.open({
                type: 0,
                title: "数据库连接 " + databaseLink.dataSourceName + " 已存在",
                resize: false,
                area: ["480px","270px"],
                skin: "delete-window",
                content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+tipContent+"</div></div>",
                btn: ["覆盖", "跳过", "取消"],
                yes: function(index,layero){
                    layer.close(index);
                    window.parent.openLoading();
                    databaseLink.dataSourceID = oldDatabaseLink.dataSourceID;
                    tempDatabaseLinks.editItem(databaseLink, false, function(){
                        idMap.add(oldID, databaseLink.dataSourceID);

                        if(i < databaseLinks.count() - 1){
                            importDatabaseLink(databaseLinks, i + 1);
                        }else{
                            importDatabaseLinkSucc = true;
                            importItems();
                        }
                    }, function(errorStatus,msg){
                        importDatabaseLinkSucc = false;
                        window.parent.closeLoading();
                        $Utils.openWindow.failWindow("数据库连接",errorStatus,msg);
                    });
                },
                btn2: function(index,layero){
                    layer.close(index);
                    window.parent.openLoading();
                    idMap.add(oldID, databaseLink.dataSourceID);
                    if(i < databaseLinks.count() - 1){
                        importDatabaseLink(databaseLinks, i + 1);
                    }else{
                        importDatabaseLinkSucc = true;
                        importItems();
                    }
                },
                btn3: function(index,layero){
                    layer.close(index);
                    window.parent.close();
                }
            });
        }else{
            //新增
            tempDatabaseLinks.addItem(databaseLink, false, function(){
                idMap.add(oldID, databaseLink.dataSourceID);
                if(i < databaseLinks.count() - 1){
                    importDatabaseLink(databaseLinks, i + 1);
                }else{
                    importDatabaseLinkSucc = true;
                    importItems();
                }
            }, function(errorStatus,msg){
                importDatabaseLinkSucc = false;
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("数据库连接",errorStatus,msg);
            });
        }
    }
    function importExcelFile(excelFiles, i){
        var excelFile = excelFiles.item(i);
        var excel = new FormData();
        excel.append(name="file",value=excelMap[excelFile.dataSourceID],fileName=excelFile.excelFileName);
        var oldID = excelFile.dataSourceID;
        var oldExcelFile = curExcelFiles.getExcelFileByName(excelFile.dataSourceName)
        var tempExcelFiles = new ExcelFiles();
        if(oldExcelFile != null){
            //修改
            var tipContent = "Excel文件 " + excelFile.dataSourceName + " 已存在。<br><br>点击“覆盖”将使用业务包中的Excel文件替换原Excel文件；<br>点击“跳过”将保留原来的Excel文件；<br>点击“取消”将不导入当前Excel文件，并终止本次导入。"
            
            window.parent.closeLoading();
            layer.open({
                type: 0,
                title: "Excel文件 " + excelFile.dataSourceName + " 已存在",
                resize: false,
                area: ["480px","270px"],
                skin: "delete-window",
                content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+tipContent+"</div></div>",
                btn: ["覆盖", "跳过", "取消"],
                yes: function(index,layero){
                    layer.close(index);
                    window.parent.openLoading();
                    excelFile.dataSourceID = oldExcelFile.dataSourceID;
                    tempExcelFiles.addItem(excelFile, excel, false, function(){
                        idMap.add(oldID, excelFile.dataSourceID);

                        if(i < excelFiles.count() - 1){
                            importExcelFile(excelFile, i + 1);
                        }else{
                            importExcelFileSucc = true;
                            importItems();
                        }
                    }, function(errorStatus,msg){
                        importExcelFileSucc = false;
                        window.parent.closeLoading();
                        $Utils.openWindow.failWindow("导入Excel文件",errorStatus,msg);
                    });
                },
                btn2: function(index,layero){
                    layer.close(index);
                    window.parent.openLoading();
                    idMap.add(oldID, excelFile.dataSourceID);
                    if(i < excelFiles.count() - 1){
                        importExcelFile(excelFiles, i + 1);
                    }else{
                        importExcelFileSucc = true;
                        importItems();
                    }
                },
                btn3: function(index,layero){
                    layer.close(index);
                    window.parent.close();
                }
            });
        }else{
            //新增
            tempExcelFiles.addItem(excelFile, excel, false, function(){
                idMap.add(oldID, excelFile.dataSourceID);
                if(i < excelFiles.count() - 1){
                    importExcelFile(excelFiles, i + 1);
                }else{
                    importExcelFileSucc = true;
                    importItems();
                }
            }, function(errorStatus,msg){
                importExcelFileSucc = false;
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("导入Excel文件",errorStatus,msg);
            });
        }
    }
    function importRelationModel(relationModels, i){
        var oldID = relationModels.item(i).businessModelID;
        relationModels.item(i).dataSourceID = idMap.getValue(relationModels.item(i).dataSourceID);
        var tempModels = new RelationModels();

        var succ = function(){
            idMap.add(oldID, relationModels.item(i).businessModelID);
            if(i < relationModels.count() - 1){
                importRelationModel(relationModels, i + 1);
            }else{
                importRelationModelSucc = true;
                importItems();
            }
        }
        var fail = function(errorStatus,msg){
            if(msg.indexOf("模型名称不能重复") == -1){
                importRelationModelSucc = false;
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("添加关系模型",errorStatus,msg);
            }else{
                //弹出询问框，点击 是 覆盖，点击 跳过 忽略，点击 取消 关闭窗口
                var oldRelationModel = curRelationModels.getModelByName(relationModels.item(i).businessModelName);
                var tipContent = "业务模型 " + relationModels.item(i).businessModelName + " 已存在。<br><br>点击“覆盖”将使用业务包中的模型替换原模型；<br>点击“跳过”将保留原来的模型；<br>点击“取消”将不导入当前模型，并终止本次导入。"
                
                window.parent.closeLoading();
                layer.open({
                    type: 0,
                    title: "业务模型 " + relationModels.item(i).businessModelName + " 已存在",
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+tipContent+"</div></div>",
                    btn: ["覆盖", "跳过", "取消"],
                    yes: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        if(oldRelationModel){
                            relationModels.item(i).businessModelID = oldRelationModel.businessModelID;
                            
                            tempModels.editItem(relationModels.item(i), false, function(){
                                idMap.add(oldID, relationModels.item(i).businessModelID);

                                if(i < relationModels.count() - 1){
                                    importRelationModel(relationModels, i + 1);
                                }else{
                                    importRelationModelSucc = true;
                                    importItems();
                                }
                            }, function(errorStatus,msg){
                                importRelationModelSucc = false;
                                window.parent.closeLoading();
                                $Utils.openWindow.failWindow("覆盖关系模型",errorStatus,msg);
                            }, "?forceModify=1");
                        }
                    },
                    btn2: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        idMap.add(oldID, oldRelationModel.businessModelID);
                        if(i < relationModels.count() - 1){
                            result = importRelationModel(relationModels, i + 1);
                        }else{
                            importRelationModelSucc = true;
                            importItems();
                        }
                    },
                    btn3: function(index,layero){
                        layer.close(index);
                        window.parent.close();
                    }
                });
            }
        }
        tempModels.addItem(relationModels.item(i), false, succ, fail);
    }
    function importTableModel(tableModels, i){
        var oldID = tableModels.item(i).businessModelID;
        tableModels.item(i).dataSourceID = idMap.getValue(tableModels.item(i).dataSourceID);
        var tempModels = new TableModels();

        var succ = function(){
            idMap.add(oldID, tableModels.item(i).businessModelID);
            if(i < tableModels.count() - 1){
                importTableModel(tableModels, i + 1);
            }else{
                importTableModelSucc = true;
                importItems();
            }
        }
        var fail = function(errorStatus,msg){
            if(msg.indexOf("模型名称不能重复") == -1){
                importTableModelSucc = false;
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("添加数据表模型",errorStatus,msg);
            }else{
                //弹出询问框，点击 是 覆盖，点击 跳过 忽略，点击 取消 关闭窗口
                var oldTableModel = curTableModels.getModelByName(tableModels.item(i).businessModelName);
                var tipContent = "业务模型 " + tableModels.item(i).businessModelName + " 已存在。<br><br>点击“覆盖”将使用业务包中的模型替换原模型；<br>点击“跳过”将保留原来的模型；<br>点击“取消”将不导入当前模型，并终止本次导入。"
                
                window.parent.closeLoading();
                layer.open({
                    type: 0,
                    title: "业务模型 " + tableModels.item(i).businessModelName + " 已存在",
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+tipContent+"</div></div>",
                    btn: ["覆盖", "跳过", "取消"],
                    yes: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        if(oldTableModel){
                            tableModels.item(i).businessModelID = oldTableModel.businessModelID;
                            tempModels.editItem(tableModels.item(i), false, function(){
                                idMap.add(oldID, tableModels.item(i).businessModelID);

                                if(i < tableModels.count() - 1){
                                    importTableModel(tableModels, i + 1);
                                }else{
                                    importTableModelSucc = true;
                                    importItems();
                                }
                            }, function(errorStatus,msg){
                                importTableModelSucc = false;
                                window.parent.closeLoading();
                                $Utils.openWindow.failWindow("覆盖数据表模型",errorStatus,msg);
                            }, "?forceModify=1");
                        }
                    },
                    btn2: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        idMap.add(oldID, oldTableModel.businessModelID);
                        if(i < tableModels.count() - 1){
                            result = importTableModel(tableModels, i + 1);
                        }else{
                            importTableModelSucc = true;
                            importItems();
                        }
                    },
                    btn3: function(index,layero){
                        layer.close(index);
                        window.parent.close();
                    }
                });
            }
        }

        tempModels.addItem(tableModels.item(i), false, succ, fail);
    }
    function importSqlModel(sqlModels, i){
        var oldID = sqlModels.item(i).businessModelID;
        sqlModels.item(i).dataSourceID = idMap.getValue(sqlModels.item(i).dataSourceID);
        var tempModels = new SqlModels();

        var succ = function(){
            idMap.add(oldID, sqlModels.item(i).businessModelID);
            if(i < sqlModels.count() - 1){
                importSqlModel(sqlModels, i + 1);
            }else{
                importSqlModelSucc = true;
                importItems();
            }
        }
        var fail = function(errorStatus,msg){
            if(msg.indexOf("模型名称不能重复") == -1){
                importSqlModelSucc = false;
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("添加SQL模型",errorStatus,msg);
            }else{
                //弹出询问框，点击 是 覆盖，点击 跳过 忽略，点击 取消 关闭窗口
                var oldSqlModel = curSqlModels.getModelByName(sqlModels.item(i).businessModelName);
                var tipContent = "业务模型 " + sqlModels.item(i).businessModelName + " 已存在。<br><br>点击“覆盖”将使用业务包中的模型替换原模型；<br>点击“跳过”将保留原来的模型；<br>点击“取消”将不导入当前模型，并终止本次导入。"
                
                window.parent.closeLoading();
                layer.open({
                    type: 0,
                    title: "业务模型 " + sqlModels.item(i).businessModelName + " 已存在",
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+tipContent+"</div></div>",
                    btn: ["覆盖", "跳过", "取消"],
                    yes: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        if(oldSqlModel){
                            sqlModels.item(i).businessModelID = oldSqlModel.businessModelID;
                            tempModels.editItem(sqlModels.item(i), false, function(){
                                idMap.add(oldID, sqlModels.item(i).businessModelID);

                                if(i < sqlModels.count() - 1){
                                    importSqlModel(sqlModels, i + 1);
                                }else{
                                    importSqlModelSucc = true;
                                    importItems();
                                }
                            }, function(errorStatus,msg){
                                importSqlModelSucc = false;
                                window.parent.closeLoading();
                                $Utils.openWindow.failWindow("覆盖SQL模型",errorStatus,msg);
                            }, "?forceModify=1");
                        }
                    },
                    btn2: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        idMap.add(oldID, oldSqlModel.businessModelID);
                        if(i < sqlModels.count() - 1){
                            result = importSqlModel(sqlModels, i + 1);
                        }else{
                            importSqlModelSucc = true;
                            importItems();
                        }
                    },
                    btn3: function(index,layero){
                        layer.close(index);
                        window.parent.close();
                    }
                });
            }
        }

        tempModels.addItem(sqlModels.item(i), false, succ, fail);
    }
    function importExcelModel(excelModels, i){
        var oldID = excelModels.item(i).businessModelID;
        var tempModels = new ExcelModels();

        var succ = function(){
            idMap.add(oldID, excelModels.item(i).businessModelID);
            if(i < excelModels.count() - 1){
                importExcelModel(excelModels, i + 1);
            }else{
                importExcelModelSucc = true;
                importItems();
            }
        }
        var fail = function(errorStatus,msg){
            if(msg.indexOf("模型名称不能重复") == -1){
                importExcelModelSucc = false;
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("添加Excel模型",errorStatus,msg);
            }else{
                //弹出询问框，点击 是 覆盖，点击 跳过 忽略，点击 取消 关闭窗口
                var oldExcelModel = curExcelModels.getModelByName(excelModels.item(i).businessModelName);
                var tipContent = "业务模型 " + excelModels.item(i).businessModelName + " 已存在。<br><br>点击“覆盖”将使用业务包中的模型替换原模型；<br>点击“跳过”将保留原来的模型；<br>点击“取消”将不导入当前模型，并终止本次导入。"
                
                window.parent.closeLoading();
                layer.open({
                    type: 0,
                    title: "业务模型 " + excelModels.item(i).businessModelName + " 已存在",
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+tipContent+"</div></div>",
                    btn: ["覆盖", "跳过", "取消"],
                    yes: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        if(oldExcelModel){
                            excelModels.item(i).businessModelID = oldExcelModel.businessModelID;
                            tempModels.editItem(excelModels.item(i), false, function(){
                                idMap.add(oldID, excelModels.item(i).businessModelID);

                                if(i < excelModels.count() - 1){
                                    importExcelModel(excelModels, i + 1);
                                }else{
                                    importExcelModelSucc = true;
                                    importItems();
                                }
                            }, function(errorStatus,msg){
                                importExcelModelSucc = false;
                                window.parent.closeLoading();
                                $Utils.openWindow.failWindow("覆盖Excel模型",errorStatus,msg);
                            }, "?forceModify=1");
                        }
                    },
                    btn2: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        idMap.add(oldID, oldExcelModel.businessModelID);
                        if(i < excelModels.count() - 1){
                            result = importExcelModel(excelModels, i + 1);
                        }else{
                            importExcelModelSucc = true;
                            importItems();
                        }
                    },
                    btn3: function(index,layero){
                        layer.close(index);
                        window.parent.close();
                    }
                });
            }
        }

        tempModels.addItem(excelModels.item(i), false, succ, fail);
    }
    function importReportFolder(){
        var rootFolder = new ReportFolder();
        rootFolder.folderID = "-1";
        var folderDictionary = new HashTable();
        folderDictionary.add("-1", rootFolder);
        for(var i = 0; i < curReportFolders.count(); i++){
            folderDictionary.add(curReportFolders.item(i).folderID, curReportFolders.item(i));
        }
        for(var i = 0; i < curReportFolders.count(); i++){
            var parentFolder = folderDictionary.getValue(curReportFolders.item(i).folderParentID);
            parentFolder.folderChildren.push(curReportFolders.item(i));
        }
        for(var i = 0; i < selectedReportFolders.count(); i++){
            var reportFolder = selectedReportFolders.item(i);
            var oldID = reportFolder.folderID;
            if(folderDictionary.getValue(reportFolder.folderParentID) != null){
                var oldFolder = getReportFolderByName(folderDictionary.getValue(reportFolder.folderParentID).folderChildren, reportFolder.folderName)
                if(oldFolder != null){
                    idMap.add(oldID, oldFolder.folderID);
                }else{
                    curReportFolders.addItem(reportFolder, false, function(){
                        idMap.add(oldID, reportFolder.folderID);
                        folderDictionary.getValue(reportFolder.folderParentID).folderChildren.push(reportFolder);
                        folderDictionary.add(reportFolder.folderID, reportFolder);
                    }, function(errorStatus,msg){
                        importReportFolderSucc = false;
                        window.parent.closeLoading();
                        $Utils.openWindow.failWindow("新增报表文件夹",errorStatus,msg);
                    });
                }
            }

        }
        importReportFolderSucc = true;
        importItems();
    }
    function importReport(reports, i){
        var report = reports.item(i);
        report.folderID = idMap.getValue(report.folderID);
        for(var j = 0; j < report.reportDesign.queries.count(); j++){
            var query = report.reportDesign.queries.item(j);
            query.modelID = idMap.getValue(query.modelID);
        }
        var oldID = report.reportID;
        var succ = function(){
            idMap.add(oldID, report.reportID);
            idMapReversal.add(report.reportID, oldID);
            setReportVisibility(report, reportVisibilityMap[oldID]);
            if(i < reports.count() - 1){
                importReport(reports, i + 1);
            }else{
                importReportSucc = true;
                importItems();
            }
        }
        var fail = function(errorStatus,msg){
            if(msg.indexOf("报表名称不能重复") == -1){
                importReportSucc = false;
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("添加报表 " + report.reportName,errorStatus,msg);
            }else{
                //弹出询问框，点击 是 覆盖，点击 跳过 忽略，点击 取消 关闭窗口
                var oldReport = curReports.getReportByName(report.reportName, report.folderID);
                var tipContent = "报表 " + report.reportName + " 已存在。<br><br>点击“覆盖”将使用业务包中的报表替换原报表；<br>点击“跳过”将保留原来的报表；<br>点击“取消”将不导入当前报表，并终止本次导入。"
                

                window.parent.closeLoading();
                layer.open({
                    type: 0,
                    title: "报表 " + report.reportName + " 已存在",
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+tipContent+"</div></div>",
                    btn: ["覆盖", "跳过", "取消"],
                    yes: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        if(oldReport){
                            report.reportID = oldReport.reportID;
                            var dataObjects = [];
                            for(var aa = 0; aa < report.reportDesign.dataObjects.count(); aa++){
                                dataObjects.push(report.reportDesign.dataObjects.item(aa));
                            }
                            recoverReport(report, reports, i, oldID, curReports);
                            
                        }
                        return false;
                    },
                    btn2: function(index,layero){
                        layer.close(index);
                        window.parent.openLoading();
                        idMap.add(oldID, oldReport.reportID);
                        idMapReversal.add(oldReport.reportID, oldID);
                        if(i < reports.count() - 1){
                            result = importReport(reports, i + 1);
                        }else{
                            importReportSucc = true;
                            importItems();
                        }
                    },
                    btn3: function(index,layero){
                        layer.close(index);
                        window.parent.close();
                    }
                });
            }
        }
        tempReports.addItem(reports.item(i), false, succ, fail);
    }

    function recoverReport(report, reports, i, oldID, curReports){
        var succ = function(){
            idMap.add(oldID, report.reportID);
            idMapReversal.add(report.reportID, oldID);
            if(i < reports.count() - 1){
                importReport(reports, i + 1);
            }else{
                importReportSucc = true;
                importItems();
            }
        };
        var fail = function(errorStatus,msg){
            importReportSucc = false;
            window.parent.closeLoading();
            $Utils.openWindow.failWindow("覆盖报表 " + report.reportName,errorStatus,msg);
        };
        curReports.editItem(report, false, succ, fail, "?forceModify=1");
    }

    function setReportVisibility(report, visibilityArray){
        var param = "";
        for(var i = 0; i < visibilityArray.length; i++){
            param += "deviceTypeIDs=" + visibilityArray[i];
            if(i < visibilityArray.length - 1){
                param += "&";
            }
        }
        report.updateRelease(param, false, function(){},function(){});
    }
    function updateReportsResource(){
        for(var a = 0; a < selectedReports.count(); a++){
            var needChange = false;
            var report = selectedReports.item(a);
            var reportdesign = report.reportDesign;
            //修改子报表ID
            for(var i = 0; i < reportdesign.chartBlocks.count(); i++){
                if(reportdesign.chartBlocks.item(i).reportLink){
                    var oldID = reportdesign.chartBlocks.item(i).reportLink.reportID;
                    if(idMap.containsKey(oldID)){
                        reportdesign.chartBlocks.item(i).reportLink.reportID = idMap.getValue(oldID);
                        needChange = true;
                    }
                }
            }
            for(var i = 0; i < reportdesign.verticalTableBlocks.count(); i++){
                var tableBodyRow = reportdesign.verticalTableBlocks.item(i).tableBody.tableRows.item(0);
                for(var j = 0; j < tableBodyRow.tableCells.count(); j++){
                    if(tableBodyRow.tableCells.item(j).reportLink){
                        var oldID = tableBodyRow.tableCells.item(j).reportLink.reportID;
                        if(idMap.containsKey(oldID)){
                            tableBodyRow.tableCells.item(j).reportLink.reportID = idMap.getValue(oldID);
                            needChange = true;
                        }
                    }
                }
            }
            for(var i = 0; i < reportdesign.freeTableBlocks.count(); i++){
                var freeTableBlock = reportdesign.freeTableBlocks.item(i);
                for(var j = 0; j < freeTableBlock.tableRows.count(); j++){
                    var tableRow = freeTableBlock.tableRows.item(j);
                    for(var k = 0; k < tableRow.tableCells.count(); k ++){
                        if(tableRow.tableCells.item(k).reportLink){
                            var oldID = tableRow.tableCells.item(k).reportLink.reportID;
                            if(idMap.containsKey(oldID)){
                                tableRow.tableCells.item(k).reportLink.reportID = idMap.getValue(oldID);
                                needChange = true;
                            }
                        }
                    }
                }
            }
            for(var i = 0; i < reportdesign.horizontalTableBlocks.count(); i++){
                var tableBodyColumn = reportdesign.horizontalTableBlocks.item(i).tableBody.tableColumns.item(0);
                for(var j = 0; j < tableBodyColumn.tableCells.count(); j++){
                    if(tableBodyColumn.tableCells.item(j).reportLink){
                        var oldID = tableBodyColumn.tableCells.item(j).reportLink.reportID;
                        if(idMap.containsKey(oldID)){
                            tableBodyColumn.tableCells.item(j).reportLink.reportID = idMap.getValue(oldID);
                            needChange = true;
                        }
                    }
                }
            }
            for(var i = 0; i < reportdesign.tileBlocks.count(); i++){
                if(reportdesign.tileBlocks.item(i).reportLink){
                    var oldID = reportdesign.tileBlocks.item(i).reportLink.reportID;
                    if(idMap.containsKey(oldID)){
                        reportdesign.tileBlocks.item(i).reportLink.reportID = idMap.getValue(oldID);
                        needChange = true;
                    }
                }
            }
            for(var i = 0; i < reportdesign.gaugeBlocks.count(); i++){
                if(reportdesign.gaugeBlocks.item(i).reportLink){
                    var oldID = reportdesign.gaugeBlocks.item(i).reportLink.reportID;
                    if(idMap.containsKey(oldID)){
                        reportdesign.gaugeBlocks.item(i).reportLink.reportID = idMap.getValue(oldID);
                        needChange = true;
                    }
                }
            }
            for(var i = 0; i < reportdesign.labelBlocks.count(); i++){
                if(reportdesign.labelBlocks.item(i).reportLink){
                    var oldID = reportdesign.labelBlocks.item(i).reportLink.reportID;
                    if(idMap.containsKey(oldID)){
                        reportdesign.labelBlocks.item(i).reportLink.reportID = idMap.getValue(oldID);
                        needChange = true;
                    }
                }
            }
            for(var i = 0; i < reportdesign.mapBlocks.count(); i++){
                if(reportdesign.mapBlocks.item(i).reportLink){
                    var oldID = reportdesign.mapBlocks.item(i).reportLink.reportID;
                    if(idMap.containsKey(oldID)){
                        reportdesign.mapBlocks.item(i).reportLink.reportID = idMap.getValue(oldID);
                        needChange = true;
                    }
                }
            }
            for(var i = 0; i < reportdesign.buttonBlocks.count(); i++){
                var buttonBlock = reportdesign.buttonBlocks.item(i);
                if(buttonBlock.reportLink){
                    var oldID = buttonBlock.reportLink.reportID;
                    if(idMap.containsKey(oldID)){
                        buttonBlock.reportLink.reportID = idMap.getValue(oldID);
                        needChange = true;
                    }
                }
                for(var j = 0; j < buttonBlock.subReports.count(); j++){
                    var subReport = buttonBlock.subReports.item(j);
                    if(idMap.containsKey(subReport.subReportID)){
                        subReport.subReportID = idMap.getValue(subReport.subReportID);
                    }
                }
            }

            //报表私有资源文件
            //1、上传文件
            var reportResources = resourceMap[idMapReversal.getValue(report.reportID)];
            for(var i = 0; i < reportResources.length; i++){
                var resourceObj = reportResources[i];
                var resource = new FormData();
                resource.append(name="file",value=resourceObj.blob,fileName=resourceObj.name);
                report.uploadResource(resource,false,function(){},function(){ });
            }
            //2、替换报表里面的ID
            reportdesign.fillBlocks();
            for(var i = 0; i < reportdesign.pcPages.count(); i++){
                if(ChangeReportImage(reportdesign.pcPages.item(i).pageImage, report.reportID)) needChange = true;
            }
            for(var i = 0; i < reportdesign.padPages.count(); i++){
                if(ChangeReportImage(reportdesign.padPages.item(i).pageImage, report.reportID)) needChange = true;
            }
            for(var i = 0; i < reportdesign.mobilePages.count(); i++){
                if(ChangeReportImage(reportdesign.mobilePages.item(i).pageImage, report.reportID)) needChange = true;
            }
            for(var i = 0; i < reportdesign.blocks.length; i++){
                var block = reportdesign.blocks[i];
                if(ChangeReportImage(block.titleIcon, report.reportID)) needChange = true;
                if(ChangeReportImage(block.backgroundImage, report.reportID)) needChange = true;
                if(block instanceof ButtonBlock){
                    if(ChangeReportImage(block.icon, report.reportID)) needChange = true;
                    if(ChangeReportImage(block.image, report.reportID)) needChange = true;
                    if(ChangeReportImage(block.selectedImage, report.reportID)) needChange = true;
                }
                if(block instanceof TabControlBlock){
                    var tabHeads = block.tabHeads;
                    if(ChangeReportImage(tabHeads.icon, report.reportID)) needChange = true;
                    if(ChangeReportImage(tabHeads.backgroundImage, report.reportID)) needChange = true;
                    if(ChangeReportImage(tabHeads.selectedBackgroundImage, report.reportID)) needChange = true;
                }
                if(block instanceof LabelBlock){
                    for(var j = 0; j < block.images.count(); j++){
                        if(ChangeReportImage(block.images.item(j), report.reportID)) needChange = true;
                    }
                }
                if(block instanceof ChartBlock){
                    if(ChangeReportImage(block.picture, report.reportID)) needChange = true;
                }
            }
            if(needChange == true){
                
                selectedReports.editItem(report, false, function(){}, function(){}, "?forceModify=1");
            }

        }
        updateReportResourceSucc = true;
        importItems();
    }
    function ChangeReportImage(reportImage, reportID){
        if(reportImage != null && reportImage.imageID != "-1"){
            if(reportImage.imageID  == "0"){
                reportImage.imageURL = reportImage.imageURL.replace(idMapReversal.getValue(reportID), reportID);
            }else{
                reportImage.imageID = "0";
                reportImage.imageURL = "resource/report/private/" + reportID + "/" + reportImage.imageName;
            }
            return true;
        }
        return false;
    }
    function getReportFolderByName(folders, name){
        for(var i = 0; i < folders.length; i++){
            if(folders[i].folderName == name){
                return folders[i];
            }
        }
        return null;
    }
    //#endregion
    
    
    
}();