/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-04-27 10:33:37
 * @LastEditTime: 2021-04-29 17:11:38
 * @LastModifyUser: 
 * @Remark: 
 */
!function () {
    var $ = layui.jquery, table = layui.table, laypage = layui.laypage;
    var reportSubscriptionController = new ReportSubscriptionController();
    var layerIndex = null, formSubmit = null, mTableBodyData = [], mSortBodyData = [], currentTableBodyData = [];
    var subScriptionReports = new Reports();
    var subscriptionableReports = new Reports();
    var mLimit = 20;
    var mCurrentPage = 1;

    window.initSubscriptionForm = function (index, addSubscription) {
        layerIndex = index;
        formSubmit = addSubscription;

        initSubscriptionHead();
        getSubscribedReportAndSubscriptionableReport();
        bindEvent();
    };

    function initSubscriptionHead() {
        var tableHead = [
            [
                { type: "checkbox" },
                { field: "reportName", title: "报表名称", sort: true },
                { field: "sourceOrganizationName", title: "所属组织", sort: true },
                { field: "description", title: "描述", sort: true }
            ]
        ];

        table.render({
            elem: '#subscriptionList',
            height: 370,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getSubscribedReportAndSubscriptionableReport() {
        var succ = function (data) {
            subScriptionReports.setReports(data);
            getSubscriptionableReport();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取已订阅报表列表", errorStatus, msg);
        };
        reportSubscriptionController.getSubscribedReport(true, succ, fail);
    }

    function getSubscriptionableReport() {
        var succ = function (data) {
            subscriptionableReports.setReports(data);
            loadReportList(); 
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取可订阅报表列表", errorStatus, msg);
        };
        reportSubscriptionController.getSubscriptionableReport(true, succ, fail);
    }

    function loadReportList() {
        mTableBodyData = setTableBody();
        mSortBodyData = mTableBodyData;
        setTablePage(mTableBodyData);
        $Utils.loading.close();
    }

    function setTableBody() {
        var tableBodyData = [];
        for (var i = 0; i < subscriptionableReports.count; i++) {
            var tempObj = {};
            for (var key in subscriptionableReports.item(i)) {
                if (typeof subscriptionableReports.item(i)[key] === "function") { continue; }
                tempObj[key] = subscriptionableReports.item(i)[key];
            }
            tempObj.subscriptionType = 0;
            tableBodyData.push(tempObj);
        }
        for (var i = 0; i < subScriptionReports.count; i++) {
            var tempObj = {};
            for (var key in subScriptionReports.item(i)) {
                if (typeof subScriptionReports.item(i)[key] === "function") { continue; }
                tempObj[key] = subScriptionReports.item(i)[key];
            }
            tempObj.subscriptionType = 1;
            tableBodyData.push(tempObj);
        }
        return tableBodyData;
    }

    function setTablePage(data) {
        laypage.render({
            elem: "subscriptionPageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function (obj, first) {
                $(".subscription-top .count-page").html("显示 " + (obj.curr * obj.limit - obj.limit + 1) + " 到 " + ((obj.curr * obj.limit) > data.length ? data.length : (obj.curr * obj.limit)) + " ，共 " + data.length + " 条记录");
                mLimit = obj.limit;
                loadTableBody(data, obj);
            }
        });
    }

    function loadTableBody(tableBodyData, obj) {
        currentTableBodyData = tableBodyData.concat().splice(obj.curr * obj.limit - obj.limit, obj.limit);
        table.reload("subscriptionList", { data: currentTableBodyData, limit: currentTableBodyData.length, done: function (res){
            for (var i = 0; i < res.data.length; i++){
                if (res.data[i].subscriptionType == 1){
                    $(".subscription-list .layui-table tr[data-index=" + i + "] input[type='checkbox']").prop('disabled', true);
                    $(".subscription-list .layui-table tr[data-index=" + i + "] input[type='checkbox']").next().addClass('layui-btn-disabled');
                }
            }
        }});
    }

    function bindEvent() {
        table.on('sort(subscriptionList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if (type === 'asc') { //升序
                thisData = $Utils.sorter(data, field);
            } else if (type === 'desc') { //降序
                thisData = $Utils.sorter(data, field, true);
            } else { //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });

        $(".search-button").click(function () {
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if (searchValue == "") {
                searchData = mTableBodyData;
            } else {
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        table.on("tool(subscriptionList)", function (obj) {
            if (obj.event == "subscribe") {
                subscribeReport(obj); 
            }
        });

        $(".layui-btn-cancel").click(function () {
            layer.close(layerIndex);
        });

        $(".subscription-submit").click(function () {
            if(change()){
                submitSubscription();
            }else{
                layer.close(layerIndex);
            }
        });
    }

    function setSearchData(searchValue) {
        var tempArr = [];
        for (var i = 0; i < mTableBodyData.length; i++) {
            if (mTableBodyData[i].reportName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
                mTableBodyData[i].sourceOrganizationName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
                (mTableBodyData[i].description && (mTableBodyData[i].description.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))) {
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function subscribeReport(currentIDs) {
        var succ = function () {
            currentIDs.splice(0, 1);
            if (currentIDs.length > 0) {
                subscribeReport(currentIDs);
            } else {
                $Utils.loading.close();
                layer.close(layerIndex);
                layer.msg("订阅成功。", { icon: 1 });
                formSubmit();
            }
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("订阅报表", errorStatus, msg);
        };
        reportSubscriptionController.subscribeReport(currentIDs[0], true, succ, fail);
    }

    function change(){
        var selectedArr = table.checkStatus("subscriptionList").data;
        var originalIDs = [];
        for (var i = 0; i < subScriptionReports.count; i++){
            if(originalIDs.indexOf(subScriptionReports.item(i).reportID) == -1){
                originalIDs.push(subScriptionReports.item(i).reportID);
            }
        }
        var currentIDs = [];
        for(var i = 0; i < selectedArr.length; i++){
            if(selectedArr[i].subscriptionType == 0){
                currentIDs.push(selectedArr[i].reportID);
            }
        }

        for(var i = 0; i < currentIDs.length; i++){
            if(originalIDs.indexOf(currentIDs[i]) == -1){
                return true;
            }
        }

        return false;
    }

    function submitSubscription() {
        var selectedArr = table.checkStatus("subscriptionList").data;
        var currentIDs = [];
        for (var i = 0; i < selectedArr.length; i++) {
            if (selectedArr[i].subscriptionType == 0) {
                currentIDs.push(selectedArr[i].reportID);
            }
        }

        $Utils.loading.open();
        var succ = function () {
            currentIDs.splice(0,1);
            if(currentIDs.length > 0){
                subscribeReport(currentIDs);
            } else {
                $Utils.loading.close();
                layer.close(layerIndex);
                layer.msg("订阅成功。", { icon: 1 });
                formSubmit();
            }
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("订阅报表", errorStatus, msg);
        };
        reportSubscriptionController.subscribeReport(currentIDs[0], true, succ, fail);
    }

}();