/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-19 17:10:39
 * @LastEditTime: 2021-03-30 17:32:35
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer;
    var resourceFiles = new ResourceFiles();
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - $(".header-box").outerHeight() - 142;

    $Utils.loading.open();
    initMain();

    function initMain(){
        getAndLoadTree();

        bindEvent();

        $(".resource-file-list").height(tableBodyHeight);
        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 142 - $(".header-box").outerHeight();
            $(".resource-file-list").height(tableBodyHeight);
        });
    }

    function getAndLoadTree(){
        var succ = function(){
            $Utils.loading.close();
            loadTree();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取资源文件列表",errorStatus,msg);
		};
		resourceFiles.getItems(true,succ,fail);
    }

    function loadTree(){
        $(".resource-file-list > ul").html("");
        var treeData = setTreeData();
        for(var i = 0; i < treeData.length; i++){
            if(treeData[i].type == 0){
                var str = "<li class='folder' data-id="+treeData[i].id+" data-type="+treeData[i].type+" title='"+treeData[i].name+"'><label><span></span></label><div><i class='iconfont bda-wenjianjia'></i>"+treeData[i].name+"</div><ul style='display:none;'></ul></li>";
				$(".resource-file-list > ul").append(str);
				if(treeData[i].children){
					createChildrenMenu(treeData[i].children,$(".resource-file-list > ul"));
				}
            }else{
                var str = "<li class='file' data-id="+treeData[i].id+" data-type="+treeData[i].type+" title='"+treeData[i].name+"'><div><i class='iconfont bda-wenjian'></i>"+treeData[i].name+"</div></li>";
				
				$(".resource-file-list > ul").append(str);
            }
        }
    }

    function createChildrenMenu(menuArr,elem){
		for(var i = 0; i < menuArr.length; i++){
			if(menuArr[i].type == 0){
				var str = "<li class='folder' data-id="+menuArr[i].id+" data-type="+menuArr[i].type+" title='"+menuArr[i].name+"'><label><span></span></label><div><i class='iconfont bda-wenjianjia'></i>"+menuArr[i].name+"</div><ul style='display:none;'></ul></li>";
				elem.find("li").each(function(){
					if($(this).attr("data-id") == menuArr[i].folderID){
						$(this).children("ul").append(str);
					}
				});
				if(menuArr[i].children){
					createChildrenMenu(menuArr[i].children,elem);
				}
			}else{
                var str = "<li class='file' data-id="+menuArr[i].id+" data-type="+menuArr[i].type+" title='"+menuArr[i].name+"'><div><i class='iconfont bda-wenjian'></i>"+menuArr[i].name+"</div></li>";
				
				elem.find("li").each(function(){
					if($(this).attr("data-id") == menuArr[i].folderID){
						$(this).children("ul").append(str);
					}
				});
			}
        }
	}

    function setTreeData(){
        var filesHashTable = new HashTable();
        filesHashTable.add("-1",{name:"资源文件",folderParentID:"-1",folderID:"-1"});
        for(var i = 0; i < resourceFiles.count; i++){
            filesHashTable.add(resourceFiles.item(i).id,{name: resourceFiles.item(i).fileName, id: resourceFiles.item(i).id, type: resourceFiles.item(i).fileType, folderID: resourceFiles.item(i).folderID});
        }
        for(var i = 0; i < resourceFiles.count; i++){
            var parentFile = filesHashTable.getValue(resourceFiles.item(i).folderID);
            if(!parentFile.children){
                parentFile.children = [];
            }
            parentFile.children.push(filesHashTable.getValue(resourceFiles.item(i).id));
        }
        return filesHashTable.getValue("-1").children;
    }

    function bindEvent(){
        
        $(".upload").click(function(){
            getAndLoadFileForm();
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTree();
        });

        $(".download").click(function(){
            if($(".resource-file-list li.select-value").length > 0 ){
                var arr = [];
                if($(".resource-file-list li.select-value").attr("data-id") == "-1"){
                    arr.push("/");
                }else{
                    if($(".resource-file-list li.select-value").parents("li").length > 0){
                        parentPath($(".resource-file-list li.select-value"),arr);
                    }
                }
                var path = (arr.reverse()).join("");
                downloadFile($(".resource-file-list li.select-value").attr("title"),path);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        treeEvent();
    }    

    function parentPath(elem,arr){
        if(elem.parent().parent("li").attr("data-id") == "-1"){
            arr.push("/");
        }else{
            arr.push(elem.parent().parent("li").attr("title")+"/");
        }
        if(elem.parent().parent("li").parents("li").length > 0){
            parentPath(elem.parent().parent("li"),arr);
        }
    }

    function downloadFile(fileName, path){
        var imgURL = $AppConstants.hostName + $AppConstants.port + "/Report/resource/report/custom/" + path + fileName
        download(imgURL);
    }

    function treeEvent(){
        $(".resource-file-list ul").on("click","label",function(){
            if($(this).siblings("ul").is(":hidden")){
                $(this).siblings("ul").show(200);
                $(this).parent("li").addClass("select-folder");
            }else{
                $(this).siblings("ul").hide(200);
                $(this).parent("li").removeClass("select-folder");
            }
        });

        $(".resource-file-list ul").on("click","div",function(){
            if(!$(this).parent("li").hasClass("select-value")){
                $(".resource-file-list ul li").removeClass("select-value");
                $(this).parent("li").addClass("select-value");
            }
        });
    }

    function getAndLoadFileForm(){
        $.ajax({
            url: "html/iReport/resourceFile/resourceFile.html",
            type: 'GET',
            success: function(data){
                loadFileForm(data);
            }
        });
    }

    function loadFileForm(strHtml){
        layer.open({
            type: 1,
            title: ["上传资源文件","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initFileForm(resourceFiles,index,closeCallBack);
            },
            cancel: function(index, layero){
                closeCallBack();
            }
        });
    }

    window.closeCallBack = function(){
        getAndLoadTree();
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.a = entry;
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }
}();