/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-11-25 15:47:49
 * @LastEditTime: 2021-03-31 14:57:35
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table;
    var mResourceFiles = null, layerIndex = null, mCloseCallBack = null;
    var tableBodyData = [];
    var filesData = [];
    var filePathStr = "/";
    
    window.initFileForm = function(resourceFiles,index,closeCallBack){
        mResourceFiles = resourceFiles;
        layerIndex = index;
        mCloseCallBack = closeCallBack;

        init();
    };

    function init(){
        
        $("#testList").click(function(){
            $("#uploadFile").click();
        });
        
        $("#uploadFile").change(function(e) {
            
            Object.values = function(obj){
                return Object.keys(obj).map(function(e){
                    return obj[e];
                });
            };
            var files = Object.values(e.target.files);
            loadTable(files);
        });

        $(".reset-select").on("click",function(){
            layer.open({
                type: 1,
                title: ["选择目标路径","font-size: 14px"],
                btn: ['确定','取消'],
                resize: false,
                area: ["375px","500px"],
                content: '<div class="resource-src"><ul></ul></div>',
                success: function(layero,index){
                    initSrcList();
                },
                yes: function(index,layero){
                    savePath();
                    layer.close(index);
                }
            });
        });

        $(".resource-file-box .form-submit button").on("click",function(){
            layer.close(layerIndex);
            mCloseCallBack();
        });
        
        initTable();

        tableEvent();
    }

    function initTable(){
        var tableHead = [
            [
                {field: "fileName",title:"文件名"},
                {field: "size",title: "大小", width: 150},
                {field: "status",title: "状态", templet: "#statues", width: 125},
                {title: "操作",templet: "#operation", width: 120, align: "center"}
            ]
        ];
        table.render({
            elem: '#fileList',
            height: 410,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: tableBodyData.length
        });
    }

    function loadTable(data){
        filesData = filesData.concat(data);
        var tempArr = [];
        for(var i = 0; i < data.length; i++){
            var isRepeat = false;
            for(var j = 0; j < tableBodyData.length; j++){
                if(tableBodyData[j].fileName === data[i].name){
                    isRepeat = true;
                    break;
                }
            }
            if(!isRepeat){
                var obj = {};
                obj.fileName = data[i].name;
                obj.size = (data[i].size/1024).toFixed(1)+"kb";
                obj.status = 0;
                tempArr.push(obj);
            }
        }
        tableBodyData = tableBodyData.concat(tempArr);

        table.reload("fileList",{data:tableBodyData,limit:tableBodyData.length});
        
    }

    function tableEvent(){
        table.on("tool(resourceFileList)",function(obj){
            if(obj.event === 'continueUpload'){
                uploadFile(obj);
            }else if(obj.event === 'del'){
                deleteFile(obj);
            }else if(obj.event === 'upload'){
                uploadFile(obj);
            }
        });

        $("#testListAction").on("click",function(){
            for(var i = 0; i < tableBodyData.length; i++){
                if(tableBodyData[i].status == 0){
                    $(".layui-upload-list .layui-table-body tr").each(function(){
                        if($(this).attr("data-index") == i){
                            $(this).find("td:last-child").find("a:last-child").trigger("click");
                            return false;
                        }
                    });
                }
            }
        });
    }

    function deleteFile(obj){
        for(var i = 0; i < tableBodyData.length; i++){
            if(tableBodyData[i].fileName === obj.data.fileName){
                tableBodyData.splice(i,1);
            }
        }
        for(var i = 0; i < filesData.length; i++){
            if(filesData[i].name === obj.data.fileName){
                filesData.splice(i,1);
            }
        }
        obj.del();
    }

    function uploadFile(obj){
        var fileObj = null;
        for(var i = 0; i < filesData.length; i++){
            if(filesData[i].name === obj.data.fileName){
                fileObj = filesData[i];
                break
            }
        }
        var file = new FormData();
        file.append("file", fileObj);
        file.append("path", "resource/report/custom"+filePathStr);
        var succ = function(){
            //
            obj.update({
                "status": 1
            });
            changeTableBodyStatus(obj,1);
            hideContinueUpload(obj);
		};
		var fail = function(errorStatus,msg){
			// $Utils.openWindow.failWindow("上传图片",errorStatus,msg);
            obj.update({
                "status": 2
            });
            changeTableBodyStatus(obj,2);
            showContinueUpload(obj);
        };
        mResourceFiles.addItem(file,true,succ,fail);
    }

    function changeTableBodyStatus(obj,status){
        for(var i = 0; i < tableBodyData.length; i++){
            if(tableBodyData[i].fileName === obj.data.fileName){
                tableBodyData[i].status = status;
            }
        }
    }

    function showContinueUpload(obj){
        for(var i = 0; i < tableBodyData.length; i++){
            if(tableBodyData[i].fileName === obj.data.fileName){
                $(".layui-upload-list .layui-table-body tr").each(function(){
                    if($(this).attr("data-index") == i){
                        $(this).find("td:last-child").find("a:first-child").show();
                        return false;
                    }
                });
                break;
            }
        }
    }

    function hideContinueUpload(obj){
        for(var i = 0; i < tableBodyData.length; i++){
            if(tableBodyData[i].fileName === obj.data.fileName){
                $(".layui-upload-list .layui-table-body tr").each(function(){
                    if($(this).attr("data-index") == i){
                        $(this).find("td:last-child").find("a").hide();
                        return false;
                    }
                });
                break;
            }
        }
    }

    function initSrcList(){
        var foldersHashTable = new HashTable();
        foldersHashTable.add("-1",{name:"文件根目录",id: "-1",folderParentID:"-1",folderID:"-1"});
        for(var i = 0; i < mResourceFiles.count; i++){
            if(mResourceFiles.item(i).fileType == 0){
                foldersHashTable.add(mResourceFiles.item(i).id,{name: mResourceFiles.item(i).fileName, id: mResourceFiles.item(i).id, type: mResourceFiles.item(i).fileType, folderID: mResourceFiles.item(i).folderID});
            }
        }
        for(var i = 0; i < mResourceFiles.count; i++){
            if(mResourceFiles.item(i).fileType == 0){
                var parentFolder = foldersHashTable.getValue(mResourceFiles.item(i).folderID);
                if(!parentFolder.children){
                    parentFolder.children = [];
                }
                parentFolder.children.push(foldersHashTable.getValue(mResourceFiles.item(i).id));
            }
        }
        createForlderList([foldersHashTable.getValue("-1")]);
        bindTreeEvent();
    }

    function createForlderList(data){
        $(".resource-src > ul").html("");
        for(var i = 0; i < data.length; i++){
            if(data[i].children && data[i].children.length > 0){
                var str = "<li class='folder select-folder' data-id="+data[i].id+" title="+data[i].name+"><label><span></span></label><div><i class='iconfont bda-wenjianjia'></i>"+data[i].name+"</div><ul></ul></li>";
            }else{
                var str = "<li class='folder' data-id="+data[i].id+" title="+data[i].name+"><div><i class='iconfont bda-wenjianjia'></i>"+data[i].name+"</div></li>";
            }
            $(".resource-src > ul").append(str);
            if(data[i].children){
                createChildrenTree(data[i].children,$(".resource-src > ul"));
            }
        }
    }

    function createChildrenTree(menuArr,elem){
		for(var i = 0; i < menuArr.length; i++){
            if(menuArr[i].children && menuArr[i].children.length > 0){
                var str = "<li class='folder' data-id="+menuArr[i].id+" title="+menuArr[i].name+"><label><span></span></label><div><i class='iconfont bda-wenjianjia'></i>"+menuArr[i].name+"</div><ul style='display:none;'></ul></li>";
            }else{
                var str = "<li class='folder' data-id="+menuArr[i].id+" title="+menuArr[i].name+"><div><i class='iconfont bda-wenjianjia'></i>"+menuArr[i].name+"</div><ul></ul></li>";
            }
            elem.find("li").each(function(){
                if($(this).attr("data-id") == menuArr[i].folderID){
                    $(this).children("ul").append(str);
                }
            });
            if(menuArr[i].children){
                createChildrenTree(menuArr[i].children,elem);
            }
        }
    }
    
    function bindTreeEvent(){
        $(".resource-src ul").on("click","label",function(){
            if($(this).siblings("ul").is(":hidden")){
                $(this).siblings("ul").show(200);
                $(this).parent("li").addClass("select-folder");
            }else{
                $(this).siblings("ul").hide(200);
                $(this).parent("li").removeClass("select-folder");
            }
        });

        $(".resource-src ul").on("click","div",function(){
            if(!$(this).parent("li").hasClass("select-value")){
                $(".resource-src ul li").removeClass("select-value");
                $(this).parent("li").addClass("select-value");
            }
        });
    }

    function savePath(){
        var arr = [];
        if($(".resource-src li.select-value").length > 0){
            if($(".resource-src li.select-value").attr("data-id") == "-1"){
                arr.push("/");
            }else{
                arr.push($(".resource-src li.select-value").attr("title")+"/");
            }
        }else{
            arr.push("/");
        }
        if($(".resource-src li.select-value").parents("li").length > 0){
            parentPath($(".resource-src li.select-value"),arr);
        }
        filePathStr = (arr.reverse()).join("");
        $(".resource-file-box .top input[name=fileName]").val(filePathStr);
    }

    function parentPath(elem,arr){
        if(elem.parent().parent("li").attr("data-id") == "-1"){
            arr.push("/");
        }else{
            arr.push(elem.parent().parent("li").attr("title")+"/");
        }
        if(elem.parent().parent("li").parents("li").length > 0){
            parentPath(elem.parent().parent("li"),arr);
        }
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.a = entry;
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }
}()