function ReportFolder(){
    var me = this;
    this.folderID = null;
    this.folderName = null;
    this.folderParentID = null;
    this.organizationID = null;
    this.createUserID = $AppVars.gUser.userID;
    this.createUserName = $AppVars.gUser.userName;
    this.createDate = (new Date()).getTime();
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
    
    this.getItemByID = function(folderID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath + "/" + folderID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}

function ReportFolders(){
	var me = this;
    this.count = 0;
    this.aryReportFolders = [];
    this.dicReportFolders = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryReportFolders[indexOrKey];
        }else{
            return this.dicReportFolders[indexOrKey];
        }
    };
    this.add = function (reprortFolder) {
        this.aryReportFolders.push(reprortFolder);
        this.dicReportFolders[reprortFolder.folderID] = reprortFolder;
        this.count = this.aryReportFolders.length;
    };
    this.remove = function (reprortFolder) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryReportFolders[i].folderID==reprortFolder.folderID){
                k = i;
                break;
            }
        }
        this.aryReportFolders.splice(k,1);
        delete this.dicReportFolders[reprortFolder.folderID];
        this.count = this.aryReportFolders.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setReprortFolders(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(folder,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath;
        var obj = JSON.stringify(folder);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var folderID = request.getResponseHeader('location').split('/reportFolders/')[1];
                folder.folderID = folderID;
                me.add(folder);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(folder,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath + "/" + folder.folderID;
        var obj = JSON.stringify(folder);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(folderID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath + "/" + folderID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(folderID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setReprortFolders(data){
        me.count = 0;
        me.aryReportFolders = [];
        me.dicReportFolders = {};
        for(var i = 0; i < data.length; i++){
            var reportFolder = new ReportFolder();
            reportFolder.init(data[i]);
            me.add(reportFolder);
        }
    }
}

function ReportPublish() {
    var me = this;
    this.reportID = null;
    this.organizationID = null;
    this.publishType = null;
    this.publishStatus = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = null;
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;

    this.rpDestinationOrganizations = new RpDestinationOrganizations();

    this.init = function (options) {
        for (var key in options) {
            if (key == "rpDestinationOrganizations") {
                this[key].setRpDestinationOrganizations(options[key]);
            } else {
                this[key] = options[key];
            }
        }
    };

    this.getItemByID = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportPublishesPath + "/" + this.reportID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
}

function ReportPublishes() {
    var me = this;
    this.count = 0;
    this.aryReportPublishes = [];
    this.dicReportPublishes = {};

    this.add = function (reportPublish) {
        this.aryReportPublishes.push(reportPublish);
        this.dicReportPublishes[reportPublish.reportID] = reportPublish;
        this.count = this.aryReportPublishes.length;
    };
    this.remove = function (reportPublish) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryReportPublishes[i].reportID == reportPublish.reportID) {
                k = i;
                break;
            }
        }
        this.aryReportPublishes.splice(k, 1);
        delete this.dicReportPublishes[reportPublish.reportID];
        this.count = this.aryReportPublishes.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryReportPublishes[indexOrKey];
        } else {
            return this.dicReportPublishes[indexOrKey];
        }
    };
    this.addItem = function (businessModel, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportPublishesPath;
        var obj = JSON.stringify(businessModel);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (reportPublish, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportPublishesPath + "/" + reportPublish.reportID;
        var obj = JSON.stringify(reportPublish);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getItems = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportPublishesPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setReportPublishes(data.items);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    function setReportPublishes(data) {
        me.count = 0;
        me.aryReportPublishes = [];
        me.dicReportPublishes = {};
        for (var i = 0; i < data.length; i++) {
            var reportPublish = new ReportPublish();
            reportPublish.init(data[i]);
            me.add(reportPublish);
        }
    }
}

function RpDestinationOrganization() {
    this.reportID = null;
    this.destinationOrganizationID = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
}

function RpDestinationOrganizations() {
    var me = this;
    this.count = 0;
    this.aryRpDestinationOrganizations = [];
    this.dicRpDestinationOrganizations = {};

    this.add = function (rpDestinationOrganization) {
        this.aryRpDestinationOrganizations.push(rpDestinationOrganization);
        this.dicRpDestinationOrganizations[rpDestinationOrganization.destinationOrganizationID] = rpDestinationOrganization;
        this.count = this.aryRpDestinationOrganizations.length;
    };
    this.remove = function (rpDestinationOrganization) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryRpDestinationOrganizations[i].destinationOrganizationID == rpDestinationOrganization.destinationOrganizationID) {
                k = i;
                break;
            }
        }
        this.aryRpDestinationOrganizations.splice(k, 1);
        delete this.dicRpDestinationOrganizations[rpDestinationOrganization.destinationOrganizationID];
        this.count = this.aryRpDestinationOrganizations.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryRpDestinationOrganizations[indexOrKey];
        } else {
            return this.dicRpDestinationOrganizations[indexOrKey];
        }
    };
    this.setRpDestinationOrganizations = function (data) {
        me.count = 0;
        me.aryRpDestinationOrganizations = [];
        me.dicRpDestinationOrganizations = {};
        for (var i = 0; i < data.length; i++) {
            var rpDestinationOrganization = new RpDestinationOrganization();
            rpDestinationOrganization.init(data[i]);
            me.add(rpDestinationOrganization);
        }
    }
}

function Report(){
    var me = this;
    this.reportID = null;
    this.reportName = null;
    this.folderID = null;
    this.createUserID = $AppVars.gUser.userID;
    this.createUserName = $AppVars.gUser.userName;
    this.createDate = (new Date()).getTime();
    this.createSource = 0;
    this.lastModifyUserID = $AppVars.gUser.userID;
    this.lastModifyUserName = $AppVars.gUser.userName;
    this.lastModifyDate = null;
    this.reportSettings = null;
    this.reportDesign = {};

    this.sourceType = null; //来源类型；0本组织创建，1从其它组织订阅
    this.sourceReportID = null;
    this.sourceOrganizationID = null;
    this.sourceOrganizationName = null;
    this.publishStatus = null;  // -1：订阅；0：未发布；1：已发布；2：发布且停止

    this.getItemByID = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID + "/simpleProperties";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getReleaseDevices = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID + "/reportVisibilities";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateRelease = function(reportID,parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID + "/reportVisibilities?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function Reports(){
    var me = this;
    this.count = 0;
    this.aryReports = [];
    this.dicReports = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryReports[indexOrKey];
        }else{
            return this.dicReports[indexOrKey];
        }
    };
    this.add = function (report) {
        this.aryReports.push(report);
        this.dicReports[report.reportID] = report;
        this.count = this.aryReports.length;
    };
    this.remove = function (report) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryReports[i].reportID==report.reportID){
                k = i;
                break;
            }
        }
        this.aryReports.splice(k,1);
        delete this.dicReports[report.reportID];
        this.count = this.aryReports.length;
    };
    this.getItemsByFolderID = function(folderID,moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "?folderID=" + folderID + "&moduleID=" + moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.setReports(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(report,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath;
        var obj = JSON.stringify(report);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var reportID = request.getResponseHeader('location').split('/reports/')[1];
                report.reportID = reportID;
                me.add(report);
                succ(reportID);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(report,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + report.reportID;
        var obj = JSON.stringify(report);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editSimpleProperty = function(report,parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + report.reportID + "/simpleProperties?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.item(report.reportID).reportName = report.reportName;
                me.item(report.reportID).folderID = report.folderID;
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(reportID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.setReports(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getUsedCount = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.modelReportsPath + "/count?modelID="+businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.property);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(textStatus == "timeout"){
                fail("请求超时。");
            }
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.setReports = function(data){
        me.count = 0;
        me.aryReports = [];
        me.dicReports = {};
        for(var i = 0; i < data.length; i++){
            var report = new Report();
            report.init(data[i]);
            me.add(report);
        }
    }
}

function ReportDesign(){
    this.pcPages = [];
    this.padPages = [];
    this.mobilePages = [];

    this.padLayoutChanged = false;
    this.mobileLayoutChanged = false;

    this.chartBlocks = [];
    this.verticalTableBlocks = [];
    this.horizontalTableBlocks = [];
    this.foldingTableBlocks = [];
    this.pivotTableBlocks = [];
    this.tileBlocks = [];
    this.gaugeBlocks = [];
    this.mapBlocks = [];
    this.labelBlocks = [];
    this.reportContainerBlocks = [];
    this.buttonBlocks = [];
    this.equipmentBlocks = [];
    this.ganttBlocks = [];

    this.blocks = [];

    this.queries = [];
    this.selects = [];

    this.dataObjects = [];

    this.dynamicOfficeCreator = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    }
}

function ReportSetting(){
    this.reportSettingKey = null;
    this.reportSettingValue = null;
}

function ReportSubscriptionController() {
    this.getSubscribedReport = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/reportSubscriptions";
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                succ(data.items);
            }
        };
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getSubscriptionableReport = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/subscriptionableReport";
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                succ(data.items);
            }
        };
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.subscribeReport = function (reportID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/reports/" + reportID + "/subscription";
        var obj = "";
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
}