!function () {
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var reportFolders = new ReportFolders();
    var reports = new Reports();
    var mFolderID = null;
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var isFirst = true;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var isSubscriptioned = false;

    $Utils.loading.open();
    initMain();

    function initMain() {
        if ($AppVars.serverEdition != 2) {
            $(".group-function-button").remove();
        }
        initTableHead();
        getAndLoadFoldersMenus();
        treeEvent();
        bindTableEvent();
    }

    function getAndLoadFoldersMenus() {
        var succ = function () {
            getReportLists();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取报表文件列表", errorStatus, msg);
        };
        reportFolders.getItems(true, succ, fail);
    }

    function getReportLists() {
        var succ = function () {
            $Utils.loading.close();
            loadMenus();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取报表列表", errorStatus, msg);
        };
        reports.getItems(3, true, succ, fail);
    }

    function loadMenus() {
        $(".report-folder-tree > ul").html("");
        var folderArr = setFolderTree();
        for (var i = 0; i < folderArr.length; i++) {
            var str = "<li class='folder folder-hide' data-folderid=" + folderArr[i].folderID + "><div title=" + folderArr[i].name + "><i class='iconfont bda-wenjianjia'></i><span>" + folderArr[i].name + "</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>";
            $(".report-folder-tree > ul").append(str);
            if (folderArr[i].children) {
                createChildrenMenu(folderArr[i].children);
            }
        }
        if(isFirst){
            isFirst = false;
            $(".report-folder-tree > ul > li:first-child > div").trigger("click");
        }else{
            clickTargetFolderEvent();
        }
    }

    function createChildrenMenu(menuArr) {
        for (var i = 0; i < menuArr.length; i++) {
            var str = "<li class='folder folder-hide' data-folderid=" + menuArr[i].folderID + "><div title=" + menuArr[i].name + "><i class='iconfont bda-wenjianjia'></i><span>" + menuArr[i].name + "</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>";
            $(".report-folder-tree > ul").find("li").each(function () {
                if ($(this).attr("data-folderid") == menuArr[i].folderParentID) {
                    $(this).children("ul").append(str);
                }
            });
            if (menuArr[i].children) {
                createChildrenMenu(menuArr[i].children);
            }
        }
    }

    function setFolderTree() {
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1", { name: "组织分析", folderID: "-1", folderParentID: "-1" });
        for (var i = 0; i < reportFolders.count; i++) {
            hashTable.add(reportFolders.item(i).folderID, { name: reportFolders.item(i).folderName, folderID: reportFolders.item(i).folderID, folderParentID: reportFolders.item(i).folderParentID });
        }
        for (var i = 0; i < reportFolders.count; i++) {
            var parentFolder = hashTable.getValue(reportFolders.item(i).folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(reportFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function initTableHead() {
        var tableHead = [
            [
                { type: "radio" },
                {field: "reportName", title: "名称", sort: true, templet: function (d) {
                        var str = "";
                        str = "<i class='iconfont bda-shilitubiao'></i>" + d.reportName
                        return str;
                }},
                { field: "folderURL", title: "所属文件夹"},
                // { field: "createUserName", title: "创建者", sort: true },
                // { field: "createDate", title: "创建时间", sort: true, templet: function(d){
                //     if(d.createDate){
                //         return $Utils.formatString.date("YYYY-MM-dd HH:mm", new Date(d.createDate));
                //     }else{
                //         return "";
                //     }
                // }},
                // { field: "lastModifyUserName", title: "修改者", sort: true },
                { field: "lastModifyDate", title: "修改时间", sort: true, width: 130, templet: function(d){
                    if (d.lastModifyDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm", new Date(d.lastModifyDate));
                    }else{
                        return "";
                    }
                }}
            ]
        ];

        if($AppVars.serverEdition == 2){
            var sourceType = {field: "sourceType", title: "来源", sort: true, width: 100, templet: function(d){
                if(d.sourceType == 0){
                    return "本组织创建";
                }else{
                    return "从其它组织订阅";
                }
            }};
            var publishStatus = { field: "publishStatus", title: "发布状态", width: 80, sort: true, templet: function(d){
                if (d.publishStatus == -1){
                    return "-";
                } else if (d.publishStatus == 0){
                    return "未发布";
                } else if (d.publishStatus == 1){
                    return "已发布";
                }else{
                    return "停止发布";
                }
            }};
            tableHead[0].splice(5, 0, sourceType, publishStatus);
        }

        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function treeEvent() {

        $(".report-folder-tree > ul").on("click", "div", function () {
            if ($(this).siblings("ul").is(":hidden")) {
                $(this).siblings("ul").show(200);
                $(".report-folder-tree li").removeClass("click-folder");
                $(this).parent("li").addClass("click-folder");
                $(this).find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
            } else {
                $(this).siblings("ul").hide(200);
                $(this).siblings("ul").find("ul").hide(200);
                $(this).find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
                $(this).siblings("ul").find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
            }
            if ($(this).parents("ul").is(":hidden")) {
                $(this).parents("ul").show(200);
                $(this).parents("ul").siblings("div").find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
            }
            $(this).parent("li").siblings("li").removeClass("click-folder");
            $(this).parent("li").siblings("li").find(".click-folder").removeClass("click-folder");
            $(this).parent("li").find(".click-folder").removeClass("click-folder");
            $(this).parent("li").addClass("click-folder");
            loadReportList($(this).parent("li").attr("data-folderid"));
        });
    }

    function loadReportList(folderID) {
        mFolderID = folderID;
        mTableBodyData = setTableBody(folderID);
        mSortBodyData = mTableBodyData;
        setTablePage(mTableBodyData);
        $Utils.loading.close();
    }

    function setTableBody(folderID) {
        var reportsTableBody = [];
        if (folderID == "-1") {
            for (var i = 0; i < reports.count; i++) {
                var tempObj = {};
                for (var key in reports.item(i)) {
                    if (typeof reports.item(i)[key] === "function") { continue; }
                    tempObj[key] = reports.item(i)[key];
                }
                tempObj.folderURL = setFolderURL(reports.item(i).folderID);
                reportsTableBody.push(tempObj);
            }
        }else{
            var folderIDs = getFolderIDs(folderID);
            for(var i = 0; i < reports.count; i++){
                if (folderIDs.indexOf(reports.item(i).folderID) != -1) {
                    var tempObj = {};
                    for (var key in reports.item(i)) {
                        if (typeof reports.item(i)[key] === "function") { continue; }
                        tempObj[key] = reports.item(i)[key];
                    }
                    tempObj.folderURL = setFolderURL(reports.item(i).folderID);
                    reportsTableBody.push(tempObj);
                }
            }
        }
        return reportsTableBody;
    }

    function setFolderURL(folderID){
        var folderURL = "";
        if(folderID == "-1"){
            return "/组织分析/";
        }else{
            folderURL = reportFolders.item(folderID).folderName + "/";
            folderURL = setParentFolderURL(reportFolders.item(folderID).folderParentID,folderURL);
            return folderURL;
        }
    }

    function setParentFolderURL(folderID, folderURL){
        if(folderID == "-1"){
            folderURL = "/组织分析/" + folderURL
            return folderURL;
        }else{
            folderURL = reportFolders.item(folderID).folderName + "/" + folderURL;
            folderURL = setParentFolderURL(reportFolders.item(folderID).folderParentID, folderURL);
            return folderURL;
        }
    }

    function getFolderIDs(folderID){
        var tempArr = [];
        tempArr.push(folderID);
        if(folderID == "-1"){
            return tempArr;
        }else{
            for(var i = 0; i < reportFolders.count; i++){
                if (reportFolders.item(i).folderParentID == folderID) {
                    tempArr.push(reportFolders.item(i).folderID);
                    return getChildrenFolderID(reportFolders.item(i).folderID, tempArr);
                }
            }
            return tempArr;
        }
    }

    function getChildrenFolderID(folderID, tempArr){
        for (var i = 0; i < reportFolders.count; i++) {
            if (reportFolders.item(i).folderParentID == folderID) {
                tempArr.push(reportFolders.item(i).folderID);
                return getChildrenFolderID(reportFolders.item(i).folderID, tempArr);
            }
        }
        return tempArr;
    }

    function setTablePage(data) {
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function (obj, first) {
                $(".count-page").html("显示 " + (obj.curr * obj.limit - obj.limit + 1) + " 到 " + ((obj.curr * obj.limit) > data.length ? data.length : (obj.curr * obj.limit)) + " ，共 " + data.length + " 条记录");

                mLimit = obj.limit;
                loadTableBody(data, obj);
            }
        });
    }

    function loadTableBody(tableBodyData, obj) {
        $Utils.loading.close();
        currentTableBodyData = tableBodyData.concat().splice(obj.curr * obj.limit - obj.limit, obj.limit);
        table.reload("objectList", { data: currentTableBodyData, limit: currentTableBodyData.length });

        $(window).resize(function () {
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            $(".object-reports-main").css("top", $(".header-box").outerHeight() + 20);
            table.reload("objectList", { height: tableBodyHeight });
        });

        $(".right-main").resize(function () {
            table.reload("objectList", { height: tableBodyHeight });
        });
    }

    function bindTableEvent() {
        $(".button-add .iconfont").click(function(){
            if ($(this).hasClass("sanjiao-up")){
                $(this).removeClass("sanjiao-up");
                $(".button-add .folder-children").show();
            } else {
                $(this).addClass("sanjiao-up");
                $(".button-add .folder-children").hide();
            }
        });

        $(document).click(function (e) {
            var target = $(e.target);
            if (target.closest(".children-sanjiao").length != 0) return;
            $(".button-add .iconfont").addClass("sanjiao-up");
            $(".button-add .folder-children").hide();
        });

        table.on('sort(objectList)', function (obj) {
            var type = obj.type, field = obj.field, data = mSortBodyData, thisData = [];
            if (type === 'asc') { //升序
                thisData = $Utils.sorter(data, field);
            } else if (type === 'desc') { //降序
                thisData = $Utils.sorter(data, field, true);
            } else { //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });

        $(".search-button").click(function () {
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if (searchValue == "") {
                searchData = mTableBodyData;
            } else {
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        table.on("tool(objectList)", function (obj) {
            if (obj.event == "drillDown") {
                mOpenChildFolder(obj.data.folderID);
            }
        });

        table.on('radio(objectList)', function (obj) {
            disabledButton(obj.data.type);
        });

        $(".refresh").click(function () {
            $Utils.loading.open();
            isFirst = true;
            getAndLoadFoldersMenus();
            disabledButton(1);
        });

        $(".add-folder").click(function () {
            var folder = new ReportFolder();
            folder.folderParentID = mFolderID;
            getAndLoadFoldertForm(0, folder);
        });

        $(".add-report").click(function () {
            var report = new Report();
            report.folderID = mFolderID;
            getAndLoadReportForm(0, report);
        });

        $(".copy-report").click(function () {
            if ($(this).prop("disabled") == false) {
                if (table.checkStatus('objectList').data.length) {
                    openCopyReportForm(table.checkStatus('objectList').data[0].reportName, table.checkStatus('objectList').data[0].reportID);
                } else {
                    layer.msg("请选择一条记录。", { icon: 2 });
                }
            }
        });

        $(".edit-report").click(function () {
            if ($(this).prop("disabled") == false) {
                if (table.checkStatus('objectList').data.length) {
                    if (table.checkStatus('objectList').data[0].sourceType == 0){
                        openClientAddAndEdit(table.checkStatus('objectList').data[0].reportID);
                    } else {
                        layer.msg("订阅的报表不能编辑。", { icon: 2 });
                    }
                } else {
                    layer.msg("请选择一条记录。", { icon: 2 });
                }
            }
        });

        $(".attribute-report").click(function () {
            if (table.checkStatus('objectList').data.length && table.checkStatus('objectList').data[0].reportID) {
                var report = reports.item(table.checkStatus('objectList').data[0].reportID);
                getAndLoadReportForm(1, report);
            } else if (table.checkStatus('objectList').data.length && table.checkStatus('objectList').data[0].folderID) {
                var folder = reportFolders.item(table.checkStatus('objectList').data[0].folderID);
                getAndLoadFoldertForm(1, folder);
            } else {
                layer.msg("请选择一条记录。", { icon: 2 });
            }
        });

        $(".attribute-folder").click(function(){
            if (mFolderID != "-1") {
                var folder = reportFolders.item(mFolderID);
                getAndLoadFoldertForm(1, folder);
            }else{
                layer.msg("不能修改根文件夹。", { icon: 2 });
            }
        });

        $(".delete-report").click(function () {
            if (table.checkStatus('objectList').data.length && table.checkStatus('objectList').data[0].reportID) {
                layer.open({
                    type: 0,
                    title: "删除报表",
                    closeBtn: 1,
                    shadeClose: true,
                    resize: false,
                    area: ["480px", "270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 " + table.checkStatus('objectList').data[0].reportName + " ？</div></div>",
                    btn: ["是", "否"],
                    yes: function (index, layero) {
                        layer.close(index);
                        $Utils.loading.open();
                        deleteReport(table.checkStatus('objectList').data[0].reportID);
                    }
                });
            } else if (table.checkStatus('objectList').data.length && table.checkStatus('objectList').data[0].folderID) {
                if (validateFolder(table.checkStatus('objectList').data[0].folderID)) {
                    loadDeleteFolderWindow(table.checkStatus('objectList').data[0].folderID);
                }
            } else {
                layer.msg("请选择一条记录。", { icon: 2 });
            }
        });

        $(".delete-folder").click(function(){
            if (mFolderID != "-1") {
                if (validateFolder(mFolderID)) {
                    loadDeleteFolderWindow(mFolderID);
                }
            }else{
                layer.msg("不能删除根文件夹。", { icon: 2 });
            }
        });

        $(".visibility-report").click(function () {
            if ($(this).prop("disabled") == false) {
                if (table.checkStatus('objectList').data.length) {
                    getAndLoadReleaseForm(reports.item(table.checkStatus('objectList').data[0].reportID));
                } else {
                    layer.msg("请选择一条记录。", { icon: 2 });
                }
            }
        });

        $(".release").click(function () {
            var selectCecord = table.checkStatus('objectList').data;
            if (selectCecord.length > 0) {
                if (selectCecord[0].sourceType == 1) {
                    layer.msg("订阅的报表不能再次发布。", { icon: 2 });
                } else {
                    var report = reports.item(selectCecord[0].reportID);
                    getAndLoadPublisherForm(report);
                }
            } else {
                layer.msg("请选择一条记录。", { icon: 2 });
            }
        });

        $(".subscribe").click(function () {
            getAndLoadSubscriptionForm();
        });
    }

    function disabledButton(type){
        if (type == 0) {
            $(".edit-report").attr("disabled", true);
            $(".visibility-report").attr("disabled", true);
            $(".copy-report").attr("disabled", true);
        } else {
            $(".edit-report").attr("disabled", false);
            $(".visibility-report").attr("disabled", false);
            $(".copy-report").attr("disabled", false);
        }
    }

    function mOpenChildFolder(folderID) {
        $(".report-folder-tree > ul").find("li").each(function () {
            if ($(this).attr("data-folderid") == folderID) {
                $(this).find("div").eq(0).trigger("click");
            }
        });
    }

    function setSearchData(searchValue) {
        var tempArr = [];
        for (var i = 0; i < mTableBodyData.length; i++) {
            if (mTableBodyData[i].reportName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1) {
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadFoldertForm(operationType, folder) {
        $.ajax({
            url: "html/iReport/report/folder.html",
            type: 'GET',
            success: function (data) {
                loadFolderForm(operationType, folder, data);
            }
        });
    }

    function loadFolderForm(operationType, folder, strHtml) {
        layer.open({
            type: 1,
            title: [operationType ? folder.folderName + " 属性" : "新增文件夹", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                initFolderFormWindow(operationType, folder, folder.folderParentID, reportFolders, index, addFolderSubmit, editFolderSubmit);
            }
        });
    }

    function getAndLoadReportForm(operationType, report) {
        $.ajax({
            url: "html/iReport/report/report.html",
            type: 'GET',
            success: function (data) {
                loadReportForm(operationType, report, data);
            }
        });
    }

    function loadReportForm(operationType, report, strHtml) {
        layer.open({
            type: 1,
            title: [operationType ? report.reportName + " 属性" : "新增报表", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                initReportFormWindow(operationType, report, report.folderID, reportFolders, index, addSubmit, editSubmit);
            }
        });
    }

    function openCopyReportForm(reportName, reportID) {
        $Utils.loading.open();
        var url = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/html/iReport/report/copyReport.html?token=" + $AppVars.token + "&reportName=" + encodeURIComponent(reportName) + "&reportID=" + reportID + "&folderID=" + mFolderID + "&userName=" + encodeURIComponent($AppVars.gUser.userName);
        layer.open({
            type: 2,
            title: "复制报表",
            btn: false,
            resize: false,
            area: ["800px", "643px"],
            content: [url, 'no']
        });
    }

    function getAndLoadReleaseForm(report) {
        $.ajax({
            url: "html/iReport/report/release.html",
            type: 'GET',
            success: function (data) {
                loadReleaseForm(report, data);
            }
        });
    }

    function loadReleaseForm(report, strHtml) {
        layer.open({
            type: 1,
            title: ["设置 " + report.reportName + " 的可见性", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["440px", "330px"],
            content: strHtml,
            success: function (layero, index) {
                initReleaseFormWindow(report, index);
            }
        });
    }

    function openClientAddAndEdit(reportID) {
        var url = "yzs:// /l " + $AppVars.gLogin.loginID + " /n1 2 /i1 " + reportID;
        $Utils.openClient(url);
    }

    function validateFolder(folderID) {
        for (var i = 0; i < reportFolders.count; i++) {
            if (reportFolders.item(i).folderParentID == folderID) {
                layer.msg("文件夹 " + reportFolders.item(i).folderName + " 包含子文件夹，不能删除。", { icon: 2 });
                return false;
            }
        }

        for (var i = 0; i < reports.count; i++) {
            if (reports.item(i).folderID == folderID) {
                layer.msg("文件夹 " + reportFolders.item(folderID).folderName + " 包含报表，不能删除。", { icon: 2 });
                return false;
            }
        }

        return true;
    }

    function loadDeleteFolderWindow(folderID) {
        layer.open({
            type: 0,
            title: "删除文件夹",
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["480px", "270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 " + reportFolders.item(folderID).folderName + " ？</div></div>",
            btn: ["是", "否"],
            success: function (layero, index) {
                $(layero).find('.layui-layer-content').css('height', '137px');
            },
            yes: function (index, layero) {
                layer.close(index);
                $Utils.loading.open();
                deleteFolder(folderID);
            }
        });
    }

    function deleteFolder(folderID) {
        var succ = function () {
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。", { icon: 1 });
            loadReportList(mFolderID);
            $(".report-folder-tree li").each(function () {
                if ($(this).attr("data-folderid") == folderID) {
                    $(this).parents("li").eq(0).children("div").trigger("click");
                    $(this).remove();
                }
            });
            disabledButton(1);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("删除文件夹", errorStatus, msg);
        };
        reportFolders.deleteItem(folderID, true, succ, fail);
    }

    function deleteReport(reportID) {
        var succ = function () {
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。", { icon: 1 });
            // getReportLists();
            loadReportList(mFolderID);
            disabledButton(1);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("删除报表", errorStatus, msg);
        };
        reports.deleteItem(reportID, true, succ, fail);
    }

    function getAndLoadPublisherForm(selectReport) {
        $.ajax({
            url: "html/publisher/publisher.html",
            type: 'GET',
            success: function (data) {
                loadPublisherForm(selectReport, data);
            }
        });
    }

    function loadPublisherForm(selectReport, strHtml) {
        layer.open({
            type: 1,
            title: ["发布", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                $Utils.loading.open();
                initPublisherForm(1, selectReport, index, updateSelectReport);
            }
        });
    }

    function getAndLoadSubscriptionForm() {
        $.ajax({
            url: "html/iReport/subscription/subscription.html",
            type: 'GET',
            success: function (data) {
                loadSubscriptionForm(data);
            }
        });
    }

    function loadSubscriptionForm(strHtml) {
        layer.open({
            type: 1,
            title: ["订阅", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                $Utils.loading.open();
                initSubscriptionForm(index, updateList);
            }
        });
    }

    var addFolderSubmit = function (folder, index) {
        var succ = function () {
            $Utils.loading.close();
            layer.close(index);
            setAndLoadReportListTableBody(mFolderID);
            addFolderMenu(folder);
            disabledButton(1);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("新增文件夹", errorStatus, msg);
        };
        reportFolders.addItem(folder, true, succ, fail);
    };

    function addFolderMenu(folder){
        str = "<li class='folder folder-hide' data-folderid=" + folder.folderID + "><div title=" + folder.folderName + "><i class='iconfont bda-wenjianjia'></i><span>" + folder.folderName + "</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>"
        $(".menu-list > ul").find("li").each(function () {
            if ($(this).attr("data-folderid") == folder.folderParentID) {
                $(this).children("ul").append(str);
            }
        });
    }

    var editFolderSubmit = function (folder, index) {
        var succ = function () {
            $Utils.loading.close();
            layer.close(index);
            reportFolders.item(folder.folderID).init(JSON.parse(JSON.stringify(folder)));
            editFolderMenu(folder);
            loadReportList(folder.folderID);
            disabledButton(1);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("修改文件夹", errorStatus, msg);
        };
        reportFolders.editItem(folder, true, succ, fail);
    };

    function editFolderMenu(folder){
        var str = "";
        var str = "";
        var isEditParent = false;
        $(".menu-list > ul").find("li").each(function () {
            if ($(this).attr("data-folderid") == folder.folderID) {
                if ($(this).parents("li").eq(0).attr("data-folderid") != folder.folderParentID) {
                    isEditParent = true;
                }
                $(this).children("div").attr("title", folder.folderName);
                $(this).children("div").find("span").text(folder.folderName);
                if (isEditParent) {
                    str = $(this);
                    $(this).remove();
                }
                return false;
            }
        });

        if (isEditParent) {
            $(".menu-list > ul").find("li").each(function () {
                if ($(this).attr("data-folderid") == folder.folderParentID) {
                    $(this).children("ul").append(str);
                    return false;
                }
            });

            $(".menu-list > ul").find("li").each(function () {
                if ($(this).attr("data-folderid") == folder.folderID) {
                    $(this).parents("li").children("ul").show();
                    return false;
                }
            });
        }
    }

    var addSubmit = function (report, index) {
        var succ = function (data) {
            $Utils.loading.close();
            layer.close(index);
            openClientAddAndEdit(data);
            getAndLoadFoldersMenus();
            disabledButton(1);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("新增报表", errorStatus, msg);
        };
        reports.addItem(report, true, succ, fail);
    };

    function clickTargetFolderEvent() {
        $(".menu-list > ul").find("li").each(function () {
            if ($(this).attr("data-folderid") == mFolderID) {
                $(this).children("div").trigger("click");
            }
        });
    }

    var editSubmit = function (report, index) {
        var succ = function () {
            $Utils.loading.close();
            layer.close(index);
            editListReportItem(reports.item(report.reportID));
            disabledButton(1);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("修改报表", errorStatus, msg);
        };
        var str = "reportName=" + encodeURIComponent(report.reportName) + "&folderID=" + report.folderID;
        reports.editSimpleProperty(report, str, true, succ, fail);
    };

    function editListReportItem(report) {
        var tempTableBody = $.extend(true, [], currentTableBodyData);
        var folderIDs = getFolderIDs(mFolderID);
        for (var i = currentTableBodyData.length - 1; i >= 0; i--) {
            if (currentTableBodyData[i].reportID == report.reportID) {
                if (folderIDs.indexOf(report.folderID) != -1 || mFolderID == "-1") {
                    for (var key in currentTableBodyData[i]){
                        if (key != "folderURL") {
                            tempTableBody[i][key] = report[key];
                            currentTableBodyData[i][key] = report[key];
                        }
                    }
                    tempTableBody[i].folderURL = setFolderURL(report.folderID);
                    currentTableBodyData[i].folderURL = setFolderURL(report.folderID);
                    tempTableBody[i].LAY_CHECKED = true;
                } else {
                    currentTableBodyData.splice(i, 1);
                    tempTableBody.splice(i, 1);
                }
                break;
            }
        }
        mSortBodyData = currentTableBodyData;
        table.reload("objectList", { data: tempTableBody, limit: tempTableBody.length });
    }

    window.closeCopyReportForm = function (reportID, reportName) {
        if (reportID) {
            var copyReport = new Report();
            var succ = function () {
                reports.add(copyReport);
                $Utils.loading.close();
                layer.closeAll();
                setAndLoadReportListTableBody(mFolderID);
            };
            var fail = function () {
                $Utils.loading.close();
                $Utils.openWindow.failWindow("获取 " + reportName + " 的属性", errorStatus, msg);
            };
            copyReport.getItemByID(reportID, true, succ, fail);
        } else {
            $Utils.loading.close();
            layer.closeAll();
        }
    };

    function setAndLoadReportListTableBody(folderID) {
        mTableBodyData = setTableBody(folderID);
        mSortBodyData = mTableBodyData;
        setTablePage(mTableBodyData);
    }

    var updateSelectReport = function (bmPublish) {
        reports.item(bmPublish.reportID).publishStatus = bmPublish.publishStatus;
        editListReportItem(reports.item(bmPublish.reportID));
    };

    var updateVarStatus = function () {
        isSubscriptioned = true;
    };

    var updateList = function () {
        $Utils.loading.open();
        getAndLoadFoldersMenus();
    };

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }

}();