/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-01 10:53:26
 * @LastEditTime: 2021-05-11 09:15:32
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form, tree = layui.tree;
    // var organizationSystemSettings = new OrganizationSystemSettings();
    var mReport = null, layerIndex = null, formAddSubmit = null, formEditSubmit = null, mOperationType = null, mFolders = null, mFolderID = null;
    
    window.initReportFormWindow = function(operationType,report,folderID,folders,index,addSubmit,editSubmit){
        mReport = report;
        layerIndex = index;
        formAddSubmit = addSubmit
        formEditSubmit = editSubmit
        mOperationType = operationType;
        mFolders = folders;
        mFolderID = folderID;

        initReportForm(operationType,report)
    }

    function initReportForm(operationType,report){
        if(operationType == 1){
            form.val("formWindow",{
                "reportName": report.reportName,
                "reportID": report.reportID,
                "createUserName": report.createUserName,
                "createDate": (report.createDate?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(report.createDate)):""),
                "lastModifyUserName": report.lastModifyUserName,
                "lastModifyDate": (report.lastModifyDate?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(report.lastModifyDate)):"")
            });
        }
        createTreeSelect();
        form.render();

        var createUserName = operationType == 0 ? $AppVars.gUser.userName : (report.createUserName || "");
        var createDate = operationType == 0 ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date()) : $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(report.createDate));
        var lastModifyUserName = operationType == 0 ? "" : (report.lastModifyUserName || "");
        var lastModifyDate = operationType == 0 ? "" : (report.lastModifyDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(report.lastModifyDate)) : "");
        $(".bottom-item .createUserName").text(createUserName);
        $(".bottom-item .createDate").text(createDate);
        $(".bottom-item .lastModifyUserName").text(lastModifyUserName);
        $(".bottom-item .lastModifyDate").text(lastModifyDate);

        $(".report-window input[name=reportName]").focus();

        form.on('submit(formSubmit)', function(data){
            $Utils.loading.open();
            if(mOperationType == 1){
                if(changed(data)){
                    var editReport = new Report();
                    editReport.init(JSON.parse(JSON.stringify(report)));
                    setReport(data, editReport);
                    formEditSubmit(editReport,layerIndex);
                }else{
                    $Utils.loading.close();
                    layer.close(layerIndex); 
                }
            }else if(mOperationType == 0){
                setReport(data, report);
                report.reportSettings = setReportSettings();
                formAddSubmit(report,layerIndex);
            }
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });
    }

    function createTreeSelect(){
        var treeData = transformFolders();
        tree.render({
            elem: '#classtree',
            data: treeData,
            onlyIconControl: true,
            click: function(node){ //点击节点回调
                var $select = $($(this)[0].elem).parents(".layui-form-select");
                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderID']").val(node.data.folderID);
            },
        });
        if(mFolderID == -1){
            $(".report-window .layui-form-select").find(".layui-select-title span").html("组织分析").end().find("input:hidden[name='folderID']").val(-1);
        }else{
            $(".report-window .layui-form-select").find(".layui-select-title span").html(mFolders.item(mFolderID).folderName).end().find("input:hidden[name='folderID']").val(mFolders.item(mFolderID).folderID);
        }
        $(".report-window .downpanel").off("click").on("click", ".layui-select-title", function (e) {
            $(".layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
            $(this).parents(".downpanel").toggleClass("layui-form-selected");
            layui.stope(e);
        }).on("click", "dl i", function (e) {
            layui.stope(e);
        });
        $(document).on("click", function (e) {
            $(".report-window .layui-form-select").removeClass("layui-form-selected");
        });
    }

    function transformFolders(){
        var index = 0;
        var tempArr = [];
        var hashTable = new $Utils.HashTable();
        hashTable.add("-1",{title: "组织分析",id:index,folderID:"-1",folderParentID:"0",spread: true});
        index++;
        for(var i = 0; i < mFolders.count; i++){
            hashTable.add(mFolders.item(i).folderID,{title:mFolders.item(i).folderName,id:index,folderID:mFolders.item(i).folderID,folderParentID:mFolders.item(i).folderParentID});
            index++;
        }
        for(var i = 0; i < mFolders.count; i++){
            var parentFolder = hashTable.getValue(mFolders.item(i).folderParentID);
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(mFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function setReport(data, report){
        report.reportName = data.field.reportName;
        report.folderID = data.field.folderID;
    }

    function changed(data){
        if(mReport.reportName != data.field.reportName){
            return true;
        }
        if(mReport.folderID != data.field.folderID){
            return true;
        }
        return false;
    }

    function setReportSettings(){
        var tempArr = [];
        var reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "pageWidth", reportSetting.reportSettingValue = $AppVars.gOrganizationSystemSettings.item("pageWidth").systemSettingValue, tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "pageHeight", reportSetting.reportSettingValue = $AppVars.gOrganizationSystemSettings.item("pageHeight").systemSettingValue, tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "customLayoutForMobile", reportSetting.reportSettingValue = $AppVars.gOrganizationSystemSettings.item("customLayoutForMobile").systemSettingValue, tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "directShowDataInChartForMobile", reportSetting.reportSettingValue = $AppVars.gOrganizationSystemSettings.item("directShowDataInChartForMobile").systemSettingValue, tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "displayHoverShadow", reportSetting.reportSettingValue = "1", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "autoRefresh", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "refreshInterval", reportSetting.reportSettingValue = "60", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "autoCloseComponent", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "closeComponentInterval", reportSetting.reportSettingValue = "30", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "autoReturnDefaultFilters", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "returnDefaultFiltersInterval", reportSetting.reportSettingValue = "30", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "showMagnifierGeneral", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "scaleByScreenSize", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "showBackButtonWhenPCFullscreen", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "backButtonInitPosition", reportSetting.reportSettingValue = "2", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "filterDialogInitPosition", reportSetting.reportSettingValue = "8", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "toolButonsColor", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "colorOfTransformedTableBody", reportSetting.reportSettingValue = "-16777216", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "followDesignSize", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "specifyPageSize", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "useNumericSymbols", reportSetting.reportSettingValue = $AppVars.gOrganizationSystemSettings.item("useNumericSymbols").systemSettingValue, tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "useComputerStyleForMobile", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "linkCoverMyself", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "mergeNull", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "calendarWithLunar", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "notGetReportView", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);
        reportSetting = new ReportSetting();
        reportSetting.reportSettingKey = "showPFinReport", reportSetting.reportSettingValue = "0", tempArr.push(reportSetting);

        return tempArr;
    }

}();