/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-12-28 10:04:04
 * @LastEditTime: 2021-02-02 14:47:53
 * @LastModifyUser: 
 * @Remark: 
 */
!function () {
    var $ = layui.jquery, form = layui.form, tree = layui.tree;
    var mFolderID = (location.href.split("folderID=")[1]).split("&")[0];
    var userName = (location.href.split("userName=")[1]).split("&")[0];
    $AppVars.token = (location.href.split("token=")[1]).split("&")[0];
    var folders = new ReportFolders();
    var report = new Report();
    var reports = new Reports();

    getFoldersAndReportProperties();

    function getFoldersAndReportProperties(){
        var succ = function () {
            getReportPropertiesAndInitPage();
        };
        var fail = function (errorStatus, msg) {
            window.parent.closeLoading();
            $Utils.openWindow.failWindow("获取文件夹列表", errorStatus, msg);
        };
        folders.getItems(true, succ, fail);
    }

    function getReportPropertiesAndInitPage(){
        var succ = function () {
            window.parent.closeLoading();
            initPage();
        };
        var fail = function (errorStatus, msg) {
            window.parent.closeLoading();
            $Utils.openWindow.failWindow("获取报表所有属性", errorStatus, msg);
        };
        report.getItemAllPropertiesByID((location.href.split("reportID=")[1]).split("&")[0], true, succ, fail);
    }

    function initPage(){
        form.val("formWindow",{
            reportName: decodeURIComponent((location.href.split("reportName=")[1]).split("&")[0]) + "副本",
            createUserName: decodeURIComponent(userName),
            createDate: $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date())
        });
        createTreeSelect();
        $(".report-window input[name=reportName]").focus();

        form.on('submit(formSubmit)', function (data) {
            window.parent.openLoading();
            var addReport = new Report();
            addReport.reportName = data.field.reportName;
            addReport.folderID = data.field.folderID;
            var succ = function (data) {
                copyReport(data,addReport.reportName,addReport.folderID);
            };
            var fail = function (errorStatus, msg) {
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("获取原报表所有属性", errorStatus, msg);
            };
            reports.addItem(addReport,true,succ,fail);
            return false;
        });

        $(".copy-report-window .layui-btn-cancel").click(function(){
            window.parent.closeCopyReportForm();
        });
    }

    function createTreeSelect() {
        var treeData = transformFolders();
        tree.render({
            elem: '#classtree',
            data: treeData,
            onlyIconControl: true,
            click: function (node) { //点击节点回调
                var $select = $($(this)[0].elem).parents(".layui-form-select");
                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderID']").val(node.data.folderID);
            },
        });
        if (mFolderID == -1) {
            $(".report-window .layui-form-select").find(".layui-select-title span").html("组织分析").end().find("input:hidden[name='folderID']").val(-1);
        } else {
            $(".report-window .layui-form-select").find(".layui-select-title span").html(folders.item(mFolderID).folderName).end().find("input:hidden[name='folderID']").val(folders.item(mFolderID).folderID);
        }
        $(".report-window .downpanel").off("click").on("click", ".layui-select-title", function (e) {
            $(".layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
            $(this).parents(".downpanel").toggleClass("layui-form-selected");
            layui.stope(e);
        }).on("click", "dl i", function (e) {
            layui.stope(e);
        });
        $(document).on("click", function (e) {
            $(".report-window .layui-form-select").removeClass("layui-form-selected");
        });
    }

    function transformFolders() {
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1", { title: "组织分析", id: "-1", folderID: "-1", folderParentID: "0", spread: true });
        for (var i = 0; i < folders.count(); i++) {
            hashTable.add(folders.item(i).folderID, { title: folders.item(i).folderName, id: folders.item(i).folderID, folderID: folders.item(i).folderID, folderParentID: folders.item(i).folderParentID });
        }
        for (var i = 0; i < folders.count(); i++) {
            var parentFolder = hashTable.getValue(folders.item(i).folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(folders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function copyReport(reportID,reportName,folderID){
        var oldReportID = (location.href.split("reportID=")[1]).split("&")[0];
        var oldReportStr = JSON.stringify(report);
        var reg = new RegExp(oldReportID, "g");
        var newReportStr = oldReportStr.replace(reg, reportID);

        reports.item(reportID).init(JSON.parse(newReportStr));
        reports.item(reportID).reportName = reportName;
        reports.item(reportID).folderID = folderID;

        var succ = function () {
            window.parent.closeCopyReportForm(reportID,reportName);
            updateResourceFile(reportID);
        };
        var fail = function (errorStatus, msg) {
            window.parent.closeLoading();
            $Utils.openWindow.failWindow("复制报表", errorStatus, msg);
        };
        reports.editItem(reports.item(reportID), true, succ, fail);
    }

    function updateResourceFile(reportID){
        var reportImageArr = extractReportImage();
        for(var i = 0; i < reportImageArr.length; i++){
            getAndUploadImg(reportImageArr[i], reportID);
        }
    }

    function extractReportImage() {
        var imgUrlsArr = [];
        var reportdesign = report.reportDesign;
        for (var i = 0; i < reportdesign.pcPages.count(); i++) {
            if (reportdesign.pcPages.item(i).pageImage != null && reportdesign.pcPages.item(i).pageImage.imageID != "-1" && reportdesign.pcPages.item(i).pageImage.imageID == "0"){
                imgUrlsArr.push(reportdesign.pcPages.item(i).pageImage.imageURL);
            }
        }
        for (var i = 0; i < reportdesign.padPages.count(); i++) {
            if (reportdesign.padPages.item(i).pageImage != null && reportdesign.padPages.item(i).pageImage.imageID != "-1" && reportdesign.padPages.item(i).pageImage.imageID == "0") {
                imgUrlsArr.push(reportdesign.padPages.item(i).pageImage.imageURL);
            }
        }
        for (var i = 0; i < reportdesign.mobilePages.count(); i++) {
            if (reportdesign.mobilePages.item(i).pageImage != null && reportdesign.mobilePages.item(i).pageImage.imageID != "-1" && reportdesign.mobilePages.item(i).pageImage.imageID == "0") {
                imgUrlsArr.push(reportdesign.mobilePages.item(i).pageImage.imageURL);
            }
        }
        reportdesign.fillBlocks();
        for (var i = 0; i < reportdesign.blocks.length; i++) {
            var block = reportdesign.blocks[i];
            if (block.titleIcon != null && block.titleIcon.imageID != "-1" && block.titleIcon.imageID == "0") {
                imgUrlsArr.push(block.titleIcon.imageURL);
            }
            if (block.backgroundImage != null && block.backgroundImage.imageID != "-1" && block.backgroundImage.imageID == "0") {
                imgUrlsArr.push(block.backgroundImage.imageURL);
            }
            if (block instanceof ButtonBlock) {
                if (block.icon != null && block.icon.imageID != "-1" && block.icon.imageID == "0") {
                    imgUrlsArr.push(block.icon.imageURL);
                }
                if (block.image != null && block.image.imageID != "-1" && block.image.imageID == "0") {
                    imgUrlsArr.push(block.image.imageURL);
                }
                if (block.selectedImage != null && block.selectedImage.imageID != "-1" && block.selectedImage.imageID == "0") {
                    imgUrlsArr.push(block.selectedImage.imageURL);
                }
            }
            if (block instanceof TabControlBlock) {
                var tabHeads = block.tabHeads;
                if (tabHeads.icon != null && tabHeads.icon.imageID != "-1" && tabHeads.icon.imageID == "0") {
                    imgUrlsArr.push(tabHeads.icon.imageURL);
                }
                if (tabHeads.backgroundImage != null && tabHeads.backgroundImage.imageID != "-1" && tabHeads.backgroundImage.imageID == "0") {
                    imgUrlsArr.push(tabHeads.backgroundImage.imageURL);
                }
                if (tabHeads.selectedBackgroundImage != null && tabHeads.selectedBackgroundImage.imageID != "-1" && tabHeads.selectedBackgroundImage.imageID == "0") {
                    imgUrlsArr.push(tabHeads.selectedBackgroundImage.imageURL);
                }
            }
            if (block instanceof LabelBlock) {
                for (var j = 0; j < block.images.count(); j++) {
                    if (block.images.item(j) != null && block.images.item(j).imageID != "-1" && block.images.item(j).imageID == "0") {
                        imgUrlsArr.push(block.images.item(j).imageURL);
                    }
                }
            }
            if (block instanceof ChartBlock) {
                if (block.picture != null && block.picture.imageID != "-1" && block.picture.imageID == "0") {
                    imgUrlsArr.push(block.picture.imageURL);
                }
            }
        }
        return imgUrlsArr;
    }

    function getAndUploadImg(imgPath, reportID){
        var imgName = imgPath.split("/")[imgPath.split("/").length - 1];
        var imgDataUrl = function (dataURL){
            var imgBlob = Base64toFile(dataURL);
            var file = new FormData();
            file.append("file", value = imgBlob, fileName = imgName);
            var succ = function(){};
            var fail = function (errorStatus, msg) {};
            reports.item(reportID).uploadResource(file,true,succ,fail);
        }
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/" + imgPath;
        (function (url, imgDataUrl){
            getImgToBase64(url, imgDataUrl);
        })(url, imgDataUrl);
    }

    function getImgToBase64(url, callback) {//将图片转换为Base64
        var canvas = document.createElement('canvas'),
            ctx = canvas.getContext('2d'),
            img = new Image();
        img.crossOrigin = 'Anonymous';
        img.onload = function () {
            canvas.height = img.height;
            canvas.width = img.width;
            ctx.drawImage(img, 0, 0);
            var dataURL = "";
            dataURL = canvas.toDataURL('image/png');
            callback(dataURL);
            canvas = null;
        };
        img.src = url;
    }

    function Base64toFile(dataurl, filename) {//将base64转换为文件
        var arr = dataurl.split(','), mime = arr[0].match(/:(.*?);/)[1],
            bstr = atob(arr[1]), n = bstr.length, u8arr = new Uint8Array(n);
        while (n--) {
            u8arr[n] = bstr.charCodeAt(n);
        }
        // return new File([u8arr], filename, { type: mime });//file
        return new Blob([u8arr], { type: mime });////blob
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }

}();