/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-19 14:38:24
 * @LastEditTime: 2021-02-21 18:32:37
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var officeTemplates = new OfficeTemplates();
    var wordFile = ["doc","docx","doct"];
    var pptFile = ["ppt","pot","pptx"];
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadTableBody();

        bindEvent();
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "templateName",title:"名称",templet: "#preview", sort: true},
                {field: "createUserName",title: "上传者", width: 150, sort: true},
                {field: "createDate",title: "上传时间", width: 125, sort: true},
                {title: "操作",templet: "#setAuthority", width: 80, align: "center"}
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取Office模版列表",errorStatus,msg);
		};
		officeTemplates.getItems(true,succ,fail);
    }

    function setTableBody(){
        var tableBody = [];
        for(var i = 0; i < officeTemplates.count; i++){
            var tempObj = {};
            for(var key in officeTemplates.item(i)){
                if(typeof officeTemplates.item(i)[key] === "function"){ continue;}
                if(key == "createDate"){
                    tempObj[key] = officeTemplates.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(officeTemplates.item(i)[key])):"";
                }else{
                    tempObj[key] = officeTemplates.item(i)[key];
                }
            }
            tableBody.push(tempObj);
        }
        return tableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        var tableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("objectList",{data:tableBody,limit:tableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindEvent(){
        table.on('sort(objectList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });
        
        $(".upload").click(function(){
            $("#uploadFile").click();
        });

        $("#uploadFile").change(function(e) {
            var name = e.target.files[0].name;
            var names = name.split(".");
            if(wordFile.indexOf(names[names.length-1]) != -1 || pptFile.indexOf(names[names.length-1]) != -1){
                if(judgeOfficeExistence(name)){
                    layer.open({
                        type: 0,
                        title: "上传Excel文件",
                        closeBtn: 1,
                        shadeClose: true,
                        resize: false,
                        area: ["480px","270px"],
                        skin: "delete-window",
                        content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-tips'></i></div><div class='fr fail-content'>Office模版 "+name+" 已存在，是否覆盖？</div></div>",
                        btn: ["确定","取消"],
                        yes: function(index, layero){
                            var files = Object.values(e.target.files);
                            var fileType = (wordFile.indexOf(names[names.length-1]) != -1)?0:1;
                            uploadFile(files[0],fileType);
                            layer.close(index);
                        },
                        end: function(){
                            e.target.value = '';
                        }
                    });
                }else{
                    var files = Object.values(e.target.files);
                    var fileType = (wordFile.indexOf(names[names.length-1]) != -1)?0:1;
                    uploadFile(files[0],fileType);
                    e.target.value = '';
                }
            }else{
                layer.msg("不能上传此类文件。",{icon:2});
            }
        });

        function judgeOfficeExistence(name){
            var isExistence = false;
            for(var i = 0; i < officeTemplates.count; i++){
                if(officeTemplates.item(i).templateName == name){
                    isExistence = true;
                    break;
                }
            }

            return isExistence;
        }

        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTableBody();
        });

        $(".delete").click(function(){
            if(table.checkStatus('objectList').data.length){
                layer.open({
                    type: 0,
                    title: "删除Office模版",
                    closeBtn: 1,
                    shadeClose: true,
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('objectList').data[0].templateName+" ？</div></div>",
                    btn: ["是","否"],
                    success: function(layero,index){
                        $(layero).find('.layui-layer-content').css('height','137px');
                    },
                    yes: function(index,layero){
                        layer.close(index);
                        $Utils.loading.open();
                        deleteOfficeTemplate(table.checkStatus('objectList').data[0].templateID);
                    }
                });
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        table.on("tool(objectList)", function(obj){
            if(obj.event == "preview"){
                getAndLoadAuthorityListForm(businessModel);
            }
            if(obj.event == "download"){
                downloadFile(obj.data.templateID,obj.data.templateName);
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].templateName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function uploadFile(fileObj,fileType){
        var file = new FormData();
        file.append("file", fileObj);
        var succ = function(data){
            $Utils.loading.close();
            layer.msg("上传成功。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增Office模版",errorStatus,msg);
        };
        officeTemplates.addItem(file,fileType,true,succ,fail);
    }

    function deleteOfficeTemplate(templateID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除Office模版",errorStatus,msg);
        };
        officeTemplates.deleteItem(templateID,true,succ,fail);
    }

    function downloadFile(templateID,templateName){
        var succ = function(data){
            $Utils.loading.close();
            if (window.navigator.msSaveOrOpenBlob) {
                navigator.msSaveBlob(data[0], templateName);
            } else{
                var t = new Blob(data);
                var a = document.createElement('a');
                a.href = URL.createObjectURL(t);
                a.download = templateName;
                a.click();
                $(a).remove();
            }
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("下载Office模版",errorStatus,msg);
        };
        officeTemplates.item(templateID).download(true,succ,fail);
    }
}();