/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-28 16:09:58
 * @LastEditTime: 2020-04-28 17:15:28
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var planets = new Planets();

    $Utils.loading.open();
    initMain();

    function initMain(){
        getAndLoadTableBody();
        treeEvent();
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
			loadTree();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取地图列表",errorStatus,msg);
		};
		planets.getItems(true,succ,fail);
    }

    function loadTree(){
        var treeData = [];
        for(var i = 0; i < planets.count; i++){
            var tempObj = {};
            tempObj.code = planets.item(i).planetCode;
            tempObj.name = planets.item(i).planetName;
            tempObj.children = setCountries(planets.item(i).countries);
            treeData.push(tempObj);
        }
        createTree(treeData);
    }

    function setCountries(countryObj){
        var tempArr = [];
        for(var i = 0; i < countryObj.count; i++){
            if(countryObj.item(i).provinces.count){
                var tempObj = {};
                tempObj.code = countryObj.item(i).countryCode;
                tempObj.name = countryObj.item(i).countryName;
                tempObj.children = setProvinces(countryObj.item(i).provinces);
                tempArr.push(tempObj);
            }
        }
        return tempArr;
    }

    function setProvinces(provincesObj){
        var tempArr = [];
        for(var i = 0; i < provincesObj.count; i++){
            var tempObj = {};
            tempObj.code = provincesObj.item(i).provinceCode;
            tempObj.name = provincesObj.item(i).provinceName;
            if(provincesObj.item(i).haveChildMap){
                tempObj.children = setCities(provincesObj.item(i).cities);
            }else{
                tempObj.children = [];
            }
            tempArr.push(tempObj);
        }
        return tempArr;
    }

    function setCities(citiesObj){
        var tempArr = [];
        for(var i = 0; i < citiesObj.count; i++){
            var tempObj = {};
            tempObj.code = citiesObj.item(i).cityCode;
            tempObj.name = citiesObj.item(i).cityName;
            tempObj.children = [];
            tempArr.push(tempObj);
        }
        return tempArr;
    }

    function createTree(treeData){
        var str = "";
        for(var i = 0; i < treeData.length; i++){
            str = "<li class='folder folder-hide' data-code="+treeData[i].code+"><div title="+treeData[i].name+"><span>"+treeData[i].name+"</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>";
            $(".map-menu-tree > ul").append(str);
            $(".map-menu-tree > ul").children("li").each(function(){
                if($(this).attr("data-code") == treeData[i].code && treeData[i].children.length){
                    createChildrenTree(treeData[i].children,this);
                }
            });
        }
        $(".map-menu-tree > ul > li:first-child > div").trigger("click");
    }

    function createChildrenTree(data,elem){
        for(var i = 0; i < data.length; i++){
            str = "<li class='folder folder-hide' data-code="+data[i].code+"><div title="+data[i].name+"><span>"+data[i].name+"</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>";
            $(elem).children("ul").append(str);
            $(elem).children("ul").children("li").each(function(){
                if($(this).attr("data-code") == data[i].code && data[i].children.length){
                    createChildrenTree(data[i].children,this);
                }
            });
        }
    }

    function treeEvent(){
        $(".map-menu-tree > ul").on("click","div",function(){
            if($(this).siblings("ul").is(":hidden")){
                $(this).siblings("ul").show(200);
                $(".map-menu-tree").find(".selected-folder").removeClass("selected-folder");
                $(this).parent().addClass("selected-folder");
                $(this).find("i").removeClass("bda-xiangyou").addClass("bda-xiangxia");
            }else{
                $(this).siblings("ul").hide(200);
                $(this).parent().addClass("selected-folder");
                $(this).find("i").removeClass("bda-xiangxia").addClass("bda-xiangyou");
            }
            loadMap($(this).parent("li").attr("data-code"));
        });
    }

    function loadMap(code){
        $(".map-frame").html("");
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/report_front_end/jsp/map.jsp?code="+code;
        $(".map-frame").html("<iframe name='right' class='rightMain' frameborder='no' scrolling='auto' width='100%' height='100%' allowtransparency='true' src='"+url+"'></iframe>");
    }
    
}();