/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-20 16:23:43
 * @LastEditTime: 2021-03-30 17:34:15
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var geographyObjectCompares = new GeographyObjectCompares();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadTableBody();

        bindEvent();
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "geoLevel",title:"地域级别",templet: "#level", sort: true},
                {field: "businessModelName",title: "业务模型", sort: true},
                {field: "businessModelType",title: "模型类型",templet: "#type", sort: true},
                {field: "businessObjectName",title: "业务对象"}
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取地图对照列表",errorStatus,msg);
		};
		geographyObjectCompares.getItems(true,succ,fail);
    }

    function setTableBody(){
        var tableBody = [];
        for(var i = 0; i < geographyObjectCompares.count; i++){
            var tempObj = {};
            for(var key in geographyObjectCompares.item(i)){
                if(typeof geographyObjectCompares.item(i)[key] === "function"){ continue;}
                tempObj[key] = geographyObjectCompares.item(i)[key];
            }
            tableBody.push(tempObj);
        }
        return tableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        var tableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("objectList",{data:tableBody,limit:tableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindEvent(){
        table.on('sort(objectList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        $(".add").click(function(){
            var geographyObjectCompare = new GeographyObjectCompare();
            getAndLoadGeographyObjectCompareForm(0,geographyObjectCompare);
        });

        $(".edit").click(function(){
            if(table.checkStatus('objectList').data.length){
                var geographyObjectCompare = geographyObjectCompares.item(table.checkStatus('objectList').data[0].geoObjectCompareID);
                getAndLoadGeographyObjectCompareForm(1,geographyObjectCompare);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTableBody();
        });

        $(".delete").click(function(){
            if(table.checkStatus('objectList').data.length){
                layer.open({
                    type: 0,
                    title: "删除地图对照表",
                    closeBtn: 1,
                    shadeClose: true,
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除？</div></div>",
                    btn: ["是","否"],
                    success: function(layero,index){
                        $(layero).find('.layui-layer-content').css('height','137px');
                    },
                    yes: function(index,layero){
                        layer.close(index);
                        $Utils.loading.open();
                        deleteCompares(table.checkStatus('objectList').data[0].geoObjectCompareID);
                    }
                });
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].geoLevel.toString().toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].businessModelName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].businessObjectName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadGeographyObjectCompareForm(operationType,geographyObjectCompare){
        $.ajax({
            url: "html/iReport/map/mapData.html",
            type: 'GET',
            success: function(data){
                loadGeographyObjectCompareForm(data,operationType,geographyObjectCompare);
            }
        });
    }

    function loadGeographyObjectCompareForm(strHtml,operationType,geographyObjectCompare){
        layer.open({
            type: 1,
            title: ["地图数据对照","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["868px","651px"],
            content: strHtml,
            success: function(layero,index){
                initGeographyObjectCompareForm(operationType,geographyObjectCompare,index,addSubmit,editSubmit);
            }
        });
    }

    function deleteCompares(geoObjectCompareID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除地图对照表",errorStatus,msg);
        };
        geographyObjectCompares.deleteItem(geoObjectCompareID,true,succ,fail);
    }

    var addSubmit = function(geographyObjectCompare,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增地图对照表",errorStatus,msg);
        };
        
		geographyObjectCompares.addItem(geographyObjectCompare,true,succ,fail);
    };

    var editSubmit = function(geographyObjectCompare,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改地图对照表",errorStatus,msg);
        };

		geographyObjectCompares.editItem(geographyObjectCompare,true,succ,fail);
    };
    
}();