/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-20 16:49:34
 * @LastEditTime: 2021-03-30 17:34:41
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form,tree = layui.tree, transfer = layui.transfer;
    var businessModels = new BusinessModels();
    var relationModel = new RelationModel();
    var tableModel = new TableModel();
    var sqlModel = new SqlModel();
    var excelModel = new ExcelModel();
    var mGeographyObjectCompare = null, layerIndex = null,mOperationType = null,formAddSubmit = null,formEditSubmit = null, mAllData = null, mBusinessObjects = null,mSelectBusinessModelID = null, mSelectBusinessModelType = null;

    window.initGeographyObjectCompareForm = function(operationType,geographyObjectCompare,index,addSubmit,editSubmit){
        mGeographyObjectCompare = geographyObjectCompare;
        layerIndex = index;
        formAddSubmit = addSubmit
        formEditSubmit = editSubmit
        mOperationType = operationType;
        getAndLoadBusinessModels();
        loadTree();
        getAndLoadBusinessObjects(mGeographyObjectCompare);

        bindElementEvent();

        if(mOperationType == 1){
            form.val("formWindow",{
                geoLevel: geographyObjectCompare.geoLevel
            });
            getCompareDetails();
        }
        form.render();
    }

    function getCompareDetails(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
			$Utils.openWindow.failWindow("获取地图对照表详情",errorStatus,msg);
		};
		mGeographyObjectCompare.getDetails(true,succ,fail);
    }

    function getAndLoadBusinessModels(){
        var succ = function(){
            $Utils.windowLoading.close();
            loadBusinessModelsSelectForm();
        };
		var fail = function(errorStatus,msg){
            $Utils.windowLoading.close();
			$Utils.openWindow.failWindow("获取业务模型列表",errorStatus,msg);
		};
		businessModels.getItems(1,true,succ,fail);
    }

    function loadBusinessModelsSelectForm(){
        var selectModelID = "";
        var businessModelsDom = document.getElementById("businessModelID");
        for(var i = 0; i < businessModels.count; i++){
            var option = document.createElement("option");
            option.setAttribute("value",businessModels.item(i).businessModelID);
            if(mOperationType == 0){
                if(i == 0){
                    option.setAttribute("selected",true);
                    selectModelID = businessModels.item(i).businessModelID;
                }
            }else if(mOperationType == 1){
                if(businessModels.item(i).businessModelID == mGeographyObjectCompare.businessModelID){
                    option.setAttribute("selected",true);
                    selectModelID = businessModels.item(i).businessModelID;
                }
            }
            option.innerText = businessModels.item(i).businessModelName;
            businessModelsDom.appendChild(option);
        }
        form.render('select');
        $Utils.windowLoading.open();
        getAndLoadBusinessObjects(businessModels.item(selectModelID));
    }

    function getAndLoadBusinessObjects(selectedBusinessModel){
        var succ = function(){
            $Utils.windowLoading.close();
            loadBusinessObjectTreeList(selectedBusinessModel.businessModelType);
        };
		var fail = function(errorStatus,msg){
            $Utils.windowLoading.close();
			$Utils.openWindow.failWindow("获取 "+selectedBusinessModel.businessObjectName+" 所属业务对象",errorStatus,msg);
        };
        if(selectedBusinessModel.businessModelType == 0){
            relationModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
        if(selectedBusinessModel.businessModelType == 1){
            tableModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
        if(selectedBusinessModel.businessModelType == 2){
            sqlModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
        if(selectedBusinessModel.businessModelType == 3){
            excelModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
    }

    function loadTree(){
        tree.render({
            elem: '#classtree',
            data: [],
            onlyIconControl: true,
            id: "authority",
            click: function(node){ //点击节点回调
                var $select = $($(this)[0].elem).parents(".layui-form-select");
                var businessObjectID = $(".map-data-box input:hidden[name='businessObjectID']").val();
                if (businessObjectID != node.data.businessObjectID){
                    mGeographyObjectCompare.geographyDataCompares = new GeographyDataCompares();
                }
                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='businessObjectID']").val(node.data.businessObjectID);
            },
        });
        $(".map-data-box .downpanel").off("click").on("click", ".layui-select-title", function (e) {
            $(".map-data-box .layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
            $(this).parents(".downpanel").toggleClass("layui-form-selected");
            layui.stope(e);
        }).on("click", "dl i", function (e) {
            layui.stope(e);
        });
        $(document).on("click", function (e) {
            $(".map-data-box .downpanel").removeClass("layui-form-selected");
        });
    }

    function loadBusinessObjectTreeList(businessModelType){
        var selectedBusinessIDs = [mGeographyObjectCompare.businessObjectID];
        var treeData = [];
        var allBusinessObjects = null;
        var businessModelID = null;
        if(businessModelType == 0){
            treeData = collectRelationModelData(selectedBusinessIDs);
            allBusinessObjects = relationModel.businessObjects;
            businessModelID = relationModel.businessModelID;
        }
        if(businessModelType == 1){
            treeData = collectOthersModelData(tableModel);
            allBusinessObjects = tableModel.businessObjects;
            businessModelID = tableModel.businessModelID;
        }
        if(businessModelType == 2){
            treeData = collectOthersModelData(sqlModel);
            allBusinessObjects = sqlModel.businessObjects;
            businessModelID = sqlModel.businessModelID;
        }
        if(businessModelType == 3){
            treeData = collectOthersModelData(excelModel);
            allBusinessObjects = excelModel.businessObjects;
            businessModelID = excelModel.businessModelID;
        }
        mBusinessObjects = allBusinessObjects;
        mSelectBusinessModelID = businessModelID;
        mSelectBusinessModelType = businessModelType
        tree.reload("authority",{data:treeData});
        if(allBusinessObjects.item(mGeographyObjectCompare.businessObjectID)){
            $(".map-data-box .downpanel").find(".layui-select-title span").html(mGeographyObjectCompare.businessObjectName).end().find("input:hidden[name='businessObjectID']").val(mGeographyObjectCompare.businessObjectID);
        }else{
            $(".map-data-box .downpanel").find(".layui-select-title span").html("无数据").end().find("input:hidden[name='businessObjectID']").val("");
        }

        $("#classtree").find(".layui-tree-set").each(function(){
            if(allBusinessObjects.item($(this).attr("data-id")) && allBusinessObjects.item($(this).attr("data-id")).businessObjectType == 0){
                $(this).find(".layui-icon-file").removeClass().addClass("iconfont bda-dimension");
            }
            if(allBusinessObjects.item($(this).attr("data-id")) && allBusinessObjects.item($(this).attr("data-id")).businessObjectType == 1){
                $(this).find(".layui-icon-file").removeClass().addClass("iconfont bda-measure");
            }
            if(allBusinessObjects.item($(this).attr("data-id")) && allBusinessObjects.item($(this).attr("data-id")).businessObjectType == 2){
                $(this).find(".layui-icon-file").removeClass().addClass("iconfont bda-measure");
            }
        });
    }

    function collectRelationModelData(selectedBusinessIDs){
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1",{title: "数据对象",id:"-1",folderID:"-1",folderParentID:"0",spread: true});
        for(var i = 0; i < relationModel.businessObjectFolders.count; i++){
            hashTable.add(relationModel.businessObjectFolders.item(i).folderID,{title:relationModel.businessObjectFolders.item(i).folderName,id:relationModel.businessObjectFolders.item(i).folderID,folderID:relationModel.businessObjectFolders.item(i).folderID,folderParentID:relationModel.businessObjectFolders.item(i).folderParentID});
        }
        for(var i = 0; i < relationModel.businessObjectFolders.count; i++){
            var parentFolder = hashTable.getValue(relationModel.businessObjectFolders.item(i).folderParentID);
            parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(relationModel.businessObjectFolders.item(i).folderID));
        }
        for(var i = 0; i < relationModel.businessObjects.count; i++){
            var businessObject = relationModel.businessObjects.item(i);
            var parentFolder = hashTable.getValue(businessObject.businessObjectFolderID);
            parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            if(selectedBusinessIDs.indexOf(businessObject.businessObjectID) != -1){
                parentFolder.children.push({title:businessObject.businessObjectName,id:businessObject.businessObjectID,businessObjectID:businessObject.businessObjectID,checked:true});
            }else{
                parentFolder.children.push({title:businessObject.businessObjectName,id:businessObject.businessObjectID,businessObjectID:businessObject.businessObjectID});
            }
        }
        if(hashTable.getValue("-1").children){
            tempArr = hashTable.getValue("-1").children;
        }
        return tempArr;
    }

    function collectOthersModelData(mSelectedBusinessModel){
        var tempArr = [];
        for(var i = 0; i < mSelectedBusinessModel.businessObjects.count; i++){
            var businessObject = mSelectedBusinessModel.businessObjects.item(i);
            var obj = {};
            obj.title = businessObject.businessObjectName;
            obj.businessObjectID = businessObject.businessObjectID;
            obj.id = businessObject.businessObjectID;
            tempArr.push(obj);
        }

        return tempArr;
    }

    function bindElementEvent(){
        form.on('select(businessModelID)', function(data){
            if(data.value != ""){
                $Utils.windowLoading.open();
                getAndLoadBusinessObjects(businessModels.item(data.value));
            }else{
                tree.reload("authority",{data:[]});
                $(".map-data-box .downpanel").find(".layui-select-title span").html("无数据").end().find("input:hidden[name='businessObjectID']").val("");
            }
        });

        form.on("submit(formSubmit)",function(obj){
            if(validate(obj)){
                var geographyObjectCompare = setGeographyObjectCompare(obj);
                if(mOperationType == 0){
                    formAddSubmit(geographyObjectCompare,layerIndex);
                }else{
                    formEditSubmit(geographyObjectCompare,layerIndex);
                }
            }
            
            return false;
        })
        
        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });

        $(".match-details").click(function(){
            var formData = form.val("formWindow");
            if(formData.businessModelID == ""){
                layer.msg("请选择业务模型。",{icon: 2});
                return;
            }
            if(formData.businessObjectID == ""){
                layer.msg("请选择业务对象。",{icon: 2});
                return;
            }
            var url = "";
            if(formData.geoLevel == 4){
                url = "html/iReport/map/countyMatchDetails.html";
            }else{
                url = "html/iReport/map/matchDetails.html";
            }
            getAndLoadMatchDetailsForm(url,formData.geoLevel,mBusinessObjects.item(formData.businessObjectID),mOperationType,mGeographyObjectCompare);
        });
    }

    function getAndLoadMatchDetailsForm(url,geoLevel,businessObject,operationType,geographyObjectCompare){
        $.ajax({
            url: url,
            type: 'GET',
            success: function(data){
                loadMatchDetailsForm(data,geoLevel,businessObject,operationType,geographyObjectCompare);
            }
        });
    }

    function loadMatchDetailsForm(strHtml,geoLevel,businessObject,operationType,geographyObjectCompare){
        layer.open({
            type: 1,
            title: ["地图数据对照","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["830px","620px"],
            content: strHtml,
            success: function(layero,index){
                initMatchDetailsForm(index,geoLevel,businessObject,operationType,geographyObjectCompare,mSelectBusinessModelType,mSelectBusinessModelID,updateMatchDetails);
            }
        });
    }

    function validate(obj){
        if(obj.field.businessModelID == ""){
            layer.msg("请选择业务模型。",{icon:2});
            return false;
        }
        if(obj.field.businessObjectID == ""){
            layer.msg("请选择业务对象。",{icon:2});
            return false;
        }
        if(mGeographyObjectCompare.geographyDataCompares.count == 0){
            layer.msg("请设置匹配详情。",{icon:2});
            return false;
        }
        return true;
    }

    function setGeographyObjectCompare(obj){
        var tempObj = {};
        tempObj.geoObjectCompareID = mGeographyObjectCompare.geoObjectCompareID;
        tempObj.geoLevel = obj.field.geoLevel;
        tempObj.businessModelID = obj.field.businessModelID;
        tempObj.businessModelName = businessModels.item(obj.field.businessModelID).businessModelName;
        tempObj.businessModelType = mSelectBusinessModelType;
        tempObj.businessObjectID = obj.field.businessObjectID;
        tempObj.businessObjectName = mBusinessObjects.item(obj.field.businessObjectID).businessObjectName;
        tempObj.geographyDataCompares = setGeographyDataCompares();
        return tempObj;
    }

    function setGeographyDataCompares(){
        var tempArr = [];
        for(var i = 0; i < mGeographyObjectCompare.geographyDataCompares.count; i++){
            tempArr.push(mGeographyObjectCompare.geographyDataCompares.item(i));
        }
        return tempArr;
    }

    var updateMatchDetails = function(compareData,index){
        mGeographyObjectCompare.geographyDataCompares.setGeographyDataCompares(compareData);
        layer.close(index);
    };

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }
    
}();