/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-21 11:45:17
 * @LastEditTime: 2020-09-10 15:50:52
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, tree = layui.tree;
    var planets = new Planets();
    var counties = new Counties();
    var layerIndex = null, mBusinessObject = null, mOperationType = null, mGeographyObjectCompare = null, mBusinessModelType = null, mBusinessModelID = null;
    var mUpdateMatchDetails = null;

    window.initMatchDetailsForm = function(index,geoLevel,businessObject,operationType,geographyObjectCompare,businessModelType,businessModelID,updateMatchDetails){
        $Utils.windowLoading.open();
        layerIndex = index;
        mBusinessObject = businessObject;
        mOperationType = operationType;
        mGeographyObjectCompare = geographyObjectCompare;
        mBusinessModelType = businessModelType;
        mBusinessModelID = businessModelID;
        mUpdateMatchDetails = updateMatchDetails;
        getAndLoadList();
        loadListTitle();

        bindEvent();
    };

    function getAndLoadList(){
        var succ = function(){
            getBusinessObjectDataAndLoadList();
        };
		var fail = function(errorStatus,msg){
			$Utils.openWindow.failWindow("获取地图列表",errorStatus,msg);
		};
        planets.getItems(true,succ,fail);
    }

    function getBusinessObjectDataAndLoadList(){
        var succ = function(data){
            $Utils.windowLoading.close();
            loadList(data);
        };
		var fail = function(errorStatus,msg){
			$Utils.openWindow.failWindow("获取 "+mBusinessObject.businessObjectName+" 值列表",errorStatus,msg);
        };
        var basePath = "";
        if(mBusinessModelType == 0){
            basePath = $AppURLs.relationModelPath;
        }
        if(mBusinessModelType == 1){
            basePath = $AppURLs.tableModelPath;
        }
        if(mBusinessModelType == 2){
            basePath = $AppURLs.sqlModelPath;
        }
        if(mBusinessModelType == 3){
            basePath = $AppURLs.excelModelPath;
        }
        mBusinessObject.getBusinessData(basePath,mBusinessModelID,true,succ,fail)
    }

    function loadList(businessObjectData){
        loadLeftTree();
        loadRightList(businessObjectData);
        loadMiddleList();
    }

    function loadLeftTree(){
        var treeData = [];
        for(var i = 0; i < planets.item(0).countries.count; i++){
            if(planets.item(0).countries.item(i).provinces.count){
                var tempObj = {};
                tempObj.id = planets.item(0).countries.item(i).countryCode;
                tempObj.title = planets.item(0).countries.item(i).countryName;
                tempObj.parentID = planets.item(0).countries.item(i).planetID;
                tempObj.children = setProvinces(planets.item(0).countries.item(i).provinces);
                treeData.push(tempObj);
            }
        }
        tree.render({
            elem: '#treeList',
            data: treeData,
            click: function(obj){
                $("#treeList").find(".select-value").removeClass("select-value");
                $(obj.elem).children(".layui-tree-entry").find(".layui-tree-txt").addClass("select-value");

                if(obj.data.cityID){
                    getAndLoadCounties(obj.data.cityID);
                }
            }
        });
    }

    function setProvinces(provincesObj){
        var tempArr = [];
        for(var i = 0; i < provincesObj.count; i++){
            var tempObj = {};
            tempObj.id = provincesObj.item(i).provinceCode;
            tempObj.title = provincesObj.item(i).provinceName;
            tempObj.parentID = provincesObj.item(i).countryID;
            if(provincesObj.item(i).haveChildMap){
                tempObj.children = setCities(provincesObj.item(i).cities);
            }else{
                tempObj.children = [];
            }
            tempArr.push(tempObj);
        }
        return tempArr;
    }

    function setCities(citiesObj){
        var tempArr = [];
        for(var i = 0; i < citiesObj.count; i++){
            var tempObj = {};
            tempObj.id = citiesObj.item(i).cityCode;
            tempObj.title = citiesObj.item(i).cityName;
            tempObj.parentID = citiesObj.item(i).provinceID;
            tempObj.cityID = citiesObj.item(i).cityID;
            tempObj.children = [];
            tempArr.push(tempObj);
        }
        return tempArr;
    }

    function getAndLoadCounties(cityID){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            loadLeftList();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取县区",errorStatus,msg);
        };
        counties.getItemsByCityID(cityID,true,succ,fail);
    }

    function loadRightList(businessObjectData){
        var rightNames = setRightNames(businessObjectData);
        for(var i = 0; i < mGeographyObjectCompare.geographyDataCompares.count; i++){
            var geographyDataCompare = mGeographyObjectCompare.geographyDataCompares.item(i);
            if(rightNames.indexOf(geographyDataCompare.objectGeoName) != -1){
                rightNames.splice(rightNames.indexOf(geographyDataCompare.objectGeoName),1);
            }
        }
        for(var i = 0; i < rightNames.length; i++){
            str = "<li><span title='"+rightNames[i]+"'>"+rightNames[i]+"</span></li>"
            $(".box-right .list").append(str);
        }
    }

    function setRightNames(businessObjectData){
        var tempArr = [];
        for(var i = 0; i < businessObjectData.length; i++){
            tempArr.push(businessObjectData[i][mBusinessObject.businessObjectName]);
        }
        return tempArr;
    }

    function loadLeftList(){
        $(".box-left .list").html("");
        var leftNames = setLeftNames();
        for(var i = 0; i < mGeographyObjectCompare.geographyDataCompares.count; i++){
            var geographyDataCompare = mGeographyObjectCompare.geographyDataCompares.item(i);
            for(var j = leftNames.length - 1; j >= 0; j--){
                if(leftNames[j].name == geographyDataCompare.mapGeoName){
                    leftNames.splice(j,1);
                }
            }
        }
        for(var i = 0; i < leftNames.length; i++){
            str = "<li data-parentid="+leftNames[i].parentID+" data-longitude="+leftNames[i].longitude+" data-latitude="+leftNames[i].latitude+"><span title='"+leftNames[i].name+"'>"+leftNames[i].name+"</span></li>";
            $(".box-left .list").append(str);
        }
    }

    function setLeftNames(){
        var tempArr = [];
        var tempObj = {};
        for(var i = 0; i < counties.count; i++){
            tempObj = {};
            tempObj.name = counties.item(i).countyName;
            tempObj.parentID = counties.item(i).cityID;
            tempObj.longitude = counties.item(i).longitude;
            tempObj.latitude = counties.item(i).latitude;
            tempArr.push(tempObj);
        }

        return tempArr;
    }

    function loadMiddleList(){
        var str = "";
        for(var i = 0; i < mGeographyObjectCompare.geographyDataCompares.count; i++){
            var geographyDataCompare = mGeographyObjectCompare.geographyDataCompares.item(i);
            str = "<li data-parentid="+geographyDataCompare.parentID+" data-longitude="+geographyDataCompare.longitude+" data-latitude="+geographyDataCompare.latitude+"><span title='"+geographyDataCompare.mapGeoName+"'>"+geographyDataCompare.mapGeoName+"</span><span title='"+geographyDataCompare.objectGeoName+"'>"+geographyDataCompare.objectGeoName+"</span></li>"
            $(".box-middle .list").append(str);
        }
        if($(".box-middle .list li").width() < 268){
            $(".box-middle .list li span").width(114);
        }
    }

    function loadListTitle(){
        $(".box-left h3").html("县区");
        $(".box-right h3").html(mBusinessObject.businessObjectName);
        $(".box-middle h3").html("<span class'geo-column'>县区</span><span class='object-column'>"+mBusinessObject.businessObjectName+"</span>");
    }
    
    function bindEvent(){
        $(".box-left ul").on("click","li",function(){
            if(!$(this).hasClass("select-value")){
                $(this).addClass("select-value").siblings("li").removeClass("select-value");
            }
        });

        $(".box-right ul").on("click","li",function(){
            if(!$(this).hasClass("select-value")){
                $(this).addClass("select-value").siblings("li").removeClass("select-value");
            }
        });

        $(".box-middle ul").on("click","li",function(){
            if(!$(this).hasClass("select-value")){
                $(this).addClass("select-value").siblings("li").removeClass("select-value");
            }
        });

        $(".compare-box-top .left-button").click(function(){
            if($(".box-left ul").find("li.select-value").length){
                var name = $(".box-left ul").find("li.select-value").text();
                var parentID = $(".box-left ul").find("li.select-value").attr("data-parentid");
                var longitude = $(".box-left ul").find("li.select-value").attr("data-longitude");
                var latitude = $(".box-left ul").find("li.select-value").attr("data-latitude");
                var str = "<li data-parentid="+parentID+" data-longitude="+longitude+" data-latitude="+latitude+"><span title='"+name+"'>"+name+"</span></li>";
                $(".box-middle ul").append(str);
                $(".box-left ul").find("li.select-value").remove();
            }
        });

        $(".compare-box-top .right-button").click(function(){
            if($(".box-right ul").find("li.select-value").length && $(".box-middle ul").find("li.select-value").length){
                var str = "<span title='"+$(".box-right ul").find("li.select-value").text()+"'>"+$(".box-right ul").find("li.select-value").text()+"</span>";

                if($(".box-middle ul").find("li.select-value span").length > 1){
                    var lastStr = $(".box-middle ul").find("li.select-value span").eq(1).text();
                    $(".box-middle ul").find("li.select-value span").eq(1).remove();
                    $(".box-right ul").append("<li><span title='"+lastStr+"'>"+lastStr+"</span></li>");
                }
                $(".box-middle ul").find("li.select-value").append(str);
                $(".box-right ul").find("li.select-value").remove();
                if($(".box-middle .list li").width() < 238){
                    $(".box-middle .list li span:last-child").width(90);
                }
            }
        });

        $(".delete-match").click(function(){
            if($(".box-middle ul").find("li.select-value").length){
                var firstStr = $(".box-middle ul").find("li.select-value span").eq(0).text();
                var lastStr = $(".box-middle ul").find("li.select-value span").eq(1).text();
                var parentID = $(".box-middle ul").find("li.select-value").attr("data-parentid");
                var longitude = $(".box-middle ul").find("li.select-value").attr("data-longitude");
                var latitude = $(".box-middle ul").find("li.select-value").attr("data-latitude");
                $(".box-left ul").append("<li data-parentid="+parentID+" data-longitude="+longitude+" data-latitude="+latitude+"><span title='"+firstStr+"'>"+firstStr+"</span></li>");
                $(".box-right ul").append("<li><span title='"+lastStr+"'>"+lastStr+"</span></li>");
                $(".box-middle ul").find("li.select-value").remove();
            }
        });

        $(".auto-match").click(function(){
            if($(".box-left ul li").length && $(".box-right ul li").length){
                setAutoMatch();
            }
        });

        $(".match-details-button .layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });

        $(".match-details-button .layui-btn-determine").click(function(){
            if(change()){
                var compareData = setCompare();
                mUpdateMatchDetails(compareData,layerIndex);
            }
        });
    }

    function setAutoMatch(){
        var leftNames = [];
        var rightNames = [];
        var middleNames = [];
        var tempObj = {};

        $(".box-left ul li").each(function(){
            tempObj = {};
            tempObj.name = $(this).text();
            tempObj.parentID = $(this).attr("data-parentid");
            tempObj.longitude = $(this).attr("data-longitude");
            tempObj.latitude = $(this).attr("data-latitude");
            leftNames.push(tempObj);
        });

        $(".box-right ul li").each(function(){
            rightNames.push($(this).text());
        });

        for(var i = leftNames.length - 1; i >= 0; i--){
            for(var j = rightNames.length - 1; j >= 0; j--){
                if(leftNames[i].name.indexOf(rightNames[j]) != -1 || rightNames[j].indexOf(leftNames[i].name) != -1){
                    var tempArr = [];
                    tempArr.push(leftNames[i]);
                    tempArr.push(rightNames[j]);
                    middleNames.push(tempArr);
                    leftNames.splice(i,1);
                    rightNames.splice(j,1);
                    break;
                }
            }
        }

        $(".box-left ul,.box-right ul").html("");

        var str = ""
        for(var i = 0; i < leftNames.length; i++){
            str = "<li data-parentid="+leftNames[i].parentID+" data-longitude="+leftNames[i].longitude+" data-latitude="+leftNames[i].latitude+"><span title='"+leftNames[i].name+"'>"+leftNames[i].name+"</span></li>";
            $(".box-left .list").append(str);
        }
        for(var i = 0; i < rightNames.length; i++){
            str = "<li><span title='"+rightNames[i]+"'>"+rightNames[i]+"</span></li>";
            $(".box-right .list").append(str);
        }

        for(var i = middleNames.length - 1; i >= 0; i--){
            str = "<li data-parentid="+middleNames[i][0].parentID+" data-longitude="+middleNames[i][0].longitude+" data-latitude="+middleNames[i][0].latitude+"><span title='"+middleNames[i][0].name+"'>"+middleNames[i][0].name+"</span><span title='"+middleNames[i][1]+"'>"+middleNames[i][1]+"</span></li>";
            $(".box-middle .list").append(str);
        }
        if($(".box-middle .list li").width() < 268){
            $(".box-middle .list li span").width(114);
        }
    }

    function change(){
        var result = true;
        $(".box-middle ul").find("li").each(function(){
            if($(this).find("span").length < 2){
                layer.msg("对照关系 "+$(this).find("span").text()+" 没有对应的值。",{icon:2});
                result = false;
                return false;
            }
        });

        return result;
    }

    function setCompare(){
        var compareData = [];
        $(".box-middle ul").find("li").each(function(){
            var geographyDataCompare = new GeographyDataCompare();
            geographyDataCompare.mapGeoName = $(this).find("span").eq(0).text();
            geographyDataCompare.objectGeoName = $(this).find("span").eq(1).text();
            geographyDataCompare.parentID = $(this).attr("data-parentid");
            geographyDataCompare.longitude = $(this).attr("data-longitude");
            geographyDataCompare.latitude = $(this).attr("data-latitude");
            compareData.push(geographyDataCompare);
        });
        
        return compareData;
    }
    
}();