/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-19 17:10:39
 * @LastEditTime: 2021-02-21 18:31:08
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var reportImages = new ReportImages();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadTableBody();

        bindEvent();
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "imageName",title:"名称",templet: "#preview", sort: true},
                {field: "createUserName",title: "上传者", width: 150, sort: true},
                {field: "createDate",title: "上传时间", width: 125, sort: true},
                {title: "操作",templet: "#setAuthority", width: 80, align: "center"}
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取图片列表",errorStatus,msg);
		};
		reportImages.getItems(true,succ,fail);
    }

    function setTableBody(){
        var tableBody = [];
        for(var i = 0; i < reportImages.count; i++){
            var tempObj = {};
            for(var key in reportImages.item(i)){
                if(typeof reportImages.item(i)[key] === "function"){ continue;}
                if(key == "createDate"){
                    tempObj[key] = reportImages.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(reportImages.item(i)[key])):"";
                }else{
                    tempObj[key] = reportImages.item(i)[key];
                }
            }
            tableBody.push(tempObj);
        }
        return tableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        var tableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("objectList",{data:tableBody,limit:tableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindEvent(){
        table.on('sort(objectList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });
        
        $(".upload").click(function(){
            $("#uploadFile").click();
        });

        $("#uploadFile").change(function(e) {
            Object.values = function(obj){
                return Object.keys(obj).map(function(e){
                    return obj[e];
                });
            };
            var files = Object.values(e.target.files);
            uploadFile(files[0]);
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTableBody();
        });

        $(".delete").click(function(){
            if(table.checkStatus('objectList').data.length){
                layer.open({
                    type: 0,
                    title: "删除图片",
                    closeBtn: 1,
                    shadeClose: true,
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('objectList').data[0].imageName+" ？</div></div>",
                    btn: ["是","否"],
                    success: function(layero,index){
                        $(layero).find('.layui-layer-content').css('height','137px');
                    },
                    yes: function(index,layero){
                        layer.close(index);
                        $Utils.loading.open();
                        deleteImage(table.checkStatus('objectList').data[0].imageID);
                    }
                });
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        table.on("tool(objectList)", function(obj){
            if(obj.event == "preview"){
                loadImage(obj.data);
            }
            if(obj.event == "download"){
                downloadFile(obj.data);
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].imageName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function uploadFile(fileObj){
        var file = new FormData();
        file.append("file", fileObj);
        var succ = function(data){
            $Utils.loading.close();
            layer.msg("上传成功。",{icon:1});
            getAndLoadTableBody();
            $("#uploadFile")[0].value = '';
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("上传图片",errorStatus,msg);
        };
        reportImages.addItem(file,true,succ,fail);
    }

    function deleteImage(imageID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除图片",errorStatus,msg);
        };
        reportImages.deleteItem(imageID,true,succ,fail);
    }

    function loadImage(reportImage){
        var imgURL = $AppConstants.hostName + $AppConstants.port + "/Report/" + reportImage.imageURL
        var image = new Image();
        image.onload = function() {
            var max_height = $(window).height() - 100;
            var max_width = $(window).width();
    
            //rate1，rate2，rate3 三个比例中取最小的。
            var rate1 = max_height / image.height;
            var rate2 = max_width / image.width;
            var rate3 = 1;
            var rate = Math.min(rate1, rate2, rate3);
            //等比例缩放
            var imgHeight = image.height * rate; //获取图片高度
            var imgWidth = image.width * rate; //获取图片宽度
    
            var imgHtml = "<img src='" + imgURL + "' width='" + imgWidth + "' height='" + imgHeight + "'/>";
            layer.open({
                type: 1,
                title: false,//不显示标题
                closeBtn: 0,
                area: ['auto', 'auto'],
                skin: 'layui-layer-nobg', //没有背景色
                shadeClose: true,
                content: imgHtml
            });
        }
        image.src = imgURL;
    }

    function downIMG(name){
        if ($('#IframeReportImg').attr("src") != "about:blank") {
            window.frames["IframeReportImg"].document.execCommand("SaveAs",true,name);
        }
    }

    function downloadFile(reportImage){
        var imgURL = $AppConstants.hostName + $AppConstants.port + "/Report/" + reportImage.imageURL
        // var imgURL = "/Report/" + reportImage.imageURL
        if (!!window.ActiveXObject || "ActiveXObject" in window){
            if ($("#IframeReportImg").length === 0){
                $('<iframe style="display:none;" id="IframeReportImg" name="IframeReportImg" width="0" height="0" src="'+imgURL+'"></iframe>').appendTo("body");
            }
            if ($('#IframeReportImg').attr("src") != imgURL) {
                $('#IframeReportImg').attr("src",imgURL);
                downIMG(reportImage.imageName);
            } else {
                //如指向图片地址,直接调用下载方法
                setTimeout(function(){
                    downIMG(reportImage.imageName);
                },1000);
            }
        }else{
            var image = new Image();
            // 解决跨域 Canvas 污染问题
            image.setAttribute("crossOrigin", "anonymous");
            image.onload = function() {
                var canvas = document.createElement("canvas");
                canvas.width = image.width;
                canvas.height = image.height;
                var context = canvas.getContext("2d");
                context.drawImage(image, 0, 0, image.width, image.height);
                var url = canvas.toDataURL("image/png"); //得到图片的base64编码数据
                var a = document.createElement("a"); // 生成一个a元素
                // var event = new MouseEvent("click"); // 创建一个单击事件
                // a.download = reportImage.imageName; // 设置图片名称
                // a.href = url; // 将生成的URL设置为a.href属性
                // a.dispatchEvent(event); // 触发a的单击事件
                // $(a).remove();
                a.href = url;
                a.download = reportImage.imageName;
                a.click();
                $(a).remove();
            }
            image.src = imgURL;
        }
    }

}();