/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-03-09 09:42:02
 * @LastEditTime: 2021-03-31 09:29:46
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer;
    var menus = new Menus();
    var reportFolders = new ReportFolders();

    // $Utils.loading.open();
    initReportModule();

    function initReportModule(){
        loadModuleTitle();
        getAndLoadReportMenus()
        
        $Utils.loading.close();

        $(".left-menu-cnt .menu-list > ul").on("click", "div", function () {
            $(".left-menu-cnt .menu-list > ul").find(".select-menu").removeClass("select-menu");
            if ($(this).parent("li").hasClass("folder")) {
                if ($(this).siblings("ul").is(":hidden")) {
                    $(this).find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
                    $(this).siblings("ul").show(200);
                    $(this).parents("li").addClass("select-menu");
                } else {
                    $(this).find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
                    $(this).siblings("ul").hide(200);
                    $(this).parents("li").addClass("select-menu");
                }
            } else {
                if (!$(this).parent("li").hasClass("select-menu")) {
                    $(this).parents("li").addClass("select-menu");
                    loadMenuList($(this).parent("li").attr("data-menucode"));
                    // setBread(this);
                }
            }
        });
    }

    function loadModuleTitle(){
        var nameCn = "报表设计";
        var nameOther = "iReport";
        $(".module-title p").html("<span class='module-name'>"+nameCn+"</span> / <span class='module-name-other-language'>"+nameOther+"</span>");
    }

    function getAndLoadReportMenus() {
        var succ = function () {
            $Utils.loading.close();
            loadMenus();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取系统管理菜单", errorStatus, msg);
        };
        menus.getItems(3, true, succ, fail);
    }

    function loadMenus() {
        $(".menu-list > ul").html("");
        var str = "";
        for (var i = 0; i < menus.count; i++) {
            if (menus.item(i).menuParentID == -1) {
                if (menus.item(i).lastLevel == false) {
                    str = "<li class='folder folder-hide' data-menuid=" + menus.item(i).menuID + " data-menucode=" + menus.item(i).menuCode + "><div title=" + menus.item(i).menuName + "><i class='iconfont bda-" + (menus.item(i).menuCode == 21000 ? "dataBase" : "moxing") + "'></i>" + menus.item(i).menuName + "<i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>"
                } else {
                    str = "<li class='report' data-menuid=" + menus.item(i).menuID + " data-menucode=" + menus.item(i).menuCode + "><div title=" + menus.item(i).menuName + "><i class='iconfont bda-" + (menus.item(i).menuCode == 31000 ? "menu2" : (menus.item(i).menuCode == 32000 ? "ditu" : (menus.item(i).menuCode == 33000 ? "Office" : (menus.item(i).menuCode == 34000 ? "tupian" : (menus.item(i).menuCode == 35000 ? "tiaoseban" : "ziyuanwenjian"))))) + "'></i><span>" + menus.item(i).menuName + "</span></div></li>"
                }
                $(".menu-list > ul").append(str);
            } else {
                if (menus.item(i).lastLevel == false) {
                    str = "<li class='folder folder-hide' data-menuid=" + menus.item(i).menuID + " data-menucode=" + menus.item(i).menuCode + "><div title=" + menus.item(i).menuName + "><i class='iconfont bda-wenjianjia'></i>" + menus.item(i).menuName + "<i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>"
                } else {
                    str = "<li class='report' data-menuid=" + menus.item(i).menuID + " data-menucode=" + menus.item(i).menuCode + "><div title=" + menus.item(i).menuName + ">" + menus.item(i).menuName + "</div></li>";
                }
                $(".menu-list > ul").find("li").each(function () {
                    if ($(this).attr("data-menuid") == menus.item(i).menuParentID) {
                        $(this).children("ul").append(str);
                    }
                });
            }
        }
        $(".menu-list > ul > li:first-child > div").trigger("click");
        $(".menu-list > ul > li:first-child ul li:first-child div").trigger("click");
    }

    function loadMenuList(menuCode) {
        switch (Number(menuCode)) {
            case 31000:
                getListHtml("html/iReport/report/reports.html");
                break;
            case 32000:
                getListHtml("html/iReport/map/mapMenus.html");
                break;
            case 33000:
                getListHtml("html/iReport/office/offices.html");
                break;
            case 34000:
                getListHtml("html/iReport/image/images.html");
                break;
            case 35000:
                getListHtml("html/iReport/color/colors.html");
                break;
            case 36000:
                getListHtml("html/iReport/resourceFile/resourceFiles.html");
                break;
        }
    }

    function getListHtml(url) {
        $.ajax({
            url: url,
            type: 'GET',
            success: function (data) {
                $(".report-module-right").children().remove();
                $(".report-module-right").html(data);
            }
        });
    }

}();