/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-19 18:11:00
 * @LastEditTime: 2021-03-30 17:35:24
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var bdaColorPalettes = new BDAColorPalettes();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadTableBody();

        bindEvent();
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "paletteName", title: "名称", sort: true},
                {field: "colorSequence", title: "颜色序列", templet: function(d){
                    var str = "";
                    for(var i = 0; i < d.colorSequence.length; i++){
                        str += "<span style='background-color:"+$Utils.csharp2rgba(d.colorSequence[i])+"'></span>";
                    }
                    return ("<span class='color-sequence'>"+ str +"</span>");
                }},
                {field: "preseted",title: "预设", templet: "#preseted", sort: true}
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 194, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取调色板列表",errorStatus,msg);
		};
		bdaColorPalettes.getItems(true,succ,fail);
    }

    function setTableBody(){
        var tableBody = [];
        for(var i = 0; i < bdaColorPalettes.count; i++){
            var tempObj = {};
            for(var key in bdaColorPalettes.item(i)){
                if(typeof bdaColorPalettes.item(i)[key] === "function"){ continue;}
                tempObj[key] = bdaColorPalettes.item(i)[key];
            }
            tableBody.push(tempObj);
        }
        return tableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        var tableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("objectList",{data:tableBody,limit:tableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindEvent(){
        table.on('sort(objectList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });
        
        $(".add").click(function(){
            var bdaColorPalette = new BDAColorPalette();
            getAndLoadBDAColorPaletteForm(0,bdaColorPalette);
        });

        $(".edit").click(function(){
            if(table.checkStatus('objectList').data.length){
                var bdaColorPalette = bdaColorPalettes.item(table.checkStatus('objectList').data[0].paletteID);
                getAndLoadBDAColorPaletteForm(1,bdaColorPalette);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTableBody();
        });

        $(".delete").click(function(){
            if(table.checkStatus('objectList').data.length){
                layer.open({
                    type: 0,
                    title: "删除调色板",
                    closeBtn: 1,
                    shadeClose: true,
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('objectList').data[0].paletteName+" ？</div></div>",
                    btn: ["是","否"],
                    success: function(layero,index){
                        $(layero).find('.layui-layer-content').css('height','137px');
                    },
                    yes: function(index,layero){
                        layer.close(index);
                        $Utils.loading.open();
                        deleteBDAColorPalette(table.checkStatus('objectList').data[0].paletteID);
                    }
                });
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].paletteName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadBDAColorPaletteForm(operationType,bdaColorPalette){
        $.ajax({
            url: "html/iReport/color/color.html",
            type: 'GET',
            success: function(data){
                loadBDAColorPaletteForm(data,operationType,bdaColorPalette)
            }
        });
    }

    function loadBDAColorPaletteForm(strHtml,operationType,bdaColorPalette){
        layer.open({
            type: 1,
            title: [operationType?(bdaColorPalette.paletteName+" 属性"):"新增调色板","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initBDAColorPaletteForm(index,operationType,bdaColorPalette,addSubmit,editSubmit);
            }
        });
    }

    function deleteBDAColorPalette(paletteID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除调色板",errorStatus,msg);
        };
        bdaColorPalettes.deleteItem(paletteID,true,succ,fail);
    }

    var addSubmit = function(bdaColorPalette,index){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增调色板",errorStatus,msg);
        };
        
		bdaColorPalettes.addItem(bdaColorPalette,true,succ,fail);
    };

    var editSubmit = function(bdaColorPalette,index){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改调色板",errorStatus,msg);
        };
		bdaColorPalettes.editItem(bdaColorPalette,true,succ,fail);
    };
    
}();