/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-09 11:14:56
 * @LastEditTime: 2020-11-14 17:54:33
 * @LastModifyUser: 
 * @Remark: 
 */
function Favorites(){
    var me = this;
    this.count = 0;
    this.aryFavorites = [];
    this.dicFavorites = {};

    this.add = function (report) {
        this.aryFavorites.push(report);
        this.dicFavorites[report.reportID] = report;
        this.count = this.aryFavorites.length;
    };
    this.remove = function (report) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryFavorites[i].reportID==report.reportID){
                k = i;
                break;
            }
        }
        this.aryFavorites.splice(k,1);
        delete this.dicFavorites[report.reportID];
        this.count = this.aryFavorites.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryFavorites[indexOrKey];
        }else{
            return this.dicFavorites[indexOrKey];
        }
    };
    this.addItem = function(userID,report,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportUsersPath + "/" + userID + "/favorite?reportID=" + report.reportID;
        var obj = "";
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                me.add(report);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(userID,reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportUsersPath + "/" + userID + "/favorite/" + reportID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(reportID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportUsersPath + "/" + userID + "/favorite";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setFavorites(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setFavorites(data){
        me.count = 0;
        me.aryFavorites = [];
        me.dicFavorites = {};
        for(var i = 0; i < data.length; i++){
            var report = new Report();
            report.init(data[i]);
            me.add(report);
        }
    }
}

function SelfAnalysis(){
    var me = this;
    this.count = 0;
    this.arySelfAnalysis = [];
    this.dicSelfAnalysis = {};

    this.add = function (report) {
        this.arySelfAnalysis.push(report);
        this.dicSelfAnalysis[report.reportID] = report;
        this.count = this.arySelfAnalysis.length;
    };
    this.remove = function (report) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.arySelfAnalysis[i].reportID==report.reportID){
                k = i;
                break;
            }
        }
        this.arySelfAnalysis.splice(k,1);
        delete this.dicSelfAnalysis[report.reportID];
        this.count = this.arySelfAnalysis.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.arySelfAnalysis[indexOrKey];
        }else{
            return this.dicSelfAnalysis[indexOrKey];
        }
    };
    this.deleteItem = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(reportID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "?moduleID="+moduleID+"&createSource=1";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setSelfAnalysis(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    function setSelfAnalysis(data){
        me.count = 0;
        me.arySelfAnalysis = [];
        me.dicSelfAnalysis = {};
        for(var i = 0; i < data.length; i++){
            var report = new Report();
            report.init(data[i]);
            me.add(report);
        }
    }
}

function ChartSample(){
    this.chartID = null;
    this.chartCode = null;
    this.chartName = null;
    this.chartURL = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    }
}

function ChartSamples(){
    var me = this;
    this.count = 0;
    this.aryChartSamples = [];
    this.dicChartSamples = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryChartSamples[indexOrKey];
        }else{
            return this.dicChartSamples[indexOrKey];
        }
    };
    this.add = function (chartSample) {
        this.aryChartSamples.push(chartSample);
        this.dicChartSamples[chartSample.chartID] = chartSample;
        this.count = this.aryChartSamples.length;
    };
    this.remove = function (chartSample) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryChartSamples[i].chartID==chartSample.chartID){
                k = i;
                break;
            }
        }
        this.aryChartSamples.splice(k,1);
        delete this.dicChartSamples[chartSample.chartID];
        this.count = this.aryChartSamples.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.chartSamplePath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setChartSamples(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setChartSamples(data){
        me.count = 0;
        me.aryReports = [];
        me.dicReports = {};
        for(var i = 0; i < data.length; i++){
            var chartSample = new ChartSample();
            chartSample.init(data[i]);
            me.add(chartSample);
        }
    }
}

function ReportSetting(){
    this.reportSettingKey = null;
    this.reportSettingValue = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function ReportSettings(){
    var me = this;
    this.count = 0;
    this.dicreportSettings = {};
    this.aryreportSettings = [];

    this.add = function (reportSetting) {
        this.aryreportSettings.push(reportSetting);
        this.dicreportSettings[reportSetting.reportSettingKey]=reportSetting;

        this.count = this.aryreportSettings.length;
    };
    this.remove = function (reportSetting) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryreportSettings[i].reportSettingKey==reportSetting.reportSettingKey){
                k=i;
                break;
            }
        }
        this.aryreportSettings.splice(k,1);
        delete this.dicreportSettings[reportSetting.reportSettingKey];

        this.count=this.aryreportSettings.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryreportSettings[indexOrKey];
        }else{
            return this.dicreportSettings[indexOrKey];
        }
    };

    this.getItemsByReportID = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID + "/reportSettings";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setReportSettings(data.property);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setReportSettings(data) {
        me.count = 0;
        me.dicreportSettings = {};
        me.aryreportSettings = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var reportSetting = new ReportSetting();
            reportSetting.init(data[intI]);
            me.add(reportSetting);
        }
    }
}