/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-03-09 09:42:02
 * @LastEditTime: 2021-04-06 15:28:17
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer;
    var menus = new Menus();
    var favorites = new Favorites();
    var folders = new ReportFolders();
    var reports = new Reports();
    var selfAnalysis = new SelfAnalysis();
    var chartSamples = new ChartSamples();
    var linkShares = new LinkShares();
    var reportBoxArr = [];
    var firstOpen = true;
    var isMagnify = false;

    $Utils.loading.open();
    initFind();

    function initFind(){
        loadModuleTitle();
        getMenus();
        getFavorites();
        getFolders();
        getReports();
        getSelfAnalysis();
        if($AppVars.gOrganizationUsers.item(0).organizationUserSettings.item("showChartSample").settingValue == 1){
            getChartSamples();
        }
        creatMainMenu();
        creatTree();

        var reportIsExistence = false;
        for(var i = 0; i < reports.count; i++){
            if(reports.item(i).reportID == $AppVars.gOrganizationUsers.item(0).organizationUserSettings.item("pageURI").settingValue){
                reportIsExistence = true;
                break;
            }
        }
        for(var i = 0; i < selfAnalysis.count; i++){
            if(selfAnalysis.item(i).reportID == $AppVars.gOrganizationUsers.item(0).organizationUserSettings.item("pageURI").settingValue){
                reportIsExistence = true;
                break;
            }
        }
        if(reportIsExistence){
            addTabOpenReport($AppVars.gOrganizationUsers.item(0).organizationUserSettings.item("pageURI").settingValue,null);
        }else{
            addTabOpenReport("home.html",null);
        }
        $Utils.loading.close();
        
        bindEvent();
    }

    function loadModuleTitle(){
        var nameCn = "数据探索";
        var nameOther = "iFind";
        $(".module-title p").html("<span class='module-name'>"+nameCn+"</span> / <span class='module-name-other-language'>"+nameOther+"</span>");
    }

    function getMenus(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据探索菜单列表",errorStatus,msg);
		};
		menus.getItems(0,false,succ,fail);
    }

    function getFavorites(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取收藏列表",errorStatus,msg);
		};
		favorites.getItems($AppVars.gLogin.userID,false,succ,fail);
    }

    function getFolders(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表文件夹列表",errorStatus,msg);
		};
		folders.getItems(false,succ,fail);
    }

    function getReports(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表列表",errorStatus,msg);
		};
		reports.getItems(0,false,succ,fail);
    }

    function getSelfAnalysis(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取自助报表列表",errorStatus,msg);
		};
		selfAnalysis.getItems(0,false,succ,fail);
    }

    function getChartSamples(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取图表样例列表",errorStatus,msg);
		};
		chartSamples.getItems(false,succ,fail);
    }

    function creatMainMenu(){
		var str = "";
        for(var i = 0; i < menus.count; i++){
            if(menus.item(i).menuParentID == -1){
                if(menus.item(i).menuID == 4){
                    if($AppVars.gOrganizationUsers.item(0).organizationUserSettings.item("showChartSample").settingValue == 1){
                        str = "<li class='category' data-menu='"+menus.item(i).menuID+"' title='"+menus.item(i).menuName+"'><div class='clearfix menu'><i class='iconfont bda-menu"+menus.item(i).menuID+"'></i><span>"+menus.item(i).menuName+"</span><i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>";
                        $(".menu-list > ul").append(str);
                    }
                }else if(menus.item(i).menuID == 51){
                    if($AppVars.gOrganizationUsers.item(0).organizationUserSettings.item("showExcelUpload") && ($AppVars.gOrganizationUsers.item(0).organizationUserSettings.item("showExcelUpload").settingValue == 1)){
                        str = "<li class='category' data-menu='"+menus.item(i).menuID+"' title='"+menus.item(i).menuName+"'><div class='clearfix menu'><i class='iconfont bda-21excel'></i><span>"+menus.item(i).menuName+"</span><i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>";
                        $(".menu-list > ul").append(str);
                    }
                }else{
                    str = "<li class='category' data-menu='"+menus.item(i).menuID+"' title='"+menus.item(i).menuName+"'><div class='clearfix menu'><i class='iconfont bda-menu"+menus.item(i).menuID+"'></i><span>"+menus.item(i).menuName+"</span><i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>";
                    $(".menu-list > ul").append(str);
                }
            }else{
                if(menus.item(i).lastLevel == false){
                    str = "<li class='folder folder-hide' data-menu="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+"><i class='iconfont bda-wenjianjia'></i><span>"+menus.item(i).menuName+"</span><i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>"
                }else{
                    str = "<li class='report' data-menu="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+"><span>"+menus.item(i).menuName+"</span></div></li>";
                }
                $(".menu-list > ul").find("li").each(function(){
                    if($(this).attr("data-menu") == menus.item(i).menuParentID){
                        $(this).children("ul").append(str);
                    }
                });
            }
        }
    }
    
    function creatTree(){
        $(".menu-list > ul").children("li").each(function(){
			var elem = $(this).children("ul");
			var serialNumber = $(this).attr("data-menu");
			if(serialNumber==1){
				creatMyFavoriteList(elem);
			}else if(serialNumber==2){
				creatFolderOrReport(elem);
			}else if(serialNumber==3){
				creatSelfAnalysis(elem);
			}else if(serialNumber==4 && $AppVars.gOrganizationUsers.item(0).organizationUserSettings.item("showChartSample").settingValue == 1){
				creatChartSample(elem);
			}
		});
		$(".menu-list > ul").find("ul").hide();
    }

    function creatMyFavoriteList(elem){
		var str = "";
		// $(elem).append("<ul></ul>");
        for(var i = 0; i < favorites.count; i++){
            str += "<li class='report' data-index='"+favorites.item(i).reportID+"' title='"+favorites.item(i).reportName+"'><div><i class='iconfont bda-shilitubiao'></i><span>"+favorites.item(i).reportName+"</span></div></li>";
        }
		elem.append(str);
    }
    
    function creatFolderOrReport(elem){
		// $(elem).append("<ul></ul>");
		creatFolders(elem);
		creatReport(elem);
    }
    
    function creatFolders(elem){
		var haveReportFolders = [];
        for(var i = 0; i < reports.count; i++){
            var folderID = reports.item(i).folderID;
            while(folderID != -1 && haveReportFolders.indexOf(folderID) == -1){
                haveReportFolders.push(folderID);
                folderID = folders.item(folderID).folderParentID;
            }
        }

		for(var i = folders.count-1;i>=0;i--){
			if(haveReportFolders.indexOf(folders.item(i).folderID) == -1){
				folders.remove(folders.item(i));
			}
        }
        
        var folderArr = setFolderTree();
        for(var i = 0; i < folderArr.length; i++){
            var str = "<li class='folder folder-hide' data-folderID="+folderArr[i].folderID+"><div title="+folderArr[i].name+"><i class='iconfont bda-wenjianjia'></i><span>"+folderArr[i].name+"</span><i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>";
            elem.append(str);
            if(folderArr[i].children){
                createChildrenMenu(folderArr[i].children,elem);
            }
        }
		
    }

    function createChildrenMenu(menuArr,elem){
        for(var i = 0; i < menuArr.length; i++){
            var str = "<li class='folder folder-hide' data-folderID="+menuArr[i].folderID+"><div title="+menuArr[i].name+"><i class='iconfont bda-wenjianjia'></i><span>"+menuArr[i].name+"</span><i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>";
            elem.find("li").each(function(){
                if($(this).attr("data-folderID") == menuArr[i].folderParentID){
                    $(this).children("ul").append(str);
                }
            });
            if(menuArr[i].children){
                createChildrenMenu(menuArr[i].children,elem);
            }
        }
    }
    
    function setFolderTree(){
        var hashTable = new HashTable();
        hashTable.add("-1",{name: "组织分析",folderID:"-1",folderParentID:"-1",children:[]});
        for(var i = 0; i < folders.count; i++){
            hashTable.add(folders.item(i).folderID,{name:folders.item(i).folderName,folderID:folders.item(i).folderID,folderParentID:folders.item(i).folderParentID});
        }
        for(var i = 0; i < folders.count; i++){
            var parentFolder = hashTable.getValue(folders.item(i).folderParentID);
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(folders.item(i).folderID));
        }

        return hashTable.getValue("-1").children;
    }
	
	function creatReport(elem){
        for(var i = 0; i < reports.count; i++){
            if(reports.item(i).folderID == -1){
                var str = "";
                str = "<li class='report' data-index="+reports.item(i).reportID+"><div title='"+reports.item(i).reportName+"'><i class='iconfont bda-shilitubiao'></i><span>"+reports.item(i).reportName+"</span></div></li>"
                elem.append(str);
            }
            if(reports.item(i).folderID != -1){
                var str = "";
                str = "<li class='report' data-index="+reports.item(i).reportID+"><div title='"+reports.item(i).reportName+"'><i class='iconfont bda-shilitubiao'></i><span>"+reports.item(i).reportName+"</span></div></li>"
                elem.find("li").each(function(){
                    if(reports.item(i).folderID == $(this).attr("data-folderID")){
                        $(this).children("ul").append(str);
                    }
                });
            }
        }
    }
    
    function creatSelfAnalysis(elem){
		var str = "";
        // $(elem).append("<ul></ul>");
        for(var i = 0; i < selfAnalysis.count; i++){
            str += "<li class='report selfAnalysis'  data-index='"+selfAnalysis.item(i).reportID+"'><div title='"+selfAnalysis.item(i).reportName+"'><i class='iconfont bda-shilitubiao'></i>"+selfAnalysis.item(i).reportName+"<i class='iconfont bda-delete1' title='删除'></i></div></li>";
        }
		elem.append(str);
	}
	
	function creatChartSample(elem){
		var str = "";
			
        // $(elem).append("<ul></ul>");
        for(var i = 0; i < chartSamples.count; i++){
            if(chartSamples.item(i).chartURL){
                str += "<li class='sample' data-index='"+chartSamples.item(i).chartURL+"' title='"+chartSamples.item(i).chartName+"'><div><i class='iconfont bda-"+chartSamples.item(i).chartCode+"'></i>"+chartSamples.item(i).chartName+"</div></li>";
            }
        }
		elem.append(str);
    }
    
    function bindEvent(){
        clickLeftTree()
        changeCurrentTab();
        closeTab();
        rightButtonEvent();
    }

    function clickLeftTree(){
        $(".ifind-list ul")[0].addEventListener("click",function(e){
            if($(e.target).hasClass("bda-delete1")){
                var selfAnalysisReportID = $(e.target).parents(".selfAnalysis").attr("data-index");
                var selfAnalysisReportName = $(e.target).parents(".selfAnalysis").text();
                layer.open({
                    type: 0,
                    title: "删除自助报表",
                    closeBtn: 1,
                    shadeClose: true,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除报表 "+selfAnalysisReportName+" ？</div></div>",
                    btn: ["确定","取消"],
                    yes: function(index,layero){
                        layer.close(index);
                        deleteSelfAnalysisReport(selfAnalysisReportID);
                    }
                });
            }
            if(!$(e.target).hasClass("bda-delete1")&&($(e.target)[0].tagName=="LI" || $(e.target)[0].parentNode.tagName =="LI" || $(e.target)[0].parentNode.parentNode.tagName =="LI")){
                var elem = null;
                if($(e.target)[0].tagName=="LI"){
                    elem = $(e.target)[0]
                }else if($(e.target)[0].parentNode.tagName =="LI"){
                    elem = $(e.target).parent("li")[0];
                }else{
                    elem = $(e.target).parents("li")[0];
                }
                if($(elem).attr("data-index")){
                    $(".ifind-other-menu-main").hide();
                    openTab(elem);
                }
                if($(elem).hasClass("select-menu")||$(elem).find("li").hasClass("select-menu")){
                    if($(elem).children("ul").is(":hidden")){
                        $(elem).children("ul").show(200);
                        $(elem).find(".bda-xiangyou").eq(0).removeClass("bda-xiangyou").addClass("bda-xiangxia");
                    }else{
                        $(elem).children("ul").hide(200);
                        $(elem).find(".bda-xiangxia").eq(0).removeClass("bda-xiangxia").addClass("bda-xiangyou");
                    }
                }else if(!$(elem).hasClass("select-menu") && !$(elem).find("li").hasClass("select-menu")){
                    $(".select-menu").removeClass("select-menu");
                    $(elem).addClass("select-menu").children("ul").show(200);
                    $(elem).parents("li").addClass("select-menu");
                    $(elem).parents("li").children("div").children(".fr").removeClass("bda-xiangyou").addClass("bda-xiangxia")
                    $(elem).find(".bda-xiangyou").eq(0).removeClass("bda-xiangyou").addClass("bda-xiangxia");
                    if($(elem).attr("data-menucode")){
                        $(".ifind-other-menu-main").show();
                        loadMenuList($(elem).attr("data-menucode"));
                    }
                }
            }
        });
    }

    function loadMenuList(menuCode){
        switch(Number(menuCode)){
            case 61000:
                getListHtml("html/iFind/excelTemplate/upLoadExcelDatas.html");
                break;
            case 62000:
                getListHtml("html/iFind/excelTemplate/upLoadExcelDataLogs.html");
                break;
        }
    }

    function getListHtml(url,elem){
        $.ajax({
            url: url,
            type: 'GET',
            success: function(data){
                $(".ifind-other-menu-main").html("");
                $(".ifind-other-menu-main").html(data);
            }
        });
    }

    function changeCurrentTab(){
        $(".report-name").on("click",".tab-name",function(e){
            if(!$(this).hasClass("current-tab") && $(e.target)[0].tagName!="I"){
                $(this).addClass("current-tab").siblings(".tab-name").removeClass("current-tab");
                var reportID = $(this).attr("data-index");
                var tabID = $(this).attr("data-tabid");
                $(".tab-content").each(function(){
                    var contentDataReportID = $(this).attr("data-divIndex");
                    if(contentDataReportID == reportID && $(this).attr("data-tabid") == tabID){
                        $(this).addClass("current-tabContent").siblings(".tab-content").removeClass("current-tabContent");
                        return false;
                    }
                });
    
                changeRightButtonStatus(reportID);
                setPrveAndNextOfSelect();
            }
        });
    }

    function closeTab(){
        $(".report-name").on("click","i",function(){
            var currentReportID = "";
            var currentTabID = null;
            if($(this).parents(".tab-name").hasClass("current-tab")){
                if($(this).parents(".tab-name").index() == $(".tab-name").length - 1){
                    currentReportID = $(this).parents(".tab-name").prev(".tab-name").attr("data-index");
                    currentTabID = $(this).parents(".tab-name").prev(".tab-name").attr("data-tabid");
                }else{
                    currentReportID = $(this).parents(".tab-name").next(".tab-name").attr("data-index");
                    currentTabID = $(this).parents(".tab-name").next(".tab-name").attr("data-tabid");
                }
            }
            
            deleteTabHtml($(this).parents(".tab-name").attr("data-index"),currentReportID,currentTabID,$(this).parents(".tab-name").attr("data-tabid"));
        });
    }

    function rightButtonEvent(){
        backButtonEvent();
        collectionButtonEvent();
        refreshButtonEvent();
        magnifyButtonEvent();
        closeManify();
        keyboardEvent();
        addEventListenerMessage();
        exportButtonEvent();
        printButtonEvent();
        shareButtonEvent();
        suspensionButtonEvent();
        exportOffice();
    }

    function backButtonEvent(){
        $("#back,#buttonBack").click(function(){
            if(!$(this).hasClass("opacity")){
                var tabContentReportID = $(".current-tabContent").attr("data-divindex");
                var reportID = "";
                for(var i = 0; i < reportBoxArr.length; i++){
                    if(reportBoxArr[i].reportID == tabContentReportID){
                        removeIframe(reportBoxArr[i].reportUrl.length);
                        reportBoxArr[i].reportUrl.pop();
                        var url = reportBoxArr[i].reportUrl[reportBoxArr[i].reportUrl.length-1]
                        reportID = (url.split("&reportID=")[1]).split("&deviceTypeID=")[0]
                        break;
                    }
                }
    
                reviseReportName(reportID);
                changeRightButtonStatus(reportID,tabContentReportID);
            }
        });
    }

    function collectionButtonEvent(){
        $("#collection").click(function(){
            $Utils.loading.open();
            var tabDataReportID = $(".current-tab").attr("data-index");
            var currentReportID = "";
            $.each(reportBoxArr,function(i){
                if(reportBoxArr[i].reportID == tabDataReportID){
                    currentReportID = (reportBoxArr[i].reportUrl[reportBoxArr[i].reportUrl.length-1].split("&reportID=")[1]).split("&")[0];
                    return false;
                }
            });
            var isFavorite = false;
            for(var i = 0; i < favorites.count; i++){
                if(favorites.item(i).reportID == currentReportID){
                    isFavorite = true;
                }
            }
            var report = checkCurrentReportByReportID(currentReportID);
            if(isFavorite){
                cancelFavorite(currentReportID);
            }else{
                addFavorite(report);
            }
    
        });
    }

    function refreshButtonEvent(){
        $("#refresh,#buttonRefresh").click(function(){
            var currentReportID = $(".current-tabContent").attr("data-divindex");
            $.each(reportBoxArr,function(i){
                if(reportBoxArr[i].reportID == currentReportID){
                    var index = (reportBoxArr[i].reportUrl.length-1)?(reportBoxArr[i].reportUrl.length-1):'';
                    var childWindow = $(".current-tabContent").find(".rightMain"+index)[0].contentWindow;
                    childWindow.refresh();
                    return false;
                }
            });
        });
    }

    function magnifyButtonEvent(){
        $("#magnify").click(function(){
            magnify();
        });
    }

    window.magnify = function(){
		var currentReportID = $(".current-tabContent").attr("data-divindex");
		$.each(reportBoxArr,function(i){
			if(reportBoxArr[i].reportID == currentReportID){
                var index = (reportBoxArr[i].reportUrl.length-1)?(reportBoxArr[i].reportUrl.length-1):'';
                var childWindow = $(".current-tabContent").find(".rightMain"+index)[0].contentWindow;
                var reportSettings = "";
                var reportSettings = childWindow.transmitReportSettings();

                // var msg = {key:"transmitReportSettings",value:""};
                // childWindow.postMessage(msg,"*");

                // window.addEventListener("message",function(e){
                //     if(e.data.key == "transmitReportSettings"){
                //         reportSettings = JSON.parse(e.data.value);
                //     }
                // });

				$(".current-tabContent").find(".main").css({
					"position": "fixed",
                    "top": 0,
                    "z-index": 999
                });
                $(".BDA-header").hide(200);
				if($AppVars.gLogin.deviceTypeID==2){
					$(".tishi").show(500);
					setTimeout(function() {
						$(".tishi").hide(500);
					}, 5000);
                }
                
                if(reportSettings.backButtonInitPosition && reportSettings.backButtonInitPosition == "0"){
                    $(".fixed-box").removeClass().addClass("fixed-box left-top");
                }
                if(reportSettings.backButtonInitPosition && reportSettings.backButtonInitPosition == "1"){
                    $(".fixed-box").removeClass().addClass("fixed-box right-top");
                }
                if(reportSettings.backButtonInitPosition && reportSettings.backButtonInitPosition == "2"){
                    $(".fixed-box").removeClass().addClass("fixed-box right-bottom");
                }
                if(reportSettings.backButtonInitPosition && reportSettings.backButtonInitPosition == "3"){
                    $(".fixed-box").removeClass().addClass("fixed-box left-bottom");
                }
                if(reportSettings.showBackButtonWhenPCFullscreen && reportSettings.showBackButtonWhenPCFullscreen == "1"){
                    $(".fixed-box").show();
                }
				return false;
			}
		});
        isMagnify = true;
    };

    function closeManify(){
        $("#closeMagnify").click(function(){
            quitFullScreen();
        });
    }

    window.quitFullScreen = function(){
        isMagnify = false;
        $(".tab-content").find(".main").removeAttr("style");
        $(".fixed-box").removeClass("select-button-box").hide();
        $(".BDA-header").show(200);
	};

    function keyboardEvent(){
        var isESCPress = false;
	
        document.body.onkeydown = function(e){
            var ev = e || window.event;
            var code = ev.keyCode;
            
            code ==27 && (isESCPress = true);
            if(isESCPress){
                quitFullScreen();
            }
            if(code == 122 && ev.ctrlKey){
                magnify();
            }
        }
        
        document.body.onkeyup = function(e){
            var ev = e || window.event;
            var code = ev.keyCode;
            
            code ==27 && (isESCPress = false);
        }
    }

    function addEventListenerMessage(){
        window.addEventListener('message',function (e) { 
            if(e.data.key == "quitFullScreen"){
                quitFullScreen();
            }
        });
    }

    function exportButtonEvent(){
        $("#export").click(function(){
            var currentReportID = $(".current-tabContent").attr("data-divindex");
            var reportName = $(".current-tab .report-tab-name").text();
            $.each(reportBoxArr,function(i){
                if(reportBoxArr[i].reportID == currentReportID){
                    var index = (reportBoxArr[i].reportUrl.length-1)?(reportBoxArr[i].reportUrl.length-1):'';
                    var childWindow = $(".current-tabContent").find(".rightMain"+index)[0].contentWindow;
                    childWindow.exportToExcel(reportName);
                    // var msg = {key:"exportToExcel",value:reportName};
                    // childWindow.postMessage(msg,"*");
                    return false;
                }
            });
        });
    }

    function printButtonEvent(){
        $("#print").click(function(){
            var currentReportID = $(".current-tabContent").attr("data-divindex");
            $.each(reportBoxArr,function(i){
                if(reportBoxArr[i].reportID == currentReportID){
                    var index = (reportBoxArr[i].reportUrl.length-1)?(reportBoxArr[i].reportUrl.length-1):'';
                    var childWindow = $(".current-tabContent").find(".rightMain"+index)[0].contentWindow;
                    childWindow.printing();
                    // var msg = {key:"printing",value:""};
                    // childWindow.postMessage(msg,"*");
                    return false;
                }
            });
        });
    }

    function shareButtonEvent(){
        $("#share").click(function(){
            $(".share-mark").show();
            $(".share-box").removeAttr("style");
            initShare();
        });
    }

    function suspensionButtonEvent(){
        $(".fixed-box .left-button").off('click').on("click",function(){
            if($(this).parent(".fixed-box").hasClass("select-button-box")){
                $(this).parent(".fixed-box").removeClass("select-button-box");
            }else{
                $(this).parent(".fixed-box").addClass("select-button-box");
            }
        });
    }

    function exportOffice(){
        $("#exportOffice").click(function(){
            var currentReportID = $(".current-tabContent").attr("data-divindex");
            openClient(currentReportID);
        });
    }

    function openClient(reportID){
        var url = "yzs:// /l "+$AppVars.gLogin.loginID+" /n1 5 /i1 "+reportID;
        $Utils.openClient(url);
    }

    function initShare(){
		$(".copy").hide();
		$(".share-type span").removeClass("current-type");
		$(".share-type span:first-child").addClass("current-type");
		$(".share-content").addClass("current-share-content");
		$(".share-content label").siblings("input").removeAttr("style");
		$("#report-url").val("");
		$(".password").val(randomWord(6));
		$(".valid-date").val(7);
        $(".share-content p").html("");
        bindShareBoxEvent();
    }

    function randomWord(min){
		var str = "",range = min,
			arr = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
		for(var i=0; i<range; i++){
			var pos = Math.round(Math.random() * (arr.length-1));
			str += arr[pos];
		}
		return str;
	}
    
    function bindShareBoxEvent(){

        $(".create-url").off('click').on("click",function(){
            if(validateShare()){
                var shareObj = setShare();
                getShareID(shareObj);
            }
        });

        $(".share-type span").off('click').on("click",function(){
            if(!$(this).hasClass("current-type")){
                $(this).addClass("current-type").siblings("span").removeClass("current-type");
            }
        });

        $(".share-content label").off('click').on("click",function(){
            if($(this).hasClass("selected-check")){
                $(this).removeClass("selected-check");
                $(this).siblings("input").attr("disabled",true);
                $(this).siblings("input").css("color","#999");
            }else{
                $(this).addClass("selected-check");
                $(this).siblings("input").attr("disabled",false);
                $(this).siblings("input").css("color","#333");
            }
        });

        $(".close-share-box,#cancelShare").off('click').on("click",function(){
            $(".share-mark").hide();
        });
    }

    function validateShare(){
		if($(".pass-check").hasClass("selected-check") && $.trim($(".password").val()) == ""){
			$(".password").siblings("p").html("请输入验证密码!");
			return false;
		}
		if($(".date-check").hasClass("selected-check") && $.trim($(".valid-date").val()) == ""){
			$(".valid-date").siblings("p").html("请输入天数!");
			return false;
		}
		return true;
    }

    function setShare(){
        var shareObj = {};
		var url = "";
		$.each(reportBoxArr,function(i){
			if(reportBoxArr[i].reportID == $(".tab-bottom .current-tabContent").attr("data-divindex")){
				url = reportBoxArr[i].reportUrl[reportBoxArr[i].reportUrl.length-1];
				var index = (reportBoxArr[i].reportUrl.length-1)?(reportBoxArr[i].reportUrl.length-1):'';
				var childWindow = $(".current-tabContent").find(".rightMain"+index)[0].contentWindow;
                shareObj = childWindow.transmitReportView();
                // var msg = {key:"transmitReportView",value:""};
                // childWindow.postMessage(msg,"*");

                // window.addEventListener("message",function(e){
                //     if(e.data.key == "transmitReportView"){
                //         shareObj = JSON.parse(e.data.value);
                //     }
                // });
                
				return false;
			}
        });

        if (shareObj.isLoadingComplate && shareObj.isLoadingComplate == false){
            layer.msg("报表未加载完成，请稍后再试。",{icon: 2});
        } else if (shareObj.isLoadingComplate && shareObj.isLoadingComplate == true) {
            return setLinkShare(url, shareObj);
        }else{
            return setLinkShare(url, shareObj);
        }
    }

    function setLinkShare(url,shareObj){
		var reportID = url.split("reportID=")[1];
		reportID = reportID.split("&")[0];
        var linkShare = new LinkShare();
        linkShare.reportID = reportID;
        linkShare.shareType = $(".have-limit").hasClass("current-type")?0:1;
		if(linkShare.shareType == 0){
			linkShare.reportView = shareObj.reportView;
		}
        linkShare.restrictDate = $(".date-check").hasClass("selected-check");
        linkShare.shareDays = $(".date-check").hasClass("selected-check")?$(".valid-date").val():"";
        linkShare.needPassword = $(".pass-check").hasClass("selected-check");
        linkShare.sharePassword = linkShare.needPassword?$(".password").val():"";
		linkShare.themeID = url.split("themeID=")[1].split("&")[0];
		linkShare.deviceTypeID = url.split("deviceTypeID=")[1].split("&")[0];
		linkShare.reportSettings = [
            {
                reportSettingKey: "scaleByScreenSize",
                reportSettingValue: shareObj.scaleByScreenSize
            },
            {
                reportSettingKey: "pageWidth",
                reportSettingValue: shareObj.pageWidth
            },
			{
				reportSettingKey: "pageHeight",
				reportSettingValue: shareObj.pageHeight
            },
            {
                reportSettingKey: "followDesignSize",
                reportSettingValue: shareObj.followDesignSize
            },
            {
                reportSettingKey: "showPFinReport",
                reportSettingValue: shareObj.showPFinReport
            },
			{
				reportSettingKey: "reportName",
				reportSettingValue: shareObj.reportName
			}
        ];

        return linkShare;
    }
    
    function getShareID(linkShare){
        var shareUrl = "";
        var succ = function(shareID){
            shareUrl = $AppConstants.hostName + $AppConstants.port+"/Report/linkShares/"+shareID+"/reportJSP";
            $("#report-url").val(shareUrl);
            var Url = document.getElementById("report-url");
            Url.select();
            document.execCommand("Copy");
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取分享列表",errorStatus,msg);
        };
        linkShares.addItem(linkShare,true,succ,fail);
    }
    
    function checkCurrentReportByReportID(reportID){
        var report = {};
        for(var i = 0; i < reports.count; i++){
            if(reports.item(i).reportID == reportID){
                report = reports.item(i);
                break;
            }
        }
        for(var i = 0; i < selfAnalysis.count; i++){
            if(selfAnalysis.item(i).reportID == reportID){
                report = selfAnalysis.item(i);
                break;
            }
        }
        return report;
    }

    function deleteTabHtml(reportID,currentReportID,currentTabID,tabID){
        $.each(reportBoxArr,function(i){
            if(reportBoxArr[i].reportID == reportID && reportBoxArr[i].tabID == tabID){
                reportBoxArr.splice(i,1);
                return false;
            }
        });
        if(currentReportID != ""){
            selectTab(currentReportID,currentTabID);
            changeRightButtonStatus(currentReportID);
        }
        setTabWidth();
        setPrveAndNextOfSelect();
        deleteTabNameAndContentHtml(reportID,tabID);
        if($(".tab-name").length == 0){
            $(".report-button").hide();
        }
    }

    function openTab(elem){
        var reportID = $(elem).attr("data-index");
        var currentIsOpen = false;
        var tabID = null;
        for(var i = 0; i < reportBoxArr.length; i++){
            if(reportBoxArr[i].reportID == reportID){
                tabID = reportBoxArr[i].tabID;
                currentIsOpen = true;
                break;
            }
        }

        if(currentIsOpen){
            openAssignReport(reportID,tabID);
        }else{
            addTabOpenReport(reportID,null);
        }
    }

    function addTabOpenReport(reportID,selfReportName,linkReportUrl){
        //根据reportID不同，获取对应的reportName
        var reportName = "";
        if(reportID == "home.html"){
            reportName = "主页";
        }else if(reportID.indexOf(".html") != -1){
            for(var i = 0; i < chartSamples.count; i++){
                if(chartSamples.item(i).chartURL == reportID){
                    reportName = chartSamples.item(i).chartName;
                }
            }
        }else{
            if(reports.item(reportID)){
                reportName = reports.item(reportID).reportName;
            }else if(selfAnalysis.item(reportID)){
                reportName = selfAnalysis.item(reportID).reportName;
            }
        }
        if(selfReportName != null){
            reportName = selfReportName;
        }
        
        //根据reportID不同，组装对应的URL
        var url = "";
        if(reportID == "home.html"){
            url = $AppConstants.projectName + "/home.html";
        }else if(reportID.indexOf(".html") == -1){
            var parameters = "?token="+$AppVars.token+"&reportID="+reportID+"&deviceTypeID="+$AppVars.deviceTypeID+"&themeID="+$AppVars.gUserTheme.themeID+"&queryTimeOut="+($AppVars.queryTimeOut?$AppVars.queryTimeOut:3);
            url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jspPath + parameters;
            if(firstOpen){
                firstOpen = false;
                openMenu(reportID);
            }
        }else{
            url = $AppConstants.hostName + $AppConstants.port + "/Report/" + reportID;
        }
        if(linkReportUrl){
            url = linkReportUrl;
        }
        addNewReportToBoxArr(reportID,url);
        //新增页签，并打开对应的URL
        $(".tab-top .tab-name").removeClass("current-tab");
        var reportNameStr = "<div class='tab-name current-tab' data-index="+reportID+" data-tabid="+(reportBoxArr.length-1)+"><span class='report-tab-name' title="+reportName+">"+reportName+"</span><span class='close-tab'><i class='iconfont bda-guanbi'></i></span></div>";
        $(".tab-top .report-name").append(reportNameStr);
        createTabBottom(reportID);

        $(".tab-bottom .tab-content").each(function(){
            if($(this).attr("data-divIndex") == reportID && $(this).attr("data-tabid") == (reportBoxArr.length-1)){
                $(this).addClass("current-tabContent").find(".rightMain").attr("src",url);
                $(this).siblings(".tab-content").removeClass("current-tabContent");
                return false;
            }
        });

        //设置页签头宽度，以及设置右边按钮状态;
        setTabWidth();
        setPrveAndNextOfSelect();
        changeRightButtonStatus(reportID);

    }

    function openMenu(reportID){
        $(".ifind-list li").each(function(){
            if($(this).attr("data-index") == reportID){
                $(this).addClass("select-menu")
                $(this).parents("li").addClass("select-menu");
                $(this).parents("li").children("div").children(".fr").removeClass("bda-xiangyou").addClass("bda-xiangxia");
                $(this).parents("li").children("ul").show();
            }
        });
    }

    function openAssignReport(reportID,tabID){
        selectTab(reportID,tabID);
        changeRightButtonStatus(reportID);
    }

    function addNewReportToBoxArr(reportID,url){
        var tempObj = {};
        tempObj.reportID = reportID;
        var tempArr = [];
        tempArr.push(url);
        tempObj.reportUrl = tempArr;
        tempObj.tabID = reportBoxArr.length;
        reportBoxArr.push(tempObj);
    }

    function deleteSelfAnalysisReport(reportID){
        var succ = function(){
            deleteSelfAnalysisReportTab(reportID);
            layer.msg("删除成功。",{icon:1});
            $Utils.loading.close();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除自助报表",errorStatus,msg);
        }
        selfAnalysis.deleteItem(reportID,true,succ,fail);
    }

    function deleteSelfAnalysisReportTab(reportID){
        deleteMenuHtml(3,reportID);

        var currentReportID = "";
        var currentTabID = null;
        var tabID = null;
        $(".report-name .tab-name").each(function(){
            if(reportID == $(this).attr("data-index")){
                if($(this).hasClass("current-tab")){
                    if($(this).index() == $(".tab-name").length - 1){
                        currentReportID = $(this).prev(".tab-name").attr("data-index");
                        currentTabID = $(this).prev(".tab-name").attr("data-tabid");
                    }else{
                        currentReportID = $(this).next(".tab-name").attr("data-index");
                        currentTabID = $(this).next(".tab-name").attr("data-tabid");
                    }
                }
                tabID = $(this).attr("data-tabid");
                return false;
            }
        });

        for(var j = 0; j < favorites.count; j++){
            if(favorites.item(j).reportID == reportID){
                deleteMenuHtml(1,reportID);
                break;
            }
        }

        deleteTabHtml(reportID,currentReportID,currentTabID,tabID);
        
    }

    function selectTab(reportID,tabID){
        $(".tab-name").each(function(){
            var tabDataReportID = $(this).attr("data-index");
            if(tabDataReportID == reportID && $(this).attr("data-tabid") == tabID){
                $(this).addClass("current-tab").siblings(".tab-name").removeClass("current-tab");
                return false;
            }
        });
        $(".tab-content").each(function(){
            var contentDataReportID = $(this).attr("data-divindex");
            var contentTabID = $(this).attr("data-tabid");
            if(contentDataReportID == reportID && tabID == contentTabID){
                $(this).addClass("current-tabContent").siblings(".tab-content").removeClass("current-tabContent");
                return false;
            }
        });
    }

    function deleteTabNameAndContentHtml(reportID,tabID){
        $(".tab-name").each(function(){
            var tabDataReportID = $(this).attr("data-index");
            if(tabDataReportID == reportID && $(this).attr("data-tabid") == tabID){
                $(this).remove();
                return false;
            }
        });
        $(".tab-content").each(function(){
            var contentDataReportID = $(this).attr("data-divindex");
            if(contentDataReportID == reportID && $(this).attr("data-tabid") == tabID){
                $(this).remove();
                return false;
            }
        });
    }

    function addFavorite(report){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("收藏成功。",{icon: 1});
            addReportToFavoriteList(report);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("收藏 "+report.reportName,errorStatus,msg);
        }
        favorites.addItem($AppVars.gUser.userID,report,true,succ,fail);
    }

    function addReportToFavoriteList(report){
		$(".ifind-list > ul > li").each(function(){
			if($(this).attr("data-menu")==1){
				$(this).find("ul").prepend("<li class=report data-index="+report.reportID+"><div><i class='iconfont bda-shilitubiao'></i>"+report.reportName+"</div></li>");
			}
		});
		changeFavoritesIcon(report.reportID);
    }

    function cancelFavorite(reportID){
        var succ = function(){
            layer.msg("反收藏成功。",{icon: 1});
            deleteMenuHtml(1,reportID);
            $Utils.loading.close();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("取消收藏 "+reports.item(reportID).reportName,errorStatus,msg);
        }
        favorites.deleteItem($AppVars.gUser.userID,reportID,true,succ,fail);
    }

    function deleteMenuHtml(menuID,reportID){
        $(".ifind-list > ul > li").each(function(){
            if($(this).attr("data-menu")==menuID){
                $(this).find("li").each(function(){
                    if($(this).attr("data-index")==reportID){
                        $(this).remove();
                    }
                });
            }
        });
        changeFavoritesIcon(reportID);
    }

    function removeIframe(length){
        $(".current-tabContent").find(".rightMain"+(length-1)).remove();
    }
    
    function reviseReportName(reportID){
		var isExistence = false;
        for(var i = 0; i < reports.count; i++){
            if(reports.item(i).reportID == reportID){
                $(".current-tab .report-tab-name").text(reports.item(i).reportName);
                $(".current-tab .report-tab-name").attr("title",reports.item(i).reportName);
                isExistence = true;
                break;
            }
        }

		if(isExistence){
			return;
		}
        
        var report = new Report();
		var succ = function(){
			$(".current-tab .report-tab-name").text(report.reportName);
            $(".current-tab .report-tab-name").attr("title",report.reportName);
		};
		var fail = function(errorStatus,msg){
			$Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表名称",errorStatus,msg);
		};
		report.getItemByID(reportID,true,succ,fail);
	}

    function changeRightButtonStatus(reportID,tabContentReportID){
        $("#back,#buttonBack").addClass("opacity");
        $(".report-button").show();
        showOrHiddenRightButton(reportID);
        changeBackIcon(tabContentReportID || reportID);
        changeFavoritesIcon(reportID);
    }

    function showOrHiddenRightButton(reportID){
        $.each(reportBoxArr,function(i){
            if(reportBoxArr[i].reportID == reportID){
                if(reportBoxArr[i].reportID.indexOf(".html") != -1){
                    $(".report-button").hide();
                    return false;
                }
            }
        });
    }

    function changeBackIcon(reportID){
        $.each(reportBoxArr,function(i){
            if(reportBoxArr[i].reportID == reportID){
                if(reportBoxArr[i].reportUrl.length>1){
                    $("#back,#buttonBack").removeClass("opacity");
                    return false;
                }
            }
        });
    }

    function changeFavoritesIcon(reportID){
        var isFavorite = false;
        for(var i = 0; i < favorites.count; i++){
            if(favorites.item(i).reportID == reportID){
                isFavorite = true;
                break;
            }
        }
        if(isFavorite){
            $("#collection").removeClass("bda-shoucang").addClass("bda-antiCollection");
            $("#collection").attr("title","取消收藏");
        }else{
            $("#collection").removeClass("bda-antiCollection").addClass("bda-shoucang");
            $("#collection").attr("title","收藏");
        }
    }

    function createTabBottom(reportID){
        var tabIframe = "<div class='main'>\
            <iframe name='right' class='rightMain' frameborder='no' scrolling='auto' width='100%' height='100%' allowtransparency='true' src=''></iframe>\
        </div>";
        var tabContentStr = "<div class='tab-content' data-divIndex="+reportID+" data-tabid="+(reportBoxArr.length-1)+">"+tabIframe+"</div>";
        $(".tab-bottom").append(tabContentStr);
    }

    function setTabWidth(){
        var reportNameWidth = $(".report-name").width();
        var tabNameLenght = $(".tab-name").length;
        var finalWidth = Math.floor((reportNameWidth - tabNameLenght * 5)/tabNameLenght) - 40;
        if(finalWidth>200){
            $(".tab-name").width(200);
        }else if(finalWidth < 200 && finalWidth > 17){
            $(".tab-name").width(finalWidth);
        }else{
            $(".tab-name").width(17);
        }
    }

    function setPrveAndNextOfSelect(){
        var currentIndex = $(".current-tab").index();
        var tabNameLength = $(".tab-name").length;
        $(".tab-name").removeClass("control-before");
        if(currentIndex == (tabNameLength - 1)){
            $(".tab-name").eq(currentIndex-1).addClass("control-before");
        }else if(currentIndex < (tabNameLength - 1) && currentIndex > 0){
            $(".tab-name").eq(currentIndex-1).addClass("control-before");
        }
    }

    window.addEventListener("message",function(e){
        if(e.data.key == "linkReport"){
            linkReport(e.data.value);
        }
    });

    window.linkReport = function(url){
        var reportID = (url.split("&reportID=")[1]).split("&")[0];
        
        if($AppVars.gOrganizationUsers.item(0).organizationUserSettings.item("linkReportTarget").settingValue == 1 && !isMagnify){
            addTabOpenReport(reportID,null,url,1);
        }else{
            currentWindowOpenLinkReport(url);
        }
        reviseReportName(reportID);
    }
    
    function currentWindowOpenLinkReport(url){
        var tabContentReportID = $(".current-tabContent").attr("data-divindex");
        var index = null;
        var iframe = "";
        $.each(reportBoxArr,function(i){
            if(reportBoxArr[i].reportID == tabContentReportID){
                reportBoxArr[i].reportUrl.push(url);
                index = reportBoxArr[i].reportUrl.length - 1;
                iframe = "<iframe name='right"+index+"' class='rightMain"+index+"' src='' frameborder='no' scrolling='auto' width='100%' height='100%' allowtransparency='true'></iframe>";
                return false;
            }
        });

        $(".current-tabContent .main").prepend(iframe);
        $(".current-tabContent .main .rightMain"+index).attr("src",url);
        var reportID = (url.split("&reportID=")[1]).split("&deviceTypeID=")[0];
        changeRightButtonStatus(tabContentReportID);
    }
    
    window.changeTheme = function(themeID){
        $.each(reportBoxArr,function(i){
            $.each(reportBoxArr[i].reportUrl,function(j){
                $(".tab-content").each(function(){
                    var tabConentReportID = $(this).attr("data-divindex");
                    if(reportBoxArr[i].reportID == tabConentReportID && tabConentReportID.indexOf(".html") == -1){
                        var str1 = reportBoxArr[i].reportUrl[j].split("&themeID=")[0];
                        var str2 = (reportBoxArr[i].reportUrl[j].split("&themeID=")[1]).substring(1);
                        var newUrl = str1 + "&themeID="+themeID+str2;
                        var index = j?j:'';
                        var childWindow = $(this).find(".rightMain"+index)[0].contentWindow;
                        var parameters = childWindow.getPromptFilterString();
                        newUrl = newUrl+"&parameters="+ parameters;
                        $(this).find(".rightMain"+index).attr("src",newUrl);
                        reportBoxArr[i].reportUrl[j] = newUrl;
                    }
                });
            })
        });
    }

    window.onCreatedSelfAnalysis = function(reportID,reportName){
        if(reportID){
            getAddSelfAnalysisReport(reportID,reportName);
        }
        layer.closeAll();
    }

    function getAddSelfAnalysisReport(reportID,reportName){
        var report = new Report();
        var succ = function(){
            selfAnalysis.add(report);
            addTabOpenReport(reportID,reportName);
            $(".ifind-list li").each(function(){
				if($(this).attr("data-menu") == 3){
					$(this).find("ul").prepend("<li class='report selfAnalysis' data-index="+reportID+"><div title="+reportName+"><i class='iconfont bda-shilitubiao'></i>"+reportName+"<i class='iconfont bda-delete1' title='删除'></i></div></li>");
				}
            });
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取新增自助报表",errorStatus,msg);
        };
        report.getItemByID(reportID,true,succ,fail);
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }

}();