!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, laypage = layui.laypage;
    var uploadExcelTemplates = new UploadExcelTemplates();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();
    
    function initMain(){  
        initExcelTemplatesTableHead();
        getAndLoadExcelTemplatesTableBody();
    }

    function initExcelTemplatesTableHead(){
        var excelTemplatesTableHead = [
            [
                {field: "templateName", title: "名称", sort: true},
                {field: "createUserName",title: "上传者", sort: true},
                {field: "createDate",title: "上传时间", sort: true},
                {title: "操作", templet: "#setOperation"}
            ]
        ];
    
        table.render({
            elem: '#dataList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: excelTemplatesTableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadExcelTemplatesTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadExcelTemplatesTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取Excel上传模版列表",errorStatus,msg);
		};
		uploadExcelTemplates.getItems(0,true,succ,fail);
    }
    

    function setTableBody(){
        var excelTemplatesTableBody = [];
        for(var i = 0; i < uploadExcelTemplates.count; i++){
            var tempObj = {};
            for(var key in uploadExcelTemplates.item(i)){
                if(typeof uploadExcelTemplates.item(i)[key] === "function"){ continue;}
                if(key == "createDate"){
                    tempObj[key] = uploadExcelTemplates.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelTemplates.item(i)[key])):"";
                }else if(key == "lastModifyDate"){
                    tempObj[key] = uploadExcelTemplates.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelTemplates.item(i)[key])):"";
                }else{
                    tempObj[key] = uploadExcelTemplates.item(i)[key];
                }
            }
            excelTemplatesTableBody.push(tempObj);
        }
        return excelTemplatesTableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadExcelTemplatesTableBody(data,obj);
            }
        });
    }

    function loadExcelTemplatesTableBody(tableBodyData,obj){
        var databaseLinksTableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("dataList",{data:databaseLinksTableBody,limit:databaseLinksTableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("dataList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("dataList",{height: tableBodyHeight});
        });
    }

    table.on('sort(dataList)', function (obj) {
        var type = obj.type,
            field = obj.field,
            data = mSortBodyData,//表格的配置Data
            thisData = [];
        if(type === 'asc'){ //升序
            thisData = $Utils.sorter(data, field);
        }else if(type === 'desc'){ //降序
            thisData = $Utils.sorter(data, field, true);
        }else{ //清除排序
            thisData = data;
        }
        setTablePage(thisData);
    });

    $(".search-button").click(function(){
        var searchValue = $(".search input[name=searchContent]").val();
        var searchData = [];
        if(searchValue == ""){
            searchData = mTableBodyData;
        }else{
            searchData = setSearchData(searchValue);
        }
        mSortBodyData = searchData;
        setTablePage(searchData);
    });

    $(".search input[name=searchContent]").keypress(function (e) {
        if (e.which == 13) {
            $(".search-button").click();
        }
    });

    $(".refresh").click(function(){
        $Utils.loading.open();
        getAndLoadExcelTemplatesTableBody();
    });

    table.on("tool(dataList)", function(obj){
        var uploadExcelTemplate = uploadExcelTemplates.item(obj.data.templateID);
        if(obj.event == "upLoadData"){
            // if (!!window.ActiveXObject || "ActiveXObject" in window || navigator.userAgent.indexOf("Edge") > -1){
            //     layer.open({
            //         type: 0,
            //         title: "上传Excel",
            //         closeBtn: 1,
            //         shadeClose: true,
            //         resize: false,
            //         area: ["480px","270px"],
            //         skin: "delete-window",
            //         content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-tips'></i></div><div class='fr fail-content'>因IE浏览器不支持某些方法，上传Excel请使用Chrome、Firefox、360（急速模式）等浏览器。</div></div>",
            //         btn: ["确定"]
            //     });
            // }else{
                getAndLoadExcelUploadForm(uploadExcelTemplate);
            // }
        }else if(obj.event == "downLoadData"){
            downLoadExcelFile(uploadExcelTemplate);
        }
    });

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].templateName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadExcelUploadForm(uploadExcelTemplate){
        $.ajax({
            url: "html/iFind/excelTemplate/upLoadExcelData.html",
            type: 'GET',
            success: function(data){
                loadExcelUploadForm(data,uploadExcelTemplate);
            }
        });
    }

    function loadExcelUploadForm(strHtml,uploadExcelTemplate){
        layer.open({
            type: 1,
            title: ["Excel数据上报","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initUploadExcel(uploadExcelTemplate,uploadSubmit,index);
            }
        });
    }

    var uploadSubmit = function(uploadExcelTemplate,excelData,index){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            layer.msg("上报成功。共上报 "+excelData.length+" 条数据。",{icon:1});
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("上传数据",errorStatus,msg);
        };
		uploadExcelTemplate.uploadExcelData(excelData,true,succ,fail);
    };

    function downLoadExcelFile(uploadExcelTemplate){

        if (!!window.ActiveXObject || "ActiveXObject" in window){
            var excelURL = $AppConstants.hostName + $AppConstants.port + "/DataOrganize/" + uploadExcelTemplate.templateURL;
            if ($("#IframeReportImg").length === 0){
                $('<iframe style="display:none;" id="IframeReportImg" name="IframeReportImg" width="0" height="0" src="'+excelURL+'"></iframe>').appendTo("body");
            }
            if ($('#IframeReportImg').attr("src") != excelURL) {
                $('#IframeReportImg').attr("src",excelURL);
                downIMG(uploadExcelTemplate.excelFileName);
            } else {
                //如指向图片地址,直接调用下载方法
                setTimeout(function(){
                    downIMG(uploadExcelTemplate.excelFileName);
                },1000);
            }
        }else{
            var a = document.createElement('a');
            a.href = $AppConstants.hostName + $AppConstants.port + "/DataOrganize/" + uploadExcelTemplate.templateURL;
            a.download = uploadExcelTemplate.excelFileName;
            a.click();
            $(a).remove();
        }
    }

    function downIMG(name){
        if ($('#IframeReportImg').attr("src") != "about:blank") {
            window.frames["IframeReportImg"].document.execCommand("SaveAs",true,name);
        }
    }

}();