/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-08-10 14:20:15
 * @LastEditTime: 2020-11-28 13:41:57
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, excel = layui.excel, form = layui.form;
    var formUploadSubmit = null;
    var layerIndex = null;
    var mUploadExcelTemplate = null;
    var selectFiles = {};

    window.initUploadExcel = function(uploadExcelTemplate,uploadSubmit,index){
        mUploadExcelTemplate = uploadExcelTemplate;
        formUploadSubmit = uploadSubmit;
        layerIndex = index;

        bindEvent();
    }

    function bindEvent(){
        $(".select-excel-file .next-step").click(function(){
            if($(this).prop("disabled") == false){
                var excelData = [];
                if(mUploadExcelTemplate.rangeType == 0){
                    excelData = saveAllExcelData();
                }
                if(mUploadExcelTemplate.rangeType == 1){
                    excelData = saveRangeExcelData();
                }
                formUploadSubmit(mUploadExcelTemplate,excelData,layerIndex);
            }
            return false;
        });

        $(".cancel").click(function(){
            layer.close(layerIndex);
        });

        $("#LAY-excel-import-excel").change(function(e) {
            if(e.target.files[0].name.indexOf(".csv") != -1 || e.target.files[0].name.indexOf(".xlsx") != -1 || e.target.files[0].name.indexOf(".xls") != -1){
                // if (!!window.ActiveXObject || "ActiveXObject" in window || navigator.userAgent.indexOf("Edge") > -1){
                //     layer.msg("因IE浏览器不支持某些方法，上传Excel请使用Chrome等浏览器。",{icon:3});
                // }else{
                    if (!Object.values) {
                        Object.values = function values(obj) {
                            return Object.keys(obj).map(function(e){
                                return obj[e];
                            })
                        };
                    }
                    var files = Object.values(e.target.files);
                    selectFiles.files = files;
                    selectFiles.excelFileName = files[0].name;
                    uploadExcel(files);
                    e.target.value = '';
                // }
            }else{
                layer.msg("不是一个Excel文件。",{icon:2});
            }
        });

        $(".reset-select").click(function(){
            $("#LAY-excel-import-excel").click();
        });
    }

    function uploadExcel(files) {
        try {
            excel.importExcel(files, {}, function(data,originalData) {
                selectFiles.data = data[0];
                selectFiles.originalData = originalData[0];
                $(".select-excel-file .next-step").attr("disabled",false);
                form.val("addExcelFile",{
                    "excelName": selectFiles.excelFileName
                });
                form.render();
            });
        } catch (e) {
            $Utils.openWindow.failWindow("读取Excel文件",e.message);
        }
    };

    function saveAllExcelData(){
        var sheetData = selectFiles.originalData[mUploadExcelTemplate.sheetName];
        var sheetStringData = selectFiles.data[mUploadExcelTemplate.sheetName];
        var startRow = Number(mUploadExcelTemplate.range.split(":")[1].replace(/[^0-9]/ig,""));
        var data = [];
        for(var i = 0; i < sheetData.length; i++){
            if(sheetData[i]["__rowNum__"] >= (startRow - 1)){
                var obj = {};
                for(var j = 0; j < mUploadExcelTemplate.columns.length; j++){
                    var column = mUploadExcelTemplate.columns[j];
                    var valueRangeArr = column.valueRange.split(":");
                    var key = valueRangeArr[0].split(valueRangeArr[0].replace(/[^0-9]/ig,""))[0];
                    var rowIndex = Number(valueRangeArr[0].split(key)[1])-1;
                    if(valueRangeArr[1]){
                        for(var k = 0; k < sheetData.length; k++){
                            if(sheetData[k]["__rowNum__"] == rowIndex){
                                if(column.dataTypeEnum == 1){
                                    obj[column.columnName] = sheetStringData[k][key]?new Date(sheetStringData[k][key]).getTime():"";
                                }else{
                                    obj[column.columnName] = sheetData[k][key] || "";
                                }
                                break;
                            }
                        }
                    }else{
                        if(column.dataTypeEnum == 1){
                            obj[column.columnName] = sheetStringData[i][key]?new Date(sheetStringData[i][key]).getTime():"";
                        }else{
                            obj[column.columnName] = sheetData[i][key] || "";
                        }
                    }
                }
                data.push(obj);
            }
        }
        return data;
    }

    function saveRangeExcelData(){
        var isSetEnd = true;
        var sheetData = selectFiles.data[mUploadExcelTemplate.sheetName];
        var sheetStringData = selectFiles.data[mUploadExcelTemplate.sheetName];
        var startRow = Number(mUploadExcelTemplate.range.split(":")[0].replace(/[^0-9]/ig,""));
        var endRow = Number(mUploadExcelTemplate.range.split(":")[1].replace(/[^0-9]/ig,""));
        if(startRow == endRow){
            isSetEnd = false;
        }
        var data = [];
        for(var i = 0; i < sheetData.length; i++){
            if(sheetData[i]["__rowNum__"] >= startRow){
                var obj = {};
                for(var j = 0; j < mUploadExcelTemplate.columns.length; j++){
                    var column = mUploadExcelTemplate.columns[j];
                    var valueRangeArr = column.valueRange.split(":");
                    var key = valueRangeArr[0].split(valueRangeArr[0].replace(/[^0-9]/ig,""))[0];
                    var rowIndex = Number(valueRangeArr[0].split(key)[1])-1;
                    if(valueRangeArr[1]){
                        for(var k = 0; k < sheetData.length; k++){
                            if(sheetData[k]["__rowNum__"] == rowIndex){
                                if(column.dataTypeEnum == 1){
                                    obj[column.columnName] = sheetStringData[k][key]?new Date(sheetStringData[k][key]).getTime():"";
                                }else{
                                    obj[column.columnName] = sheetData[k][key] || "";
                                }
                                break;
                            }
                        }
                    }else{
                        if(column.dataTypeEnum == 1){
                            obj[column.columnName] =sheetStringData[i][key]?new Date(sheetStringData[i][key]).getTime():"";
                        }else{
                            obj[column.columnName] = sheetData[i][key];
                        }
                    }
                }
                data.push(obj);
            }
            if(isSetEnd){
                if(sheetData[i]["__rowNum__"] == endRow){
                    break;
                }
            }
        }
        return data;
    }

}();