/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-14 17:37:39
 * @LastEditTime: 2021-05-10 10:52:54
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, laypage = layui.laypage;
    var transforms = new Transforms();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var currentTableBodyData = [];

    $Utils.loading.open();
    initMain();
    
    function initMain(){
        initTransformsTableHead();
        getAndLoadTransformsTableBody();
    }

    function initTransformsTableHead(){

        var transformTableHead = [
            [
                {type: "radio"},
                {field: "transformName", title: "转换名称", sort: true},
                {field: "transformType", title: "转换分类", sort: true, width: 80, templet: function(d){
                    return (d.transformType?"事实表":"维表");
                }},
                { field: "targetTable", title: "目标表", sort: true, width: 230},
                { field: "sourceTable", title: "源表", sort: true, width: 230},
                {field: "preseted", title: "系统预置", sort: true, width: 80, templet: function(d){
                    return (d.preseted?"是":"否");
                }},
                {field: "lastExecuteDate", title: "最后执行时间", sort: true, width: 130, templet: function(d){
                    if (d.lastExecuteDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.lastExecuteDate))
                    }else{
                        return "";
                    }
                }},
                // {field: "createUserName",title: "创建者", sort: true},
                // {field: "createDate",title: "创建时间", sort: true, templet: function(d){
                //     if (d.createDate){
                //         return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.createDate))
                //     }else{
                //         return "";
                //     }
                // }},
                // {field: "lastModifyUserName",title: "最后修改者", sort: true},
                {field: "lastModifyDate",title: "修改时间", sort: true, width: 130, templet: function(d){
                    if(d.lastModifyDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.lastModifyDate))
                    }else{
                        return "";
                    }
                }},
                {title: "操作", templet: "#reset", width: 150}
            ]
        ];
    
        table.render({
            elem: '#dataList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: transformTableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTransformsTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
            // loadTransformsTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取转换列表",errorStatus,msg);
		};
		transforms.getItems(true,succ,fail);
    }

    function setTableBody(){
        var transformsTableBody = [];
        for(var i = 0; i < transforms.count; i++){
            var tempObj = {};
            for(var key in transforms.item(i)){
                if(typeof transforms.item(i)[key] === "function"){ continue;}
                // if(key == "createDate"){
                //     tempObj[key] = transforms.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(transforms.item(i)[key])):"";
                // }else if(key == "lastModifyDate"){
                //     tempObj[key] = transforms.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(transforms.item(i)[key])):"";
                // }else if(key == "lastExecuteDate"){
                //     tempObj[key] = transforms.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(transforms.item(i)[key])):"";
                // }else{
                    tempObj[key] = transforms.item(i)[key];
                // }
            }
            transformsTableBody.push(tempObj);
        }
        return transformsTableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                mLimit = obj.limit;
                loadTransformsTableBody(data,obj);
            }
        });
    }

    function loadTransformsTableBody(tableBodyData,obj){
        currentTableBodyData = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("dataList",{data:currentTableBodyData,limit:currentTableBodyData.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("dataList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("dataList",{height: tableBodyHeight});
        });
    }

    table.on('sort(dataList)', function (obj) {
        var type = obj.type,
            field = obj.field,
            data = mSortBodyData,//表格的配置Data
            thisData = [];
        if(type === 'asc'){ //升序
            thisData = $Utils.sorter(data, field);
        }else if(type === 'desc'){ //降序
            thisData = $Utils.sorter(data, field, true);
        }else{ //清除排序
            thisData = data;
        }
        setTablePage(thisData);
    });

    table.on("tool(dataList)", function(obj){
        var transform = transforms.item(obj.data.transformID);
        if(obj.event === "checkTableValue"){
            $Utils.loading.open();
            var succ = function(data){
                $Utils.loading.close();
                openTableValueWindow(transform,data);
            };
            var fail = function(errorStatus,msg){
                $Utils.loading.close();
                $Utils.openWindow.failWindow("获取表值",errorStatus,msg);
            };
            transform.getTableData(true,succ,fail);
        }
        if(obj.event === "execution"){
            $Utils.loading.open();
            var succ = function(){
                $Utils.loading.close();
                layer.msg("执行转换成功。",{icon: 1});
            };
            var fail = function(errorStatus,msg){
                $Utils.loading.close();
                $Utils.openWindow.failWindow("手动执行转换",errorStatus,msg);
            };
            transform.executionTransform(true,succ,fail);
        }
    });

    function openTableValueWindow(transform,tableData){
        layer.open({
            type: 1,
            title: [transform.targetTable + " 表值（前200行）","font-size: 14px"],
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["720px","540px"],
            content: "<div class='table-data-list'><table class='layui-hide' id='transformTargetTableDataList'></table></div>",
            btn: false,
            success: function(layero,index){
                loadTableDataList(tableData);
            }
        });
    }

    function loadTableDataList(tableData){
        if(!tableData.length){
            $(".table-data-list").html("无数据。").css({
                "line-height": "30px",
                "text-align": "center"
            });
            return;
        }
        var tableHead = [];
        for(var key in tableData[0]){
            var obj = {};
            obj.field = key;
            obj.title = key;
            obj.sort = true;
            obj.align = "center";
            tableHead.push(obj);
        }

        var tableBody = [];
        for(var i = 0; i < tableData.length; i++){
            var obj = {};
            for(var j = 0; j < tableHead.length; j++){
                obj[tableHead[j].title] = tableData[i][tableHead[j].title];
            }
            tableBody.push(obj);
        }

        table.render({
            elem: '#transformTargetTableDataList',
            height: 493,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: [tableHead],
            data: tableBody,
            toolbar: false,
            limit: tableBody.length
        });
    }

    $(".search-button").click(function(){
        var searchValue = $(".search input[name=searchContent]").val();
        var searchData = [];
        if(searchValue == ""){
            searchData = mTableBodyData;
        }else{
            searchData = setSearchData(searchValue);
        }
        mSortBodyData = searchData;
        setTablePage(searchData);
    });

    $(".search input[name=searchContent]").keypress(function (e) {
        if (e.which == 13) {
            $(".search-button").click();
        }
    });

    $(".add-transform").click(function(){
        var transform = new Transform();
        getAndLoadTransformForm(0,transform);
    });

    $(".edit-transform").click(function(){
        if(table.checkStatus('dataList').data.length){
            var transform = transforms.item(table.checkStatus('dataList').data[0].transformID);
            getAndLoadTransformForm(1,transform);
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".delete-transform").click(function(){
        if(table.checkStatus('dataList').data.length){
            if(table.checkStatus('dataList').data[0].preseted == true){
                layer.msg("系统预设转换不能删除。",{icon:2});
            }else{
                deleteWindow();
            }
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".refresh").click(function(){
        $Utils.loading.open();
        getAndLoadTransformsTableBody();
    });

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].transformName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].targetTable.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].sourceTable.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadTransformForm(operationType,transform){
        $.ajax({
            url: "html/iDataOrganize/transform/transform.html",
            type: 'GET',
            success: function(data){
                loadTransformForm(operationType,transform,data)
            }
        });
    }

    function loadTransformForm(operationType,transform,strHtml){
        layer.open({
            type: 1,
            title: [operationType?transform.transformName+" 属性":"新增转换","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initTransformForm(operationType,transform,index,addSubmit,editSubmit);
            }
        });
    }

    function deleteWindow(str,className){
        layer.open({
            type: 0,
            title: "删除转换",
            closeBtn: 1,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('dataList').data[0].transformName+" ？</div></div>",
            btn: ["是","否"],
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                deleteTransform(table.checkStatus('dataList').data[0].transformID);
            }
        });
    }

    function deleteTransform(transformID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTransformsTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除转换",errorStatus,msg);
		};
		transforms.deleteItem(transformID,true,succ,fail);
    }

    var addSubmit = function(transform,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadTransformsTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增转换",errorStatus,msg);
        };
        
		transforms.addItem(transform,true,succ,fail);
    };

    var editSubmit = function(transform,index){
        var succ = function(){
            layer.close(index);
            getAndLoadEditList(transform);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改转换",errorStatus,msg);
        };

		transforms.editItem(transform,true,succ,fail);
    };

    function getAndLoadEditList(transform){
        var succ = function(){
            $Utils.loading.close();
            editListItem(transform);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+transform.transformName+" 的属性",errorStatus,msg);
        };
        transform.initByID(true,succ,fail);
    }

    function editListItem(transform){
        var tempTableBody = $.extend(true,[],currentTableBodyData);
        for(var i = 0; i < currentTableBodyData.length; i++){
            if(currentTableBodyData[i].transformID == transform.transformID){
                for(var key in currentTableBodyData[i]){
                    if(key == "createDate"){
                        currentTableBodyData[i][key] = transform[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(transform[key])):"";
                        tempTableBody[i][key] = transform[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(transform[key])):"";

                    }else if(key == "lastModifyDate"){
                        currentTableBodyData[i][key] = transform[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(transform[key])):"";
                        tempTableBody[i][key] = transform[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(transform[key])):"";
                    }else{
                        currentTableBodyData[i][key] = transform[key];
                        tempTableBody[i][key] = transform[key];
                    }
                }
                tempTableBody[i].LAY_CHECKED = true;
            }else{
                tempTableBody[i].LAY_CHECKED = false;
            }
        }
        mSortBodyData = currentTableBodyData;
        table.reload("dataList",{data:tempTableBody,limit:tempTableBody.length});
    }

}();