/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-14 18:26:19
 * @LastEditTime: 2021-05-11 09:16:22
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form, element = layui.element;
    var mOperationType = null;
    var transformTypes = [
        {
            key: "维表",
            value: 0
        },
        {
            key: "事实表",
            value: 1
        }
    ];
    var mTransform = null, layerIndex = null;
    var formAddSubmit = null;
    var formEditSubmit = null;

    window.initTransformForm = function(operationType,transform,index,addSubmit,editSubmit){
        mTransform = transform;
        layerIndex = index;
        formAddSubmit = addSubmit;
        formEditSubmit = editSubmit;
        mOperationType = operationType;

        var createUserName = mOperationType == 0 ? $AppVars.gUser.userName : (mTransform.createUserName || "");
        var createDate = mOperationType == 0 ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date()) : $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(mTransform.createDate));
        var lastModifyUserName = mOperationType == 0 ? "" : (mTransform.lastModifyUserName || "");
        var lastModifyDate = mOperationType == 0 ? "" : (mTransform.lastModifyDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(mTransform.lastModifyDate)) : "");
        $(".bottom-item .createUserName").text(createUserName);
        $(".bottom-item .createDate").text(createDate);
        $(".bottom-item .lastModifyUserName").text(lastModifyUserName);
        $(".bottom-item .lastModifyDate").text(lastModifyDate);
        
        if(mOperationType == 0){
            initAddTransformForm();
        }else if(mOperationType == 1){
            initEditTransformForm(transform);
        }
        form.render();
        $(".database-window input[name=transformName]").focus();

        bindElementEvent();
    }

    function initAddTransformForm(){
        createSelect(0);
        $(".backstage").attr("disabled",true);
    }

    function createSelect(value){
        var transformType = document.getElementById("transformType");
        for(var i = 0; i < transformTypes.length; i++){
            var option = document.createElement("option");
            option.setAttribute("value",transformTypes[i].value);
            if(value == transformTypes[i].value){
                option.setAttribute("selected",true);
            }
            option.innerText = transformTypes[i].key;
            transformType.appendChild(option);
        }
    }

    function initEditTransformForm(){
        createSelect(mTransform.transformType);
        form.val("formWindow",{
            "transformName": mTransform.transformName,
            "targetTable": mTransform.targetTable,
            "targetTableDescription": mTransform.targetTableDescription,
            "sourceTable": mTransform.sourceTable,
            "sourceTableDescription": mTransform.sourceTableDescription,
            "transformLogicType": mTransform.transformLogicType,
            "transformLogic": mTransform.transformLogic
        });

        if(mTransform.preseted == 0){
            $(".backstage").attr("disabled",true);
            $(".server-content").show();
            $("textarea[name=transformLogic]").attr("lay-verify","required");
        }
        if(mTransform.preseted == 1){
            if(mTransform.transformLogicType == 0){
                $(".backstage").attr("disabled",true);
                $(".server-content").show();
                $("textarea[name=transformLogic]").attr("lay-verify","required");
            }else if(mTransform.transformLogicType == 1){
                $(".sqlText").attr("disabled",true);
                $(".server-content").hide();
                $("textarea[name=transformLogic]").removeAttr("lay-verify");
            }
        }
        if(mTransform.flag){
            $("textarea[name=transformLogic]").removeAttr("lay-verify");
        }
    }

    function bindElementEvent(){

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });
        
        form.on('submit(formSubmit)', function(data){
            $Utils.loading.open();
            if(mOperationType == 1){
                if(changed(data)){
                    if(!mTransform.flag){
                        var transform = new Transform();
                        transform.init(JSON.parse(JSON.stringify(mTransform)));
                        setTransform(data, transform);
                        formEditSubmit(transform,layerIndex);
                    }else{
                        $Utils.loading.close();
                        layer.msg("该转换不允许修改。",{icon:3});
                    }
                }else{
                    $Utils.loading.close();
                    layer.close(layerIndex); 
                }
            }else if(mOperationType == 0){
                setTransform(data, mTransform);
                formAddSubmit(mTransform,layerIndex);
            }
            return false;
        });
    }

    function setTransform(data, transform){
        transform.transformName = data.field.transformName;
        transform.transformType = data.field.transformType;
        transform.targetTable = data.field.targetTable;
        transform.targetTableDescription = data.field.targetTableDescription;
        transform.sourceTable = data.field.sourceTable;
        transform.sourceTableDescription = data.field.sourceTableDescription;
        transform.transformLogicType = data.field.transformLogicType;
        transform.transformLogic = data.field.transformLogic;
    }

    function changed(data){
        if(mTransform.transformName != data.field.transformName){
            return true
        }
        if(mTransform.transformType != data.field.transformType){
            return true
        }
        if(mTransform.targetTable != data.field.targetTable){
            return true
        }
        if(mTransform.targetTableDescription != data.field.targetTableDescription){
            return true
        }
        if(mTransform.sourceTable != data.field.sourceTable){
            return true
        }
        if(mTransform.sourceTableDescription != data.field.sourceTableDescription){
            return true
        }
        if(mTransform.transformLogicType != data.field.transformLogicType){
            return true
        }
        if(!mTransform.flag){
            if(mTransform.transformLogic != data.field.transformLogic){
                return true
            }
        }
        return false;
    }

}();