/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-15 18:09:04
 * @LastEditTime: 2020-07-20 18:40:04
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var mIncludedTransforms = null;
    var mTableBody = [];
    var backupArr = [];
    var lazyArr = [];
    var selectTransforms = [];

    window.initTransformList = function(index,includedTransforms,transforms,addTransformList){
        mIncludedTransforms = includedTransforms;
        initUserListHead();
        setTableBody(transforms);

        buttonEvent(index,addTransformList,transforms);
    };

    function initUserListHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "transformName", title: "转换名称"},
                {field: "transformType", title: "转换分类", templet: function(d){
                    return (d.transformType?"事实表":"维表");
                }}
            ]
        ];

        table.render({
            elem: '#userList',
            height: 360,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function setTableBody(transforms){
        var includedTransformIDs = setIncludedTransformIDs();
        var tableBody = [];
        for(var i = 0; i < transforms.count; i++){
            if(includedTransformIDs.indexOf(transforms.item(i).transformID) == -1){
                var obj = {};
                obj.transformID = transforms.item(i).transformID;
                obj.transformName = transforms.item(i).transformName;
                obj.transformType = transforms.item(i).transformType;
                tableBody.push(obj);
            }
        }
        $.extend(true,mTableBody,tableBody);
        loadTransformListBody(tableBody);
    }

    function loadTransformListBody(tableBody){
        if(tableBody.length > 100){
            lazyArr = tableBody.splice(100,tableBody.length);
        }
        backupArr = tableBody;
        if(selectTransforms.length){
            setSelect(tableBody);
        }
        table.reload("userList",{data:tableBody,limit:tableBody.length,skin: "nob",done:function(){
            $(".user-list .layui-table-main").scroll(function(){
                var scrollTop = $(this)[0].scrollTop;
                var clientHeight = $(this)[0].clientHeight;
                var scrollHeight = $(this)[0].scrollHeight;
                
                if(lazyArr.length > 0 && scrollHeight > clientHeight && scrollTop + clientHeight === scrollHeight) {
                    loadmore(scrollTop);
                }
            });
        }});
    }

    function setSelect(currentData){
        var selectTransformIDs = [];
        for(var i = 0; i < selectTransforms.length; i++){
            selectTransformIDs.push(selectTransforms[i].transformID);
        }
        for(var i = 0; i < currentData.length; i++){
            if(selectTransformIDs.indexOf(currentData[i].transformID) != -1){
                currentData[i].LAY_CHECKED = true;
            }else if(currentData[i].LAY_CHECKED){
                currentData[i].LAY_CHECKED = false;
            }
        }
    }

    function setIncludedTransformIDs(){
        var tempArr = [];
        for(var i = 0; i < mIncludedTransforms.length; i++){
            tempArr.push(mIncludedTransforms[i].transformID);
        }

        return tempArr;
    }

    function buttonEvent(index,addTransformList,transforms){
        $(".list-filter-button").click(function(){
            var searchValue = $(".list-filter input").val();
            if(searchValue == ""){
                searchData = mTableBody;
            }else{
                searchData = setSearchData(searchValue);
            }
            loadTransformListBody(searchData);
        });

        $(".list-filter input").keypress(function (e) {
            if (e.which == 13) {
                $(".list-filter-button").click();
            }
        });

        $(".user-list-button .layui-btn-determine").click(function(){
            // if(table.checkStatus('userList').data.length){
            //     var transmitData = setTransmitData(table.checkStatus('userList').data,transforms);
            //     addTransformList(transmitData,index);
            // }else{
            //     layer.msg("请至少选择一条记录。",{icon:2});
            // }
            var transmitData = setTransmitData(selectTransforms,transforms);
            addTransformList(transmitData,index);
        });

        table.on('checkbox(userList)', function(obj){
            if(obj.checked){
                if(obj.type == "all"){
                    selectTransforms = table.checkStatus('userList').data;
                }else{
                    selectTransforms.push(obj.data);
                }
            }else{
                for(var i = selectTransforms.length - 1; i >= 0 ; i--){
                    if(selectTransforms[i].transformID == obj.data.transformID){
                        selectTransforms.splice(i,1);
                    }
                }
            }
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });
        
    }

    function setSearchData(searchValue){
        var searchData = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].transformName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                searchData.push(mTableBody[i]);
            }
        }
        return searchData;
    }

    function setTransmitData(data,transforms){
        var tempArr = [];
        var transformIDsArr = [];
        for(var i = 0; i < data.length; i++){
            if(transformIDsArr.indexOf(data[i].transformID) == -1){
                transformIDsArr.push(data[i].transformID)
            }
        }
        for(var i = 0; i < transforms.count; i++){
            if(transformIDsArr.indexOf(transforms.item(i).transformID) != -1){
                tempArr.push(transforms.item(i));
            }
        }

        return  tempArr;
    }

    function loadmore(scrollTop){
        if(lazyArr.length > 100){
            var tempArr = lazyArr.splice(0,100);
            backupArr = backupArr.concat(tempArr);
        }else{
            backupArr = backupArr.concat(lazyArr);
            lazyArr = [];
        }
        if(selectTransforms.length){
            setSelect(backupArr)
        }
        table.reload("userList",{data:backupArr,limit:backupArr.length,skin: "nob"});
        $(".user-list .layui-table-main").scrollTop(scrollTop);
    }

}();