/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-15 17:22:59
 * @LastEditTime: 2020-07-24 15:41:05
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, form = layui.form;
    var transforms = new Transforms();
    var jobTransforms = new JobTransforms();
    var mTableBody = [];
    var mBackupsTableBody = [];
    var mJob = null;
    var scrollTop = 0;

    window.initSetTransformsForm = function(index,job){
        mJob = job;
        loadUserListTableHead();
        getAndLoadTransforms(job);

        buttonEvent(index);
    };

    function loadUserListTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "transformName", title: "转换名称"},
                {field: "transformType", title: "转换分类", templet: function(d){
                    return (d.transformType?"事实表":"维表");
                }}
            ]
        ];

        table.render({
            elem: '#list',
            height: 420,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadTransforms(job){
        var succ = function(){
            $Utils.loading.close();
			loadTransforms(job);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取转换列表",errorStatus,msg);
		};
		transforms.getItems(true,succ,fail);
    }

    function loadTransforms(job){
        var tableBody = [];
        for(var i = 0; i < job.transforms.count; i++){
            if(job.transforms.item(i).transformID){
                var tempObj = {};
                for(var key in transforms.item(i)){
                    if(typeof transforms.item(i)[key] === "function"){ continue;}
                    tempObj[key] = transforms.item(i)[key];
                }
                tableBody.push(tempObj);
            }
        }
        $.extend(true,mBackupsTableBody,tableBody);
        mTableBody = tableBody;
        table.reload("list",{data:tableBody,limit:tableBody.length,skin: "nob"});
    }

    function buttonEvent(index){
        var rowObj = {};
        rowObj.rowIndex = null;
        table.on("radio(list)",function(data){
            rowObj.rowIndex = $(this).parents("tr").index();
        });

        $(".add").click(function(){
            getAndLoadTransformListForm();
        });

        $(".up").off("click").on("click",function(){
            if(table.checkStatus('list').data.length){
                scrollTop = $(".job-window .layui-table-main")[0].scrollTop;
                upRow(rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".down").off("click").on("click",function(){
            if(table.checkStatus('list').data.length){
                scrollTop = $(".job-window .layui-table-main")[0].scrollTop;
                downRow(rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".remove").click(function(){
            if(table.checkStatus('list').data.length){
                deleteTransforms(table.checkStatus('list').data);
            }else{
                layer.msg("请至少选择一条记录。",{icon:2});
            }
        });

        form.on("submit(formSubmit)",function(){
            if(change()){
                $Utils.loading.open();
                addTransformSubmit(index);
            }else{
                layer.close(index);
            }
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });
    }

    function upRow(rowObj){
        if(rowObj.rowIndex != 0){
            var tempArr = $.extend(true,[],mTableBody);
            for(var i = 0; i < tempArr.length; i++){
                if(i == rowObj.rowIndex){
                    tempArr[i].LAY_CHECKED = true;
                    break;
                }
            }
            mTableBody[rowObj.rowIndex] = mTableBody.splice(rowObj.rowIndex-1, 1, mTableBody[rowObj.rowIndex])[0];
            tempArr[rowObj.rowIndex] = tempArr.splice(rowObj.rowIndex-1, 1, tempArr[rowObj.rowIndex])[0];
            table.reload("list",{data: tempArr, limit: tempArr.length});
            $(".job-window .layui-table-main").scrollTop(scrollTop);
            if(rowObj.rowIndex != 0){ rowObj.rowIndex--;}
        }
    }

    function downRow(rowObj){
        if(rowObj.rowIndex != mTableBody.length - 1){
            var tempArr = $.extend(true,[],mTableBody);
            for(var i = 0; i < tempArr.length; i++){
                if(i == rowObj.rowIndex){
                    tempArr[i].LAY_CHECKED = true;
                    break;
                }
            }
            mTableBody[rowObj.rowIndex] = mTableBody.splice(rowObj.rowIndex+1, 1, mTableBody[rowObj.rowIndex])[0];
            tempArr[rowObj.rowIndex] = tempArr.splice(rowObj.rowIndex+1, 1, tempArr[rowObj.rowIndex])[0];
            table.reload("list",{data: tempArr, limit: tempArr.length});
            $(".job-window .layui-table-main").scrollTop(scrollTop);
            if(rowObj.rowIndex < mTableBody.length - 1){ rowObj.rowIndex++;}
        }
    }

    function getAndLoadTransformListForm(){
        $.ajax({
            url: "html/iDataOrganize/job/transformList.html",
            type: 'GET',
            success: function(data){
                loadTransformListForm(data)
            }
        });
    }

    function loadTransformListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加转换","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                initTransformList(index,mTableBody,transforms,addTransformList);
            }
        });
    }

    function deleteTransforms(selectTransforms){
        for(var i = 0; i < selectTransforms.length; i++){
            for(var j = mTableBody.length - 1; j >= 0; j--){
                if(selectTransforms[i].transformID == mTableBody[j].transformID){
                    mTableBody.splice(j,1);
                    break;
                }
            }
        }
        var scrollTop = $(".content-list .layui-table-main").scrollTop();
        table.reload("list",{data:mTableBody,limit:mTableBody.length,skin: "nob"});
        $(".content-list .layui-table-main").scrollTop(scrollTop-35);
    }

    function change(){
        var transformIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            transformIDs.push(mTableBody[i].transformID);
        }
        
        if(mBackupsTableBody.length == 0 && transformIDs.length == 0){
            return false;
        }

        if(mBackupsTableBody.length != transformIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsTableBody.length; i++){
            if(transformIDs.indexOf(mBackupsTableBody[i].transformID) == -1){
                return true;
            }
        }
        
        return false;
    }

    function addTransformSubmit(index){
        var tempArr = [];
        var tempTransformIDArr = [];

        for(var i = 0; i < mTableBody.length; i++){
            var tempObj = {};
            tempObj.sequence = i;
            tempObj.transformID = mTableBody[i].transformID;
            tempTransformIDArr.push(mTableBody[i].transformID);
            tempArr.push(tempObj);
        }
        var tempObj = {};
        tempObj.jobID = mJob.jobID;
        tempObj.transformIDs = tempArr;

        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            addTransformToJob(tempTransformIDArr);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改包含的转换",errorStatus,msg);
        };
		jobTransforms.updateTransform(tempObj,true,succ,fail);
    }

    function addTransformToJob(transformIDs){
        for(var i = 0; i < transforms.count; i++){
            if(transformIDs.indexOf(transforms.item(i).transformID) != -1){
                mJob.transforms.add(transforms.item(i));
            }else{
                mJob.transforms.remove(transforms.item(i));
            }
        }
    }

    var addTransformList = function(transformList,index){
        layer.close(index);
        mTableBody = mTableBody.concat(transformList);
        table.reload("list",{data:mTableBody,limit:mTableBody.length,skin: "nob"});
    };
    
}();