/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-15 10:10:37
 * @LastEditTime: 2021-05-10 18:09:55
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, laypage = layui.laypage;
    var bdaJobs = new BdaJobs();
    var jobTransforms = new JobTransforms();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var currentTableBodyData = [];

    $Utils.loading.open();
    initMain();
    
    function initMain(){
        initBdaJobsTableHead();
        getAndLoadBdaJobsTableBody();
    }

    function initBdaJobsTableHead(){
        var bdaJobTableHead = [
            [
                {type: "radio"},
                {field: "jobName", title: "作业名称", sort: true},
                {field: "frequency", title: "执行频率", sort: true, templet: function(d){
                    return (d.frequency?(d.frequency == 1 ? "每周" : "每月"):"每天");
                }},
                {field: "frequencyType", title: "频率类别", sort: true, templet: function(d){
                    return (d.preseted?"间隔执行":"执行一次");
                }},
                {field: "enabled", title: "启用", sort: true, templet: function(d){
                    return (d.enabled?"是":"否");
                }},
                {field: "jobStatus", title: "作业状态", sort: true, templet: function(d){
                    return (d.jobStatus?"正在执行中":"空闲");
                }},
                { field: "lastModifyDate", title: "修改时间", sort: true, width: 130, templet: function(d){
                    if (d.lastModifyDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.lastModifyDate));
                    }else{
                        return "";
                    }
                }},
                {title: "操作", templet: "#reset", width: 195}
            ]
        ];
    
        table.render({
            elem: '#dataList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: bdaJobTableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadBdaJobsTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
            // loadBdaJobsTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取作业列表",errorStatus,msg);
		};
		bdaJobs.getItems(true,succ,fail);
    }

    function setTableBody(){
        var bdaJobsTableBody = [];
        for(var i = 0; i < bdaJobs.count; i++){
            var tempObj = {};
            for(var key in bdaJobs.item(i)){
                if(typeof bdaJobs.item(i)[key] === "function"){ continue;}
                if(key == "createDate"){
                    tempObj[key] = bdaJobs.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(bdaJobs.item(i)[key])):"";
                }else if(key == "lastModifyDate"){
                    tempObj[key] = bdaJobs.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(bdaJobs.item(i)[key])):"";
                }else{
                    tempObj[key] = bdaJobs.item(i)[key];
                }
            }
            bdaJobsTableBody.push(tempObj);
        }
        return bdaJobsTableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadBdaJobsTableBody(data,obj);
            }
        });
    }

    function loadBdaJobsTableBody(tableBodyData,obj){
        currentTableBodyData = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("dataList",{data:currentTableBodyData,limit:currentTableBodyData.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("dataList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("dataList",{height: tableBodyHeight});
        });
    }

    table.on('sort(dataList)', function (obj) {
        var type = obj.type,
            field = obj.field,
            data = mSortBodyData,//表格的配置Data
            thisData = [];
        if(type === 'asc'){ //升序
            thisData = $Utils.sorter(data, field);
        }else if(type === 'desc'){ //降序
            thisData = $Utils.sorter(data, field, true);
        }else{ //清除排序
            thisData = data;
        }
        setTablePage(thisData);
    });

    table.on("tool(dataList)", function(obj){
        var job = bdaJobs.item(obj.data.jobID);
        if(obj.event === "resetStatus"){
            layer.open({
                type: 0,
                title: "重置作业为空闲状态",
                closeBtn: 1,
                shadeClose: true,
                resize: false,
                area: ["480px","270px"],
                skin: "delete-window",
                content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>重置为空闲状态可能会将正在执行的作业中断，是否重置？</div></div>",
                btn: ["确定","取消"],
                yes: function(index,layero){
                    layer.close(index);
                    $Utils.loading.open();
                    resetJobStatus(job);
                }
            });
        }
        if(obj.event === "execution"){
            // getAndLoadSetTransformsFrom(job);
            if(job.transforms.count){
                $Utils.loading.open();
                var succ = function(){
                    $Utils.loading.close();
                    layer.msg("执行作业成功。",{icon: 1});
                };
                var fail = function(errorStatus,msg){
                    $Utils.loading.close();
                    $Utils.openWindow.failWindow("手动执行作业",errorStatus,msg);
                };
                job.executionJob(true,succ,fail);
            }else{
                layer.msg("至少要有一个转换才能执行。",{icon: 3});
            }
        }
    });

    function resetJobStatus(job){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("重置成功。",{icon: 1});
            job.jobStatus = 0;
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
            // loadBdaJobsTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("重置作业执行状态",errorStatus,msg);
		};
		job.resetJobStatus(true,succ,fail);
    }

    function getAndLoadSetTransformsFrom(job){
        $.ajax({
            url: "html/iDataOrganize/job/setTransform.html",
            type: 'GET',
            success: function(data){
                loadSetTransformsForm(data,job)
            }
        });
    }

    function loadSetTransformsForm(strHtml,job){
        layer.open({
            type: 1,
            title: [job.jobName + " 转换","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initSetTransformsForm(index,job);
            }
        });
    }

    $(".search-button").click(function(){
        var searchValue = $(".search input[name=searchContent]").val();
        var searchData = [];
        if(searchValue == ""){
            searchData = mTableBodyData;
        }else{
            searchData = setSearchData(searchValue);
        }
        mSortBodyData = searchData;
        setTablePage(searchData);
    });

    $(".search input[name=searchContent]").keypress(function (e) {
        if (e.which == 13) {
            $(".search-button").click();
        }
    });

    $(".add-job").click(function(){
        var bdaJob = new BdaJob();
        getAndLoadBdaJobForm(0,bdaJob);
    });

    $(".edit-job").click(function(){
        if(table.checkStatus('dataList').data.length){
            var bdaJob = bdaJobs.item(table.checkStatus('dataList').data[0].jobID);
            getAndLoadBdaJobForm(1,bdaJob);
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".delete-job").click(function(){
        if(table.checkStatus('dataList').data.length){
            deleteWindow();
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".refresh").click(function(){
        $Utils.loading.open();
        getAndLoadBdaJobsTableBody();
    });

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].jobName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].emailAddress.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadBdaJobForm(operationType,bdaJob){
        $.ajax({
            url: "html/iDataOrganize/job/job.html",
            type: 'GET',
            success: function(data){
                loadBdaJobForm(operationType,bdaJob,data);
            }
        });
    }

    function loadBdaJobForm(operationType,bdaJob,strHtml){
        layer.open({
            type: 1,
            title: [operationType?bdaJob.jobName+" 属性":"新增作业","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initBdaJobForm(operationType,bdaJob,index,addSubmit,editSubmit);
            }
        });
    }

    function deleteWindow(str,className){
        layer.open({
            type: 0,
            title: "删除转换",
            closeBtn: 1,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('dataList').data[0].jobName+" ？</div></div>",
            btn: ["是","否"],
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                deleteBdaJob(table.checkStatus('dataList').data[0].jobID);
            }
        });
    }

    function deleteBdaJob(jobID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadBdaJobsTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除作业",errorStatus,msg);
		};
		bdaJobs.deleteItem(jobID,true,succ,fail);
    }

    var addSubmit = function(bdaJob,transformIsChange,jobTransform,index){
        var succ = function(data){
            $Utils.loading.close();
            layer.close(index);
            if(transformIsChange){
                jobTransform.jobID = data;
                updateTransform(jobTransform);
            }
            getAndLoadBdaJobsTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增作业",errorStatus,msg);
        };
        
		bdaJobs.addItem(bdaJob,true,succ,fail);
    };

    var editSubmit = function(bdaJob,jobAttrIsChange,transformIsChange,jobTransform,index){
        if(jobAttrIsChange){
            var succ = function(){
                $Utils.loading.close();
                layer.close(index);
                if(transformIsChange){
                    updateTransform(jobTransform);
                }
                getAndLoadEditList(bdaJob);
            };
            var fail = function(errorStatus,msg){
                $Utils.loading.close();
                $Utils.openWindow.failWindow("修改作业",errorStatus,msg);
            };
    
            bdaJobs.editItem(bdaJob,true,succ,fail);
        }else if(transformIsChange){
            $Utils.loading.close();
            layer.close(index);
            updateTransform(jobTransform);
            getAndLoadEditList(bdaJob);
        }
    };

    function updateTransform(jobTransform){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改包含的转换",errorStatus,msg);
        };
		jobTransforms.updateTransform(jobTransform,true,succ,fail);
    }

    function getAndLoadEditList(bdaJob){
        var succ = function(){
            $Utils.loading.close();
            editListItem(bdaJob);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+bdaJob.jobName+" 的属性",errorStatus,msg);
        };
        bdaJobs.item(bdaJob.jobID).initByID(true,succ,fail);
    }

    function editListItem(bdaJob){
        var tempTableBody = $.extend(true,[],currentTableBodyData);
        for(var i = 0; i < currentTableBodyData.length; i++){
            if(currentTableBodyData[i].jobID == bdaJob.jobID){
                for(var key in currentTableBodyData[i]){
                    if(key == "createDate"){
                        currentTableBodyData[i][key] = bdaJob[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(bdaJob[key])):"";
                        tempTableBody[i][key] = bdaJob[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(bdaJob[key])):"";

                    }else if(key == "lastModifyDate"){
                        currentTableBodyData[i][key] = bdaJob[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(bdaJob[key])):"";
                        tempTableBody[i][key] = bdaJob[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(bdaJob[key])):"";
                    }else{
                        currentTableBodyData[i][key] = bdaJob[key];
                        tempTableBody[i][key] = bdaJob[key];
                    }
                }
                tempTableBody[i].LAY_CHECKED = true;
            }else{
                tempTableBody[i].LAY_CHECKED = false;
            }
        }
        mSortBodyData = currentTableBodyData;
        table.reload("dataList",{data:tempTableBody,limit:tempTableBody.length});
    }

}();