/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-15 14:51:23
 * @LastEditTime: 2021-05-11 09:16:02
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form, laydate = layui.laydate, table = layui.table, element = layui.element;
    var mOperationType = null;
    var transforms = new Transforms();
    var frequencys = [
        {
            key: "每天",
            value: 0
        }
    ];
    var mJob = null, layerIndex = null;
    var formAddSubmit = null;
    var formEditSubmit = null;
    var oneTimeStartDate = null;
    var intervalStartTime = null;
    var intervalEndTime = null;
    var mTableBody = [];
    var mBackupsTableBody = [];
    var scrollTop = 0;

    window.initBdaJobForm = function(operationType,job,index,addSubmit,editSubmit){
        mJob = job;
        layerIndex = index;
        formAddSubmit = addSubmit;
        formEditSubmit = editSubmit;
        mOperationType = operationType;
        oneTimeStartDate = mJob.oneTimeStartDate?mJob.oneTimeStartDate:"00:00:00";
        intervalStartTime = mJob.intervalStartTime?mJob.intervalStartTime:"00:00:00";
        intervalEndTime = mJob.intervalEndTime?mJob.intervalEndTime:"23:59:59";
        laydate.render({ 
            elem: '#oneTimeStartDate',
            type: 'time',
            theme: '#246ca8',
            btns: ['now', 'confirm'],
            value: oneTimeStartDate,
            done: function(value, date, endDate){
                oneTimeStartDate = value;
            }
        });
        laydate.render({ 
            elem: '#intervalStartTime',
            type: 'time',
            theme: '#246ca8',
            btns: ['now', 'confirm'],
            value: intervalStartTime,
            done: function(value, date, endDate){
                intervalStartTime = value;
            }
        });
        laydate.render({ 
            elem: '#intervalEndTime',
            type: 'time',
            theme: '#246ca8',
            btns: ['now', 'confirm'],
            value: intervalEndTime,
            done: function(value, date, endDate){
                intervalEndTime = value;
            }
        });

        if(mOperationType == 0){
            initAddJobForm();
        }else if(mOperationType == 1){
            initEditJobForm(job);
        }
        form.render();
        $(".job-window input[name=jobName]").focus();

        var createUserName = mOperationType == 0 ? $AppVars.gUser.userName : (mJob.createUserName || "");
        var createDate = mOperationType == 0 ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date()) : $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(mJob.createDate));
        var lastModifyUserName = mOperationType == 0 ? "" : (mJob.lastModifyUserName || "");
        var lastModifyDate = mOperationType == 0 ? "" : (mJob.lastModifyDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(mJob.lastModifyDate)) : "");
        $(".bottom-item .createUserName").text(createUserName);
        $(".bottom-item .createDate").text(createDate);
        $(".bottom-item .lastModifyUserName").text(lastModifyUserName);
        $(".bottom-item .lastModifyDate").text(lastModifyDate);
        
        bindRadioElementEvent();
        bindElementEvent();

        loadTransformListTableHead();
        getAndLoadTransforms(job);
        buttonEvent(index);
    }

    function initAddJobForm(){
        createSelect(0);
        $(".interval").css("color","#a5a5a5");
        $(".interval").find("input").attr("disabled",true);
    }

    function createSelect(value){
        var frequency = document.getElementById("frequency");
        for(var i = 0; i < frequencys.length; i++){
            var option = document.createElement("option");
            option.setAttribute("value",frequencys[i].value);
            if(value == frequencys[i].value){
                option.setAttribute("selected",true);
            }
            option.innerText = frequencys[i].key;
            frequency.appendChild(option);
        }
    }

    function initEditJobForm(){
        createSelect(mJob.frequency);
        
        form.val("formWindow",{
            "jobName": mJob.jobName,
            "frequencyType": mJob.frequencyType,
            "emailAddress": mJob.emailAddress,
            "enabled": mJob.enabled
        });
        if(mJob.frequencyType == 0){
            $(".interval").css("color","#a5a5a5");
            $(".interval").find("input").attr("disabled",true);
        }else if(mJob.frequencyType == 1){
            $(".one-time").css("color","#a5a5a5");
            $(".one-time").find("input").attr("disabled",true);

            form.val("formWindow",{
                "interval": mJob.interval
            });
        }
    }

    function bindRadioElementEvent(){
        form.on("radio(frequencyType)", function (data) {
            if(this.value == '0'){
                $(".one-time").css("color","#666");
                $(".one-time").find("input").attr("disabled",false);

                $(".interval").css("color","#a5a5a5");
                $(".interval").find("input").attr("disabled",true);
            }else if(this.value == '1'){
                $(".interval").css("color","#666");
                $(".interval").find("input").attr("disabled",false);
                
                $(".one-time").css("color","#a5a5a5");
                $(".one-time").find("input").attr("disabled",true);
            }
        });
    }

    function bindElementEvent(){

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });

        $(".job-window").on("click",".test-link a",function(){
            if(mJob.transforms.count){
                $Utils.loading.open();
                var succ = function(){
                    $Utils.loading.close();
                    layer.msg("执行成功。",{icon: 1});
                };
                var fail = function(errorStatus,msg){
                    $Utils.loading.close();
                    $Utils.openWindow.failWindow("手动执行作业",errorStatus,msg);
                };
                mJob.executionJob(true,succ,fail);
            }else{
                layer.msg("至少要有一个转换才能执行。",{icon: 3});
            }
        });
        
        form.on('submit(formSubmit)', function(data){
            $Utils.loading.open();
            var jobTransform = {};
            var job = setJob(data);
            jobTransform = setJobTransform();
            if(mOperationType == 1){
                if(changeTransforms() && changed(data)){
                    formEditSubmit(job,true,true,jobTransform,layerIndex);
                }else{
                    if(changeTransforms()){
                        formEditSubmit(job,false,true,jobTransform,layerIndex);
                    }else if(changed(data)){
                        formEditSubmit(job,true,false,jobTransform,layerIndex);
                    }else{
                        $Utils.loading.close();
                        layer.close(layerIndex); 
                    }
                }
            }else if(mOperationType == 0){
                if(changeTransforms()){
                    formAddSubmit(job,true,jobTransform,layerIndex);
                }else{
                    formAddSubmit(job,false,jobTransform,layerIndex);
                }
            }
            return false;
        });
    }

    function setJob(data){
        var job = new BdaJob();
        if(mOperationType == 1){
            job.jobID = mJob.jobID;
        }
        job.jobName = data.field.jobName;
        job.frequency = Number(data.field.frequency);
        job.frequencyType = Number(data.field.frequencyType);
        if(job.frequencyType == 0){
            job.oneTimeStartDate = oneTimeStartDate;
        }
        if(job.frequencyType == 1){
            job.interval = data.field.interval;
            job.intervalStartTime = intervalStartTime;
            job.intervalEndTime = intervalEndTime;
        }
        job.emailAddress = data.field.emailAddress;
        job.enabled = Number(data.field.enabled)?true:false;
        job.transforms = [];

        return job;
    }

    function setJobTransform(){
        var tempArr = [];
        for(var i = 0; i < mTableBody.length; i++){
            var tempObj = {};
            tempObj.sequence = i;
            tempObj.transformID = mTableBody[i].transformID;
            tempArr.push(tempObj);
        }
        var tempJobTransformObj = {
            jobID: mJob.jobID,
            transformIDs: tempArr
        }
        return tempJobTransformObj;
    }

    function changed(data){
        if(mJob.jobName != data.field.jobName){
            return true
        }
        if(mJob.frequency != data.field.frequency){
            return true
        }
        if(mJob.frequencyType != data.field.frequencyType){
            return true
        }
        if(mJob.emailAddress != data.field.emailAddress){
            return true
        }
        if(mJob.enabled != data.field.enabled){
            return true
        }
        if(mJob.frequencyType == 0){
            if(mJob.oneTimeStartDate != oneTimeStartDate){
                return true
            }
        }
        if(mJob.frequencyType == 1){
            if(mJob.interval != data.field.interval){
                return true
            }
            if(mJob.intervalStartTime != intervalStartTime){
                return true
            }
            if(mJob.intervalEndTime != intervalEndTime){
                return true
            }
        }
        return false;
    }

    function changeTransforms(){
        var transformIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            transformIDs.push(mTableBody[i].transformID);
        }
        
        if(mBackupsTableBody.length == 0 && transformIDs.length == 0){
            return false;
        }

        if(mBackupsTableBody.length != transformIDs.length){
            return true;
        }

        for(var i = 0; i < mJob.transforms.count; i++){
            if(mJob.transforms.item(i).transformID != transformIDs[i]){
                return true;
            }
        }
        
        return false;
    }

    function loadTransformListTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "transformName", title: "转换名称"},
                {field: "transformType", title: "转换分类", templet: function(d){
                    return (d.transformType?"事实表":"维表");
                }}
            ]
        ];

        table.render({
            elem: '#list',
            height: 380,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadTransforms(job){
        var succ = function(){
            $Utils.loading.close();
			loadTransforms(job);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取转换列表",errorStatus,msg);
		};
		transforms.getItems(true,succ,fail);
    }

    function loadTransforms(job){
        var tableBody = [];
        for(var i = 0; i < job.transforms.count; i++){
            if(job.transforms.item(i).transformID){
                var tempObj = {};
                for(var key in job.transforms.item(i)){
                    if(typeof job.transforms.item(i)[key] === "function"){ continue;}
                    tempObj[key] = job.transforms.item(i)[key];
                }
                tableBody.push(tempObj);
            }
        }
        $.extend(true,mBackupsTableBody,tableBody);
        mTableBody = tableBody;
        table.reload("list",{data:tableBody,limit:tableBody.length,skin: "nob"});
    }

    function buttonEvent(index){
        var rowObj = {};
        rowObj.rowIndex = null;
        table.on("radio(list)",function(data){
            rowObj.rowIndex = $(this).parents("tr").index();
        });

        $(".add").click(function(){
            getAndLoadTransformListForm();
        });

        $(".up").off("click").on("click",function(){
            if(table.checkStatus('list').data.length){
                scrollTop = $(".job-window .layui-table-main")[0].scrollTop;
                upRow(rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".down").off("click").on("click",function(){
            if(table.checkStatus('list').data.length){
                scrollTop = $(".job-window .layui-table-main")[0].scrollTop;
                downRow(rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".remove").click(function(){
            if(table.checkStatus('list').data.length){
                deleteTransforms(table.checkStatus('list').data);
            }else{
                layer.msg("请至少选择一条记录。",{icon:2});
            }
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });
    }

    function upRow(rowObj){
        if(rowObj.rowIndex != 0){
            var tempArr = $.extend(true,[],mTableBody);
            for(var i = 0; i < tempArr.length; i++){
                if(i == rowObj.rowIndex){
                    tempArr[i].LAY_CHECKED = true;
                    break;
                }
            }
            mTableBody[rowObj.rowIndex] = mTableBody.splice(rowObj.rowIndex-1, 1, mTableBody[rowObj.rowIndex])[0];
            tempArr[rowObj.rowIndex] = tempArr.splice(rowObj.rowIndex-1, 1, tempArr[rowObj.rowIndex])[0];
            table.reload("list",{data: tempArr, limit: tempArr.length});
            if(rowObj.rowIndex != mTableBody.length - 1){
                $(".job-window .layui-table-main").scrollTop(scrollTop-35);
            }else{
                $(".job-window .layui-table-main").scrollTop(scrollTop);
            }
            if(rowObj.rowIndex != 0){ rowObj.rowIndex--;}
        }
    }

    function downRow(rowObj){
        if(rowObj.rowIndex != mTableBody.length - 1){
            var tempArr = $.extend(true,[],mTableBody);
            for(var i = 0; i < tempArr.length; i++){
                if(i == rowObj.rowIndex){
                    tempArr[i].LAY_CHECKED = true;
                    break;
                }
            }
            mTableBody[rowObj.rowIndex] = mTableBody.splice(rowObj.rowIndex+1, 1, mTableBody[rowObj.rowIndex])[0];
            tempArr[rowObj.rowIndex] = tempArr.splice(rowObj.rowIndex+1, 1, tempArr[rowObj.rowIndex])[0];
            table.reload("list",{data: tempArr, limit: tempArr.length});
            if(rowObj.rowIndex != 0){
                $(".job-window .layui-table-main").scrollTop(scrollTop+35);
            }
            if(rowObj.rowIndex < mTableBody.length - 1){ rowObj.rowIndex++;}
        }
    }

    function getAndLoadTransformListForm(){
        $.ajax({
            url: "html/iDataOrganize/job/transformList.html",
            type: 'GET',
            success: function(data){
                loadTransformListForm(data)
            }
        });
    }

    function loadTransformListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加转换","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                initTransformList(index,mTableBody,transforms,addTransformList);
            }
        });
    }

    function deleteTransforms(selectTransforms){
        for(var i = 0; i < selectTransforms.length; i++){
            for(var j = mTableBody.length - 1; j >= 0; j--){
                if(selectTransforms[i].transformID == mTableBody[j].transformID){
                    mTableBody.splice(j,1);
                    break;
                }
            }
        }
        var scrollTop = $(".content-list .layui-table-main").scrollTop();
        table.reload("list",{data:mTableBody,limit:mTableBody.length,skin: "nob"});
        $(".content-list .layui-table-main").scrollTop(scrollTop-35);
    }

    var addTransformList = function(transformList,index){
        layer.close(index);
        mTableBody = mTableBody.concat(transformList);
        table.reload("list",{data:mTableBody,limit:mTableBody.length,skin: "nob"});
    };

}();