/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-14 14:03:53
 * @LastEditTime: 2020-09-03 11:09:41
 * @LastModifyUser: 
 * @Remark: 
 */

/**
 * @Descripttion: 数据库设置
 * @Author: 王政
 * @Date: 2020-07-14 14:39:34
 * @LastEditTime: Do not edit
 * @LastmodifyUser: 
 * @Remark: 
 */
function BizDbSetting() {
    this.databaseSettingID = null;
    this.organizationID = null;
    this.bizSystemName = null;
    this.databaseIP = null;
    this.databasePort = null;
    this.databaseTypeName = null;
    this.databaseTypeVersion = null;
    this.databaseName = null;
    this.userName = null;
    this.password = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
    this.testConnections = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath + "/connection?"+parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    }
}

function BizDbSettings() {
    var me = this;
    this.aryBizDbSettings = [];
    this.dicBizDbSettings = {};

    this.add = function (bizDbSetting) {
        this.aryBizDbSettings.push(bizDbSetting);
        this.dicBizDbSettings[bizDbSetting.databaseSettingID] = bizDbSetting;
        this.count = this.aryBizDbSettings.length;
    };
    this.remove = function (bizDbSetting) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryBizDbSettings[i].databaseSettingID == bizDbSetting.databaseSettingID) {
                k = i;
                break;
            }
        }
        this.aryBizDbSettings.splice(k, 1);
        delete this.dicBizDbSettings[bizDbSetting.databaseSettingID];
        this.count = this.aryBizDbSettings.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryBizDbSettings[indexOrKey];
        } else {
            return this.dicBizDbSettings[indexOrKey];
        }
    };
    this.getItems = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setBizDbSettings(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (bizDbSetting, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath;
        var obj = JSON.stringify(bizDbSetting);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getDatabaseNames = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bizDbSettingPath + "/databaseNames?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                succ(data.items);
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    function setBizDbSettings(data) {
        me.count = 0;
        me.aryBizDbSettings = [];
        me.dicBizDbSettings = {};
        for (var i = 0; i < data.length; i++) {
            var bizDbSetting = new BizDbSetting();
            bizDbSetting.init(data[i]);
            me.add(bizDbSetting);
        }
    }
}

/**
 * @Descripttion: 财务指标维表
 * @Author: 王政
 * @Date: 2020-07-14 14:39:15
 * @LastEditTime: Do not edit
 * @LastmodifyUser: 
 * @Remark: 
 */
function FinanceIndex() {
    this.indexID = null;
    this.indexCode = null;
    this.indexName = null;
    this.indexClassCode = null;
    this.expression = null;
    this.finalExpression = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
}

function FinanceIndexs() {
    var me = this;
    this.aryFinanceIndexs = [];
    this.dicFinanceIndexs = {};

    this.add = function (financeIndex) {
        this.aryFinanceIndexs.push(financeIndex);
        this.dicFinanceIndexs[financeIndex.indexID] = financeIndex;
        this.count = this.aryFinanceIndexs.length;
    };
    this.remove = function (financeIndex) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryFinanceIndexs[i].indexID == financeIndex.indexID) {
                k = i;
                break;
            }
        }
        this.aryFinanceIndexs.splice(k, 1);
        delete this.dicFinanceIndexs[financeIndex.indexID];
        this.count = this.aryFinanceIndexs.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryFinanceIndexs[indexOrKey];
        } else {
            return this.dicFinanceIndexs[indexOrKey];
        }
    };
    this.setFinanceIndexs = function (data) {
        this.count = 0;
        this.aryFinanceIndexs = [];
        this.dicFinanceIndexs = {};
        for (var i = 0; i < data.length; i++) {
            var financeIndex = new FinanceIndex();
            financeIndex.init(data[i]);
            this.add(financeIndex);
        }
    }
    this.getItems = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeIndicesPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                me.setFinanceIndexs(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.addItem = function (financeIndex, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeIndicesPath;
        var obj = JSON.stringify(financeIndex);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                var indexID = request.getResponseHeader('location').split('/financeIndices/')[1];
                financeIndex.indexID = indexID;
                me.add(financeIndex);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (financeIndex, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeIndicesPath + "/" + financeIndex.indexID;
        var obj = JSON.stringify(financeIndex);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.deleteItem = function (indexID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeIndicesPath + "/" + indexID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                me.remove(me.item(indexID));
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

}

/**
 * @Descripttion: 财务指标分类维表
 * @Author: 王政
 * @Date: 2020-07-14 14:39:56
 * @LastEditTime: Do not edit
 * @LastmodifyUser: 
 * @Remark: 
 */
function FinanceIndexClass() {
    this.indexClassCode = null;
    this.indexClassName = null;
    this.financeIndices = new FinanceIndexs();

    this.init = function (options) {
        for (var key in options) {
            if (key == "financeIndices") {
                this[key].setFinanceIndexs(options[key]);
            } else {
                this[key] = options[key];
            }
        }
    };
}

function FinanceIndexClasses() {
    var me = this;
    this.count = 0;
    this.aryFinanceIndexClasses = [];
    this.dicFinanceIndexClasses = {};

    this.add = function (financeIndexClass) {
        this.aryFinanceIndexClasses.push(financeIndexClass);
        this.dicFinanceIndexClasses[financeIndexClass.indexClassCode] = financeIndexClass;
        this.count = this.aryFinanceIndexClasses.length;
    };
    this.remove = function (financeIndexClass) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryFinanceIndexClasses[i].indexClassCode == financeIndexClass.indexClassCode) {
                k = i;
                break;
            }
        }
        this.aryFinanceIndexClasses.splice(k, 1);
        delete this.dicFinanceIndexClasses[financeIndexClass.indexClassCode];
        this.count = this.aryFinanceIndexClasses.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryFinanceIndexClasses[indexOrKey];
        } else {
            return this.dicFinanceIndexClasses[indexOrKey];
        }
    };
    this.getItems = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeIndexClassesPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setFinanceIndexClasses(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.addItem = function (financeIndexClass, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeIndexClassesPath;
        var obj = JSON.stringify(financeIndexClass);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (financeIndexClass, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeIndexClassesPath + "/" + financeIndexClass.indexClassCode;
        var obj = JSON.stringify(financeIndexClass);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.deleteItem = function (indexClassCode, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeIndexClassesPath + "/" + indexClassCode;
        var obj = "";
        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                me.remove(me.item(indexClassCode));
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    function setFinanceIndexClasses(data) {
        me.count = 0;
        me.aryFinanceIndexClasses = [];
        me.dicFinanceIndexClasses = {};
        for (var i = 0; i < data.length; i++) {
            var financeIndexClass = new FinanceIndexClass();
            financeIndexClass.init(data[i]);
            me.add(financeIndexClass);
        }
    }
}

/**
 * @Descripttion: 财务报表维表
 * @Author: 王政
 * @Date: 2020-07-14 14:50:46
 * @LastEditTime: Do not edit
 * @LastmodifyUser: 
 * @Remark: 
 */
function FinanceReport() {
    this.reportCode = null;
    this.reportName = null;
    this.financeReportItems = new FinanceReportItems();

    this.init = function (options) {
        for (var key in options) {
            if (key == "financeReportItems") {
                this[key].setFinanceReportItems(options[key]);
            } else {
                this[key] = options[key];
            }
        }
    };
}

function FinanceReports() {
    var me = this;
    this.count = 0;
    this.aryFinanceReports = [];
    this.dicFinanceReports = {};

    this.add = function (financeReport) {
        this.aryFinanceReports.push(financeReport);
        this.dicFinanceReports[financeReport.reportCode] = financeReport;
        this.count = this.aryFinanceReports.length;
    };
    this.remove = function (financeReport) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryFinanceReports[i].reportCode == financeReport.reportCode) {
                k = i;
                break;
            }
        }
        this.aryFinanceReports.splice(k, 1);
        delete this.dicFinanceReports[financeReport.reportCode];
        this.count = this.aryFinanceReports.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryFinanceReports[indexOrKey];
        } else {
            return this.dicFinanceReports[indexOrKey];
        }
    };
    this.getItems = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeReportsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setFinanceReports(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.addItem = function (financeReport, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeReportsPath;
        var obj = JSON.stringify(financeReport);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (financeReport, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeReportsPath + "/" + financeReport.reportCode;
        var obj = JSON.stringify(financeReport);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.deleteItem = function (reportCode, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeReportsPath + "/" + reportCode;
        var obj = "";
        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                me.remove(me.item(reportCode));
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    function setFinanceReports(data) {
        me.count = 0;
        me.aryFinanceReports = [];
        me.dicFinanceReports = {};
        for (var i = 0; i < data.length; i++) {
            var financeReport = new FinanceReport();
            financeReport.init(data[i]);
            me.add(financeReport);
        }
    }
}

/**
 * @Descripttion: 财务报表项目维表
 * @Author: 王政
 * @Date: 2020-07-14 14:56:54
 * @LastEditTime: Do not edit
 * @LastmodifyUser: 
 * @Remark: 
 */
function FinanceReportItem() {
    this.reportItemID = null;
    this.reportItemCode = null;
    this.reportItemName = null;
    this.showName = null;
    this.rowNumber = null;
    this.reportCode = null;
    this.expression = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
}

function FinanceReportItems() {
    var me = this;
    this.count = 0;
    this.aryFinanceReportItems = [];
    this.dicFinanceReportItems = {};

    this.add = function (financeReportItem) {
        this.aryFinanceReportItems.push(financeReportItem);
        this.dicFinanceReportItems[financeReportItem.reportItemID] = financeReportItem;
        this.count = this.aryFinanceReportItems.length;
    };
    this.remove = function (financeReportItem) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryFinanceReportItems[i].reportItemID == financeReportItem.reportItemID) {
                k = i;
                break;
            }
        }
        this.aryFinanceReportItems.splice(k, 1);
        delete this.dicFinanceReportItems[financeReportItem.reportItemID];
        this.count = this.aryFinanceReportItems.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryFinanceReportItems[indexOrKey];
        } else {
            return this.dicFinanceReportItems[indexOrKey];
        }
    };
    this.setFinanceReportItems = function (data) {
        me.count = 0;
        me.aryFinanceReportItems = [];
        me.dicFinanceReportItems = {};
        for (var i = 0; i < data.length; i++) {
            var financeReportItem = new FinanceReportItem();
            financeReportItem.init(data[i]);
            me.add(financeReportItem);
        }
    };
    this.getItems = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeReportItemsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                me.setFinanceReportItems(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.addItem = function (financeReportItem, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeReportItemsPath;
        var obj = JSON.stringify(financeReportItem);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                var reportItemID = request.getResponseHeader('location').split('/financeReportItems/')[1];
                financeReportItem.reportItemID = reportItemID;
                me.add(financeReportItem);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (financeReportItem, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeReportItemsPath + "/" + financeReportItem.reportItemID;
        var obj = JSON.stringify(financeReportItem);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.deleteItem = function (reportItemID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.financeReportItemsPath + "/" + reportItemID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                me.remove(me.item(reportItemID));
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
}

/**
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-15 10:03:17
 * @LastEditTime: Do not edit
 * @LastmodifyUser: 
 * @Remark: 
 */
function BdaJob(){
    var me = this;
    this.jobID = null;
    this.organizationID = null;
    this.jobName = null;
    this.frequency = null;
    this.frequencyType = null;
    this.oneTimeStartDate = null;
    this.interval = null;
    this.intervalStartTime = null;
    this.intervalEndTime = null;
    this.emailAddress = null;
    this.enabled = null;
    this.jobStatus = 0;
    this.createUserID = null;
    this.createDate = null;
    this.lastModifyUserID = null;
    this.lastModifyDate = null;
    this.transforms = new Transforms();

    this.init = function (options) {
        for (var key in options) {
            if (key == "transforms") {
                this[key].setTransforms(options[key]);
            } else {
                this[key] = options[key];
            }
        }
    };
    this.initByID = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath + "/"+this.jobID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.resetJobStatus = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath + "/" + this.jobID + "/jobStatus?jobStatus=0";
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.executionJob = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath + "/" + this.jobID + "/execution";
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback, 1);
    }
}

function BdaJobs(){
    var me = this;
    this.count = 0;
    this.aryBdaJobs = [];
    this.dicBdaJobs = {};

    this.add = function (bdaJob) {
        this.aryBdaJobs.push(bdaJob);
        this.dicBdaJobs[bdaJob.jobID] = bdaJob;
        this.count = this.aryBdaJobs.length;
    };
    this.remove = function (bdaJob) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryBdaJobs[i].jobID==bdaJob.jobID){
                k = i;
                break;
            }
        }
        this.aryBdaJobs.splice(k,1);
        delete this.dicBdaJobs[bdaJob.jobID];
        this.count = this.aryBdaJobs.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryBdaJobs[indexOrKey];
        }else{
            return this.dicBdaJobs[indexOrKey];
        }
    };
    this.getItems = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setBdaJobs(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.addItem = function (bdaJob, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath;
        var obj = JSON.stringify(bdaJob);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                var jobID = request.getResponseHeader('location').split('/jobs/')[1];
                bdaJob.jobID = jobID;
                me.add(bdaJob);
                succ(jobID);
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (bdaJob, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath + "/" + bdaJob.jobID;
        var obj = JSON.stringify(bdaJob);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.deleteItem = function (jobID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobsPath + "/" + jobID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                me.remove(me.item(jobID));
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    function setBdaJobs(data){
        me.count = 0;
        me.aryBdaJobs = [];
        me.dicBdaJobs = {};
        for(var i = 0; i < data.length; i++){
            var bdaJob = new BdaJob();
            bdaJob.init(data[i]);
            me.add(bdaJob);
        }
    }
}

/**
 * @Descripttion: 作业转换
 * @Author: 王政
 * @Date: 2020-07-14 15:33:55
 * @LastEditTime: Do not edit
 * @LastmodifyUser: 
 * @Remark: 
 */
function JobTransform() {
    this.jobID = null;
    this.organizationID = null;
    this.transformID = null;
    this.sequence = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
}

function JobTransforms() {
    var me = this;
    this.count = 0;
    this.aryJobTransforms = [];
    this.dicJobTransforms = {};

    this.add = function (jobTransform) {
        this.aryJobTransforms.push(jobTransform);
        this.dicJobTransforms[jobTransform.jobID] = jobTransform;
        this.count = this.aryJobTransforms.length;
    };
    this.remove = function (jobTransform) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryJobTransforms[i].jobID == jobTransform.jobID) {
                k = i;
                break;
            }
        }
        this.aryJobTransforms.splice(k, 1);
        delete this.dicJobTransforms[jobTransform.jobID];
        this.count = this.aryJobTransforms.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryJobTransforms[indexOrKey];
        } else {
            return this.dicJobTransforms[indexOrKey];
        }
    };
    this.updateTransform = function (jobTransform, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jobTransformsPath + "/" + jobTransform.jobID;
        var obj = JSON.stringify(jobTransform.transformIDs);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    function setJobTransforms(data) {
        me.count = 0;
        me.aryJobTransforms = [];
        me.dicJobTransforms = {};
        for (var i = 0; i < data.length; i++) {
            var jobTransform = new JobTransform();
            jobTransform.init(data[i]);
            me.add(jobTransform);
        }
    }
}

/**
 * @Descripttion: 转换
 * @Author: 王政
 * @Date: 2020-07-14 15:49:41
 * @LastEditTime: Do not edit
 * @LastmodifyUser: 
 * @Remark: 
 */
function Transform(){
    var me = this;
    this.transformID = null;
    this.organizationID = null;
    this.transformName = null;
    this.transformType = null;
    this.targetTable = null;
    this.targetTableDescription = null;
    this.sourceTable = null;
    this.sourceTableDescription = null;
    this.transformLogicType = null;
    this.transformLogic = null;
    this.preseted = 0;
    this.lastExecuteDate = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = null;
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;
    this.flag = false;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
    this.initByID = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath + "/"+this.transformID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.executionTransform = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath + "/" + this.transformID + "/execution";
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback, 1);
    };
    this.getTableData = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath + "/" + this.transformID + "/targetTableValues";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    }
}

function Transforms(){
    var me = this;
    this.count = 0;
    this.aryTransforms = [];
    this.dicTransforms = {};

    this.add = function (transform) {
        this.aryTransforms.push(transform);
        this.dicTransforms[transform.transformID] = transform;
        this.count = this.aryTransforms.length;
    };
    this.remove = function (transform) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTransforms[i].transformID==transform.transformID){
                k = i;
                break;
            }
        }
        this.aryTransforms.splice(k,1);
        delete this.dicTransforms[transform.transformID];
        this.count = this.aryTransforms.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTransforms[indexOrKey];
        }else{
            return this.dicTransforms[indexOrKey];
        }
    };
    this.setTransforms = function(data){
        this.count = 0;
        this.aryTransforms = [];
        this.dicTransforms = {};
        for(var i = 0; i < data.length; i++){
            var transform = new Transform();
            transform.init(data[i]);
            this.add(transform);
        }
    };
    this.getItems = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                me.setTransforms(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.addItem = function (transform, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath;
        var obj = JSON.stringify(transform);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (transform, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath + "/" + transform.transformID;
        var obj = JSON.stringify(transform);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.deleteItem = function (transformID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformsPath + "/" + transformID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                me.remove(me.item(transformID));
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    
}

/**
 * @Descripttion: 转换日志
 * @Author: 王政
 * @Date: 2020-07-14 15:53:29
 * @LastEditTime: Do not edit
 * @LastmodifyUser: 
 * @Remark: 
 */
function TransformLog(){
    this.transformLogID = null;
    this.organizationID = null;
    this.transformID = null;
    this.transformName = null;
    this.startDate = null;
    this.endDate = null;
    this.status = null;
    this.message = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
}

function TransformLogs(){
    var me = this;
    this.count = 0;
    this.aryTransformLogs = [];
    this.dicTransformLogs = {};

    this.add = function (transformLog) {
        this.aryTransformLogs.push(transformLog);
        this.dicTransformLogs[transformLog.transformLogID] = transformLog;
        this.count = this.aryTransformLogs.length;
    };
    this.remove = function (transformLog) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTransformLogs[i].transformLogID==transformLog.transformLogID){
                k = i;
                break;
            }
        }
        this.aryTransformLogs.splice(k,1);
        delete this.dicTransformLogs[transformLog.transformLogID];
        this.count = this.aryTransformLogs.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTransformLogs[indexOrKey];
        }else{
            return this.dicTransformLogs[indexOrKey];
        }
    };
    this.getItems = function (parameters, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformLogsPath + "?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setTransformLogs(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getCount = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.transformLogsPath + "/recordCount?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setTransformLogs(data){
        me.count = 0;
        me.aryTransformLogs = [];
        me.dicTransformLogs = {};
        for(var i = 0; i < data.length; i++){
            var transformLog = new TransformLog();
            transformLog.init(data[i]);
            me.add(transformLog);
        }
    }
}

function Account(){
    this.id = null;
    this.code = null;
    this.name = null;
    this.parentID = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
}

function Accounts(){
    var me = this;
    this.count = 0;
    this.aryAccounts = [];
    this.dicAccounts = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryAccounts[indexOrKey];
        }else{
            return this.dicAccounts[indexOrKey];
        }
    };
    this.add = function (account) {
        this.aryAccounts.push(account);
        this.dicAccounts[account.id] = account;
        this.count = this.aryAccounts.length;
    };
    this.remove = function (account) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryAccounts[i].id==account.id){
                k = i;
                break;
            }
        }
        this.aryAccounts.splice(k,1);
        delete this.dicAccounts[account.id];
        this.count = this.aryAccounts.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.accountsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setAccounts(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setAccounts(data){
        me.count = 0;
        me.aryAccounts = [];
        me.dicAccounts = {};
        for(var i = 0; i < data.length; i++){
            var account = new Account();
            account.init(data[i]);
            me.add(account);
        }
    }
}

function CashItem(){
    this.code = null;
    this.name = null;
    this.direction = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
}

function CashItems(){
    var me = this;
    this.count = 0;
    this.aryCashItems = [];
    this.dicCashItems = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryCashItems[indexOrKey];
        }else{
            return this.dicCashItems[indexOrKey];
        }
    };
    this.add = function (cashItem) {
        this.aryCashItems.push(cashItem);
        this.dicCashItems[cashItem.code] = cashItem;
        this.count = this.aryCashItems.length;
    };
    this.remove = function (cashItem) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryCashItems[i].code==cashItem.code){
                k = i;
                break;
            }
        }
        this.aryCashItems.splice(k,1);
        delete this.dicCashItems[cashItem.code];
        this.count = this.aryCashItems.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.cashItemsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setCashItems(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setCashItems(data){
        me.count = 0;
        me.aryCashItems = [];
        me.dicCashItems = {};
        for(var i = 0; i < data.length; i++){
            var cashItem = new CashItem();
            cashItem.init(data[i]);
            me.add(cashItem);
        }
    }
}