/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-23 10:32:08
 * @LastEditTime: 2020-08-19 14:08:16
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, tree = layui.tree, form = layui.form;
    var mReportItems = null, addFormSubmit = null, mReportCode = null, layerIndex = null;
    var accounts = new Accounts();
    var cashItems = new CashItems();
    var treeSelectCode = "";
    var operator = [
        {operat: "+"},
        {operat: "-"},
        {operat: "*"},
        {operat: "/"},
        {operat: "("},
        {operat: ")"},
    ];
    var isHaveAccount = false;
    var isHaveReportItem = false;
    var isAccountAlert = false;
    var isReportItemAlert = false;

    window.initExpressionForm = function(expressionStr,reportItems,reportCode,addAccountToExpression,index){
        mReportItems = reportItems;
        addFormSubmit = addAccountToExpression;
        mReportCode = reportCode;
        layerIndex = index;

        form.val("expressionWindow",{
            "expressionTeatarea": expressionStr
        });

        if(mReportCode == "03"){
            getCashItems();
        }else{
            getAccounts();
        }

        initReportItemList();
        initOperator();
        
        bindEvent();
    };

    function getAccounts(){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            initAccountsList();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取科目列表",errorStatus,msg);
		};
		accounts.getItems(true,succ,fail);
    }

    function getCashItems(){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            initCashItems();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取科目列表",errorStatus,msg);
		};
		cashItems.getItems(true,succ,fail);
    }

    function initAccountsList(){
        var treeData = setTreeData();
        tree.render({
            elem: '#treeAccountList',
            data: treeData,
            isJump: true,
            showLine: false,
            onlyIconControl: true,
            click: function(obj){
                treeSelectCode = obj.data.code;
                $('#treeAccountList').find(".select-tree").removeClass("select-tree");
                $(obj.elem).addClass("select-tree");
            }
        });
    }

    function initCashItems(){
        $("#treeAccountList").html("").html("<ul></ul>");
        var str = "";
        for(var i = 0; i < cashItems.count; i++){
            str += "<li title='("+cashItems.item(i).code+") "+cashItems.item(i).name+"' data-code='"+cashItems.item(i).code+"'>("+cashItems.item(i).code+") "+cashItems.item(i).name+"</li>";
        }
        $("#treeAccountList ul").html(str);
    }

    function setTreeData(){
        var hashTable = new HashTable();
        hashTable.add("-1",{title: "科目列表"});
        for(var i = 0; i < accounts.count; i++){
            hashTable.add(accounts.item(i).code,{title: "("+accounts.item(i).code+") "+accounts.item(i).name,id:accounts.item(i).id,code:accounts.item(i).code,parentID:accounts.item(i).parentID});
        }
        for(var i = 0; i < accounts.count; i++){
            var parentAccount = hashTable.getValue(accounts.item(i).parentID);
            if(parentAccount){
                if(!parentAccount.children){
                    parentAccount.children = [];
                }
                parentAccount.children.push(hashTable.getValue(accounts.item(i).code));
            }
        }
        return hashTable.getValue("-1").children;
    }

    function initReportItemList(){
        $(".report-item ul").html("");
        var str = "";
        for(var i = 0; i < mReportItems.length; i++){
            str += "<li data-code='"+mReportItems[i].reportItemCode+"' title='"+"("+mReportItems[i].reportItemCode+") "+$.trim(mReportItems[i].reportItemName)+"'>"+"("+mReportItems[i].reportItemCode+") "+$.trim(mReportItems[i].reportItemName)+"</li>";
        }
        $(".report-item ul").html(str);
    }

    function initOperator(){
        $(".operator ul").html("");
        var str = "";
        for(var i = 0; i < operator.length; i++){
            str += "<li>"+operator[i].operat+"</li>";
        }
        $(".operator ul").html(str);
    }
    
    function bindEvent(){
        $(".expression-cancel").click(function(){
            layer.close(layerIndex);
        });

        $(".report-item ul,.operator ul,#treeAccountList").on("click","li",function(){
            if(!$(this).hasClass("select-expression")){
                $(this).addClass("select-expression").siblings("li").removeClass("select-expression");
            }
        });
        
        $("#treeAccountList").on("dblclick","li",function(){
            if(!$(this).hasClass("select-expression")){
                $(this).addClass("select-expression").siblings("li").removeClass("select-expression");
                treeSelectCode = $("#treeAccountList ul li.select-expression").attr("data-code");
                addAccountToTextarea(treeSelectCode);
            }else{
                treeSelectCode = $("#treeAccountList ul li.select-expression").attr("data-code");
                addAccountToTextarea(treeSelectCode);
            }
        });
        
        $(".report-item ul").on("dblclick","li",function(){
            if(!$(this).hasClass("select-expression")){
                $(this).addClass("select-expression").siblings("li").removeClass("select-expression");
                treeSelectCode = "R" + $(".report-item ul li.select-expression").attr("data-code");
                addAccountToTextarea(treeSelectCode);
            }else{
                treeSelectCode = "R" + $(".report-item ul li.select-expression").attr("data-code");
                addAccountToTextarea(treeSelectCode);
            }
        });
        
        $(".operator ul").on("dblclick","li",function(){
            if(!$(this).hasClass("select-expression")){
                $(this).addClass("select-expression").siblings("li").removeClass("select-expression");
                treeSelectCode = $(".operator ul li.select-expression").text();
                addAccountToTextarea(treeSelectCode);
            }else{
                treeSelectCode = $(".operator ul li.select-expression").text();
                addAccountToTextarea(treeSelectCode);
            }
        });

        $("#treeAccountList").on("dblclick",".layui-tree-txt",function(){
            addAccountToTextarea(treeSelectCode);
        });

        form.on('submit(expressionFormSubmit)', function(data){
            var itemNamesArr = setArr(data.field.expressionTeatarea);
            var finalExpressionStr = changeItemName(itemNamesArr);
            if(isAccountAlert || isReportItemAlert){ return false;}
            addFormSubmit($("#expressionTeatarea").val(),layerIndex);
            return false;
        });
    }

    function judgeIsOperator(str){
        if(str == "+"){
            return false;
        }
        if(str == "-"){
            return false;
        }
        if(str == "*"){
            return false;
        }
        if(str == "/"){
            return false;
        }
        if(str == "("){
            return false;
        }
        if(str == ")"){
            return false;
        }
        return true;
    }

    function setArr(str){
        var tempArr = [];
        var obj = {};
        var code = "";
        for(var i = 0; i < str.length; i++){
            if(!judgeIsOperator(str[i])){
                obj = {};
                obj.code = code;
                obj.isCode = true;
                if(code){
                    tempArr.push(obj);
                }
                obj = {};
                obj.code = str[i];
                obj.isCode = false;
                tempArr.push(obj);
                code = "";
                continue;
            }
            code += str[i];
            if(i == str.length - 1){
                obj = {};
                obj.code = code;
                obj.isCode = true;
                tempArr.push(obj);
            }
        }

        return tempArr;
    }

    function changeItemName(arr){
        var tempArr = [];
        isReportItemAlert = false;
        isAccountAlert = false;
        for(var i = 0; i < arr.length; i++){
            if(arr[i].isCode){
                if(arr[i].code.indexOf("R") == 0){
                    var code = arr[i].code.substring(1);
                    var reportItemName = judgeReportItemName(code);
                    if(!isHaveReportItem){
                        layer.msg(code+" 该报表项不存在。",{icon: 2});
                        isReportItemAlert = true;
                        return;
                    }
                }else{
                    var reportItemName = judgeAccount(arr[i].code);
                    if(!isHaveAccount){
                        layer.msg(arr[i].code+" 该科目不存在。",{icon: 2});
                        isAccountAlert = true;
                        return;
                    }
                }
                tempArr.push(arr[i].code);
            }else{
                tempArr.push(arr[i].code);
            }
        }
        return tempArr.join("");
    }

    function judgeReportItemName(code){
        isHaveReportItem = false;
        for(var i = 0; i < mReportItems.length; i++){
            if(mReportItems[i].reportItemCode == code){
                isHaveReportItem = true;
                break;
            }
        }
    }

    function judgeAccount(code){
        isHaveAccount = false;
        if(mReportCode == "03"){
            for(var i = 0; i < cashItems.count; i++){
                if(cashItems.item(i).code == code){
                    isHaveAccount = true;
                    break;
                }
            }
        }else{
            for(var i = 0; i < accounts.count; i++){
                if(accounts.item(i).code == code){
                    isHaveAccount = true;
                    break;
                }
            }
        }
    }

    function addAccountToTextarea(str){
        $.fn.extend({
            "insert":function(value){
                //默认参数
                value=$.extend({
                    "text":""
                },value);
                 
                var dthis = $(this)[0]; //将jQuery对象转换为DOM元素
                 
                //IE下
                if(document.selection){
                     
                    $(dthis).focus();        //输入元素textara获取焦点
                    var fus = document.selection.createRange();//获取光标位置
                    fus.text = value.text;    //在光标位置插入值
                    $(dthis).focus();    ///输入元素textara获取焦点
                     
                 
                }
                //火狐下标准   
                else if(dthis.selectionStart || dthis.selectionStart == '0'){
                     
                    var start = dthis.selectionStart;
                    var end = dthis.selectionEnd;
                    var top = dthis.scrollTop;
                     
                    //以下这句，应该是在焦点之前，和焦点之后的位置，中间插入我们传入的值
                    dthis.value = dthis.value.substring(0, start) + value.text + dthis.value.substring(end, dthis.value.length);

                    if(dthis.setSelectionRange){
                        dthis.focus();
                        dthis.setSelectionRange((end+value.text.length),(end+value.text.length));
                    }else if (dthis.createTextRange) {
                        var range = dthis.createTextRange();
                        range.collapse(true);
                        range.moveEnd('character', (end+value.text.length));
                        range.moveStart('character', (end+value.text.length));
                        range.select();
                    }
                }
                 
                //在输入元素textara没有定位光标的情况
                else{
                    this.value += value.text;
                    this.focus();   
                };
                 
                return $(this);
            }
        });
        $("#expressionTeatarea").insert({"text":str});
    }

    
    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }

}();