/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-15 20:47:50
 * @LastEditTime: 2021-02-21 18:35:55
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var financeReports = new FinanceReports();
    var mTableBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 108 - $(".header-box").outerHeight() -12;
    var mReportCodes = [];
    var mReportItemCodes = [];

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadFinanceReports();
        treeEvent();
        bindTableEvent();
    }

    function getAndLoadFinanceReports(){
        var succ = function(){
            $Utils.loading.close();
            loadFinanceReportsMenu();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取财务报表列表",errorStatus,msg);
        };
        financeReports.getItems(true,succ,fail);
    }

    function loadFinanceReportsMenu(){
        $(".report-folder-tree > ul").html("");
        for(var i = 0; i < financeReports.count; i++){
            var str = "<li class='folder folder-hide' data-reportcode="+financeReports.item(i).reportCode+"><div title='("+financeReports.item(i).reportCode + ") " + financeReports.item(i).reportName+"'>("+ financeReports.item(i).reportCode + ") " + financeReports.item(i).reportName+"</div><ul></ul></li>";
            $(".report-folder-tree > ul").append(str);
            mReportCodes.push(financeReports.item(i).reportCode);
        }
        $(".report-folder-tree > ul > li:first-child > div").trigger("click");
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "reportItemCode", title: "项目编码", width: 100},
                {field: "showName", title: "项目名称", width: 350, templet: function(d){
                    if(d.showName){
                        return (d.showName).replace(new RegExp(" ", "gm"), "&nbsp;");
                    }else{
                        return d.showName;
                    }
                }},
                {field: "rowNumber", title: "行次", width: 80},
                {field: "expression", title: "表达式"}
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function treeEvent(){

        $(".object-reports-main").css("top",$(".header-box").outerHeight()+20);

        $(".report-folder-tree > ul").on("click","div",function(){
            $(this).parent("li").siblings("li").removeClass("click-folder");
            $(this).parent("li").addClass("click-folder");
            loadFinanceReports($(this).parent("li").attr("data-reportcode"));
        });
    }

    function loadFinanceReports(reportCode){
        var reportsTableBody = [];
        mReportItemCodes = [];
        for(var i = 0; i < financeReports.count; i++){
            if(financeReports.item(i).reportCode == reportCode){
                for(var j = 0; j < financeReports.item(i).financeReportItems.count; j++){
                    var tempObj = {};
                    for(var key in financeReports.item(i).financeReportItems.item(j)){
                        if(typeof financeReports.item(i).financeReportItems.item(j)[key] === "function"){ continue;}
                        tempObj[key] = financeReports.item(i).financeReportItems.item(j)[key];
                    }
                    reportsTableBody.push(tempObj);
                    mReportItemCodes.push(tempObj.reportItemCode);
                }
                break;
            }
        }
        mTableBodyData = mSortBodyData = reportsTableBody;
        loadTableBody(reportsTableBody);
    }

    function loadTableBody(tableBodyData){
        $Utils.loading.close();
        table.reload("objectList",{data:tableBodyData,limit:tableBodyData.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 108 - $(".header-box").outerHeight() - 12;
            $(".object-reports-main").css("top",$(".header-box").outerHeight()+20);
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindTableEvent(){

        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            loadTableBody(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
			getAndLoadFinanceReports();
        });

        $(".add-report").click(function(){
            var financeReport = new FinanceReport();
            getAndLoadReportForm(0,financeReport);
        });

        $(".edit-report").click(function(){
            var financeReport = financeReports.item($(".finance-report").find(".click-folder").attr("data-reportcode"));
            getAndLoadReportForm(1,financeReport);
        });

        $(".delete-report").click(function(){
            if($(".finance-report").find(".click-folder").length){
                var reportCode = $(".finance-report").find(".click-folder").attr("data-reportcode");
                if(financeReports.item(reportCode).financeReportItems.count){
                    layer.msg("不能删除含有报表项的报表。",{icon: 2});
                }else{
                    layer.open({
                        type: 0,
                        title: "删除报表",
                        closeBtn: 1,
                        shadeClose: true,
                        resize: false,
                        area: ["480px","270px"],
                        skin: "delete-window",
                        content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+financeReports.item(reportCode).reportName+" ？</div></div>",
                        btn: ["是","否"],
                        yes: function(index,layero){
                            layer.close(index);
                            $Utils.loading.open();
                            deleteReport(reportCode);
                        }
                    });
                }
            }
        });

        $(".add-report-item").click(function(){
            var reportCode = $(".finance-report").find(".click-folder").attr("data-reportcode");
            if(reportCode){
                var financeReportItem = new FinanceReportItem();
                getAndLoadReportItemForm(0,financeReportItem,reportCode);
            }else{
                layer.msg("请先创建报表。",{icon:2});
            }
        });

        $(".edit-report-item").click(function(){
            if(table.checkStatus('objectList').data.length){
                var reportCode = $(".finance-report").find(".click-folder").attr("data-reportcode");
                var financeReportItem = financeReports.item(reportCode).financeReportItems.item(table.checkStatus('objectList').data[0].reportItemID);
                getAndLoadReportItemForm(1,financeReportItem,reportCode);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".delete-report-item").click(function(){
            if(table.checkStatus('objectList').data.length){
                var reportCode = $(".finance-report").find(".click-folder").attr("data-reportcode");
                var reportItemID = table.checkStatus('objectList').data[0].reportItemID;
                layer.open({
                    type: 0,
                    title: "删除报表项",
                    closeBtn: 1,
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('objectList').data[0].showName+" ？</div></div>",
                    btn: ["是","否"],
                    yes: function(index,layero){
                        layer.close(index);
                        $Utils.loading.open();
                        deleteReportItem(reportCode,reportItemID);
                    }
                });
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].showName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].reportItemCode.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function deleteReport(reportCode){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
            getAndLoadFinanceReports();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除财务报表",errorStatus,msg);
		};
		financeReports.deleteItem(reportCode,true,succ,fail);
    }

    function deleteReportItem(reportCode,reportItemID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
            loadFinanceReports(reportCode);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除财务报表项",errorStatus,msg);
        };
        financeReports.item(reportCode).financeReportItems.deleteItem(reportItemID,true,succ,fail)
    }

    function getAndLoadReportForm(operationType,financeReport){
        $.ajax({
            url: "html/iDataOrganize/financeReport/financeReport.html",
            type: 'GET',
            success: function(data){
                loadReportForm(operationType,financeReport,data);
            }
        });
    }

    function loadReportForm(operationType,financeReport,strHtml){
        layer.open({
            type: 1,
            title: [operationType?financeReport.reportName+" 属性":"新增财务报表","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initReportForm(index,financeReport,operationType,mReportCodes,addSubmitReport,editSubmitReport);
            }
        });
    }

    function getAndLoadReportItemForm(operationType,financeReportItem,reportCode){
        $.ajax({
            url: "html/iDataOrganize/financeReport/financeReportItem.html",
            type: 'GET',
            success: function(data){
                loadReportItemForm(operationType,financeReportItem,reportCode,data);
            }
        });
    }

    function loadReportItemForm(operationType,financeReportItem,reportCode,strHtml){
        layer.open({
            type: 1,
            title: [operationType?financeReportItem.reportItemName+" 属性":"新增财务报表项目","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                if(operationType == 1){
                    mReportItemCodes.splice(mReportItemCodes.indexOf(financeReportItem.reportItemCode),1);
                }
                initReportItemForm(index,financeReportItem,operationType,mReportItemCodes,reportCode,mTableBodyData,addSubmitReportItem,editSubmitReportItem);
            }
        });
    }

    var addSubmitReport = function(financeReport,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadFinanceReports();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增财务报表",errorStatus,msg);
        };
        
		financeReports.addItem(financeReport,true,succ,fail);
    };

    var editSubmitReport = function(financeReport,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            $(".finance-report > ul li").each(function(){
                if($(this).attr("reportcode") == financeReport.reportCode){
                    $(this).find("div").attr("title",financeReport.reportName);
                    $(this).find("span").text(financeReport.reportName);
                }
            });
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改财务报表",errorStatus,msg);
        };

		financeReports.editItem(financeReport,true,succ,fail);
    };

    var addSubmitReportItem = function(financeReportItem,reportCode,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            loadFinanceReports(reportCode);
            // getAndLoadFinanceReports();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增财务报表项目",errorStatus,msg);
        };
		financeReports.item(reportCode).financeReportItems.addItem(financeReportItem,true,succ,fail);
    };

    var editSubmitReportItem = function(financeReportItem,reportCode,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            editListItem(financeReportItem);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改财务报表项目",errorStatus,msg);
        };

		financeReports.item(reportCode).financeReportItems.editItem(financeReportItem,true,succ,fail);
    };
    
    function editListItem(financeReportItem){
        var tempTableBody = $.extend(true,[],mTableBodyData);
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].reportItemID == financeReportItem.reportItemID){
                for(var key in mTableBodyData[i]){
                    mTableBodyData[i][key] = financeReportItem[key];
                    tempTableBody[i][key] = financeReportItem[key];
                }
                tempTableBody[i].LAY_CHECKED = true;
            }else{
                tempTableBody[i].LAY_CHECKED = false;
            }
        }
        table.reload("objectList",{data:tempTableBody,limit:tempTableBody.length});
    }

}();