/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-16 17:17:07
 * @LastEditTime: 2020-08-19 14:02:11
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form, tree = layui.tree;
    var mOperationType = null,mFinanceReportItem = null,formAddSubmit = null,formEditSubmit = null,layerIndex = null, mReportCode = null, mReportItemCodes = null, mReportItems = null;
    var treeSelectCode = {};

    window.initReportItemForm = function(index,financeReportItem,operationType,reportItemCodes,reportCode,reportItems,addSubmitReportItem,editSubmitReportItem){
        mOperationType = operationType;
        mFinanceReportItem = financeReportItem;
        layerIndex = index;
        formAddSubmit = addSubmitReportItem;
        formEditSubmit = editSubmitReportItem;
        mReportCode = reportCode;
        mReportItems = reportItems;
        mReportItemCodes = reportItemCodes;

        initForm();
    }

    function initForm(){
        if(mOperationType == 0){
            $(".relation-model-window input[name=reportItemCode]").focus();
        }else if(mOperationType == 1){
            initEditFinanceReportItemForm();
            $(".relation-model-window textarea[name=reportItemCode]").focus();
        }

        bindElementEvent();
    }

    function initEditFinanceReportItemForm(){
        form.val("formWindow",{
            "reportItemCode": mFinanceReportItem.reportItemCode,
            "reportItemName": mFinanceReportItem.reportItemName,
            "showName": mFinanceReportItem.showName,
            "expression": mFinanceReportItem.expression,
            "rowNumber": mFinanceReportItem.rowNumber
        });
    }

    function bindElementEvent(){

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });

        form.on('submit(formSubmit)', function(data){
            if(mReportItemCodes.indexOf(data.field.reportItemCode) != -1){
                layer.msg("项目编号不能重复。",{icon:2});
                return false;
            }
            if(mOperationType == 1){
                if(changed(data)){
                    $Utils.loading.open();
                    setFinanceReportItem(data);
                    formEditSubmit(mFinanceReportItem,mReportCode,layerIndex);
                }else{
                    $Utils.loading.close();
                    layer.close(layerIndex); 
                }
            }else if(mOperationType == 0){
                $Utils.loading.open();
                setFinanceReportItem(data);
                formAddSubmit(mFinanceReportItem,mReportCode,layerIndex);
            }
            return false;
        });

        $(".select-account").click(function(){
            getAndLoadExpressionSelectForm();
        });
    }

    function setFinanceReportItem(data){
        mFinanceReportItem.reportItemCode = data.field.reportItemCode;
        mFinanceReportItem.reportItemName = data.field.reportItemName;
        mFinanceReportItem.showName = data.field.showName;
        mFinanceReportItem.expression = data.field.expression;
        mFinanceReportItem.rowNumber = data.field.rowNumber;
        if(mOperationType == 0){
            mFinanceReportItem.reportCode = mReportCode;
        }
    }

    function changed(data){
        if(mFinanceReportItem.reportItemCode != data.field.reportItemCode){
            return true
        }
        if(mFinanceReportItem.reportItemName != data.field.reportItemName){
            return true
        }
        if(mFinanceReportItem.showName != data.field.showName){
            return true
        }
        if(mFinanceReportItem.expression != data.field.expression){
            return true
        }
        if(mFinanceReportItem.rowNumber != data.field.rowNumber){
            return true
        }
        return false;
    }

    function getAndLoadExpressionSelectForm(){
        $.ajax({
            url: "html/iDataOrganize/financeReport/selectExpression.html",
            type: 'GET',
            success: function(data){
                loadExpressionSelectForm(data);
            }
        });
    }

    function loadExpressionSelectForm(strHtml){
        layer.open({
            type: 1,
            title: ["编辑表达式","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["720px","540px"],
            content: strHtml,
            success: function(layero,index){
                if(mReportCode == "03"){
                    initExpressionForm($("#expression").val(),mReportItems,mReportCode,addAccountToExpression,index);
                }else{
                    initExpressionForm($("#expression").val(),mReportItems,mReportCode,addAccountToExpression,index);
                }
            }
        });
    }

    var addAccountToExpression = function(str,index){
        $("#expression").val(str);
        layer.close(index);
    }

}();