/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-24 16:53:17
 * @LastEditTime: 2020-08-19 14:24:49
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, form = layui.form, layer = layui.layer;
    var financeReports = new FinanceReports();
    var financeReportItems = new FinanceReportItems();
    var addFormSubmit = null;
    var layerIndex = null;
    var mReportCode = null;
    var operator = [
        {operat: "+"},
        {operat: "-"},
        {operat: "*"},
        {operat: "/"},
        {operat: "("},
        {operat: ")"},
    ];
    var keywords = [
        {keyword: "month_number"}
    ];
    var treeSelectCode = "";
    var isHaveReportItem = false;

    window.initExpressionForm = function(expressionStr,addItemToExpression,index){
        addFormSubmit = addItemToExpression;
        layerIndex = index;
        getFinanceReports(expressionStr);

    }
    
    function getFinanceReports(expressionStr){
        $Utils.loading.open();
        var succ = function(){
            getFinanceReportItems(expressionStr);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取财务报表列表",errorStatus,msg);
        };
        financeReports.getItems(true,succ,fail);
    }

    function getFinanceReportItems(expressionStr){
        var succ = function(){
            $Utils.loading.close();
            initForm(expressionStr)
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取财务报表项列表",errorStatus,msg);
        };
        financeReportItems.getItems(true,succ,fail);
    }

    function initForm(expressionStr){
        form.val("expressionWindow",{
            "expressionTeatarea": expressionStr
        });

        initExpressionForm();
        initOperator();
        initKeyword();
    }

    function initExpressionForm(){
        createSelect();
        form.render();

        initItemList();

        bindEvent();
    }

    function initOperator(){
        $(".operator ul").html("");
        var str = "";
        for(var i = 0; i < operator.length; i++){
            str += "<li>"+operator[i].operat+"</li>";
        }
        $(".operator ul").html(str);
    }

    function initKeyword(){
        $(".keyword ul").html("");
        var str = "";
        for(var i = 0; i < keywords.length; i++){
            str += "<li title='"+keywords[i].keyword+"'>"+keywords[i].keyword+"</li>";
        }
        $(".keyword ul").html(str);
    }

    function createSelect(){
        var financeReport = document.getElementById("financeReport");
        for(var i = 0; i < financeReports.count; i++){
            var option = document.createElement("option");
            option.setAttribute("value",financeReports.item(i).reportCode);
            if(i == 0){
                option.setAttribute("selected",true);
                mReportCode = financeReports.item(i).reportCode;
            }
            option.innerText = financeReports.item(i).reportName;
            financeReport.appendChild(option);
        }
    }

    function bindEvent(){
        $(".expression-cancel").click(function(){
            layer.close(layerIndex);
        });

        form.on("select(financeReport)",function(data){
            if(data.value != "01"){
                $("#star").attr("title","本期");
                $("#star").val("本期");
                $("#end").attr("title","本年累计");
                $("#end").val("本年累计");
            }else{
                $("#star").attr("title","年初");
                $("#star").val("年初");
                $("#end").attr("title","期末");
                $("#end").val("期末");
            }
            mReportCode = data.value;
            initItemList();
            form.render();
        });

        $(".expression-box,.operator ul,.keyword ul").on("click","li",function(){
            if(!$(this).hasClass("select-expression")){
                $(this).addClass("select-expression").siblings("li").removeClass("select-expression");
            }
        });

        $(".expression-box").on("dblclick","li",function(){
            var datacType = form.val("expressionWindow");
            if(!$(this).hasClass("select-expression")){
                $(this).addClass("select-expression").siblings("li").removeClass("select-expression");
            }
            treeSelectCode = financeReports.item(mReportCode).financeReportItems.item($(".expression-box li.select-expression").attr("data-itemid")).reportItemName;
            treeSelectCode = "[" + $.trim(treeSelectCode) + (datacType.year==1?"上年":"") + datacType.cType + "]";
            addAccountToTextarea(treeSelectCode);
        });

        $(".operator ul").on("dblclick","li",function(){
            if(!$(this).hasClass("select-expression")){
                $(this).addClass("select-expression").siblings("li").removeClass("select-expression");
                treeSelectCode = $(".operator ul li.select-expression").text();
                addAccountToTextarea(treeSelectCode);
            }else{
                treeSelectCode = $(".operator ul li.select-expression").text();
                addAccountToTextarea(treeSelectCode);
            }
        });

        $(".keyword ul").on("dblclick","li",function(){
            if(!$(this).hasClass("select-expression")){
                $(this).addClass("select-expression").siblings("li").removeClass("select-expression");
                treeSelectCode = $(".keyword ul li.select-expression").text();
                addAccountToTextarea(treeSelectCode);
            }else{
                treeSelectCode = $(".keyword ul li.select-expression").text();
                addAccountToTextarea(treeSelectCode);
            }
        });

        form.on('submit(expressionFormSubmit)', function(data){
            var itemNamesArr = setArr(data.field.expressionTeatarea);
            var finalExpressionStr = changeItemName(itemNamesArr);
            if(!isHaveReportItem){ return false;}
            addFormSubmit($("#expressionTeatarea").val(),finalExpressionStr,layerIndex);
            return false;
        });
    }

    function setArr(str){
        var tempArr = [];
        var isStar = false;
        var obj = {};
        var itemName = "";
        for(var i = 0; i < str.length; i++){
            if(str[i] == "["){
                isStar = true;
                itemName = "";
                obj = {}
                continue;
            }
            if(str[i] == "]"){
                isStar = false;
                obj.itemName = itemName;
                obj.isItemName = true;
                tempArr.push(obj);
                continue;
            }
            if(isStar){
                itemName += str[i];
                continue;
            }
            if(!isStar){
                obj = {};
                obj.itemName = str[i];
                obj.isItemName = false;
                tempArr.push(obj);
                continue;
            }
        }

        return tempArr;
    }

    function changeItemName(arr){
        var tempArr = [];
        for(var i = 0; i < arr.length; i++){
            if(arr[i].isItemName){
                var reportItemName = arr[i].itemName;
                var reportItemCode = changeItemCode(reportItemName);
                if(!isHaveReportItem){
                    layer.msg(reportItemName+" 该报表项不存在。",{icon: 2});
                    return;
                }
                tempArr.push(reportItemCode);
            }else{
                tempArr.push(arr[i].itemName);
            }
        }
        return tempArr.join("");
    }

    function changeItemCode(reportItemName){
        var financeReportItemName = "";
        var endCode = "";
        var startCode = "";
        var tempArr = [];
        if(reportItemName.indexOf("年初") != -1){
            tempArr = reportItemName.split("年初");
            financeReportItemName = tempArr[0]+tempArr[1];
            endCode = "bt";
        }
        if(reportItemName.indexOf("期末") != -1){
            tempArr = reportItemName.split("期末");
            financeReportItemName = tempArr[0]+tempArr[1];
            endCode = "et";
        }
        if(reportItemName.indexOf("本期") != -1){
            tempArr = reportItemName.split("本期");
            financeReportItemName = tempArr[0]+tempArr[1];
            endCode = "tp";
        }
        if(reportItemName.indexOf("本年累计") != -1){
            tempArr = reportItemName.split("本年累计");
            financeReportItemName = tempArr[0]+tempArr[1];
            endCode = "ty";
        }
        if(financeReportItemName.indexOf("上年") != -1){
            tempArr = financeReportItemName.split("上年");
            financeReportItemName = tempArr[0]+tempArr[1];
            startCode = "ly";
        }
        isHaveReportItem = false;
        for(var i = 0; i < financeReportItems.count; i++){
            if($.trim(financeReportItems.item(i).reportItemName) == financeReportItemName){
                isHaveReportItem = true;
                return financeReportItems.item(i).reportItemCode+startCode+endCode;
            }
        }
    }

    function initItemList(){
        $(".expression-box").html("");
        var financeReportItem = null;
        var str = "";
        for(var i = 0; i < financeReportItems.count; i++){
            financeReportItem = financeReportItems.item(i);
            if(financeReportItem.reportCode == mReportCode){
                str += "<li data-itemid='"+financeReportItem.reportItemID+"' data-code='"+financeReportItem.reportItemCode+"'>"+"("+financeReportItem.reportItemCode+") "+$.trim(financeReportItem.reportItemName)+"</li>";
            }
        }
        $(".expression-box").html(str);
    }

    function addAccountToTextarea(str){
        $.fn.extend({
            "insert":function(value){
                //默认参数
                value=$.extend({
                    "text":""
                },value);
                 
                var dthis = $(this)[0]; //将jQuery对象转换为DOM元素
                
                //IE下
                if(document.selection){
                     
                    $(dthis).focus();        //输入元素textara获取焦点
                    var fus = document.selection.createRange();//获取光标位置
                    fus.text = value.text;    //在光标位置插入值
                    $(dthis).focus();    ///输入元素textara获取焦点
                     
                 
                }
                //火狐下标准   
                else if(dthis.selectionStart || dthis.selectionStart == '0'){
                     
                    var start = dthis.selectionStart;
                    var end = dthis.selectionEnd;
                    var top = dthis.scrollTop;
                     
                    //以下这句，应该是在焦点之前，和焦点之后的位置，中间插入我们传入的值
                    dthis.value = dthis.value.substring(0, start) + value.text + dthis.value.substring(end, dthis.value.length);

                    if(dthis.setSelectionRange){
                        dthis.focus();
                        dthis.setSelectionRange((end+value.text.length),(end+value.text.length));
                    }else if (dthis.createTextRange) {
                        var range = dthis.createTextRange();
                        range.collapse(true);
                        range.moveEnd('character', (end+value.text.length));
                        range.moveStart('character', (end+value.text.length));
                        range.select();
                    }
                }
                 
                //在输入元素textara没有定位光标的情况
                else{
                    this.value += value.text;
                    this.focus();   
                };
                 
                return $(this);
            }
        });
        $("#expressionTeatarea").insert({"text":str});
    }

}()